/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.jcr.benchmark.usecases.portal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.exoplatform.jcr.benchmark.usecases.portal.AbstractAction;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.util.IdGenerator;

public abstract class AbstractWriteAction
extends AbstractAction {
    private String stringValue;
    private byte[] binaryValue;
    private int multiValueSize;
    private Random random = new Random();

    public AbstractWriteAction(RepositoryImpl repository, String workspace, String rootName, int depth, String stringValue, byte[] binaryValue, int multiValueSize) {
        super(repository, workspace, rootName, depth);
        this.binaryValue = binaryValue;
        this.stringValue = stringValue;
        this.multiValueSize = multiValueSize;
    }

    public Node createGenericNode(Node root, ValueFactory valueFactory) throws RepositoryException {
        String id = IdGenerator.generate();
        Node target = root.addNode(id, "exo:genericNode");
        for (int i = 1; i <= 9; ++i) {
            String propName = PropertyType.nameFromValue((int)i) + "-m";
            target.setProperty(propName, this.createValues(target, i, true, valueFactory), i);
            propName = PropertyType.nameFromValue((int)i) + "-s";
            target.setProperty(propName, this.createValues(target, i, false, valueFactory)[0], i);
        }
        return target;
    }

    public Value[] createValues(Node node, int propType, boolean isMultivalued, ValueFactory valueFactory) throws RepositoryException {
        Value[] values = new Value[isMultivalued ? this.multiValueSize : 1];
        switch (propType) {
            case 1: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(this.stringValue);
                }
                return values;
            }
            case 2: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue((InputStream)new ByteArrayInputStream(this.binaryValue));
                }
                return values;
            }
            case 3: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(this.random.nextLong());
                }
                return values;
            }
            case 4: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(this.random.nextDouble());
                }
                return values;
            }
            case 5: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(Calendar.getInstance());
                }
                return values;
            }
            case 6: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(true);
                }
                return values;
            }
            case 7: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(node.getName(), 7);
                }
                return values;
            }
            case 8: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(node.getPath(), 8);
                }
                return values;
            }
            case 9: {
                for (int i = 0; i < values.length; ++i) {
                    values[i] = valueFactory.createValue(node);
                }
                return values;
            }
        }
        return null;
    }
}

