/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.client;

import com.google.gwt.event.logical.shared.ShowRangeHandler;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.gadgets.client.DynamicHeightFeature;
import com.google.gwt.gadgets.client.Gadget;
import com.google.gwt.gadgets.client.NeedsDynamicHeight;
import com.google.gwt.gadgets.client.io.ResponseReceivedHandler;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.MenuBar;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DatePicker;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.RangeChangeEvent;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.exoplatform.calendar.client.CalGadMenubarBuilder;
import org.exoplatform.calendar.client.CalendarEventInfo;
import org.exoplatform.calendar.client.CellListData;
import org.exoplatform.calendar.client.EventDatabase;
import org.exoplatform.calendar.client.JSO.RestRequestController;
import org.exoplatform.calendar.client.UserPrefs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Gadget.ModulePrefs(title="eXo Calendar Gadget", author="Le Thanh Quang - Do Hoang Khiem (eXo CT)", author_email="letquang@gmail.com, dohoangkhiem@gmail.com")
public class CalendarGadget
extends Gadget<UserPrefs>
implements NeedsDynamicHeight {
    List<String> visibleCals = new ArrayList();
    DynamicHeightFeature heightFeature;
    DatePicker datePicker;
    VerticalPanel mainPanel;
    VerticalPanel topPanel;
    MenuBar menubar;
    CellListData cellList;

    public void refresh() {
        this.highlightDates();
        this.getEventData();
        this.heightFeature.adjustHeight();
    }

    public void initData() {
        this.visibleCals.clear();
        RestRequestController.instance().makeGetJsonRequest("/calgad/calendars/personal", (ResponseReceivedHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showTopPanel() {
        this.mainPanel.insert((Widget)this.topPanel, 0);
    }

    public void hideTopPanel() {
        this.mainPanel.remove((Widget)this.topPanel);
    }

    protected void init(UserPrefs preferences) {
        String restUrl = preferences.restURL().getValue();
        if (restUrl != null && restUrl.length() > 0) {
            if (restUrl.endsWith("/")) {
                restUrl = restUrl.substring(0, restUrl.length() - 1);
            }
            RestRequestController.REST_BASE_URL = restUrl;
        }
        this.mainPanel = new VerticalPanel();
        this.mainPanel.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
        this.mainPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        this.mainPanel.setStylePrimaryName("calgadMainPanel");
        CalGadMenubarBuilder menubarBuilder = new CalGadMenubarBuilder(this);
        this.topPanel = new VerticalPanel();
        this.topPanel.setStylePrimaryName("topPanel");
        this.datePicker = new DatePicker();
        this.datePicker.setValue(new Date());
        this.mainPanel.add((Widget)this.datePicker);
        this.cellList = new CellListData();
        this.mainPanel.add((Widget)this.cellList);
        this.initData();
        this.handleEventListSelection();
        this.datePicker.addValueChangeHandler((ValueChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.datePicker.addShowRangeHandler((ShowRangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.cellList.getCellList().addRangeChangeHandler((RangeChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel rootPanel = RootPanel.get();
        this.menubar = menubarBuilder.createMenuBar();
        rootPanel.add((Widget)this.menubar);
        rootPanel.setStyleName("rootPanel");
        rootPanel.add((Widget)this.mainPanel);
        this.heightFeature.adjustHeight();
    }

    public void initializeFeature(DynamicHeightFeature feature) {
        this.heightFeature = feature;
    }

    public void highlightDates() {
        Date fromDate = this.datePicker.getFirstDate();
        Date toDate = this.datePicker.getLastDate();
        Date d = new Date(fromDate.getTime());
        while (d.getTime() <= toDate.getTime()) {
            this.datePicker.removeStyleFromDates("bold-date", d);
            d.setTime(d.getTime() + 86400000L);
        }
        String relPath = "/calgad/hdays/" + fromDate.getTime() + "/" + toDate.getTime() + "/";
        for (String s : this.visibleCals) {
            relPath = relPath + s + '/';
        }
        RestRequestController.instance().makeGetJsonRequest(relPath, (ResponseReceivedHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void getEventData() {
        Date fromDate = this.datePicker.getFirstDate();
        Date toDate = this.datePicker.getLastDate();
        String relPath = "/calgad/events/" + fromDate.getTime() + "/" + toDate.getTime() + "/";
        for (String s : this.visibleCals) {
            relPath = relPath + s + '/';
        }
        RestRequestController.instance().makeGetJsonRequest(relPath, (ResponseReceivedHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void handleEventListSelection() {
        SingleSelectionModel selectionModel = this.cellList.getSelectionModel();
        selectionModel.addSelectionChangeHandler((SelectionChangeEvent.Handler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void handleDatePickerSelection(Date selectedDate) {
        EventDatabase database = EventDatabase.get();
        ListDataProvider dataProvider = database.getDataProvider();
        Date firstDate = null;
        int pos = 0;
        if (dataProvider.getList() == null || dataProvider.getList().size() == 0) {
            return;
        }
        for (CalendarEventInfo ce : dataProvider.getList()) {
            ++pos;
            if (selectedDate.after(ce.getFromDate())) continue;
            firstDate = ce.getFromDate();
            break;
        }
        if (firstDate != null) {
            this.cellList.getCellList().getRowElement(pos - 1).scrollIntoView();
        }
    }

    public void clearPanel(Panel panel) {
        panel.clear();
        this.heightFeature.adjustHeight();
    }

    public static final native void debug(Object var0);
}

