/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import com.sun.syndication.feed.synd.SyndContent;
import com.sun.syndication.feed.synd.SyndContentImpl;
import com.sun.syndication.feed.synd.SyndEntry;
import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndFeedImpl;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import net.fortuna.ical4j.model.DateList;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.RRule;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.DataStorage;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventPageListQuery;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.FeedData;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.RemoteCalendar;
import org.exoplatform.calendar.service.RssData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.util.XPathUtils;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.IdentityConstants;

public class JCRDataStorage
implements DataStorage {
    private static final String CALENDARS = "calendars".intern();
    private static final String SHARED_CALENDAR = "sharedCalendars".intern();
    private static final String FEED = "eXoCalendarFeed".intern();
    private static final String CALENDAR_EVENT = "events".intern();
    private static final String CALENDAR_SETTING = "calendarSetting".intern();
    private static final String EVENT_CATEGORIES = "eventCategories".intern();
    private static final String VALUE = "value".intern();
    private final NodeHierarchyCreator nodeHierarchyCreator_;
    private final RepositoryService repoService_;
    private final SessionProviderService sessionProviderService_;
    private ExoCache<String, List<Calendar>> eXoGroupCalendarCache;
    private ExoCache<String, CalendarEvent> eXoEventCache;
    private final ExoCache<String, List<CalendarEvent>> groupCalendarEventCache;
    private final ExoCache<String, List<CalendarEvent>> groupCalendarRecurrentEventCache;
    private final ExoCache<String, List<EventCategory>> userEventCategories;
    private final ExoCache<KeyValuePair, Calendar> exoCalendarCache;
    private FutureExoCache<String, CalendarEvent, JCRDataStorage> eventCache;
    private FutureExoCache<KeyValuePair, Calendar, JCRDataStorage> calendarCache;
    private FutureExoCache<String, List<Calendar>, JCRDataStorage> userCalendarCache;
    private FutureExoCache<String, List<Calendar>, JCRDataStorage> groupCalendarCache;
    private FutureExoCache<String, CalendarSetting, JCRDataStorage> calendarSettingCache;
    private final ConcurrentMap<String, Lock> locks = new ConcurrentHashMap<String, Lock>(64, 0.75f, 64);
    private static final Log log = ExoLogger.getLogger(JCRDataStorage.class);
    private String groupHomePath;

    public JCRDataStorage(NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, CacheService cservice) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repoService_ = repoService;
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        this.sessionProviderService_ = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        this.eXoEventCache = cservice.getCacheInstance("calendar.CalendarEvent");
        this.eventCache = new FutureExoCache((Loader)new CalendarEventLoader(), this.eXoEventCache);
        ExoCache eXoUserCalendarCache = cservice.getCacheInstance("calendar.UserCalendar");
        this.userCalendarCache = new FutureExoCache((Loader)new UserCalendarLoader(), eXoUserCalendarCache);
        this.eXoGroupCalendarCache = cservice.getCacheInstance("calendar.GroupCalendar");
        this.groupCalendarCache = new FutureExoCache((Loader)new GroupCalendarLoader(), this.eXoGroupCalendarCache);
        ExoCache eXoSettingCache = cservice.getCacheInstance("calendar.UserCalendarSetting");
        this.calendarSettingCache = new FutureExoCache((Loader)new CalendarSettingLoader(), eXoSettingCache);
        this.exoCalendarCache = cservice.getCacheInstance("calendar.Calendar");
        this.calendarCache = new FutureExoCache((Loader)new CalendarLoader(), this.exoCalendarCache);
        this.groupCalendarEventCache = cservice.getCacheInstance("calendar.GroupCalendarEvent");
        this.groupCalendarRecurrentEventCache = cservice.getCacheInstance("calendar.GroupCalendarRecurrentEvent");
        this.userEventCategories = cservice.getCacheInstance("calendar.EventCategories");
    }

    private Lock getLock(String type, String id) {
        String fullId = new StringBuilder(type.length() + id.length() + 1).append(type).append('-').append(id).toString();
        Lock lock = (Lock)this.locks.get(fullId);
        if (lock != null) {
            return lock;
        }
        lock = new InternalLock(fullId);
        Lock prevLock = this.locks.putIfAbsent(fullId, lock);
        if (prevLock != null) {
            lock = prevLock;
        }
        return lock;
    }

    @Override
    public Node getPublicCalendarServiceHome() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node publicApp = this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
        try {
            return publicApp.getNode("CalendarApplication");
        }
        catch (Exception e) {
            Node calendarApp = publicApp.addNode("CalendarApplication", "nt:unstructured");
            publicApp.getSession().save();
            return calendarApp;
        }
    }

    @Override
    public Node getSharedCalendarHome() throws Exception {
        Node calendarServiceHome = this.getPublicCalendarServiceHome();
        try {
            return calendarServiceHome.getNode(SHARED_CALENDAR);
        }
        catch (Exception e) {
            Node sharedCal = calendarServiceHome.addNode(SHARED_CALENDAR, "nt:unstructured");
            calendarServiceHome.getSession().save();
            return sharedCal;
        }
    }

    @Override
    public Node getPublicRoot() throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        return this.nodeHierarchyCreator_.getPublicApplicationNode(sProvider);
    }

    @Override
    public Node getUserCalendarServiceHome(String username) throws Exception {
        SessionProvider sProvider = this.createSystemProvider();
        Node userApp = this.nodeHierarchyCreator_.getUserApplicationNode(sProvider, username);
        try {
            return userApp.getNode("CalendarApplication");
        }
        catch (Exception e) {
            Node calendarRoot = userApp.addNode("CalendarApplication", "nt:unstructured");
            userApp.getSession().save();
            return calendarRoot;
        }
    }

    @Override
    public Node getPublicCalendarHome() throws Exception {
        Node calendarServiceHome = this.getPublicCalendarServiceHome();
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node cal = calendarServiceHome.addNode(CALENDARS, "nt:unstructured");
            calendarServiceHome.getSession().save();
            return cal;
        }
    }

    @Override
    public Node getUserCalendarHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(CALENDARS);
        }
        catch (Exception e) {
            Node calendars = calendarServiceHome.addNode(CALENDARS, "nt:unstructured");
            calendarServiceHome.getSession().save();
            return calendars;
        }
    }

    @Override
    public Node getRssHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(FEED);
        }
        catch (Exception e) {
            Node feed = calendarServiceHome.addNode(FEED, "nt:unstructured");
            calendarServiceHome.getSession().save();
            return feed;
        }
    }

    protected Node getEventCategoryHome(String username) throws Exception {
        Node calendarServiceHome = this.getUserCalendarServiceHome(username);
        try {
            return calendarServiceHome.getNode(EVENT_CATEGORIES);
        }
        catch (Exception e) {
            Node eventCat = calendarServiceHome.addNode(EVENT_CATEGORIES, "nt:unstructured");
            calendarServiceHome.getSession().save();
            return eventCat;
        }
    }

    @Override
    public Calendar getUserCalendar(String username, String calendarId) throws Exception {
        return this.getCalendar(calendarId, username);
    }

    private Calendar getCalendar(String calendarId, String username) {
        Calendar calendar = (Calendar)this.calendarCache.get((Object)this, (Object)new KeyValuePair(calendarId, username));
        if (this.isNullCalendar(calendar)) {
            return null;
        }
        return (Calendar)SerializationUtils.clone((Serializable)calendar);
    }

    @Override
    public List<Calendar> getUserCalendars(String username, boolean isShowAll) throws Exception {
        List calList = (List)this.userCalendarCache.get((Object)this, (Object)username);
        LinkedList<Calendar> retList = new LinkedList<Calendar>();
        if (!isShowAll) {
            List<String> defaultCalendars = Arrays.asList(this.getCalendarSetting(username).getFilterPrivateCalendars());
            for (Calendar calendar : calList) {
                if (defaultCalendars.contains(calendar.getId())) continue;
                retList.add(calendar);
            }
        } else {
            retList.addAll(calList);
        }
        return retList;
    }

    @Override
    public void saveUserCalendar(String username, Calendar calendar, boolean isNew) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getUserCalendarHome(username);
        if (isNew) {
            try {
                calendarNode = calendarHome.getNode(calendar.getId());
            }
            catch (Exception e) {
                calendarNode = calendarHome.addNode(calendar.getId(), "exo:calendar");
                calendarNode.setProperty("exo:id", calendar.getId());
            }
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        calendar.setCalendarOwner(username);
        calendar.setGroups(null);
        this.setCalendarProperties(calendarNode, calendar);
        Session session = calendarHome.getSession();
        session.save();
        this.userCalendarCache.remove((Serializable)((Object)username));
        this.clearCalendarCache(calendar.getId(), username);
    }

    @Override
    public Calendar removeUserCalendar(String username, String calendarId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        if (calendarHome.hasNode(calendarId)) {
            Node calNode = calendarHome.getNode(calendarId);
            Calendar calendar = this.getCalendar(new String[]{calendarId}, username, calNode, true);
            NodeIterator iter = calNode.getNodes();
            try {
                while (iter.hasNext()) {
                    Node eventNode = iter.nextNode();
                    Node eventFolder = this.getEventFolder(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
                    this.syncRemoveEvent(eventFolder, eventNode.getName());
                    this.removeReminder(eventNode);
                }
                calNode.remove();
                calendarHome.save();
            }
            catch (Exception e) {
                log.error((Object)("Exception occurred when removing calendar " + calendarId), (Throwable)e);
            }
            this.eXoEventCache.select((CachedObjectSelector)new EventCalendarSelector(calendarId));
            this.userCalendarCache.remove((Serializable)((Object)username));
            this.clearCalendarCache(calendarId, username);
            try {
                this.removeFeed(username, calendarId);
            }
            catch (Exception e) {
                log.warn((Object)("Exception occurred when removing feeds from calendar " + calendarId), (Throwable)e);
            }
            return calendar;
        }
        return null;
    }

    @Override
    public Calendar getGroupCalendar(String calendarId) throws Exception {
        return this.getCalendar(calendarId, null);
    }

    private String buildGroupCalendarQuery(String groupId) {
        StringBuilder queryString = new StringBuilder("SELECT * FROM exo:calendar WHERE jcr:path LIKE '").append(this.getGroupCalendarHomePath()).append("/%' AND exo:groups = '").append(groupId).append("'");
        return queryString.toString();
    }

    @Override
    public List<GroupCalendarData> getGroupCalendars(String[] groupIds, boolean isShowAll, String username) throws Exception {
        LinkedList<GroupCalendarData> groupCalendars = new LinkedList<GroupCalendarData>();
        for (String groupId : groupIds) {
            CalendarSetting calendarSetting;
            String sQuery = this.buildGroupCalendarQuery(groupId);
            List calList = (List)this.groupCalendarCache.get((Object)this, (Object)sQuery);
            if (calList == null || calList.isEmpty()) continue;
            String[] defaultCalendars = null;
            if (username != null && (calendarSetting = this.getCalendarSetting(username)) != null) {
                defaultCalendars = calendarSetting.getFilterPublicCalendars();
            }
            LinkedList<Calendar> calendars = new LinkedList<Calendar>();
            for (Calendar c : calList) {
                Calendar cal = this.getCalendar(defaultCalendars, null, c, isShowAll);
                if (cal == null) continue;
                calendars.add(cal);
            }
            groupCalendars.add(new GroupCalendarData(groupId, groupId, calendars));
        }
        return groupCalendars;
    }

    private String getGroupCalendarHomePath() {
        if (this.groupHomePath == null) {
            try {
                this.groupHomePath = this.getPublicCalendarHome().getPath();
            }
            catch (Exception e) {
                this.groupHomePath = null;
                log.error((Object)"Can't find group calendar home path", (Throwable)e);
            }
        }
        return this.groupHomePath;
    }

    @Override
    public void savePublicCalendar(Calendar calendar, boolean isNew, String username) throws Exception {
        Node calendarNode;
        Node calendarHome = this.getPublicCalendarHome();
        if (isNew) {
            if (calendarHome.hasNode(calendar.getId())) {
                throw new Exception("This calendar is already exists");
            }
            calendarNode = calendarHome.addNode(calendar.getId(), "exo:calendar");
            calendarNode.setProperty("exo:id", calendar.getId());
        } else {
            calendarNode = calendarHome.getNode(calendar.getId());
        }
        String[] oldCalendarGroups = this.loadCalendar(calendarNode).getGroups();
        String[] calendarGroups = calendar.getGroups();
        this.setCalendarProperties(calendarNode, calendar);
        calendarHome.getSession().save();
        HashSet<String> keys = new HashSet<String>();
        if (calendarGroups != null) {
            for (String key : calendarGroups) {
                keys.add(this.buildGroupCalendarQuery(key));
            }
        }
        if (oldCalendarGroups != null) {
            for (String key : oldCalendarGroups) {
                keys.add(this.buildGroupCalendarQuery(key));
            }
        }
        this.eXoGroupCalendarCache.select((CachedObjectSelector)new GroupCalendarSelector(keys));
        this.clearCalendarCache(calendar.getId(), username);
    }

    @Override
    public Calendar removeGroupCalendar(String calendarId) throws Exception {
        Node calendarHome = this.getPublicCalendarHome();
        if (calendarHome.hasNode(calendarId)) {
            Node calNode = calendarHome.getNode(calendarId);
            Calendar calendar = this.getCalendar(new String[]{calendarId}, null, calNode, true);
            NodeIterator iter = calNode.getNodes();
            while (iter.hasNext()) {
                Node eventNode = iter.nextNode();
                Node eventFolder = this.getEventFolder(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
                this.removeReminder(eventNode);
                this.syncRemoveEvent(eventFolder, eventNode.getName());
            }
            calNode.remove();
            calendarHome.getSession().save();
            this.eXoEventCache.select((CachedObjectSelector)new EventCalendarSelector(calendarId));
            String[] groupIds = calendar.getGroups();
            if (groupIds != null) {
                for (String groupId : groupIds) {
                    String queryKey = this.buildGroupCalendarQuery(groupId);
                    this.groupCalendarCache.remove((Serializable)((Object)queryKey));
                }
            }
            this.clearCalendarCache(calendar.getId(), calendar.getCalendarOwner());
            return calendar;
        }
        return null;
    }

    @Override
    public Calendar getCalendar(String[] defaultFilterCalendars, String username, Node calNode, boolean isShowAll) throws Exception {
        if (!isShowAll && defaultFilterCalendars != null && Arrays.asList(defaultFilterCalendars).contains(calNode.getName())) {
            return null;
        }
        return this.loadCalendar(calNode);
    }

    private Calendar getCalendar(String[] defaultFilterCalendars, String username, Calendar cal, boolean isShowAll) throws Exception {
        if (!isShowAll && defaultFilterCalendars != null && Arrays.asList(defaultFilterCalendars).contains(cal.getId())) {
            return null;
        }
        return cal;
    }

    public Calendar loadCalendar(Node calNode) throws Exception {
        Calendar calendar = new Calendar();
        StringBuilder namePattern = new StringBuilder(256);
        namePattern.append("exo:id").append('|').append("exo:name").append('|').append("exo:description").append('|').append("exo:locale").append('|').append("exo:timeZone").append('|').append("exo:sharedColor").append('|').append("exo:calendarColor").append('|').append("exo:calendarOwner").append('|').append("exo:publicUrl").append('|').append("exo:privateUrl").append('|').append("exo:groups").append('|').append("exo:viewPermissions").append('|').append("exo:editPermissions").append("|").append("exo:dateModified");
        PropertyIterator it = calNode.getProperties(namePattern.toString());
        ArrayList<String> groups = null;
        String[] viewPermission = null;
        String[] editPermission = null;
        while (it.hasNext()) {
            Property p = it.nextProperty();
            String name = p.getName();
            if (name.equals("exo:id")) {
                calendar.setId(p.getString());
                continue;
            }
            if (name.equals("exo:name")) {
                calendar.setName(p.getString());
                continue;
            }
            if (name.equals("exo:description")) {
                calendar.setDescription(p.getString());
                continue;
            }
            if (name.equals("exo:locale")) {
                calendar.setLocale(p.getString());
                continue;
            }
            if (name.equals("exo:timeZone")) {
                calendar.setTimeZone(p.getString());
                continue;
            }
            if (name.equals("exo:sharedColor")) {
                calendar.setCalendarColor(p.getString());
                continue;
            }
            if (name.equals("exo:calendarColor")) {
                calendar.setCalendarColor(p.getString());
                continue;
            }
            if (name.equals("exo:calendarOwner")) {
                calendar.setCalendarOwner(p.getString());
                continue;
            }
            if (name.equals("exo:publicUrl")) {
                calendar.setPublicUrl(p.getString());
                continue;
            }
            if (name.equals("exo:privateUrl")) {
                calendar.setPrivateUrl(p.getString());
                continue;
            }
            if (name.equals("exo:dateModified")) {
                calendar.setLastModified(p.getDate().getTimeInMillis());
                continue;
            }
            if (name.equals("exo:groups")) {
                Value[] values = p.getValues();
                groups = new ArrayList<String>();
                for (Value v : values) {
                    groups.add(v.getString());
                }
                continue;
            }
            if (name.equals("exo:viewPermissions")) {
                viewPermission = this.ValuesToStrings(p.getValues());
                continue;
            }
            if (!name.equals("exo:editPermissions")) continue;
            editPermission = this.ValuesToStrings(p.getValues());
        }
        calendar.setRemote(calNode.isNodeType("exo:remoteCalendar"));
        calendar.setHasChildren(calNode.hasNodes());
        if (!calendar.isPublic()) {
            if (groups != null) {
                calendar.setGroups(groups.toArray(new String[groups.size()]));
            }
            if (viewPermission != null) {
                calendar.setViewPermission(viewPermission);
            }
            if (editPermission != null) {
                calendar.setEditPermission(editPermission);
            }
        }
        if (calNode.getPath().startsWith(this.getGroupCalendarHomePath())) {
            calendar.setCalType(Calendar.Type.GROUP.type());
        } else {
            calendar.setCalType(Calendar.Type.PERSONAL.type());
        }
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<EventCategory> getEventCategories(String username) throws Exception {
        ArrayList<EventCategory> eventCategoryList;
        Lock lock = this.getLock("EventCategories", username);
        lock.lock();
        try {
            eventCategoryList = (ArrayList<EventCategory>)this.userEventCategories.get((Serializable)((Object)username));
            if (eventCategoryList == null) {
                eventCategoryList = new ArrayList<EventCategory>();
                Node eventCategoryHome = this.getEventCategoryHome(username);
                NodeIterator iter = eventCategoryHome.getNodes();
                while (iter.hasNext()) {
                    eventCategoryList.add(this.getEventCategory(iter.nextNode()));
                }
                this.userEventCategories.put((Serializable)((Object)username), eventCategoryList);
            }
        }
        finally {
            lock.unlock();
        }
        return eventCategoryList;
    }

    public void saveEventCategory(String username, EventCategory eventCategory, String[] values, boolean isNew) throws Exception {
        this.saveEventCategory(username, eventCategory, isNew);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveEventCategory(String username, EventCategory eventCategory, boolean isNew) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        Node eventCategoryNode = null;
        if (isNew) {
            eventCategoryNode = eventCategoryHome.addNode(eventCategory.getId(), "exo:eventCategory");
        } else {
            eventCategoryNode = eventCategoryHome.getNode(eventCategory.getId());
            Node calendarHome = this.getUserCalendarHome(username);
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            NodeIterator calIter = calendarHome.getNodes();
            while (calIter.hasNext()) {
                StringBuilder queryString = new StringBuilder("/jcr:root").append(XPathUtils.escapeIllegalXPathName((String)calIter.nextNode().getPath())).append("//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategory.getId()).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Node eventNode = it.nextNode();
                    eventNode.setProperty("exo:eventCategoryName", eventCategory.getName());
                }
            }
            if (this.getSharedCalendarHome().hasNode(username)) {
                PropertyIterator iterPro = this.getSharedCalendarHome().getNode(username).getReferences();
                while (iterPro.hasNext()) {
                    try {
                        Node calendar = iterPro.nextProperty().getParent();
                        NodeIterator it = calendar.getNodes();
                        while (it.hasNext()) {
                            Node eventNode = it.nextNode();
                            if (!eventNode.hasProperty("exo:eventCategoryId") || !eventNode.getProperty("exo:eventCategoryId").getString().equals(eventCategory.getId())) continue;
                            eventNode.setProperty("exo:eventCategoryName", eventCategory.getName());
                        }
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)e);
                    }
                }
            }
            this.eXoEventCache.select((CachedObjectSelector)new EventCategorySelector(eventCategory.getId()));
        }
        eventCategoryNode.setProperty("exo:id", eventCategory.getId());
        eventCategoryNode.setProperty("exo:name", eventCategory.getName());
        eventCategoryHome.getSession().save();
        Lock lock = this.getLock("EventCategories", username);
        lock.lock();
        try {
            this.userEventCategories.put((Serializable)((Object)username), null);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEventCategory(String username, String eventCategoryId) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        if (eventCategoryHome.hasNode(eventCategoryId)) {
            Node eventCategoryNode = eventCategoryHome.getNode(eventCategoryId);
            for (CalendarEvent ce : this.getUserEventByCategory(username, eventCategoryId)) {
                ce.setEventCategoryId("defaultEventCategoryIdAll");
                ce.setEventCategoryName("defaultEventCategoryNameAll");
                this.saveUserEvent(username, ce.getCalendarId(), ce, false);
            }
            for (CalendarEvent ce : this.getSharedEventByCategory(username, eventCategoryId)) {
                ce.setEventCategoryId("defaultEventCategoryIdAll");
                ce.setEventCategoryName("defaultEventCategoryNameAll");
                this.saveEventToSharedCalendar(username, ce.getCalendarId(), ce, false);
            }
            for (CalendarEvent ce : this.getPublicEventByCategory(username, eventCategoryId)) {
                ce.setEventCategoryId("defaultEventCategoryIdAll");
                ce.setEventCategoryName("defaultEventCategoryNameAll");
                this.savePublicEvent(ce.getCalendarId(), ce, false);
            }
            eventCategoryNode.remove();
            eventCategoryHome.save();
            eventCategoryHome.getSession().save();
            Lock lock = this.getLock("EventCategories", username);
            lock.lock();
            try {
                this.userEventCategories.put((Serializable)((Object)username), null);
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public EventCategory getEventCategory(Node eventCatNode) throws Exception {
        EventCategory eventCategory = new EventCategory();
        StringBuilder namePattern = new StringBuilder(128);
        namePattern.append("exo:id").append('|').append("exo:name").append('|').append("exo:description").append("|").append("exo:dateModified");
        PropertyIterator it = eventCatNode.getProperties(namePattern.toString());
        while (it.hasNext()) {
            Property p = it.nextProperty();
            String name = p.getName();
            if (name.equals("exo:id")) {
                eventCategory.setId(p.getString());
                continue;
            }
            if (name.equals("exo:name")) {
                eventCategory.setName(p.getString());
                continue;
            }
            if (!name.equals("exo:dateModified")) continue;
            eventCategory.setLastModified(p.getDate().getTimeInMillis());
        }
        return eventCategory;
    }

    @Override
    public EventCategory getEventCategory(String username, String eventcategoryId) throws Exception {
        Node eventCategoryHome = this.getEventCategoryHome(username);
        return this.getEventCategory(eventCategoryHome.getNode(eventcategoryId));
    }

    @Override
    public CalendarEvent getUserEvent(String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        return this.getEvent(calendarNode.getNode(eventId));
    }

    @Override
    public List<CalendarEvent> getUserEventByCalendar(String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                events.add(this.getEventById(it.nextNode().getProperty("exo:id").getString()));
            }
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getPublicEventByCategory(String username, String eventCategoryId) throws Exception {
        Node publicCalendarHome = this.getPublicCalendarHome();
        QueryManager qm = publicCalendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        try {
            NodeIterator calIter = publicCalendarHome.getNodes();
            while (calIter.hasNext()) {
                StringBuilder queryString = new StringBuilder("/jcr:root").append(calIter.nextNode().getPath()).append("//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
                Query query = qm.createQuery(queryString.toString(), "xpath");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    events.add(this.getEvent(it.nextNode()));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Error occurred when querying public events from event category " + eventCategoryId), (Throwable)e);
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getSharedEventByCategory(String username, String eventCategoryId) throws Exception {
        ArrayList<CalendarEvent> events;
        block7: {
            events = new ArrayList<CalendarEvent>();
            try {
                if (this.getSharedCalendarHome().hasNode(username)) {
                    PropertyIterator iterPro = this.getSharedCalendarHome().getNode(username).getReferences();
                    while (iterPro.hasNext()) {
                        try {
                            Node calendar = iterPro.nextProperty().getParent();
                            NodeIterator it = calendar.getNodes();
                            while (it.hasNext()) {
                                Node eventNode = it.nextNode();
                                if (!eventNode.hasProperty("exo:eventCategoryId") || !eventNode.getProperty("exo:eventCategoryId").getString().equals(eventCategoryId)) continue;
                                events.add(this.getEvent(eventNode));
                            }
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)e);
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)e);
            }
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getUserEventByCategory(String username, String eventCategoryId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        NodeIterator calIter = calendarHome.getNodes();
        while (calIter.hasNext()) {
            StringBuilder queryString = new StringBuilder("/jcr:root").append(XPathUtils.escapeIllegalXPathName((String)calIter.nextNode().getPath())).append("//element(*,exo:calendarEvent)[@exo:eventCategoryId='").append(eventCategoryId).append("']");
            Query query = qm.createQuery(queryString.toString(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                events.add(this.getEvent(it.nextNode()));
            }
        }
        return events;
    }

    private CalendarEvent getEventById(Node calendarHome, String eventId) throws Exception {
        String queryString = "/jcr:root" + XPathUtils.escapeIllegalXPathName((String)calendarHome.getPath()) + "//element(*,exo:calendarEvent)[@exo:id='" + eventId + "']";
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString, "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        if (it.hasNext()) {
            return this.getEvent(it.nextNode());
        }
        return null;
    }

    @Override
    public CalendarEvent getEvent(String username, String eventId) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        return this.getEventById(calendarHome, eventId);
    }

    private List<CalendarEvent> getEventsByType(Node calendarHome, int type, EventQuery eventQuery) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        eventQuery.setCalendarPath(calendarHome.getPath());
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            CalendarEvent calEvent = this.getEvent(it.nextNode());
            calEvent.setCalType(String.valueOf(type));
            events.add(calEvent);
            if (eventQuery.getLimitedItems() != it.getPosition()) continue;
            break;
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getUserEvents(String username, EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getUserCalendarHome(username);
        return this.getEventsByType(calendarHome, 0, eventQuery);
    }

    @Override
    public void saveUserEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        event.setCalendarId(calendarId);
        if (event.getReminders() != null && event.getReminders().size() > 0) {
            try {
                Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                this.saveEvent(calendarNode, event, reminderFolder, isNew);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
            }
        } else {
            this.saveEvent(calendarNode, event, null, isNew);
        }
        this.userCalendarCache.remove((Serializable)((Object)username));
    }

    public void saveOccurrenceEvent(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        int calType = this.getTypeOfCalendar(username, calendarId);
        if (calType == 0) {
            Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
            event.setCalendarId(calendarId);
            if (event.getReminders() != null && event.getReminders().size() > 0) {
                Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                this.saveOccurrenceEvent(calendarNode, event, reminderFolder, isNew);
            } else {
                this.saveOccurrenceEvent(calendarNode, event, null, isNew);
            }
            return;
        }
        if (calType == 1) {
            Node sharedCalendarHome = this.getSharedCalendarHome();
            if (sharedCalendarHome.hasNode(username)) {
                Node userNode = sharedCalendarHome.getNode(username);
                PropertyIterator iter = userNode.getReferences();
                while (iter.hasNext()) {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                    if (!this.canEdit(calendar, username)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"\n Do not have edit permission. \n");
                        }
                        throw new AccessDeniedException();
                    }
                    Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                    this.saveOccurrenceEvent(calendar, event, reminderFolder, isNew);
                    break;
                }
            }
            return;
        }
        if (calType == 2) {
            Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
            Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
            this.saveOccurrenceEvent(calendarNode, event, reminderFolder, isNew);
            return;
        }
    }

    public void saveOccurrenceEvent(Node calendarNode, CalendarEvent event, Node reminderFolder, boolean isNew) throws Exception {
        block7: {
            try {
                if (isNew) {
                    Node originalNode;
                    block6: {
                        originalNode = null;
                        try {
                            originalNode = calendarNode.getNode(event.getId());
                        }
                        catch (PathNotFoundException e) {
                            if (!log.isDebugEnabled()) break block6;
                            log.debug((Object)"Original recurrence node not found", (Throwable)e);
                        }
                    }
                    event.setId("Event" + IdGenerator.generate());
                    event.setRepeatType(CalendarEvent.RP_NOREPEAT);
                    if (originalNode != null) {
                        event.setOriginalReference(originalNode.getUUID());
                    }
                    event.setIsExceptionOccurrence(true);
                    event.setRepeatInterval(0L);
                    event.setRepeatCount(0L);
                    event.setRepeatUntilDate(null);
                    event.setRepeatByDay(null);
                    event.setRepeatByMonthDay(null);
                    this.saveEvent(calendarNode, event, reminderFolder, true);
                    break block7;
                }
                event.setRepeatType(CalendarEvent.RP_NOREPEAT);
                event.setIsExceptionOccurrence(true);
                event.setRepeatByDay(null);
                event.setRepeatCount(0L);
                event.setRepeatInterval(0L);
                event.setRepeatUntilDate(null);
                event.setRepeatByMonthDay(null);
                this.saveEvent(calendarNode, event, reminderFolder, false);
            }
            catch (Exception e) {
                log.error((Object)"Error occurred when saving occurrence event", (Throwable)e);
            }
        }
    }

    public void removeOccurrenceInstance(String username, CalendarEvent occurrence) throws Exception {
        String[] excludeId;
        String eventId = occurrence.getId();
        String calendarId = occurrence.getCalendarId();
        int calType = Integer.parseInt(occurrence.getCalType());
        String recurId = occurrence.getRecurrenceId();
        CalendarEvent originalEvent = null;
        if (calType == 0) {
            originalEvent = this.getUserEvent(username, calendarId, eventId);
        } else if (calType == 2) {
            originalEvent = this.getGroupEvent(calendarId, eventId);
        } else if (calType == 1) {
            originalEvent = this.getSharedEvent(username, calendarId, eventId);
        }
        if (originalEvent.getExcludeId() == null) {
            excludeId = new String[]{recurId};
        } else {
            ArrayList<String> excId = new ArrayList<String>(Arrays.asList(originalEvent.getExcludeId()));
            excId.add(recurId);
            excludeId = excId.toArray(new String[0]);
        }
        originalEvent.setExcludeId(excludeId);
        if (calType == 0) {
            this.saveUserEvent(username, calendarId, originalEvent, false);
            return;
        }
        if (calType == 2) {
            this.savePublicEvent(calendarId, originalEvent, false);
            return;
        }
        if (calType == 1) {
            this.saveEventToSharedCalendar(username, calendarId, originalEvent, false);
            return;
        }
    }

    public void removeRecurrenceSeries(String username, CalendarEvent originalEvent) throws Exception {
        int calType = Integer.parseInt(originalEvent.getCalType());
        if (originalEvent.getRepeatType().equals(CalendarEvent.RP_NOREPEAT)) {
            return;
        }
        List<CalendarEvent> exceptions = this.getExceptionEvents(username, originalEvent);
        if (exceptions != null && exceptions.size() > 0) {
            for (CalendarEvent exception : exceptions) {
                this.removeReference(exception);
            }
        }
        if (calType == 0) {
            this.removeUserEvent(username, originalEvent.getCalendarId(), originalEvent.getId());
            return;
        }
        if (calType == 2) {
            this.removePublicEvent(originalEvent.getCalendarId(), originalEvent.getId());
            return;
        }
        if (calType == 1) {
            this.removeSharedEvent(username, originalEvent.getCalendarId(), originalEvent.getId());
            return;
        }
    }

    private void removeReference(CalendarEvent exceptionEvent) throws Exception {
        String sql;
        Node calendarApp = Utils.getPublicServiceHome();
        QueryManager queryManager = calendarApp.getSession().getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(sql = "select * from exo:repeatCalendarEvent where exo:id='" + exceptionEvent.getId() + "'", "sql");
        QueryResult result = query.execute();
        NodeIterator nodesIt = result.getNodes();
        if (nodesIt.hasNext()) {
            Node eventNode = nodesIt.nextNode();
            eventNode.setProperty("exo:originalReference", (Value)null);
            eventNode.getSession().save();
            this.eventCache.remove((Serializable)((Object)eventNode.getProperty("exo:id").getString()));
        }
    }

    public Node getCalendarEventNode(String username, String calType, String calendarId, String eventId) throws Exception {
        Node eventNode = null;
        try {
            Node sharedCalendarHome;
            if (String.valueOf(0).equals(calType)) {
                eventNode = this.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
            } else if (String.valueOf(2).equals(calType)) {
                eventNode = this.getPublicCalendarHome().getNode(calendarId).getNode(eventId);
            } else if (String.valueOf(1).equals(calType) && (sharedCalendarHome = this.getSharedCalendarHome()).hasNode(username)) {
                PropertyIterator iter = sharedCalendarHome.getNode(username).getReferences();
                while (iter.hasNext()) {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendarId.equals(calendar.getProperty("exo:id")) || !calendar.hasNode(eventId)) continue;
                    eventNode = calendar.getNode(eventId);
                    break;
                }
            }
            return eventNode;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurs when get calendar event node", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public CalendarEvent removeUserEvent(String username, String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            CalendarEvent event;
            Node eventNode;
            block3: {
                eventNode = calendarNode.getNode(eventId);
                event = this.getEvent(eventNode);
                try {
                    Node eventFolder = this.getEventFolder(event.getFromDateTime());
                    this.syncRemoveEvent(eventFolder, event.getId());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)e);
                }
            }
            this.removeReminder(eventNode);
            eventNode.remove();
            calendarNode.save();
            calendarNode.getSession().save();
            calendarNode.refresh(true);
            this.userCalendarCache.remove((Serializable)((Object)username));
            return event;
        }
        return null;
    }

    @Override
    public void removeReminder(Node eventNode) throws Exception {
        block9: {
            if (eventNode.hasProperty("exo:fromDateTime")) {
                try {
                    Node reminders;
                    block8: {
                        reminders = this.getReminderFolder(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
                        try {
                            reminders.getNode(eventNode.getName()).remove();
                            reminders.save();
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) break block8;
                            log.debug((Object)"Failed to remove reminder for an event", (Throwable)e);
                        }
                    }
                    Node events = reminders.getParent().getNode("reminders");
                    if (events != null && events.hasNode(eventNode.getName()) && events.hasNode(eventNode.getName())) {
                        events.getNode(eventNode.getName()).remove();
                        if (!reminders.isNew()) {
                            reminders.save();
                        } else {
                            reminders.getSession().save();
                        }
                    }
                    this.eventCache.remove((Serializable)((Object)eventNode.getProperty("exo:id").getString()));
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)e);
                }
            }
        }
    }

    @Override
    public CalendarEvent getGroupEvent(String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        CalendarEvent calEvent = this.getEvent(calendarNode.getNode(eventId));
        calEvent.setCalType(String.valueOf(2));
        return calEvent;
    }

    @Override
    public CalendarEvent getGroupEvent(String eventId) throws Exception {
        Node calendarHome = this.getPublicCalendarHome();
        return this.getEventById(calendarHome, eventId);
    }

    @Override
    public List<CalendarEvent> getGroupEventByCalendar(List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
            NodeIterator it = calendarNode.getNodes();
            while (it.hasNext()) {
                CalendarEvent event = this.getEventById(it.nextNode().getProperty("exo:id").getString());
                event.setCalType(String.valueOf(2));
                events.add(event);
            }
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getPublicEvents(EventQuery eventQuery) throws Exception {
        Node calendarHome = this.getPublicCalendarHome();
        List<CalendarEvent> events = this.getEventsByType(calendarHome, 2, eventQuery);
        return events;
    }

    @Override
    public void savePublicEvent(String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        event.setCalendarId(calendarId);
        event.setCalType(String.valueOf(2));
        Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
        this.saveEvent(calendarNode, event, reminderFolder, isNew);
        this.groupCalendarEventCache.select((CachedObjectSelector)new GroupCalendarEventSelector(calendarNode.getPath()));
        this.groupCalendarRecurrentEventCache.select((CachedObjectSelector)new GroupCalendarEventSelector(calendarNode.getPath()));
    }

    @Override
    public CalendarEvent removePublicEvent(String calendarId, String eventId) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        if (calendarNode.hasNode(eventId)) {
            CalendarEvent event;
            block5: {
                Node eventNode = calendarNode.getNode(eventId);
                event = this.getEvent(eventNode);
                this.removeReminder(eventNode);
                eventNode.remove();
                calendarNode.save();
                calendarNode.getSession().save();
                calendarNode.refresh(true);
                try {
                    Node eventFolder = this.getEventFolder(event.getFromDateTime());
                    this.syncRemoveEvent(eventFolder, eventId);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block5;
                    log.debug((Object)e.getMessage());
                }
            }
            Calendar calendar = this.loadCalendar(calendarNode);
            String[] calendarGroups = calendar.getGroups();
            if (calendarGroups != null) {
                HashSet<String> keys = new HashSet<String>();
                for (String key : calendarGroups) {
                    keys.add(this.buildGroupCalendarQuery(key));
                }
                this.eXoGroupCalendarCache.select((CachedObjectSelector)new GroupCalendarSelector(keys));
            }
            this.groupCalendarEventCache.select((CachedObjectSelector)new GroupCalendarEventSelector(calendarNode.getPath()));
            this.groupCalendarRecurrentEventCache.select((CachedObjectSelector)new GroupCalendarEventSelector(calendarNode.getPath()));
            return event;
        }
        return null;
    }

    @Override
    public CalendarEvent getEvent(Node eventNode) throws Exception {
        CalendarEvent event = new CalendarEvent();
        event = EventPageListQuery.getEventFromNode(event, eventNode, this.getReminderFolder(eventNode.getProperty("exo:fromDateTime").getDate().getTime(), false));
        StringBuilder namePattern = new StringBuilder(128);
        namePattern.append("exo:recurrenceId").append('|').append("exo:isException").append('|').append("exo:repeatUntil").append('|').append("exo:repeatCount").append('|').append("exo:originalReference").append('|').append("exo:repeatInterval").append('|').append("exo:excludeId").append('|').append("exo:repeatByDay").append('|').append("exo:repeatByMonthDay");
        PropertyIterator it = eventNode.getProperties(namePattern.toString());
        while (it.hasNext()) {
            int i;
            Value[] values;
            Property p = it.nextProperty();
            String name = p.getName();
            if (name.equals("exo:recurrenceId")) {
                event.setRecurrenceId(p.getString());
                continue;
            }
            if (name.equals("exo:isException")) {
                event.setIsExceptionOccurrence(p.getBoolean());
                continue;
            }
            if (name.equals("exo:repeatUntil")) {
                event.setRepeatUntilDate(p.getDate().getTime());
                continue;
            }
            if (name.equals("exo:repeatCount")) {
                event.setRepeatCount(p.getLong());
                continue;
            }
            if (name.equals("exo:originalReference")) {
                event.setOriginalReference(p.getString());
                continue;
            }
            if (name.equals("exo:repeatInterval")) {
                event.setRepeatInterval(p.getLong());
                continue;
            }
            if (name.equals("exo:excludeId")) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setExcludeId(new String[]{values[0].getString()});
                    continue;
                }
                String[] excludeIds = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    excludeIds[i] = values[i].getString();
                }
                event.setExcludeId(excludeIds);
                continue;
            }
            if (name.equals("exo:repeatByDay")) {
                values = p.getValues();
                if (values.length == 1) {
                    event.setRepeatByDay(new String[]{values[0].getString()});
                    continue;
                }
                String[] byDays = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    byDays[i] = values[i].getString();
                }
                event.setRepeatByDay(byDays);
                continue;
            }
            if (!name.equals("exo:repeatByMonthDay")) continue;
            values = p.getValues();
            if (values.length == 1) {
                event.setRepeatByMonthDay(new long[]{values[0].getLong()});
                continue;
            }
            long[] byMonthDays = new long[values.length];
            for (i = 0; i < values.length; ++i) {
                byMonthDays[i] = values[i].getLong();
            }
            event.setRepeatByMonthDay(byMonthDays);
        }
        String activitiId = ActivityTypeUtils.getActivityId((Node)eventNode);
        if (activitiId != null) {
            event.setActivityId(ActivityTypeUtils.getActivityId((Node)eventNode));
        }
        return event;
    }

    @Override
    public void saveEvent(Node calendarNode, CalendarEvent event, Node reminderFolder, boolean isNew) throws Exception {
        Calendar calendar;
        String[] calendarGroups;
        List<Attachment> attachments;
        Node eventNode;
        Boolean isRepeatNode;
        block43: {
            isRepeatNode = false;
            if (isNew) {
                eventNode = calendarNode.addNode(event.getId(), "exo:calendarEvent");
                eventNode.setProperty("exo:id", event.getId());
                if (Utils.isRepeatEvent(event)) {
                    eventNode.addMixin("exo:repeatCalendarEvent");
                    eventNode.addMixin("mix:referenceable");
                    isRepeatNode = true;
                }
                if (Utils.isExceptionOccurrence(event)) {
                    eventNode.addMixin("exo:repeatCalendarEvent");
                    isRepeatNode = true;
                }
            } else {
                try {
                    eventNode = calendarNode.getNode(event.getId());
                    if (Utils.isRepeatEvent(event)) {
                        if (!eventNode.isNodeType("exo:repeatCalendarEvent")) {
                            eventNode.addMixin("exo:repeatCalendarEvent");
                        }
                        if (!eventNode.isNodeType("mix:referenceable")) {
                            eventNode.addMixin("mix:referenceable");
                        }
                        isRepeatNode = true;
                    }
                }
                catch (Exception e) {
                    eventNode = calendarNode.addNode(event.getId(), "exo:calendarEvent");
                    eventNode.setProperty("exo:id", event.getId());
                }
                try {
                    this.removeReminder(eventNode);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block43;
                    log.debug((Object)e);
                }
            }
        }
        eventNode.setProperty("exo:summary", event.getSummary());
        eventNode.setProperty("exo:calendarId", event.getCalendarId());
        eventNode.setProperty("exo:eventCategoryId", event.getEventCategoryId());
        eventNode.setProperty("exo:eventCategoryName", event.getEventCategoryName());
        eventNode.setProperty("exo:description", event.getDescription());
        eventNode.setProperty("exo:location", event.getLocation());
        eventNode.setProperty("exo:taskDelegator", event.getTaskDelegator());
        GregorianCalendar startTime = Utils.getInstanceTempCalendar();
        GregorianCalendar endTime = Utils.getInstanceTempCalendar();
        if (event.getFromDateTime() != null) {
            startTime.setTime(event.getFromDateTime());
        }
        eventNode.setProperty("exo:fromDateTime", (java.util.Calendar)startTime);
        eventNode.getSession().save();
        if (event.getToDateTime() != null) {
            endTime.setTime(event.getToDateTime());
        }
        eventNode.setProperty("exo:toDateTime", (java.util.Calendar)endTime);
        eventNode.getSession().save();
        eventNode.setProperty("exo:eventType", event.getEventType());
        eventNode.setProperty("exo:repeat", event.getRepeatType());
        eventNode.setProperty("exo:priority", event.getPriority());
        eventNode.setProperty("exo:isPrivate", event.isPrivate());
        eventNode.setProperty("exo:eventState", event.getEventState());
        if (event.getInvitation() == null) {
            event.setInvitation(new String[0]);
        }
        eventNode.setProperty("exo:invitation", event.getInvitation());
        if (event.getParticipant() == null) {
            event.setParticipant(new String[0]);
        }
        eventNode.setProperty("exo:participant", event.getParticipant());
        List<Reminder> reminders = event.getReminders();
        if (reminders != null && !reminders.isEmpty()) {
            for (Reminder reminder : reminders) {
                reminder.setFromDateTime(event.getFromDateTime());
                this.addReminder(eventNode, reminderFolder, reminder);
            }
        }
        if (eventNode.hasNode("attachment")) {
            while (eventNode.getNodes().hasNext()) {
                eventNode.getNodes().nextNode().remove();
            }
            eventNode.save();
        }
        if ((attachments = event.getAttachment()) != null) {
            for (Attachment att : attachments) {
                this.addAttachment(eventNode, att, isNew);
            }
        }
        eventNode.setProperty("exo:message", event.getMessage());
        eventNode.setProperty("exo:sendOption", event.getSendOption());
        if (event.getParticipantStatus() == null) {
            event.setParticipantStatus(new String[0]);
        }
        eventNode.setProperty("exo:participantStatus", event.getParticipantStatus());
        if (isRepeatNode.booleanValue()) {
            Date repeatFinish;
            if (event.getRecurrenceId() != null) {
                eventNode.setProperty("exo:recurrenceId", event.getRecurrenceId());
            } else {
                eventNode.setProperty("exo:recurrenceId", "");
            }
            if (event.getIsExceptionOccurrence() != null) {
                eventNode.setProperty("exo:isException", event.getIsExceptionOccurrence().booleanValue());
            } else {
                eventNode.setProperty("exo:isException", (Value)null);
            }
            if (event.getExcludeId() != null && event.getExcludeId().length > 0) {
                eventNode.setProperty("exo:excludeId", event.getExcludeId());
            } else {
                eventNode.setProperty("exo:excludeId", (Value[])null);
            }
            if (event.getRepeatUntilDate() != null) {
                GregorianCalendar gregorianCalendar = Utils.getInstanceTempCalendar();
                gregorianCalendar.setTime(event.getRepeatUntilDate());
                eventNode.setProperty("exo:repeatUntil", (java.util.Calendar)gregorianCalendar);
            } else {
                eventNode.setProperty("exo:repeatUntil", (Value)null);
            }
            if (event.getOriginalReference() != null) {
                eventNode.setProperty("exo:originalReference", event.getOriginalReference());
            } else {
                eventNode.setProperty("exo:originalReference", (Value)null);
            }
            eventNode.setProperty("exo:repeatCount", event.getRepeatCount());
            eventNode.setProperty("exo:repeatInterval", event.getRepeatInterval());
            if (event.getRepeatByDay() != null) {
                eventNode.setProperty("exo:repeatByDay", event.getRepeatByDay());
            } else {
                eventNode.setProperty("exo:repeatByDay", (Value[])null);
            }
            if (event.getRepeatByMonthDay() != null) {
                long[] lArray = event.getRepeatByMonthDay();
                String[] byMonthDay = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    byMonthDay[i] = String.valueOf(lArray[i]);
                }
                eventNode.setProperty("exo:repeatByMonthDay", byMonthDay);
            } else {
                eventNode.setProperty("exo:repeatByMonthDay", (Value[])null);
            }
            String string = event.getRepeatType();
            if (!Utils.isEmpty(string) && !string.equals(CalendarEvent.RP_NOREPEAT) && (repeatFinish = this.calculateRecurrenceFinishDate(event)) != null) {
                GregorianCalendar finishRepeatDate = Utils.getInstanceTempCalendar();
                finishRepeatDate.setTime(repeatFinish);
                eventNode.setProperty("exo:repeatFinishDate", (java.util.Calendar)finishRepeatDate);
            }
        }
        if (event.getActivityId() != null) {
            ActivityTypeUtils.attachActivityId((Node)eventNode, (String)event.getActivityId());
        }
        calendarNode.getSession().save();
        if (CalendarEvent.TYPE_EVENT.equals(event.getEventType())) {
            this.addEvent(event);
        }
        if ((calendarGroups = (calendar = this.loadCalendar(calendarNode)).getGroups()) != null) {
            HashSet<String> keys = new HashSet<String>();
            for (String key : calendarGroups) {
                keys.add(this.buildGroupCalendarQuery(key));
            }
            this.eXoGroupCalendarCache.select((CachedObjectSelector)new GroupCalendarSelector(keys));
        }
        this.eventCache.remove((Serializable)((Object)event.getId()));
    }

    @Override
    public void addReminder(Node eventNode, Node reminderFolder, Reminder reminder) throws Exception {
        Node reminderNode;
        Node catNode;
        try {
            catNode = reminderFolder.getNode(eventNode.getName());
        }
        catch (Exception e) {
            catNode = reminderFolder.addNode(eventNode.getName(), "nt:unstructured");
        }
        try {
            reminderNode = catNode.getNode(reminder.getId());
        }
        catch (Exception e) {
            reminderNode = catNode.addNode(reminder.getId(), "exo:reminder");
        }
        reminderNode.setProperty("exo:eventId", eventNode.getName());
        reminderNode.setProperty("exo:alarmBefore", reminder.getAlarmBefore());
        reminderNode.setProperty("exo:timeInterval", reminder.getRepeatInterval());
        reminderNode.setProperty("exo:reminderType", reminder.getReminderType());
        reminderNode.setProperty("exo:email", reminder.getEmailAddress());
        reminderNode.setProperty("exo:isRepeat", reminder.isRepeat());
        reminderNode.setProperty("exo:isOver", false);
        if (reminder.getReminderType().equals(Reminder.TYPE_POPUP)) {
            reminderNode.setProperty("exo:creator", reminder.getReminderOwner());
        }
        GregorianCalendar fromTime = new GregorianCalendar();
        GregorianCalendar remindTime = new GregorianCalendar();
        GregorianCalendar toTime = new GregorianCalendar();
        if (reminder.getFromDateTime() != null) {
            fromTime.setTime(reminder.getFromDateTime());
            reminderNode.setProperty("exo:fromDateTime", (java.util.Calendar)fromTime);
            long time = reminder.getFromDateTime().getTime() - reminder.getAlarmBefore() * 60L * 1000L;
            remindTime.setTimeInMillis(time);
            reminderNode.setProperty("exo:remindDateTime", (java.util.Calendar)remindTime);
        }
        reminderNode.setProperty("exo:description", "");
        reminderNode.setProperty("exo:summary", eventNode.getProperty("exo:summary").getString());
        if (!reminderFolder.isNew()) {
            reminderFolder.save();
        } else {
            reminderFolder.getSession().save();
        }
        this.eventCache.remove((Serializable)((Object)eventNode.getProperty("exo:id").getString()));
    }

    @Override
    public void addEvent(CalendarEvent event) throws Exception {
        block12: {
            Node eventFolder = this.getEventFolder(event.getFromDateTime());
            this.syncRemoveEvent(eventFolder, event.getId());
            CalendarEvent ev = new CalendarEvent();
            Node publicEvent = eventFolder.addNode(ev.getId(), "exo:calendarPublicEvent");
            publicEvent.setProperty("exo:id", ev.getId());
            publicEvent.setProperty("exo:rootEventId", event.getId());
            publicEvent.setProperty("exo:eventType", event.getEventType());
            publicEvent.setProperty("exo:calendarId", event.getCalendarId());
            GregorianCalendar startTime = Utils.getInstanceTempCalendar();
            GregorianCalendar endTime = Utils.getInstanceTempCalendar();
            startTime.setTime(event.getFromDateTime());
            int fromDate = startTime.get(6);
            publicEvent.setProperty("exo:fromDateTime", (java.util.Calendar)startTime);
            publicEvent.getSession().save();
            publicEvent.setProperty("exo:eventState", event.getEventState());
            endTime.setTime(event.getToDateTime());
            int toDate = endTime.get(6);
            if (toDate > fromDate) {
                GregorianCalendar tmpTime = Utils.getInstanceTempCalendar();
                tmpTime.setTime(event.getFromDateTime());
                tmpTime.set(11, 0);
                tmpTime.set(12, 0);
                tmpTime.set(13, 0);
                tmpTime.set(14, 0);
                tmpTime.setTimeInMillis(tmpTime.getTimeInMillis() + 86400000L - 1000L);
                publicEvent.setProperty("exo:toDateTime", (java.util.Calendar)tmpTime);
                publicEvent.getSession().save();
            } else {
                publicEvent.setProperty("exo:toDateTime", (java.util.Calendar)endTime);
                publicEvent.getSession().save();
            }
            publicEvent.setProperty("exo:participant", event.getParticipant());
            try {
                if (!eventFolder.isNew()) {
                    eventFolder.save();
                } else {
                    eventFolder.getSession().save();
                }
            }
            catch (Exception e) {
                eventFolder.getSession().refresh(true);
                eventFolder.getSession().save();
            }
            try {
                if (toDate > fromDate) {
                    GregorianCalendar cal = Utils.getInstanceTempCalendar();
                    cal.setTime(event.getFromDateTime());
                    cal.set(11, 0);
                    cal.set(12, 0);
                    cal.set(13, 0);
                    cal.set(14, 0);
                    for (int i = fromDate + 1; i <= toDate; ++i) {
                        ((java.util.Calendar)cal).roll(6, true);
                        Node dateFolder = this.getEventFolder(cal.getTime());
                        ev = new CalendarEvent();
                        eventFolder.getSession().getWorkspace().copy(publicEvent.getPath(), dateFolder.getPath() + "/" + ev.getId());
                        dateFolder.getSession().save();
                        if (i > toDate) continue;
                        Node newEvent = dateFolder.getNode(ev.getId());
                        newEvent.setProperty("exo:id", ev.getId());
                        newEvent.setProperty("exo:fromDateTime", (java.util.Calendar)cal);
                        newEvent.getSession().save();
                        GregorianCalendar tmpCal = Utils.getInstanceTempCalendar();
                        if (i == toDate) {
                            tmpCal.setTime(event.getToDateTime());
                        } else {
                            tmpCal.setTimeInMillis(cal.getTimeInMillis() + 86400000L - 1000L);
                        }
                        newEvent.setProperty("exo:toDateTime", (java.util.Calendar)tmpCal);
                        newEvent.getSession().save();
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block12;
                log.debug((Object)e);
            }
        }
    }

    @Override
    public void syncRemoveEvent(Node eventFolder, String rootEventId) throws Exception {
        QueryManager qm = eventFolder.getSession().getWorkspace().getQueryManager();
        StringBuilder queryString = new StringBuilder("/jcr:root").append(eventFolder.getParent().getParent().getParent().getPath()).append("//element(*,exo:calendarPublicEvent)[@exo:rootEventId='").append(rootEventId).append("']");
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            it.nextNode().remove();
        }
        this.eventCache.remove((Serializable)((Object)rootEventId));
        eventFolder.getSession().save();
        eventFolder.refresh(true);
    }

    @Override
    public Node getReminderFolder(Date fromDate) throws Exception {
        return this.getReminderFolder(fromDate, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Node getReminderFolder(Date fromDate, boolean create) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode("reminders");
        }
        catch (PathNotFoundException pnfe) {
            if (!create) return null;
            Lock lock = this.getLock("RemiderFolder", dateFolder.getPath());
            lock.lock();
            try {
                if (dateFolder.hasNode("reminders")) return dateFolder.getNode("reminders");
                dateFolder.addNode("reminders", "nt:unstructured");
                if (dateFolder.isNew()) {
                    dateFolder.getSession().save();
                    return dateFolder.getNode("reminders");
                } else {
                    dateFolder.save();
                }
                return dateFolder.getNode("reminders");
            }
            catch (Exception e) {
                dateFolder.refresh(false);
                return dateFolder.getNode("reminders");
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public Node getEventFolder(Date fromDate) throws Exception {
        Node publicApp = this.getPublicCalendarServiceHome();
        Node dateFolder = this.getDateFolder(publicApp, fromDate);
        try {
            return dateFolder.getNode(CALENDAR_EVENT);
        }
        catch (PathNotFoundException e) {
            dateFolder.addNode(CALENDAR_EVENT, "nt:unstructured");
            this.getPublicRoot().getSession().save();
            return dateFolder.getNode(CALENDAR_EVENT);
        }
    }

    @Override
    public Node getDateFolder(Node publicApp, Date date) throws Exception {
        Node monthNode;
        Node yearNode;
        if (date instanceof DateTime) {
            date = new Date(date.getTime());
        }
        GregorianCalendar fromCalendar = Utils.getInstanceTempCalendar();
        fromCalendar.setTime(date);
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        try {
            yearNode = publicApp.getNode(year);
        }
        catch (PathNotFoundException e) {
            yearNode = publicApp.addNode(year, "nt:unstructured");
        }
        try {
            monthNode = yearNode.getNode(month);
        }
        catch (PathNotFoundException e) {
            monthNode = yearNode.addNode(month, "nt:unstructured");
        }
        try {
            return monthNode.getNode(day);
        }
        catch (PathNotFoundException e) {
            return monthNode.addNode(day, "nt:unstructured");
        }
    }

    @Override
    public void addAttachment(Node eventNode, Attachment attachment, boolean isNew) throws Exception {
        Node attachNode;
        Node attachHome;
        ExtendedNode extNode = (ExtendedNode)eventNode;
        if (extNode.canAddMixin("exo:privilegeable")) {
            extNode.addMixin("exo:privilegeable");
        }
        String[] arrayPers = new String[]{"read", "add_node", "set_property", "remove"};
        extNode.setPermission(IdentityConstants.ANY, arrayPers);
        List permsList = extNode.getACL().getPermissionEntries();
        for (AccessControlEntry accessControlEntry : permsList) {
            extNode.setPermission(accessControlEntry.getIdentity(), arrayPers);
        }
        try {
            attachHome = eventNode.getNode("attachment");
        }
        catch (Exception e) {
            attachHome = eventNode.addNode("attachment", "nt:unstructured");
        }
        String name = attachment.getId().substring(attachment.getId().lastIndexOf("/") + 1);
        try {
            attachNode = attachHome.getNode(name);
        }
        catch (Exception e) {
            attachNode = attachHome.addNode(name, "exo:eventAttachment");
        }
        attachNode.setProperty("exo:fileName", attachment.getName());
        Node nodeContent = null;
        try {
            nodeContent = attachNode.getNode("jcr:content");
        }
        catch (Exception e) {
            nodeContent = attachNode.addNode("jcr:content", "nt:resource");
        }
        nodeContent.setProperty("jcr:lastModified", java.util.Calendar.getInstance().getTimeInMillis());
        nodeContent.setProperty("jcr:mimeType", attachment.getMimeType());
        nodeContent.setProperty("jcr:data", attachment.getInputStream());
        this.eventCache.remove((Serializable)((Object)eventNode.getProperty("exo:id").getString()));
    }

    public void removeAttachmentById(String attId) {
        block2: {
            try {
                Node calendarApp = Utils.getPublicServiceHome();
                Node parentNode = calendarApp.getSession().getItem(attId).getParent();
                calendarApp.getSession().getItem(attId).remove();
                parentNode.save();
                this.eventCache.remove((Serializable)((Object)parentNode.getParent().getProperty("exo:id").getString()));
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)e.getMessage());
            }
        }
    }

    @Override
    public void saveCalendarSetting(String username, CalendarSetting setting) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(username);
        this.addCalendarSetting(calendarHome, setting);
        Session session = calendarHome.getSession();
        session.save();
        this.calendarSettingCache.remove((Serializable)((Object)username));
    }

    private void saveCalendarSetting(CalendarSetting setting, String username) throws Exception {
        Node calendarHome = this.getUserCalendarServiceHome(username);
        this.addCalendarSetting(calendarHome, setting);
        calendarHome.save();
        this.calendarSettingCache.remove((Serializable)((Object)username));
    }

    @Override
    public void addCalendarSetting(Node calendarHome, CalendarSetting setting) throws Exception {
        Node settingNode;
        try {
            settingNode = calendarHome.getNode(CALENDAR_SETTING);
        }
        catch (Exception e) {
            settingNode = calendarHome.addNode(CALENDAR_SETTING, "exo:calendarSetting");
        }
        settingNode.setProperty("exo:viewType", setting.getViewType());
        settingNode.setProperty("exo:timeInterval", setting.getTimeInterval());
        settingNode.setProperty("exo:weekStartOn", setting.getWeekStartOn());
        settingNode.setProperty("exo:dateFormat", setting.getDateFormat());
        settingNode.setProperty("exo:timeFormat", setting.getTimeFormat());
        settingNode.setProperty("exo:timeZone", setting.getTimeZone());
        settingNode.setProperty("exo:showWorkingTime", setting.isShowWorkingTime());
        if (setting.isShowWorkingTime()) {
            settingNode.setProperty("exo:workingTimeBegin", setting.getWorkingTimeBegin());
            settingNode.setProperty("exo:workingTimeEnd", setting.getWorkingTimeEnd());
        }
        settingNode.setProperty("exo:baseUrl", setting.getBaseURL());
        settingNode.setProperty("exo:defaultPrivateCalendars", setting.getFilterPrivateCalendars());
        settingNode.setProperty("exo:defaultPublicCalendars", setting.getFilterPublicCalendars());
        settingNode.setProperty("exo:defaultSharedCalendars", setting.getFilterSharedCalendars());
        settingNode.setProperty("exo:sharedCalendarsColors", setting.getSharedCalendarsColors());
        settingNode.setProperty("exo:sendOption", setting.getSendOption());
    }

    @Override
    public CalendarSetting getCalendarSetting(String username) throws Exception {
        CalendarSetting calendarSetting = (CalendarSetting)this.calendarSettingCache.get((Object)this, (Object)username);
        return calendarSetting;
    }

    private CalendarSetting getCalendarSetting(Node calendarHome) throws Exception {
        if (calendarHome.hasNode(CALENDAR_SETTING)) {
            CalendarSetting calendarSetting = new CalendarSetting();
            Node settingNode = calendarHome.getNode(CALENDAR_SETTING);
            StringBuilder namePattern = new StringBuilder(256);
            namePattern.append("exo:viewType").append('|').append("exo:timeInterval").append('|').append("exo:weekStartOn").append('|').append("exo:dateFormat").append('|').append("exo:timeFormat").append('|').append("exo:sendOption").append('|').append("exo:baseUrl").append('|').append("exo:timeZone").append('|').append("exo:showWorkingTime").append('|').append("exo:workingTimeBegin").append('|').append("exo:workingTimeEnd").append('|').append("exo:defaultPrivateCalendars").append('|').append("exo:defaultPublicCalendars").append('|').append("exo:defaultSharedCalendars").append('|').append("exo:sharedCalendarsColors");
            PropertyIterator it = settingNode.getProperties(namePattern.toString());
            String workingTimeBegin = null;
            String workingTimeEnd = null;
            while (it.hasNext()) {
                int i;
                String[] calendars;
                Value[] values;
                Property p = it.nextProperty();
                String name = p.getName();
                if (name.equals("exo:viewType")) {
                    calendarSetting.setViewType(p.getString());
                    continue;
                }
                if (name.equals("exo:timeInterval")) {
                    calendarSetting.setTimeInterval(p.getLong());
                    continue;
                }
                if (name.equals("exo:weekStartOn")) {
                    calendarSetting.setWeekStartOn(p.getString());
                    continue;
                }
                if (name.equals("exo:dateFormat")) {
                    calendarSetting.setDateFormat(p.getString());
                    continue;
                }
                if (name.equals("exo:timeFormat")) {
                    calendarSetting.setTimeFormat(p.getString());
                    continue;
                }
                if (name.equals("exo:sendOption")) {
                    calendarSetting.setSendOption(p.getString());
                    continue;
                }
                if (name.equals("exo:baseUrl")) {
                    calendarSetting.setBaseURL(p.getString());
                    continue;
                }
                if (name.equals("exo:timeZone")) {
                    calendarSetting.setTimeZone(p.getString());
                    continue;
                }
                if (name.equals("exo:showWorkingTime")) {
                    calendarSetting.setShowWorkingTime(p.getBoolean());
                    continue;
                }
                if (name.equals("exo:workingTimeBegin")) {
                    workingTimeBegin = p.getString();
                    continue;
                }
                if (name.equals("exo:workingTimeEnd")) {
                    workingTimeEnd = p.getString();
                    continue;
                }
                if (name.equals("exo:defaultPrivateCalendars")) {
                    values = p.getValues();
                    calendars = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        calendars[i] = values[i].getString();
                    }
                    calendarSetting.setFilterPrivateCalendars(calendars);
                    continue;
                }
                if (name.equals("exo:defaultPublicCalendars")) {
                    values = p.getValues();
                    calendars = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        calendars[i] = values[i].getString();
                    }
                    calendarSetting.setFilterPublicCalendars(calendars);
                    continue;
                }
                if (name.equals("exo:defaultSharedCalendars")) {
                    values = p.getValues();
                    calendars = new String[values.length];
                    for (i = 0; i < values.length; ++i) {
                        calendars[i] = values[i].getString();
                    }
                    calendarSetting.setFilterSharedCalendars(calendars);
                    continue;
                }
                if (!name.equals("exo:sharedCalendarsColors")) continue;
                values = p.getValues();
                String[] calendarsColors = new String[values.length];
                for (i = 0; i < values.length; ++i) {
                    calendarsColors[i] = values[i].getString();
                }
                calendarSetting.setSharedCalendarsColors(calendarsColors);
            }
            if (calendarSetting.isShowWorkingTime()) {
                calendarSetting.setWorkingTimeBegin(workingTimeBegin);
                calendarSetting.setWorkingTimeEnd(workingTimeEnd);
            }
            return calendarSetting;
        }
        return null;
    }

    @Override
    public void storeXML(String feedXML, Node rssHome, RssData rssData) throws Exception {
        String rssNodeName = rssData.getName();
        Node rss = rssHome.hasNode(rssNodeName) ? rssHome.getNode(rssNodeName) : rssHome.addNode(rssNodeName, "exo:rssData");
        rss.setProperty("exo:baseUrl", rssData.getUrl());
        rss.setProperty("exo:title", rssData.getTitle());
        rss.setProperty("exo:content", (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
    }

    @Override
    public void removeFeed(String username, String calendarId) throws Exception {
        block11: {
            try {
                Node rssCal;
                Node rssHome = this.getRssHome(username);
                NodeIterator iter = rssHome.getNodes();
                ArrayList<String> removedFeedNodes = new ArrayList<String>();
                while (iter.hasNext()) {
                    Node feedNode = iter.nextNode();
                    if (!feedNode.isNodeType("exo:rssData")) continue;
                    FeedData feedData = new FeedData();
                    feedData.setTitle(feedNode.getProperty("exo:title").getString());
                    StringBuilder url = new StringBuilder(feedNode.getProperty("exo:baseUrl").getString());
                    url.append("/").append(PortalContainer.getCurrentPortalContainerName());
                    url.append("/").append(feedNode.getSession().getWorkspace().getName());
                    url.append("/").append(username);
                    url.append("/").append(feedNode.getName());
                    feedData.setUrl(url.toString());
                    URL feedUrl = new URL(feedData.getUrl());
                    SyndFeedInput input = new SyndFeedInput();
                    SyndFeed feed = input.build((Reader)new XmlReader(feedUrl));
                    List entries = feed.getEntries();
                    ArrayList listBefore = new ArrayList();
                    listBefore.addAll(entries);
                    for (int i = 0; i < listBefore.size(); ++i) {
                        SyndEntry entry = (SyndEntry)listBefore.get(i);
                        String id = entry.getLink().substring(entry.getLink().lastIndexOf("/") + 1);
                        if (!id.contains(calendarId)) continue;
                        listBefore.remove(i);
                        --i;
                    }
                    if (listBefore.size() == 0) {
                        removedFeedNodes.add(feedNode.getName());
                        continue;
                    }
                    feed.setEntries(listBefore);
                    SyndFeedOutput output = new SyndFeedOutput();
                    String feedXML = output.outputString(feed);
                    feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
                    feedNode.setProperty("exo:content", (InputStream)new ByteArrayInputStream(feedXML.getBytes()));
                    feedNode.save();
                }
                if (removedFeedNodes.size() > 0) {
                    for (String s : removedFeedNodes) {
                        if (rssHome.getNode(s) == null) continue;
                        rssHome.getNode(s).remove();
                    }
                    rssHome.getSession().save();
                }
                if (rssHome.hasNode("WebDavCalendars")) {
                    iter = rssHome.getNode("WebDavCalendars").getNodes();
                    while (iter.hasNext()) {
                        rssCal = iter.nextNode();
                        if (!rssCal.getPath().contains(calendarId)) continue;
                        rssCal.remove();
                    }
                }
                if (rssHome.hasNode("iCalendars")) {
                    iter = rssHome.getNode("iCalendars").getNodes();
                    while (iter.hasNext()) {
                        rssCal = iter.nextNode();
                        if (!rssCal.getPath().contains(calendarId)) continue;
                        rssCal.remove();
                    }
                }
                rssHome.getSession().save();
            }
            catch (FileNotFoundException e) {
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)e.getMessage());
            }
        }
    }

    public void removeFeedData(String username, String title) {
        block3: {
            try {
                Node rssHome = this.getRssHome(username);
                NodeIterator iter = rssHome.getNodes();
                while (iter.hasNext()) {
                    Node feedNode = iter.nextNode();
                    if (!feedNode.isNodeType("exo:rssData") || !feedNode.getProperty("exo:title").getString().equals(title)) continue;
                    feedNode.remove();
                    break;
                }
                rssHome.getSession().save();
            }
            catch (Exception ex) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Fail to remove feed data", (Throwable)ex);
            }
        }
    }

    @Override
    public List<FeedData> getFeeds(String username) throws Exception {
        ArrayList<FeedData> feeds;
        block3: {
            feeds = new ArrayList<FeedData>();
            try {
                Node rssHome = this.getRssHome(username);
                NodeIterator iter = rssHome.getNodes();
                while (iter.hasNext()) {
                    Node feedNode = iter.nextNode();
                    if (!feedNode.isNodeType("exo:rssData")) continue;
                    FeedData feed = new FeedData();
                    feed.setTitle(feedNode.getProperty("exo:title").getString());
                    StringBuilder url = new StringBuilder(feedNode.getProperty("exo:baseUrl").getString());
                    feed.setUrl(url.toString());
                    feed.setContent(feedNode.getProperty("exo:content").getStream());
                    feeds.add(feed);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)e);
            }
        }
        return feeds;
    }

    @Override
    public int generateRss(String username, List<String> calendarIds, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        Node iCalHome = null;
        try {
            iCalHome = rssHomeNode.getNode("iCalendars");
        }
        catch (Exception e) {
            iCalHome = rssHomeNode.addNode("iCalendars", "nt:unstructured");
        }
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            String portalName = PortalContainer.getCurrentPortalContainerName();
            for (String calendarId : calendarIds) {
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), "0", -1);
                if (out == null) continue;
                ByteArrayInputStream is = new ByteArrayInputStream(out.toString().getBytes());
                try {
                    iCalHome.getNode(calendarId + ".ics").setProperty("exo:data", (InputStream)is);
                }
                catch (Exception e) {
                    Node ical = iCalHome.addNode(calendarId + ".ics", "exo:iCalData");
                    ical.setProperty("exo:data", (InputStream)is);
                }
                StringBuilder path = new StringBuilder("/");
                path.append(iCalHome.getName()).append("/").append(iCalHome.getNode(calendarId + ".ics").getName());
                String url = this.getEntryUrl(portalName, rssHomeNode.getSession().getWorkspace().getName(), username, path.toString(), rssData.getUrl());
                Calendar exoCal = this.getUserCalendar(username, calendarId);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(url);
                entry.setAuthor(username);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                log.info((Object)"No data to make rss!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return -1;
        }
        return 1;
    }

    @Override
    public int generateRss(String username, LinkedHashMap<String, Calendar> calendars, RssData rssData, CalendarImportExport importExport) throws Exception {
        Node rssHomeNode = this.getRssHome(username);
        try {
            SyndFeedImpl feed = new SyndFeedImpl();
            feed.setFeedType(rssData.getVersion());
            feed.setTitle(rssData.getTitle());
            feed.setLink(rssData.getLink());
            feed.setDescription(rssData.getDescription());
            ArrayList<SyndEntryImpl> entries = new ArrayList<SyndEntryImpl>();
            for (String calendarMap : calendars.keySet()) {
                String calendarId = calendarMap.split(":")[1];
                String type = calendarMap.split(":")[0];
                OutputStream out = importExport.exportCalendar(username, Arrays.asList(calendarId), type, -1);
                if (out == null) continue;
                Calendar exoCal = calendars.get(calendarMap);
                SyndEntryImpl entry = new SyndEntryImpl();
                entry.setTitle(exoCal.getName());
                entry.setLink(rssHomeNode.getPath() + "/" + calendarId);
                entry.setAuthor(username);
                SyndContentImpl description = new SyndContentImpl();
                description.setType("text/plain");
                description.setValue(exoCal.getDescription());
                entry.setDescription((SyndContent)description);
                entries.add(entry);
                entry.getEnclosures();
            }
            if (entries.isEmpty()) {
                log.info((Object)"No data to make rss!");
                return -1;
            }
            feed.setEntries(entries);
            feed.setEncoding("UTF-8");
            SyndFeedOutput output = new SyndFeedOutput();
            String feedXML = output.outputString((SyndFeed)feed);
            feedXML = StringUtils.replace((String)feedXML, (String)"&amp;", (String)"&");
            this.storeXML(feedXML, rssHomeNode, rssData);
            rssHomeNode.getSession().save();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return -1;
        }
        return 1;
    }

    @Override
    public String getEntryUrl(String portalName, String wsName, String username, String path, String baseUrl) throws Exception {
        StringBuilder url = new StringBuilder(baseUrl);
        url.append("/").append(portalName).append("/").append(wsName);
        if (username != null) {
            url.append("/").append(username);
        }
        url.append(path);
        return url.toString();
    }

    @Override
    @Deprecated
    public Map<Integer, String> searchHightLightEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        Map<Integer, String> mapData;
        block11: {
            mapData = new HashMap<Integer, String>();
            try {
                Query query;
                StringBuilder queryStatement;
                CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
                Node calendarHome = this.getUserCalendarHome(username);
                Node calendarShareNode = this.getSharedCalendarHome();
                Node publicCalHome = this.getPublicCalendarHome();
                java.util.Calendar fromDateCal = calSetting.createCalendar(eventQuery.getFromDate().getTimeInMillis());
                java.util.Calendar toDateCal = calSetting.createCalendar(eventQuery.getToDate().getTimeInMillis());
                QueryManager qm = publicCalHome.getSession().getWorkspace().getQueryManager();
                int queryPrivateEvents = username != null && username.length() > 0 ? 1 : 0;
                CountDownLatch latch = new CountDownLatch(queryPrivateEvents + 1);
                QueryHighLightEventsTask queryPrivateEventsTask = null;
                if (queryPrivateEvents == 1) {
                    queryStatement = new StringBuilder("/jcr:root").append(calendarHome.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "'))").append(" and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='norepeat' and @exo:recurrenceId='')]").append(" /(@exo:calendarId, @exo:toDateTime, @exo:fromDateTime)");
                    query = qm.createQuery(queryStatement.toString(), "xpath");
                    queryPrivateEventsTask = new QueryHighLightEventsTask(query, latch);
                    Thread queryPrivateEventsThread = new Thread(queryPrivateEventsTask);
                    queryPrivateEventsThread.start();
                }
                queryStatement = new StringBuilder("/jcr:root").append(publicCalHome.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "'))").append(" and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='norepeat' and @exo:recurrenceId='')");
                if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                    queryStatement.append(" and (");
                    for (int i = 0; i < publicCalendarIds.length; ++i) {
                        if (i == 0) {
                            queryStatement.append("@exo:calendarId = '" + publicCalendarIds[i] + "'");
                            continue;
                        }
                        queryStatement.append(" or @exo:calendarId = '" + publicCalendarIds[i] + "'");
                    }
                    queryStatement.append(")");
                }
                queryStatement.append("]").append(" /(@exo:calendarId, @exo:toDateTime, @exo:fromDateTime)");
                query = qm.createQuery(queryStatement.toString(), "xpath");
                QueryHighLightEventsTask queryPublicEventsTask = new QueryHighLightEventsTask(query, latch);
                Thread queryPublicEventsThread = new Thread(queryPublicEventsTask);
                queryPublicEventsThread.start();
                if (calendarShareNode.hasNode(username)) {
                    PropertyIterator propertyIterator = calendarShareNode.getNode(username).getReferences();
                    while (propertyIterator.hasNext()) {
                        try {
                            Node calendar = propertyIterator.nextProperty().getParent();
                            queryStatement = new StringBuilder("/jcr:root").append(calendar.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "'))").append(" and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='norepeat' and @exo:recurrenceId='')]").append(" /(@exo:calendarId, @exo:toDateTime, @exo:fromDateTime)");
                            query = qm.createQuery(queryStatement.toString(), "xpath");
                            NodeIterator it = query.execute().getNodes();
                            mapData = this.updateMap(mapData, it, fromDateCal, toDateCal, calSetting, 1);
                        }
                        catch (Exception e) {
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Fail to update map of shared event", (Throwable)e);
                        }
                    }
                }
                latch.await();
                mapData = this.updateMap(mapData, queryPublicEventsTask.iterator, fromDateCal, toDateCal, calSetting, 2);
                if (queryPrivateEventsTask != null) {
                    mapData = this.updateMap(mapData, queryPrivateEventsTask.iterator, fromDateCal, toDateCal, calSetting, 0);
                }
            }
            catch (Exception e) {
                log.info((Object)("Exception: " + e.getLocalizedMessage()));
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)"Fail to search highlight event", (Throwable)e);
            }
        }
        return mapData;
    }

    @Override
    public EventPageList searchEvent(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events;
        block11: {
            events = new ArrayList<CalendarEvent>();
            try {
                if (eventQuery.getCalendarId() == null) {
                    events.addAll(this.getUserEvents(username, eventQuery));
                    if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                        eventQuery.setCalendarId(publicCalendarIds);
                        events.addAll(this.getPublicEvents(eventQuery));
                        eventQuery.setCalendarId(null);
                    }
                    events.addAll(this.getSharedEvents(username, eventQuery));
                } else {
                    String calFullId = eventQuery.getCalendarId()[0];
                    if (calFullId.split(":").length > 0) {
                        String[] calId = new String[]{calFullId.split(":")[1]};
                        int type = Integer.parseInt(calFullId.split(":")[0]);
                        eventQuery.setCalendarId(calId);
                        switch (type) {
                            case 0: {
                                events.addAll(this.getUserEvents(username, eventQuery));
                                return new EventPageList(events, 10L);
                            }
                            case 1: {
                                events.addAll(this.getSharedEvents(username, eventQuery));
                                return new EventPageList(events, 10L);
                            }
                            case 2: {
                                events.addAll(this.getPublicEvents(eventQuery));
                                return new EventPageList(events, 10L);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)e);
            }
        }
        return new EventPageList(events, 10L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<Integer, String>> searchHightLightEventSQL(String username, EventQuery eventQuery, String[] privateCalendars, String[] publicCalendars) throws Exception {
        Query query;
        String[] categoryIds;
        String eventType;
        StringBuilder queryEventsStatementSQL;
        String calendarPath;
        Node calendarHome = this.getUserCalendarHome(username);
        Node calendarShareNode = this.getSharedCalendarHome();
        Node publicCalHome = this.getPublicCalendarHome();
        CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
        java.util.Calendar fromDateCal = calSetting.createCalendar(eventQuery.getFromDate().getTimeInMillis());
        java.util.Calendar toDateCal = calSetting.createCalendar(eventQuery.getToDate().getTimeInMillis());
        Map<Integer, String> mapData = new HashMap<Integer, String>();
        HashMap<Integer, String> emptyCalendarsMap = new HashMap<Integer, String>();
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : privateCalendars) {
            calendarPath = calendarHome.getPath() + "/" + calendarId + "/%";
            queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
            eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
            try {
                NodeIterator iterator = query.execute().getNodes();
                if (!iterator.hasNext()) {
                    emptyCalendarsMap.put(emptyCalendarsMap.size(), calendarId);
                }
                mapData = this.updateMap(mapData, iterator, fromDateCal, toDateCal, calSetting, 0);
            }
            catch (RepositoryException e) {
                log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
            }
            catch (Exception e) {
                log.debug((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
        qm = publicCalHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : publicCalendars) {
            calendarPath = publicCalHome.getPath() + "/" + calendarId + "/%";
            queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
            eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            Lock lock = this.getLock("GroupCalendarEvent", queryEventsStatementSQL.toString());
            lock.lock();
            try {
                List<CalendarEvent> events = (List<CalendarEvent>)this.groupCalendarEventCache.get((Serializable)((Object)queryEventsStatementSQL.toString()));
                if (events == null) {
                    query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
                    try {
                        NodeIterator iterator = query.execute().getNodes();
                        if (!iterator.hasNext()) {
                            emptyCalendarsMap.put(emptyCalendarsMap.size(), calendarId);
                        }
                        events = this.getGroupHighLightEvents(iterator);
                        this.groupCalendarEventCache.put((Serializable)((Object)queryEventsStatementSQL.toString()), events);
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                    }
                }
                mapData = this.updateMap1(mapData, events.iterator(), fromDateCal, toDateCal, calSetting, 2);
            }
            finally {
                lock.unlock();
            }
        }
        qm = calendarShareNode.getSession().getWorkspace().getQueryManager();
        if (calendarShareNode.hasNode(username)) {
            PropertyIterator propertyIterator = calendarShareNode.getNode(username).getReferences();
            while (propertyIterator.hasNext()) {
                try {
                    Node calendar = propertyIterator.nextProperty().getParent();
                    StringBuilder queryEventsStatementSQL2 = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendar.getPath()).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendar.getPath()).append("/%/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
                    String eventType2 = eventQuery.getEventType();
                    if (eventType2 != null && eventType2.length() > 0) {
                        queryEventsStatementSQL2.append(" AND (exo:eventType='" + eventType2 + "')");
                    }
                    if (!eventQuery.isSearchInAllCategories()) {
                        String[] categoryIds2 = eventQuery.getCategoryId();
                        queryEventsStatementSQL2.append(" AND (");
                        for (int i = 0; i < categoryIds2.length; ++i) {
                            if (i == 0) {
                                queryEventsStatementSQL2.append("exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                                continue;
                            }
                            queryEventsStatementSQL2.append(" OR exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                        }
                        queryEventsStatementSQL2.append(")");
                    }
                    query = qm.createQuery(queryEventsStatementSQL2.toString(), "sql");
                    NodeIterator iterator = query.execute().getNodes();
                    mapData = this.updateMap(mapData, iterator, fromDateCal, toDateCal, calSetting, 1);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to update map of shared event", (Throwable)e);
                }
            }
        }
        ArrayList<Map<Integer, String>> result = new ArrayList<Map<Integer, String>>();
        result.add(0, mapData);
        result.add(1, emptyCalendarsMap);
        return result;
    }

    private List<CalendarEvent> getGroupHighLightEvents(NodeIterator nodeIterator) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        while (nodeIterator.hasNext()) {
            events.add(this.getEvent(nodeIterator.nextNode()));
        }
        return events;
    }

    public Map<Integer, String> searchHighlightRecurrenceEvent(String username, EventQuery eventQuery, String[] publicCalendarIds, String timezone) throws Exception {
        HashMap<Integer, String> mapData = new HashMap<Integer, String>();
        int fromDayOfYear = eventQuery.getFromDate().get(6);
        int toDayOfYear = eventQuery.getFromDate().get(6);
        int daysOfYear = eventQuery.getFromDate().getMaximum(6);
        if (eventQuery.getToDate().get(6) > eventQuery.getFromDate().get(6)) {
            toDayOfYear += daysOfYear;
        }
        java.util.Calendar tempCalendar = java.util.Calendar.getInstance(DateUtils.getTimeZone((String)timezone));
        List<CalendarEvent> originalRecurEvents = this.getHighLightOriginalRecurrenceEvents(username, eventQuery.getFromDate(), eventQuery.getToDate(), publicCalendarIds);
        boolean isVictory = false;
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            Iterator<CalendarEvent> recurEventsIter = originalRecurEvents.iterator();
            block0: while (recurEventsIter.hasNext() && !isVictory) {
                CalendarEvent recurEvent = recurEventsIter.next();
                Map<String, CalendarEvent> tempMap = this.getOccurrenceEvents(recurEvent, eventQuery.getFromDate(), eventQuery.getToDate(), timezone);
                if (tempMap == null) continue;
                for (CalendarEvent event : tempMap.values().toArray(new CalendarEvent[0])) {
                    if (isVictory) continue block0;
                    tempCalendar.setTime(event.getFromDateTime());
                    int eventFromDayOfYear = tempCalendar.get(6);
                    if (tempCalendar.get(1) < eventQuery.getFromDate().get(1)) {
                        eventFromDayOfYear = 1;
                    }
                    tempCalendar.setTime(event.getToDateTime());
                    int eventToDayOfYear = tempCalendar.get(6);
                    if (tempCalendar.get(1) > eventQuery.getToDate().get(1)) {
                        eventToDayOfYear = 366;
                    }
                    Integer begin = -1;
                    Integer end = -1;
                    if (fromDayOfYear >= eventFromDayOfYear) {
                        begin = fromDayOfYear;
                        if (toDayOfYear <= eventToDayOfYear) {
                            end = toDayOfYear;
                            isVictory = true;
                        } else {
                            end = eventToDayOfYear;
                        }
                    } else {
                        begin = eventFromDayOfYear;
                        end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
                    }
                    if (begin <= 0 || end <= 0) continue;
                    Integer i = begin;
                    while (i <= end) {
                        mapData.put(i, VALUE);
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
            }
        }
        return mapData;
    }

    public List<Map<Integer, String>> searchHighlightRecurrenceEventSQL(String username, EventQuery eventQuery, String timezone, String[] privateCalendars, String[] publicCalendars) throws Exception {
        CalendarEvent calEvent;
        HashMap<Integer, String> mapData = new HashMap<Integer, String>();
        int fromDayOfYear = eventQuery.getFromDate().get(6);
        int toDayOfYear = eventQuery.getFromDate().get(6);
        int daysOfYear = eventQuery.getFromDate().getMaximum(6);
        if (eventQuery.getToDate().get(6) > eventQuery.getFromDate().get(6)) {
            toDayOfYear += daysOfYear;
        }
        java.util.Calendar tempCalendar = java.util.Calendar.getInstance(DateUtils.getTimeZone((String)timezone));
        List<CalendarEvent> originalRecurEvents = this.searchHighLightOriginalRecurrenceEventsSQL(username, eventQuery.getFromDate(), eventQuery.getToDate(), eventQuery, privateCalendars, publicCalendars);
        String[] emptyCalsId = new String[]{};
        if (originalRecurEvents != null && originalRecurEvents.size() > 0 && (calEvent = originalRecurEvents.get(0)).getCalendarId().equals("-1")) {
            emptyCalsId = calEvent.getSummary().split(";");
            originalRecurEvents.remove(0);
        }
        boolean isVictory = false;
        if (originalRecurEvents != null && originalRecurEvents.size() > 0) {
            Iterator<CalendarEvent> recurEventsIter = originalRecurEvents.iterator();
            block0: while (recurEventsIter.hasNext() && !isVictory) {
                CalendarEvent calendarEvent = recurEventsIter.next();
                Map<String, CalendarEvent> tempMap = this.getOccurrenceEvents(calendarEvent, eventQuery.getFromDate(), eventQuery.getToDate(), timezone);
                if (tempMap == null) continue;
                for (CalendarEvent event : tempMap.values().toArray(new CalendarEvent[0])) {
                    if (isVictory) continue block0;
                    tempCalendar.setTime(event.getFromDateTime());
                    int eventFromDayOfYear = tempCalendar.get(6);
                    if (tempCalendar.get(1) < eventQuery.getFromDate().get(1)) {
                        eventFromDayOfYear = 1;
                    }
                    tempCalendar.setTime(event.getToDateTime());
                    int eventToDayOfYear = tempCalendar.get(6);
                    if (tempCalendar.get(1) > eventQuery.getToDate().get(1)) {
                        eventToDayOfYear = 366;
                    }
                    Integer begin = -1;
                    Integer end = -1;
                    if (fromDayOfYear >= eventFromDayOfYear) {
                        begin = fromDayOfYear;
                        if (toDayOfYear <= eventToDayOfYear) {
                            end = toDayOfYear;
                            isVictory = true;
                        } else {
                            end = eventToDayOfYear;
                        }
                    } else {
                        begin = eventFromDayOfYear;
                        end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
                    }
                    if (begin <= 0 || end <= 0) continue;
                    Integer i = begin;
                    while (i <= end) {
                        mapData.put(i, VALUE);
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                }
            }
        }
        HashMap<Integer, String> emptyCalendarsMap = new HashMap<Integer, String>();
        for (String calendarId : emptyCalsId) {
            emptyCalendarsMap.put(emptyCalendarsMap.size(), calendarId);
        }
        ArrayList<Map<Integer, String>> arrayList = new ArrayList<Map<Integer, String>>();
        arrayList.add(0, mapData);
        arrayList.add(1, emptyCalendarsMap);
        return arrayList;
    }

    private Map<Integer, String> updateMap(Map<Integer, String> data, NodeIterator it, java.util.Calendar fromDate, java.util.Calendar toDate, CalendarSetting calendarSetting, int calType) throws Exception {
        String[] filterCalIds = null;
        switch (calType) {
            case 0: {
                filterCalIds = calendarSetting.getFilterPrivateCalendars();
                break;
            }
            case 2: {
                filterCalIds = calendarSetting.getFilterPublicCalendars();
                break;
            }
            case 1: {
                filterCalIds = calendarSetting.getFilterSharedCalendars();
                break;
            }
        }
        int fromDayOfYear = fromDate.get(6);
        int daysOfyer = fromDate.getMaximum(6);
        int toDayOfYear = toDate.get(6);
        if (toDate.get(6) > fromDate.get(6)) {
            toDayOfYear += daysOfyer;
        }
        boolean isVictory = false;
        while (it.hasNext() && !isVictory) {
            Node eventNode = it.nextNode();
            if (filterCalIds != null && Arrays.asList(filterCalIds).contains(eventNode.getProperty("exo:calendarId").getString())) continue;
            java.util.Calendar eventFormDate = calendarSetting.createCalendar(eventNode.getProperty("exo:fromDateTime").getDate().getTime());
            java.util.Calendar eventToDate = calendarSetting.createCalendar(eventNode.getProperty("exo:toDateTime").getDate().getTime());
            int eventFromDayOfYear = eventFormDate.get(6);
            int eventToDayOfYear = eventToDate.get(6);
            if (eventFormDate.get(1) < fromDate.get(1)) {
                eventFromDayOfYear = 1;
            }
            if (eventToDate.get(1) > toDate.get(1)) {
                eventToDayOfYear = 366;
            }
            Integer begin = -1;
            Integer end = -1;
            if (fromDayOfYear >= eventFromDayOfYear) {
                begin = fromDayOfYear;
                if (toDayOfYear <= eventToDayOfYear) {
                    end = toDayOfYear;
                    isVictory = true;
                } else {
                    end = eventToDayOfYear;
                }
            } else {
                begin = eventFromDayOfYear;
                end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
            }
            if (begin <= 0 || end <= 0) continue;
            Integer i = begin;
            while (i <= end) {
                data.put(i, VALUE);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return data;
    }

    private Map<Integer, String> updateMap1(Map<Integer, String> data, Iterator<CalendarEvent> it, java.util.Calendar fromDate, java.util.Calendar toDate, CalendarSetting calendarSetting, int calType) throws Exception {
        String[] filterCalIds = null;
        switch (calType) {
            case 0: {
                filterCalIds = calendarSetting.getFilterPrivateCalendars();
                break;
            }
            case 2: {
                filterCalIds = calendarSetting.getFilterPublicCalendars();
                break;
            }
            case 1: {
                filterCalIds = calendarSetting.getFilterSharedCalendars();
                break;
            }
        }
        int fromDayOfYear = fromDate.get(6);
        int daysOfyer = fromDate.getMaximum(6);
        int toDayOfYear = toDate.get(6);
        if (toDate.get(6) > fromDate.get(6)) {
            toDayOfYear += daysOfyer;
        }
        boolean isVictory = false;
        while (it.hasNext() && !isVictory) {
            CalendarEvent event = it.next();
            if (filterCalIds != null && Arrays.asList(filterCalIds).contains(event.getCalendarId())) continue;
            java.util.Calendar eventFormDate = calendarSetting.createCalendar(event.getFromDateTime().getTime());
            java.util.Calendar eventToDate = calendarSetting.createCalendar(event.getToDateTime().getTime());
            int eventFromDayOfYear = eventFormDate.get(6);
            int eventToDayOfYear = eventToDate.get(6);
            if (eventFormDate.get(1) < fromDate.get(1)) {
                eventFromDayOfYear = 1;
            }
            if (eventToDate.get(1) > toDate.get(1)) {
                eventToDayOfYear = 366;
            }
            Integer begin = -1;
            Integer end = -1;
            if (fromDayOfYear >= eventFromDayOfYear) {
                begin = fromDayOfYear;
                if (toDayOfYear <= eventToDayOfYear) {
                    end = toDayOfYear;
                    isVictory = true;
                } else {
                    end = eventToDayOfYear;
                }
            } else {
                begin = eventFromDayOfYear;
                end = toDayOfYear <= eventToDayOfYear ? Integer.valueOf(toDayOfYear) : Integer.valueOf(eventToDayOfYear);
            }
            if (begin <= 0 || end <= 0) continue;
            Integer i = begin;
            while (i <= end) {
                data.put(i, VALUE);
                Integer n = i;
                Integer n2 = i = Integer.valueOf(i + 1);
            }
        }
        return data;
    }

    private List<Value> calculateSharedCalendar(String user, Node calendarNode, Value[] values, List<Value> valueList, Node sharedCalendarHome) throws Exception {
        Session systemSession;
        Node userNode;
        block8: {
            CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(user));
            if (calSetting == null) {
                calSetting = new CalendarSetting();
            }
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : calSetting.getSharedCalendarsColors()) {
                map.put(key.split(":")[0], key.split(":")[1]);
            }
            if (map.get(calendarNode.getProperty("exo:id").getString()) == null) {
                map.put(calendarNode.getProperty("exo:id").getString(), calendarNode.getProperty("exo:calendarColor").getString());
            }
            ArrayList<String> calColors = new ArrayList<String>();
            for (String key : map.keySet()) {
                calColors.add(key + ":" + (String)map.get(key));
            }
            calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
            this.saveCalendarSetting(calSetting, user);
            userNode = null;
            systemSession = sharedCalendarHome.getSession();
            try {
                userNode = sharedCalendarHome.getNode(user);
            }
            catch (PathNotFoundException e) {
                userNode = sharedCalendarHome.addNode(user, "nt:unstructured");
                if (!userNode.canAddMixin("mix:referenceable")) break block8;
                userNode.addMixin("mix:referenceable");
            }
        }
        boolean isExist = false;
        isExist = false;
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            String uuid = value.getString();
            Node refNode = systemSession.getNodeByUUID(uuid);
            if (!refNode.getPath().equals(userNode.getPath())) continue;
            isExist = true;
            break;
        }
        if (!isExist) {
            Value value2add = calendarNode.getSession().getValueFactory().createValue(userNode);
            valueList.add(value2add);
        }
        return valueList;
    }

    @Override
    public void shareCalendar(String username, String calendarId, List<String> receiverUsers) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        Value[] values = new Value[]{};
        if (calendarNode.isNodeType("exo:calendarShared")) {
            values = calendarNode.getProperty("exo:sharedId").getValues();
        }
        List<Value> valueList = new ArrayList<Value>();
        for (int i = 0; i < values.length; ++i) {
            Value value = values[i];
            valueList.add(value);
        }
        for (String user : receiverUsers) {
            valueList = this.calculateSharedCalendar(user, calendarNode, values, valueList, sharedCalendarHome);
        }
        if (valueList.size() > 0) {
            if (!calendarNode.isNodeType("exo:calendarShared")) {
                calendarNode.addMixin("exo:calendarShared");
            }
            calendarNode.setProperty("exo:sharedId", valueList.toArray(new Value[valueList.size()]));
            calendarNode.save();
            sharedCalendarHome.getSession().save();
            calendarNode.getSession().save();
        }
        this.clearCalendarCache(calendarId, username);
    }

    @Override
    public GroupCalendarData getSharedCalendars(String username, boolean isShowAll) throws Exception {
        Node shareCalendarHome = this.getSharedCalendarHome();
        if (shareCalendarHome.hasNode(username)) {
            Node sharedNode = shareCalendarHome.getNode(username);
            ArrayList<Calendar> calendars = new ArrayList<Calendar>();
            PropertyIterator iter = sharedNode.getReferences();
            String[] defaultFilterCalendars = null;
            if (username != null) {
                defaultFilterCalendars = this.getCalendarSetting(username).getFilterSharedCalendars();
            }
            while (iter.hasNext()) {
                try {
                    Calendar cal = this.getCalendar(defaultFilterCalendars, null, iter.nextProperty().getParent(), isShowAll);
                    if (cal == null) continue;
                    calendars.add(cal);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to create new calendar", (Throwable)e);
                }
            }
            if (calendars.size() > 0) {
                return new GroupCalendarData("Shared", "Shared", calendars);
            }
        }
        return null;
    }

    private Node setCalendarProperties(Node calendarNode, Calendar calendar) throws Exception {
        calendarNode.setProperty("exo:name", calendar.getName());
        calendarNode.setProperty("exo:description", calendar.getDescription());
        calendarNode.setProperty("exo:viewPermissions", calendar.getViewPermission());
        calendarNode.setProperty("exo:editPermissions", calendar.getEditPermission());
        calendarNode.setProperty("exo:groups", calendar.getGroups());
        calendarNode.setProperty("exo:locale", calendar.getLocale());
        calendarNode.setProperty("exo:timeZone", calendar.getTimeZone());
        calendarNode.setProperty("exo:calendarColor", calendar.getCalendarColor());
        calendarNode.setProperty("exo:calendarOwner", calendar.getCalendarOwner());
        try {
            calendarNode.setProperty("exo:publicUrl", calendar.getPublicUrl());
            calendarNode.setProperty("exo:privateUrl", calendar.getPrivateUrl());
        }
        catch (ConstraintViolationException e) {
            log.debug((Object)"\n\n Need to add property definition in exo:calendar node type !", (Throwable)e);
        }
        return calendarNode;
    }

    @Override
    public void saveSharedCalendar(String username, Calendar calendar) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            ArrayList<Value> newValues = new ArrayList<Value>();
            while (iter.hasNext()) {
                Value[] values;
                Node calendarNode = iter.nextProperty().getParent();
                if (!calendarNode.getProperty("exo:id").getString().equals(calendar.getId())) continue;
                for (Value value : values = calendarNode.getProperty("exo:sharedId").getValues()) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                calendarNode = this.setCalendarProperties(calendarNode, calendar);
                CalendarSetting usCalSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : usCalSetting.getSharedCalendarsColors()) {
                    map.put(key.split(":")[0], key.split(":")[1]);
                }
                map.put(calendar.getId(), calendar.getCalendarColor());
                ArrayList<String> calColors = new ArrayList<String>();
                for (String key : map.keySet()) {
                    calColors.add(key + ":" + (String)map.get(key));
                }
                calColors.add(calendar.getId() + ":" + calendar.getCalendarColor());
                usCalSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
                this.saveCalendarSetting(usCalSetting, username);
                calendarNode.save();
                break;
            }
        }
        this.clearCalendarCache(calendar.getId(), username);
    }

    @Override
    public List<CalendarEvent> getSharedEvents(String username, EventQuery eventQuery) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        Node shareHome = this.getSharedCalendarHome();
        if (shareHome.hasNode(username)) {
            QueryManager qm = shareHome.getSession().getWorkspace().getQueryManager();
            PropertyIterator iter = this.getSharedCalendarHome().getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    eventQuery.setCalendarPath(calendar.getPath());
                    Query query = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
                    NodeIterator it = query.execute().getNodes();
                    while (it.hasNext()) {
                        CalendarEvent calEvent = this.getEvent(it.nextNode());
                        calEvent.setCalType(String.valueOf(1));
                        events.add(calEvent);
                        if (eventQuery.getLimitedItems() != it.getPosition()) continue;
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to get events from calendar", (Throwable)e);
                }
            }
        }
        return events;
    }

    @Override
    public List<CalendarEvent> getSharedEventByCalendars(String username, List<String> calendarIds) throws Exception {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        if (this.getSharedCalendarHome().hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome().getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendarIds.contains(calendar.getProperty("exo:id").getString())) continue;
                    NodeIterator it = calendar.getNodes();
                    while (it.hasNext()) {
                        events.add(this.getEventById(it.nextNode().getProperty("exo:id").getString()));
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to get events from calendar", (Throwable)e);
                }
            }
        }
        return events;
    }

    public CalendarEvent getSharedEvent(String username, String calendarId, String eventId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            PropertyIterator iter = this.getSharedCalendarHome().getNode(username).getReferences();
            while (iter.hasNext()) {
                try {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendarId.equals(calendar.getProperty("exo:id").getString()) || !calendar.hasNode(eventId)) continue;
                    CalendarEvent event = this.getEvent(calendar.getNode(eventId));
                    event.setCalType(String.valueOf(1));
                    return event;
                }
                catch (Exception e) {
                    log.error((Object)"Exception when get shared event", (Throwable)e);
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    public void saveEventToSharedCalendar(String username, String calendarId, CalendarEvent event, boolean isNew) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                if (!this.canEdit(calendar, username)) {
                    log.debug((Object)"\n Do not have edit permission. \n");
                    throw new AccessDeniedException();
                }
                Node reminderFolder = this.getReminderFolder(event.getFromDateTime());
                this.saveEvent(calendar, event, reminderFolder, isNew);
                calendar.save();
                break;
            }
        }
    }

    @Override
    public boolean canEdit(Node calNode, String username) throws Exception {
        OrganizationService oService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        Value[] editValues = calNode.getProperty("exo:editPermissions").getValues();
        String[] editPerms = new String[editValues.length];
        for (int i = 0; i < editValues.length; ++i) {
            editPerms[i] = editValues[i].getString();
        }
        return Utils.hasPermission(oService, editPerms, username);
    }

    private void clearCalendarCache(String calendarId, String username) {
        this.calendarCache.remove((Serializable)new KeyValuePair(calendarId, username));
        if (StringUtils.isNotBlank((String)username)) {
            this.calendarCache.remove((Serializable)new KeyValuePair(calendarId, null));
        }
    }

    @Deprecated
    public List<CalendarEvent> getAllNoRepeatEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        QueryEventsTask queryPublicEventsTask;
        QueryEventsTask queryPrivateEventsTask;
        CountDownLatch latch;
        ArrayList<CalendarEvent> allEvents;
        block28: {
            int i;
            String[] categoryIds;
            String eventType;
            allEvents = new ArrayList<CalendarEvent>();
            Node calendarHome = this.getUserCalendarHome(username);
            Node calendarShareNode = this.getSharedCalendarHome();
            Node publicCalHome = this.getPublicCalendarHome();
            CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
            QueryManager qm = publicCalHome.getSession().getWorkspace().getQueryManager();
            latch = new CountDownLatch(2);
            String[] filteredCalendars = calSetting.getFilterPrivateCalendars();
            StringBuilder queryStatement = new StringBuilder("/jcr:root").append(calendarHome.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "'))").append(" and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='norepeat' and @exo:recurrenceId='')");
            if (filteredCalendars != null && filteredCalendars.length > 0) {
                queryStatement.append(" and (");
                for (int i2 = 0; i2 < filteredCalendars.length; ++i2) {
                    if (i2 == 0) {
                        queryStatement.append("@exo:calendarId != '" + filteredCalendars[i2] + "'");
                        continue;
                    }
                    queryStatement.append(" or @exo:calendarId != '" + filteredCalendars[i2] + "'");
                }
            }
            if ((eventType = eventQuery.getEventType()) != null && eventType.length() > 0) {
                queryStatement.append(" and (@exo:eventType='" + eventType + "')");
            }
            if ((categoryIds = eventQuery.getCategoryId()) != null && categoryIds.length > 0) {
                queryStatement.append(" and (");
                for (int i3 = 0; i3 < categoryIds.length; ++i3) {
                    if (i3 == 0) {
                        queryStatement.append("@exo:eventCategoryId='").append(categoryIds[i3]).append("'");
                        continue;
                    }
                    queryStatement.append(" or @exo:eventCategoryId='").append(categoryIds[i3]).append("'");
                }
                queryStatement.append(")");
            }
            queryStatement.append("]");
            Query query = qm.createQuery(queryStatement.toString(), "xpath");
            queryPrivateEventsTask = new QueryEventsTask(query, String.valueOf(0), latch);
            Thread queryPrivateEventsThread = new Thread(queryPrivateEventsTask);
            queryPrivateEventsThread.start();
            filteredCalendars = calSetting.getFilterPublicCalendars();
            queryStatement = new StringBuilder("/jcr:root").append(publicCalHome.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')) and @exo:repeat='norepeat'");
            if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                queryStatement.append(" and (");
                for (i = 0; i < publicCalendarIds.length; ++i) {
                    if (i == 0) {
                        queryStatement.append("@exo:calendarId = '" + publicCalendarIds[i] + "'");
                        continue;
                    }
                    queryStatement.append(" or @exo:calendarId = '" + publicCalendarIds[i] + "'");
                }
                queryStatement.append(")");
            }
            if (filteredCalendars != null && filteredCalendars.length > 0) {
                queryStatement.append(" and (");
                for (i = 0; i < filteredCalendars.length; ++i) {
                    if (i == 0) {
                        queryStatement.append("@exo:calendarId != '" + filteredCalendars[i] + "'");
                        continue;
                    }
                    queryStatement.append(" or @exo:calendarId != '" + filteredCalendars[i] + "'");
                }
                queryStatement.append(")");
            }
            if ((eventType = eventQuery.getEventType()) != null && eventType.length() > 0) {
                queryStatement.append(" and (@exo:eventType='" + eventType + "')");
            }
            if ((categoryIds = eventQuery.getCategoryId()) != null && categoryIds.length > 0) {
                queryStatement.append(" and (");
                for (i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryStatement.append("@exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryStatement.append(" or @exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryStatement.append(")");
            }
            queryStatement.append("]");
            query = qm.createQuery(queryStatement.toString(), "xpath");
            queryPublicEventsTask = new QueryEventsTask(query, String.valueOf(2), latch);
            Thread queryPublicEventsThread = new Thread(queryPublicEventsTask);
            queryPublicEventsThread.start();
            filteredCalendars = calSetting.getFilterSharedCalendars();
            try {
                PropertyIterator propertyIterator = calendarShareNode.getNode(username).getReferences();
                while (propertyIterator.hasNext()) {
                    int i4;
                    Node calendar = propertyIterator.nextProperty().getParent();
                    queryStatement = new StringBuilder("/jcr:root").append(calendar.getPath()).append("//element(*,exo:calendarEvent)").append(" [ not(@exo:toDateTime < xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "')").append(" or @exo:fromDateTime > xs:dateTime('" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "'))").append(" and not(@jcr:mixinTypes='exo:repeatCalendarEvent' and @exo:repeat!='norepeat' and @exo:recurrenceId='')");
                    if (filteredCalendars != null && filteredCalendars.length > 0) {
                        queryStatement.append(" and (");
                        for (i4 = 0; i4 < filteredCalendars.length; ++i4) {
                            if (i4 == 0) {
                                queryStatement.append("@exo:calendarId != '" + filteredCalendars[i4] + "'");
                                continue;
                            }
                            queryStatement.append(" or @exo:calendarId != '" + filteredCalendars[i4] + "'");
                        }
                        queryStatement.append(")");
                    }
                    if ((eventType = eventQuery.getEventType()) != null && eventType.length() > 0) {
                        queryStatement.append(" and (@exo:eventType='" + eventType + "')");
                    }
                    if ((categoryIds = eventQuery.getCategoryId()) != null && categoryIds.length > 0) {
                        queryStatement.append(" and (");
                        for (i4 = 0; i4 < categoryIds.length; ++i4) {
                            if (i4 == 0) {
                                queryStatement.append("@exo:eventCategoryId='").append(categoryIds[i4]).append("'");
                                continue;
                            }
                            queryStatement.append(" or @exo:eventCategoryId='").append(categoryIds[i4]).append("'");
                        }
                        queryStatement.append(")");
                    }
                    queryStatement.append("]");
                    query = qm.createQuery(queryStatement.toString(), "xpath");
                    NodeIterator iterator = query.execute().getNodes();
                    while (iterator.hasNext()) {
                        CalendarEvent event = this.getEvent(iterator.nextNode());
                        event.setCalType(String.valueOf(1));
                        allEvents.add(event);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block28;
                log.debug((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
        latch.await();
        allEvents.addAll(queryPrivateEventsTask.events);
        allEvents.addAll(queryPublicEventsTask.events);
        return allEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarEvent> getAllNoRepeatEventsSQL(String username, EventQuery eventQuery, String[] privateCalendars, String[] publicCalendars, List<String> emptyCalendars) throws Exception {
        Query query;
        String[] categoryIds;
        String eventType;
        StringBuilder queryEventsStatementSQL;
        String calendarPath;
        ArrayList<CalendarEvent> allEvents = new ArrayList<CalendarEvent>();
        Node calendarHome = this.getUserCalendarHome(username);
        Node calendarShareNode = this.getSharedCalendarHome();
        Node publicCalHome = this.getPublicCalendarHome();
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : privateCalendars) {
            if (emptyCalendars != null && emptyCalendars.contains(calendarId)) continue;
            calendarPath = calendarHome.getPath() + "/" + calendarId + "/%";
            queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
            eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
            try {
                NodeIterator iterator = query.execute().getNodes();
                while (iterator.hasNext()) {
                    CalendarEvent event = this.getEvent(iterator.nextNode());
                    event.setCalType(String.valueOf(0));
                    allEvents.add(event);
                }
            }
            catch (RepositoryException e) {
                log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
            }
            catch (Exception e) {
                log.debug((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
        qm = publicCalHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : publicCalendars) {
            ArrayList<CalendarEvent> events;
            if (emptyCalendars != null && emptyCalendars.contains(calendarId)) continue;
            calendarPath = publicCalHome.getPath() + "/" + calendarId + "/%";
            queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
            eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            Lock lock = this.getLock("GroupCalendarEvent", queryEventsStatementSQL.toString());
            lock.lock();
            try {
                events = (ArrayList<CalendarEvent>)this.groupCalendarEventCache.get((Serializable)((Object)queryEventsStatementSQL.toString()));
                if (events == null) {
                    query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
                    events = new ArrayList<CalendarEvent>();
                    try {
                        NodeIterator iterator = query.execute().getNodes();
                        while (iterator.hasNext()) {
                            CalendarEvent event = this.getEvent(iterator.nextNode());
                            event.setCalType(String.valueOf(2));
                            events.add(event);
                        }
                        this.groupCalendarEventCache.put((Serializable)((Object)queryEventsStatementSQL.toString()), events);
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                    }
                }
            }
            finally {
                lock.unlock();
            }
            allEvents.addAll((Collection<CalendarEvent>)events);
        }
        qm = calendarShareNode.getSession().getWorkspace().getQueryManager();
        if (calendarShareNode.hasNode(username)) {
            PropertyIterator propertyIterator = calendarShareNode.getNode(username).getReferences();
            while (propertyIterator.hasNext()) {
                try {
                    Node calendar = propertyIterator.nextProperty().getParent();
                    StringBuilder queryEventsStatementSQL2 = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendar.getPath()).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendar.getPath()).append("/%/%'").append(" AND NOT (exo:toDateTime < TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getFromDate()) + "'").append(" OR exo:fromDateTime > TIMESTAMP '" + ISO8601.format((java.util.Calendar)eventQuery.getToDate()) + "')").append(" AND NOT (jcr:mixinTypes='exo:repeatCalendarEvent' AND NOT exo:repeat='norepeat' AND exo:recurrenceId='')");
                    String eventType2 = eventQuery.getEventType();
                    if (eventType2 != null && eventType2.length() > 0) {
                        queryEventsStatementSQL2.append(" AND (exo:eventType='" + eventType2 + "')");
                    }
                    if (!eventQuery.isSearchInAllCategories()) {
                        String[] categoryIds2 = eventQuery.getCategoryId();
                        queryEventsStatementSQL2.append(" AND (");
                        for (int i = 0; i < categoryIds2.length; ++i) {
                            if (i == 0) {
                                queryEventsStatementSQL2.append("exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                                continue;
                            }
                            queryEventsStatementSQL2.append(" OR exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                        }
                        queryEventsStatementSQL2.append(")");
                    }
                    query = qm.createQuery(queryEventsStatementSQL2.toString(), "sql");
                    try {
                        NodeIterator iterator = query.execute().getNodes();
                        while (iterator.hasNext()) {
                            CalendarEvent event = this.getEvent(iterator.nextNode());
                            event.setCalType(String.valueOf(1));
                            allEvents.add(event);
                        }
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to update map of shared event", (Throwable)e);
                }
            }
        }
        return allEvents;
    }

    public List<CalendarEvent> getHighLightOriginalRecurrenceEvents(String username, java.util.Calendar from, java.util.Calendar to, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
        Node calendarHome = this.getUserCalendarHome(username);
        String[] filterIds = calSetting.getFilterPrivateCalendars();
        CountDownLatch latch = new CountDownLatch(2);
        QueryRecurrentEventsTask privateEventsQueryTask = new QueryRecurrentEventsTask(calendarHome, String.valueOf(0), from, to, null, filterIds, latch);
        Thread privateEventsQueryThread = new Thread(privateEventsQueryTask);
        privateEventsQueryThread.start();
        Node publicCalendarHome = this.getPublicCalendarHome();
        filterIds = calSetting.getFilterPublicCalendars();
        QueryRecurrentEventsTask publicEventsQueryTask = new QueryRecurrentEventsTask(publicCalendarHome, String.valueOf(2), from, to, publicCalendarIds, filterIds, latch);
        Thread publicEventsQueryThread = new Thread(publicEventsQueryTask);
        publicEventsQueryThread.start();
        Node sharedCalendarHome = this.getSharedCalendarHome();
        filterIds = calSetting.getFilterSharedCalendars();
        List<String> filterIdList = null;
        if (filterIds != null && filterIds.length > 0) {
            filterIdList = Arrays.asList(filterIds);
        }
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (filterIdList != null && filterIdList.contains(calendar.getProperty("exo:id").getString())) continue;
                recurEvents.addAll(this.getOriginalRecurrenceEvents1(calendar, String.valueOf(1), from, to, null, null));
            }
        }
        latch.await();
        recurEvents.addAll(privateEventsQueryTask.calendarEvents);
        recurEvents.addAll(publicEventsQueryTask.calendarEvents);
        return recurEvents;
    }

    @Override
    public List<CalendarEvent> getEvents(String username, EventQuery eventQuery, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> events;
        block3: {
            events = new ArrayList<CalendarEvent>();
            ArrayList<String> filterList = new ArrayList<String>();
            CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
            filterList.addAll(Arrays.asList(calSetting.getFilterPrivateCalendars()));
            filterList.addAll(Arrays.asList(calSetting.getFilterPublicCalendars()));
            filterList.addAll(Arrays.asList(calSetting.getFilterSharedCalendars()));
            eventQuery.setFilterCalendarIds(filterList.toArray(new String[0]));
            events.addAll(this.getUserEvents(username, eventQuery));
            try {
                events.addAll(this.getSharedEvents(username, eventQuery));
                if (publicCalendarIds != null && publicCalendarIds.length > 0) {
                    eventQuery.setCalendarId(publicCalendarIds);
                    events.addAll(this.getPublicEvents(eventQuery));
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"Fail to get events", (Throwable)e);
            }
        }
        return events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarEvent> getHighLightOriginalRecurrenceEventsSQL(String username, java.util.Calendar from, java.util.Calendar to, EventQuery eventQuery, String[] privateCalendars, String[] publicCalendars, List<String> emptyCalendars) throws Exception {
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        recurEvents.addAll(this.getOriginalRecurrenceEventsSQL(this.getUserCalendarHome(username), String.valueOf(0), from, to, eventQuery, privateCalendars, emptyCalendars));
        Node publicHome = this.getPublicCalendarHome();
        QueryManager qm = publicHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : publicCalendars) {
            ArrayList<CalendarEvent> events;
            if (emptyCalendars != null && emptyCalendars.contains(calendarId)) continue;
            String calendarPath = publicHome.getPath() + "/" + calendarId;
            StringBuilder queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
            String eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                String[] categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            Lock lock = this.getLock("GroupCalendarRecurrentEvent", queryEventsStatementSQL.toString());
            lock.lock();
            try {
                events = (ArrayList<CalendarEvent>)this.groupCalendarRecurrentEventCache.get((Serializable)((Object)queryEventsStatementSQL.toString()));
                if (events == null) {
                    events = new ArrayList<CalendarEvent>();
                    Query query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
                    try {
                        NodeIterator it = query.execute().getNodes();
                        while (it.hasNext()) {
                            Node eventNode = it.nextNode();
                            CalendarEvent event = this.getEvent(eventNode);
                            event.setCalType(String.valueOf(2));
                            events.add(event);
                        }
                        this.groupCalendarRecurrentEventCache.put((Serializable)((Object)queryEventsStatementSQL.toString()), events);
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                    }
                }
            }
            finally {
                lock.unlock();
            }
            recurEvents.addAll(events);
        }
        Node sharedCalendarHome = this.getSharedCalendarHome();
        qm = sharedCalendarHome.getSession().getWorkspace().getQueryManager();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator propertyIterator = userNode.getReferences();
            while (propertyIterator.hasNext()) {
                Node calendarNode = propertyIterator.nextProperty().getParent();
                StringBuilder queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarNode.getPath()).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarNode.getPath()).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
                String eventType = eventQuery.getEventType();
                if (eventType != null && eventType.length() > 0) {
                    queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
                }
                if (!eventQuery.isSearchInAllCategories()) {
                    String[] categoryIds = eventQuery.getCategoryId();
                    queryEventsStatementSQL.append(" AND (");
                    for (int i = 0; i < categoryIds.length; ++i) {
                        if (i == 0) {
                            queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                            continue;
                        }
                        queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                    }
                    queryEventsStatementSQL.append(")");
                }
                Query query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Node eventNode = it.nextNode();
                    CalendarEvent event = this.getEvent(eventNode);
                    event.setCalType(String.valueOf(1));
                    recurEvents.add(event);
                }
            }
        }
        return recurEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CalendarEvent> searchHighLightOriginalRecurrenceEventsSQL(String username, java.util.Calendar from, java.util.Calendar to, EventQuery eventQuery, String[] privateCalendars, String[] publicCalendars) throws Exception {
        CalendarEvent event;
        Node eventNode;
        Query query;
        QueryResult result;
        NodeIterator it;
        String[] categoryIds;
        String eventType;
        StringBuilder queryEventsStatementSQL;
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        StringBuffer emptyCalendars = null;
        Node calendarHome = this.getUserCalendarHome(username);
        QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : privateCalendars) {
            String calendarPath = calendarHome.getPath() + "/" + calendarId;
            queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
            eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            if (!(it = (result = (query = qm.createQuery(queryEventsStatementSQL.toString(), "sql")).execute()).getNodes()).hasNext()) {
                if (emptyCalendars == null) {
                    emptyCalendars = new StringBuffer();
                    emptyCalendars.append(calendarId);
                    continue;
                }
                emptyCalendars.append(";" + calendarId);
                continue;
            }
            while (it.hasNext()) {
                eventNode = it.nextNode();
                event = this.getEvent(eventNode);
                event.setCalType(String.valueOf(0));
                recurEvents.add(event);
            }
        }
        Node publicHome = this.getPublicCalendarHome();
        qm = publicHome.getSession().getWorkspace().getQueryManager();
        for (String calendarId : publicCalendars) {
            ArrayList<CalendarEvent> events;
            block31: {
                String calendarPath = publicHome.getPath() + "/" + calendarId;
                StringBuilder queryEventsStatementSQL2 = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
                String eventType2 = eventQuery.getEventType();
                if (eventType2 != null && eventType2.length() > 0) {
                    queryEventsStatementSQL2.append(" AND (exo:eventType='" + eventType2 + "')");
                }
                if (!eventQuery.isSearchInAllCategories()) {
                    String[] categoryIds2 = eventQuery.getCategoryId();
                    queryEventsStatementSQL2.append(" AND (");
                    for (int i = 0; i < categoryIds2.length; ++i) {
                        if (i == 0) {
                            queryEventsStatementSQL2.append("exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                            continue;
                        }
                        queryEventsStatementSQL2.append(" OR exo:eventCategoryId='").append(categoryIds2[i]).append("'");
                    }
                    queryEventsStatementSQL2.append(")");
                }
                Lock lock = this.getLock("GroupCalendarRecurrentEvent", queryEventsStatementSQL2.toString());
                lock.lock();
                try {
                    events = (ArrayList<CalendarEvent>)this.groupCalendarRecurrentEventCache.get((Serializable)((Object)queryEventsStatementSQL2.toString()));
                    if (events != null) break block31;
                    Query query2 = qm.createQuery(queryEventsStatementSQL2.toString(), "sql");
                    events = new ArrayList<CalendarEvent>();
                    try {
                        NodeIterator it2 = query2.execute().getNodes();
                        if (!it2.hasNext()) {
                            if (emptyCalendars == null) {
                                emptyCalendars = new StringBuffer();
                                emptyCalendars.append(calendarId);
                            } else {
                                emptyCalendars.append(";" + calendarId);
                            }
                            break block31;
                        }
                        while (it2.hasNext()) {
                            Node eventNode2 = it2.nextNode();
                            CalendarEvent event2 = this.getEvent(eventNode2);
                            event2.setCalType(String.valueOf(2));
                            events.add(event2);
                        }
                        this.groupCalendarRecurrentEventCache.put((Serializable)((Object)queryEventsStatementSQL2.toString()), events);
                    }
                    catch (RepositoryException e) {
                        log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
                    }
                    catch (Exception e) {
                        log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            recurEvents.addAll((Collection<CalendarEvent>)events);
        }
        Node sharedCalendarHome = this.getSharedCalendarHome();
        qm = sharedCalendarHome.getSession().getWorkspace().getQueryManager();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator propertyIterator = userNode.getReferences();
            while (propertyIterator.hasNext()) {
                Node calendarNode = propertyIterator.nextProperty().getParent();
                queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarNode.getPath()).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarNode.getPath()).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
                eventType = eventQuery.getEventType();
                if (eventType != null && eventType.length() > 0) {
                    queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
                }
                if (!eventQuery.isSearchInAllCategories()) {
                    categoryIds = eventQuery.getCategoryId();
                    queryEventsStatementSQL.append(" AND (");
                    for (int i = 0; i < categoryIds.length; ++i) {
                        if (i == 0) {
                            queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                            continue;
                        }
                        queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                    }
                    queryEventsStatementSQL.append(")");
                }
                query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
                result = query.execute();
                it = result.getNodes();
                while (it.hasNext()) {
                    eventNode = it.nextNode();
                    event = this.getEvent(eventNode);
                    event.setCalType(String.valueOf(1));
                    recurEvents.add(event);
                }
            }
        }
        if (emptyCalendars != null) {
            CalendarEvent emptyCalEvent = new CalendarEvent();
            emptyCalEvent.setCalendarId("-1");
            emptyCalEvent.setSummary(emptyCalendars.toString());
            recurEvents.add(0, emptyCalEvent);
        }
        return recurEvents;
    }

    public List<CalendarEvent> getOriginalRecurrenceEvents(String username, java.util.Calendar from, java.util.Calendar to, String[] publicCalendarIds) throws Exception {
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
        Node calendarHome = this.getUserCalendarHome(username);
        String[] filterIds = calSetting.getFilterPrivateCalendars();
        recurEvents.addAll(this.getOriginalRecurrenceEvents1(calendarHome, String.valueOf(0), from, to, null, filterIds));
        Node sharedCalendarHome = this.getSharedCalendarHome();
        filterIds = calSetting.getFilterSharedCalendars();
        List<String> filterIdList = null;
        if (filterIds != null && filterIds.length > 0) {
            filterIdList = Arrays.asList(filterIds);
        }
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (filterIdList != null && filterIdList.contains(calendar.getProperty("exo:id").getString())) continue;
                recurEvents.addAll(this.getOriginalRecurrenceEvents1(calendar, String.valueOf(1), from, to, null, null));
            }
        }
        Node publicCalendarHome = this.getPublicCalendarHome();
        filterIds = calSetting.getFilterPublicCalendars();
        recurEvents.addAll(this.getOriginalRecurrenceEvents1(publicCalendarHome, String.valueOf(2), from, to, publicCalendarIds, filterIds));
        return recurEvents;
    }

    public List<CalendarEvent> getOriginalRecurrenceEvents1(Node calendar, String calType, java.util.Calendar from, java.util.Calendar to, String[] calendarIds, String[] filterCalendarIds) throws Exception {
        int i;
        if (calendar == null) {
            return null;
        }
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        StringBuilder queryString = new StringBuilder("/jcr:root").append(XPathUtils.escapeIllegalXPathName((String)calendar.getPath())).append("//element(*,exo:repeatCalendarEvent) [@exo:repeat!='norepeat' and @exo:recurrenceId=''").append(" and (not(@exo:repeatUntil) or @exo:repeatUntil >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from) + "'))").append(" and (not(@exo:repeatFinishDate) or @exo:repeatFinishDate >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from) + "'))");
        if (calendarIds != null && calendarIds.length > 0) {
            queryString.append(" and (");
            for (i = 0; i < calendarIds.length; ++i) {
                if (i == 0) {
                    queryString.append("@exo:calendarId = '").append(calendarIds[i]).append("'");
                    continue;
                }
                queryString.append(" or @exo:calendarId = '").append(calendarIds[i]).append("'");
            }
            queryString.append(")");
        }
        if (filterCalendarIds != null && filterCalendarIds.length > 0) {
            queryString.append(" and (");
            for (i = 0; i < filterCalendarIds.length; ++i) {
                if (i == 0) {
                    queryString.append("@exo:calendarId != '").append(filterCalendarIds[i]).append("'");
                    continue;
                }
                queryString.append(" and @exo:calendarId != '").append(filterCalendarIds[i]).append("'");
            }
            queryString.append(")");
        }
        queryString.append("]");
        QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Node eventNode = it.nextNode();
            CalendarEvent event = this.getEvent(eventNode);
            event.setCalType(calType);
            recurEvents.add(event);
        }
        return recurEvents;
    }

    public List<CalendarEvent> getOriginalRecurrenceEventsSQL(Node calendar, String calType, java.util.Calendar from, java.util.Calendar to, EventQuery eventQuery, String[] calendarIds, List<String> emptyCalendars) throws Exception {
        if (calendar == null) {
            return null;
        }
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            if (emptyCalendars != null && emptyCalendars.contains(calendarId)) continue;
            String calendarPath = calendar.getPath() + "/" + calendarId;
            StringBuilder queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
            StringBuilder queryEventsStatementXPath = new StringBuilder("/jcr:root").append(calendarPath).append("/element(*,exo:repeatCalendarEvent) [@exo:repeat!='norepeat' and @exo:recurrenceId=''").append(" and (not(@exo:repeatUntil) or @exo:repeatUntil >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from) + "'))").append(" and (not(@exo:repeatFinishDate) or @exo:repeatFinishDate >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from) + "'))").append("]");
            String eventType = eventQuery.getEventType();
            if (eventType != null && eventType.length() > 0) {
                queryEventsStatementSQL.append(" AND (exo:eventType='" + eventType + "')");
            }
            if (!eventQuery.isSearchInAllCategories()) {
                String[] categoryIds = eventQuery.getCategoryId();
                queryEventsStatementSQL.append(" AND (");
                for (int i = 0; i < categoryIds.length; ++i) {
                    if (i == 0) {
                        queryEventsStatementSQL.append("exo:eventCategoryId='").append(categoryIds[i]).append("'");
                        continue;
                    }
                    queryEventsStatementSQL.append(" OR exo:eventCategoryId='").append(categoryIds[i]).append("'");
                }
                queryEventsStatementSQL.append(")");
            }
            QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Node eventNode = it.nextNode();
                CalendarEvent event = this.getEvent(eventNode);
                event.setCalType(calType);
                recurEvents.add(event);
            }
        }
        return recurEvents;
    }

    public List<CalendarEvent> searchOriginalRecurrenceEventsSQL(Node calendar, String calType, java.util.Calendar from, java.util.Calendar to, String[] calendarIds, List<String> emptyCalendars) throws Exception {
        if (calendar == null) {
            return null;
        }
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        for (String calendarId : calendarIds) {
            String calendarPath = calendar.getPath() + "/" + calendarId;
            StringBuilder queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath).append("/%'").append(" AND NOT jcr:path LIKE '").append(calendarPath).append("/%/%'").append(" AND jcr:mixinTypes='exo:repeatCalendarEvent'").append(" AND NOT exo:repeat='norepeat'").append(" AND (exo:repeatUntil IS NULL OR exo:repeatUntil >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )").append(" AND (exo:repeatFinishDate IS NULL OR exo:repeatFinishDate >=  TIMESTAMP '" + ISO8601.format((java.util.Calendar)from) + "' )");
            QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(queryEventsStatementSQL.toString(), "sql");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            if (!it.hasNext()) {
                emptyCalendars.add(calendarId);
                continue;
            }
            while (it.hasNext()) {
                Node eventNode = it.nextNode();
                CalendarEvent event = this.getEvent(eventNode);
                event.setCalType(calType);
                recurEvents.add(event);
            }
        }
        return recurEvents;
    }

    public List<CalendarEvent> getOriginalRecurrenceEvents(Node calendar, String calType, java.util.Calendar from, java.util.Calendar to, String[] calendarIds, String[] filterCalendarIds) throws Exception {
        int i;
        if (calendar == null) {
            return null;
        }
        ArrayList<CalendarEvent> recurEvents = new ArrayList<CalendarEvent>();
        StringBuilder queryString = new StringBuilder("/jcr:root").append(XPathUtils.escapeIllegalXPathName((String)calendar.getPath())).append("//element(*,exo:repeatCalendarEvent)[@exo:repeat!='").append(CalendarEvent.RP_NOREPEAT).append("' and @exo:recurrenceId=''");
        if (from != null) {
            queryString.append(" and (not(@exo:repeatUntil) or @exo:repeatUntil >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from)).append("'))").append(" and (not(@exo:repeatFinishDate) or @exo:repeatFinishDate >= xs:dateTime('" + ISO8601.format((java.util.Calendar)from)).append("'))");
        } else {
            queryString.append(" and (not(@exo:repeatUntil))").append(" and (not(@exo:repeatFinishDate))");
        }
        if (calendarIds != null && calendarIds.length > 0) {
            queryString.append(" and (");
            for (i = 0; i < calendarIds.length; ++i) {
                if (i == 0) {
                    queryString.append("@exo:calendarId = '").append(calendarIds[i]).append("'");
                    continue;
                }
                queryString.append(" or @exo:calendarId = '").append(calendarIds[i]).append("'");
            }
            queryString.append(")");
        }
        if (filterCalendarIds != null && filterCalendarIds.length > 0) {
            queryString.append(" and (");
            for (i = 0; i < filterCalendarIds.length; ++i) {
                if (i == 0) {
                    queryString.append("@exo:calendarId != '").append(filterCalendarIds[i]).append("'");
                    continue;
                }
                queryString.append(" and @exo:calendarId != '").append(filterCalendarIds[i]).append("'");
            }
            queryString.append(")");
        }
        queryString.append("]");
        QueryManager qm = calendar.getSession().getWorkspace().getQueryManager();
        Query query = qm.createQuery(queryString.toString(), "xpath");
        QueryResult result = query.execute();
        NodeIterator it = result.getNodes();
        while (it.hasNext()) {
            Node eventNode = it.nextNode();
            CalendarEvent event = this.getEvent(eventNode);
            event.setCalType(calType);
            recurEvents.add(event);
        }
        return recurEvents;
    }

    public List<CalendarEvent> getExceptionEvents(String username, CalendarEvent recurEvent) throws Exception {
        if (recurEvent == null || recurEvent.getRepeatType().equals(CalendarEvent.RP_NOREPEAT)) {
            return null;
        }
        try {
            Node calendarHome = null;
            int calType = Integer.parseInt(recurEvent.getCalType());
            Node eventNode = null;
            if (calType == 0) {
                calendarHome = this.getUserCalendarHome(username);
                eventNode = calendarHome.getNode(recurEvent.getCalendarId()).getNode(recurEvent.getId());
            }
            if (calType == 1 && (calendarHome = this.getSharedCalendarHome()).hasNode(username)) {
                PropertyIterator iter = calendarHome.getNode(username).getReferences();
                while (iter.hasNext()) {
                    Node calendar = iter.nextProperty().getParent();
                    if (!recurEvent.getCalendarId().equals(calendar.getProperty("exo:id")) || !calendar.hasNode(recurEvent.getId())) continue;
                    eventNode = calendar.getNode(recurEvent.getId());
                }
            }
            if (calType == 2) {
                calendarHome = this.getPublicCalendarHome();
                eventNode = calendarHome.getNode(recurEvent.getCalendarId()).getNode(recurEvent.getId());
            }
            if (eventNode == null || !eventNode.isNodeType("mix:referenceable")) {
                return null;
            }
            PropertyIterator propIter = eventNode.getReferences();
            if (propIter == null) {
                return null;
            }
            ArrayList<CalendarEvent> exceptions = new ArrayList<CalendarEvent>();
            while (propIter.hasNext()) {
                Property prop = propIter.nextProperty();
                Node exceptionNode = prop.getParent();
                CalendarEvent exception = this.getEvent(exceptionNode);
                exception.setCalType(String.valueOf(calType));
                exceptions.add(exception);
            }
            return exceptions;
        }
        catch (Exception e) {
            log.error((Object)"Exception occurred when finding all exception occurrences", (Throwable)e);
            return null;
        }
    }

    public Map<String, CalendarEvent> getOccurrenceEvents(CalendarEvent recurEvent, java.util.Calendar from, java.util.Calendar to, String timezone) throws Exception {
        if (Utils.isEmpty(recurEvent.getRepeatType())) {
            return null;
        }
        if (from.after(to) || !recurEvent.getFromDateTime().before(to.getTime())) {
            return null;
        }
        if (recurEvent.getRepeatUntilDate() != null && recurEvent.getRepeatUntilDate().before(from.getTime())) {
            return null;
        }
        TimeZone userTimeZone = DateUtils.getTimeZone((String)timezone);
        SimpleDateFormat format = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        format.setTimeZone(userTimeZone);
        HashMap<String, CalendarEvent> occurrences = new HashMap<String, CalendarEvent>();
        int diffMinutes = (int)((recurEvent.getToDateTime().getTime() - recurEvent.getFromDateTime().getTime()) / 60000L);
        Recur recur = Utils.getICalendarRecur(recurEvent);
        if (recur == null) {
            return null;
        }
        DateTime ical4jEventFrom = new DateTime(recurEvent.getFromDateTime());
        net.fortuna.ical4j.model.TimeZone tz = Utils.getICalTimeZone(DateUtils.getTimeZone((String)timezone));
        ical4jEventFrom.setTimeZone(tz);
        Utils.adaptRepeatRule(recur, recurEvent.getFromDateTime(), CalendarService.PERSISTED_TIMEZONE, userTimeZone);
        java.util.Calendar occurenceFrom = java.util.Calendar.getInstance();
        occurenceFrom.setTime(from.getTime());
        occurenceFrom.add(12, -(diffMinutes - 1));
        DateTime ical4jFrom = new DateTime(occurenceFrom.getTime());
        DateTime ical4jTo = new DateTime(to.getTime());
        Period period = new Period(ical4jFrom, ical4jTo);
        period.setTimeZone(tz);
        DateList list = recur.getDates((net.fortuna.ical4j.model.Date)ical4jEventFrom, period, net.fortuna.ical4j.model.parameter.Value.DATE_TIME);
        for (Object dt : list) {
            DateTime ical4jStart = (DateTime)dt;
            ical4jStart.setTimeZone(tz);
            CalendarEvent occurrence = new CalendarEvent(recurEvent);
            java.util.Calendar startTime = java.util.Calendar.getInstance(TimeZone.getDefault());
            java.util.Calendar endTime = java.util.Calendar.getInstance(TimeZone.getDefault());
            startTime.setTimeInMillis(ical4jStart.getTime());
            occurrence.setFromDateTime(startTime.getTime());
            endTime.setTime(startTime.getTime());
            endTime.add(12, diffMinutes);
            occurrence.setToDateTime(endTime.getTime());
            if (userTimeZone.useDaylightTime()) {
                this.adaptTimeToDST(occurrence, recurEvent, userTimeZone);
            }
            String recurId = format.format(occurrence.getFromDateTime());
            boolean isException = false;
            if (recurEvent.getExceptionIds() != null) {
                for (String s : recurEvent.getExcludeId()) {
                    if (!s.split("T")[0].equals(recurId.split("T")[0])) continue;
                    isException = true;
                    break;
                }
            }
            if (isException) continue;
            occurrence.setRecurrenceId(recurId);
            occurrences.put(recurId, occurrence);
        }
        return occurrences;
    }

    private void adaptTimeToDST(CalendarEvent occurrence, CalendarEvent recurEvent, TimeZone userTimeZone) {
        java.util.Calendar from = java.util.Calendar.getInstance(userTimeZone);
        java.util.Calendar to = java.util.Calendar.getInstance(userTimeZone);
        from.setTime(occurrence.getFromDateTime());
        to.setTime(occurrence.getToDateTime());
        int dstUser = userTimeZone.getDSTSavings() / 3600000;
        Boolean originalUseDst = userTimeZone.inDaylightTime(recurEvent.getFromDateTime());
        Boolean occurenceUseDst = userTimeZone.inDaylightTime(occurrence.getFromDateTime());
        if (originalUseDst.booleanValue() && !occurenceUseDst.booleanValue()) {
            from.add(10, dstUser);
            to.add(10, dstUser);
        }
        if (!originalUseDst.booleanValue() && occurenceUseDst.booleanValue()) {
            from.add(10, -dstUser);
            to.add(10, -dstUser);
        }
        occurrence.setFromDateTime(from.getTime());
        occurrence.setToDateTime(to.getTime());
    }

    public Date calculateRecurrenceFinishDate(CalendarEvent originalEvent) throws Exception {
        try {
            if (originalEvent.getRepeatUntilDate() != null) {
                return originalEvent.getRepeatUntilDate();
            }
            if (originalEvent.getRepeatCount() <= 0L) {
                return null;
            }
            DateTime ical4jEventFrom = new DateTime(originalEvent.getFromDateTime());
            VEvent vevent = new VEvent((net.fortuna.ical4j.model.Date)ical4jEventFrom, "");
            Recur recur = Utils.getICalendarRecur(originalEvent);
            vevent.getProperties().add((net.fortuna.ical4j.model.Property)new RRule(recur));
            GregorianCalendar calendar = new GregorianCalendar(2011, 7, 1);
            ((java.util.Calendar)calendar).setTimeZone(DateUtils.getTimeZone((String)"GMT"));
            calendar.set(1, ((java.util.Calendar)calendar).getMinimum(1));
            DateTime ical4jFrom = new DateTime(calendar.getTime());
            calendar.set(1, ((java.util.Calendar)calendar).getMaximum(1));
            DateTime ical4jTo = new DateTime(calendar.getTime());
            Period period = new Period(ical4jFrom, ical4jTo);
            PeriodList list = vevent.calculateRecurrenceSet(period);
            if (list == null || list.size() == 0) {
                return null;
            }
            Period last = (Period)list.last();
            calendar.setTimeInMillis(last.getStart().getTime());
            ((java.util.Calendar)calendar).add(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            return calendar.getTime();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred when calculating finish date of recurrence event", (Throwable)e);
            }
            return null;
        }
    }

    @Override
    public Map<String, String> checkFreeBusy(EventQuery eventQuery) throws Exception {
        Map<String, String> remainingInfo;
        Date fromDate = eventQuery.getFromDate().getTime();
        Date toDate = eventQuery.getToDate().getTime();
        HashMap<String, String> participantMap = new HashMap<String, String>();
        participantMap.putAll(this.checkFreeBusy(eventQuery, fromDate));
        if (!Utils.isSameDate(fromDate, toDate) && (remainingInfo = this.checkFreeBusy(eventQuery, toDate)).size() > 0) {
            StringBuilder sb = new StringBuilder();
            for (String par : remainingInfo.keySet()) {
                sb.append(remainingInfo.get(par));
                if (participantMap.containsKey(par)) {
                    sb.append(",").append((String)participantMap.get(par));
                }
                participantMap.put(par, sb.toString());
                sb.setLength(0);
            }
        }
        return participantMap;
    }

    public Map<String, String> checkFreeBusy(EventQuery eventQuery, Date date) throws Exception {
        String[] pars;
        Node eventFolder = this.getEventFolder(date);
        HashMap<String, String> participantMap = new HashMap<String, String>();
        String calendarPath = eventQuery.getCalendarPath();
        String[] orderBy = eventQuery.getOrderBy();
        eventQuery.setCalendarPath(eventFolder.getPath());
        eventQuery.setOrderBy(new String[]{"exo:fromDateTime"});
        QueryManager qm = this.getSession(this.createSystemProvider()).getWorkspace().getQueryManager();
        for (String par : pars = eventQuery.getParticipants()) {
            String[] participants = eventQuery.getParticipants();
            eventQuery.setParticipants(new String[]{par});
            Query query = qm.createQuery(eventQuery.getQueryStatement(), "xpath");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            StringBuilder timeValues = new StringBuilder();
            while (it.hasNext()) {
                String to;
                Node event = it.nextNode();
                if (!event.hasProperty("exo:eventState") || CalendarEvent.ST_AVAILABLE.equals(event.getProperty("exo:eventState").getValue().getString())) continue;
                java.util.Calendar fromCal = event.getProperty("exo:fromDateTime").getDate();
                java.util.Calendar toCal = event.getProperty("exo:toDateTime").getDate();
                String from = fromCal.getTimeInMillis() < eventQuery.getFromDate().getTimeInMillis() ? String.valueOf(eventQuery.getFromDate().getTimeInMillis()) : String.valueOf(fromCal.getTimeInMillis());
                if (toCal.getTimeInMillis() > eventQuery.getToDate().getTimeInMillis()) {
                    GregorianCalendar cal = new GregorianCalendar();
                    cal.setTimeInMillis(eventQuery.getToDate().getTimeInMillis() - 1000L);
                    to = String.valueOf(cal.getTimeInMillis());
                } else {
                    to = String.valueOf(toCal.getTimeInMillis());
                }
                if (timeValues != null && timeValues.length() > 0) {
                    timeValues.append(",");
                }
                timeValues.append(from).append(",").append(to);
                participantMap.put(par, timeValues.toString());
            }
            eventQuery.setParticipants(participants);
        }
        eventQuery.setCalendarPath(calendarPath);
        eventQuery.setOrderBy(orderBy);
        return participantMap;
    }

    @Override
    public void removeSharedEvent(String username, String calendarId, String eventId) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            PropertyIterator iter = userNode.getReferences();
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                if (calendar.hasNode(eventId)) {
                    Node event = calendar.getNode(eventId);
                    Node eventFolder = this.getEventFolder(event.getProperty("exo:fromDateTime").getDate().getTime());
                    this.syncRemoveEvent(eventFolder, eventId);
                    this.removeReminder(event);
                    event.remove();
                }
                calendar.save();
                calendar.refresh(true);
                break;
            }
            this.userCalendarCache.remove((Serializable)((Object)username));
        }
    }

    @Override
    public void moveEvent(String formCalendar, String toCalendar, String fromType, String toType, List<CalendarEvent> calEvents, String username) throws Exception {
        block34: {
            try {
                switch (Integer.parseInt(fromType)) {
                    case 0: {
                        if (!this.getUserCalendarHome(username).hasNode(formCalendar)) break;
                        switch (Integer.parseInt(toType)) {
                            case 0: {
                                if (!this.getUserCalendarHome(username).hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    if (!formCalendar.equals(toCalendar)) {
                                        this.removeUserEvent(username, formCalendar, calEvent.getId());
                                        calEvent.setCalendarId(toCalendar);
                                        this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                                        continue;
                                    }
                                    this.saveUserEvent(username, toCalendar, calEvent, false);
                                }
                                break block34;
                            }
                            case 1: {
                                if (!this.getSharedCalendarHome().hasNode(username)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removeUserEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.saveEventToSharedCalendar(username, toCalendar, calEvent, this.getSharedCalendarHome().getNode(username).hasNode(calEvent.getId()));
                                }
                                break block34;
                            }
                            case 2: {
                                if (!this.getPublicCalendarHome().hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removeUserEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome().getNode(toCalendar).hasNode(calEvent.getId()));
                                }
                                break block34;
                            }
                        }
                        break;
                    }
                    case 1: {
                        if (!this.getSharedCalendarHome().hasNode(username)) break;
                        switch (Integer.parseInt(toType)) {
                            case 0: {
                                if (!this.getUserCalendarHome(username).hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                                }
                                break block34;
                            }
                            case 1: {
                                if (!this.getSharedCalendarHome().hasNode(username)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    if (!formCalendar.equals(toCalendar)) {
                                        this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                        calEvent.setCalendarId(toCalendar);
                                        this.saveEventToSharedCalendar(username, toCalendar, calEvent, this.getSharedCalendarHome().getNode(username).hasNode(calEvent.getId()));
                                        continue;
                                    }
                                    this.saveEventToSharedCalendar(username, toCalendar, calEvent, false);
                                }
                                break block34;
                            }
                            case 2: {
                                if (!this.getPublicCalendarHome().hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removeSharedEvent(username, formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome().getNode(toCalendar).hasNode(calEvent.getId()));
                                }
                                break block34;
                            }
                        }
                        break;
                    }
                    case 2: {
                        if (!this.getPublicCalendarHome().hasNode(formCalendar)) break;
                        switch (Integer.parseInt(toType)) {
                            case 0: {
                                if (!this.getUserCalendarHome(username).hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removePublicEvent(formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    calEvent.setCalType(String.valueOf(0));
                                    this.saveUserEvent(username, toCalendar, calEvent, this.getUserCalendarHome(username).getNode(toCalendar).hasNode(calEvent.getId()));
                                }
                                break block34;
                            }
                            case 1: {
                                if (!this.getSharedCalendarHome().hasNode(username)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    this.removePublicEvent(formCalendar, calEvent.getId());
                                    calEvent.setCalendarId(toCalendar);
                                    this.saveEventToSharedCalendar(username, toCalendar, calEvent, true);
                                }
                                break block34;
                            }
                            case 2: {
                                if (!this.getPublicCalendarHome().hasNode(toCalendar)) break;
                                for (CalendarEvent calEvent : calEvents) {
                                    if (!formCalendar.equals(toCalendar)) {
                                        this.removePublicEvent(formCalendar, calEvent.getId());
                                        calEvent.setCalendarId(toCalendar);
                                        this.savePublicEvent(toCalendar, calEvent, this.getPublicCalendarHome().getNode(toCalendar).hasNode(calEvent.getId()));
                                        continue;
                                    }
                                    this.savePublicEvent(toCalendar, calEvent, false);
                                }
                                break block34;
                            }
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block34;
                log.debug((Object)"Fail to move event", (Throwable)e);
            }
        }
    }

    public void updateOccurrenceEvent(String fromCalendar, String toCalendar, String fromCalendarType, String toCalendarType, List<CalendarEvent> events, String username) throws Exception {
        try {
            int fromType = Integer.parseInt(fromCalendarType);
            int toType = Integer.parseInt(toCalendarType);
            for (CalendarEvent event : events) {
                if (event.getIsExceptionOccurrence() == null || !event.getIsExceptionOccurrence().booleanValue()) {
                    CalendarEvent originalEvent = null;
                    if (fromType == 0) {
                        originalEvent = this.getUserEvent(username, fromCalendar, event.getId());
                    } else if (fromType == 1) {
                        originalEvent = this.getSharedEvent(username, fromCalendar, event.getId());
                    } else if (fromType == 2) {
                        originalEvent = this.getGroupEvent(fromCalendar, event.getId());
                    }
                    if (originalEvent != null) {
                        ArrayList<Object> excludeId = originalEvent.getExcludeId() == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(originalEvent.getExcludeId()));
                        excludeId.add(event.getRecurrenceId());
                        originalEvent.setExcludeId(excludeId.toArray(new String[0]));
                        if (fromType == 0) {
                            this.saveUserEvent(username, fromCalendar, originalEvent, false);
                        } else if (fromType == 1) {
                            this.saveEventToSharedCalendar(username, fromCalendar, originalEvent, false);
                        } else if (fromType == 2) {
                            this.savePublicEvent(fromCalendar, originalEvent, false);
                        }
                    }
                }
                if (fromCalendar.equals(toCalendar)) {
                    if (Utils.isExceptionOccurrence(event)) {
                        this.saveOccurrenceEvent(username, toCalendar, event, false);
                        continue;
                    }
                    this.saveOccurrenceEvent(username, toCalendar, event, true);
                    continue;
                }
                if (Utils.isExceptionOccurrence(event)) {
                    if (fromType == 0) {
                        this.removeUserEvent(username, fromCalendar, event.getId());
                    } else if (fromType == 1) {
                        this.removeSharedEvent(username, fromCalendar, event.getId());
                    } else if (fromType == 2) {
                        this.removePublicEvent(fromCalendar, event.getId());
                    }
                }
                event.setCalendarId(toCalendar);
                event.setRepeatType(CalendarEvent.RP_NOREPEAT);
                event.setIsExceptionOccurrence(false);
                if (toType == 0) {
                    this.saveUserEvent(username, toCalendar, event, true);
                    continue;
                }
                if (toType == 1) {
                    this.saveEventToSharedCalendar(username, toCalendar, event, true);
                    continue;
                }
                if (toType != 2) continue;
                this.savePublicEvent(toCalendar, event, true);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error occurred when updating occurrence event", (Throwable)e);
        }
    }

    public void updateRecurrenceSeries(String fromCalendar, String toCalendar, String fromType, String toType, CalendarEvent occurrence, String username) throws Exception {
        try {
            String eventId = occurrence.getId();
            int calType = Integer.parseInt(fromType);
            int toCalType = Integer.parseInt(toType);
            CalendarEvent originalEvent = null;
            if (calType == 0) {
                originalEvent = this.getUserEvent(username, fromCalendar, eventId);
            } else if (calType == 2) {
                originalEvent = this.getGroupEvent(fromCalendar, eventId);
            } else if (calType == 1) {
                originalEvent = this.getSharedEvent(username, fromCalendar, eventId);
            }
            GregorianCalendar fromDate = Utils.getInstanceTempCalendar();
            fromDate.setTime(originalEvent.getFromDateTime());
            GregorianCalendar newFromDate = Utils.getInstanceTempCalendar();
            newFromDate.setTime(occurrence.getFromDateTime());
            fromDate.set(11, newFromDate.get(11));
            fromDate.set(12, newFromDate.get(12));
            originalEvent.setFromDateTime(fromDate.getTime());
            GregorianCalendar newToDate = Utils.getInstanceTempCalendar();
            newToDate.setTime(occurrence.getToDateTime());
            int diffMinutes = (int)(newToDate.getTimeInMillis() - newFromDate.getTimeInMillis()) / 60000;
            newToDate.setTime(fromDate.getTime());
            ((java.util.Calendar)newToDate).add(12, diffMinutes);
            originalEvent.setToDateTime(newToDate.getTime());
            originalEvent.setSummary(occurrence.getSummary());
            originalEvent.setDescription(occurrence.getDescription());
            originalEvent.setEventCategoryId(occurrence.getEventCategoryId());
            originalEvent.setEventCategoryName(occurrence.getEventCategoryName());
            originalEvent.setMessage(occurrence.getMessage());
            originalEvent.setLocation(occurrence.getLocation());
            List<Attachment> attachments = occurrence.getAttachment();
            originalEvent.setAttachment(attachments);
            originalEvent.setInvitation(occurrence.getInvitation());
            originalEvent.setParticipant(occurrence.getParticipant());
            originalEvent.setParticipantStatus(occurrence.getParticipantStatus());
            originalEvent.setReminders(occurrence.getReminders());
            originalEvent.setSendOption(occurrence.getSendOption());
            originalEvent.setStatus(occurrence.getStatus());
            originalEvent.setPriority(occurrence.getPriority());
            originalEvent.setRepeatType(occurrence.getRepeatType());
            originalEvent.setRepeatUntilDate(occurrence.getRepeatUntilDate());
            originalEvent.setRepeatCount(occurrence.getRepeatCount());
            originalEvent.setRepeatInterval(occurrence.getRepeatInterval());
            originalEvent.setRepeatByDay(occurrence.getRepeatByDay());
            originalEvent.setRepeatByMonthDay(occurrence.getRepeatByMonthDay());
            if (!fromCalendar.equals(toCalendar)) {
                if (calType == 0) {
                    this.removeUserEvent(username, fromCalendar, eventId);
                } else if (calType == 2) {
                    this.removePublicEvent(fromCalendar, eventId);
                } else if (calType == 1) {
                    this.removeSharedEvent(username, fromCalendar, eventId);
                }
                CalendarEvent newEvent = new CalendarEvent(originalEvent);
                newEvent.setCalendarId(toCalendar);
                newEvent.setExcludeId(originalEvent.getExcludeId());
                if (toCalType == 0) {
                    this.saveUserEvent(username, toCalendar, newEvent, true);
                } else if (toCalType == 1) {
                    this.saveEventToSharedCalendar(username, toCalendar, newEvent, true);
                } else if (toCalType == 2) {
                    this.savePublicEvent(toCalendar, newEvent, true);
                }
            } else if (calType == 0) {
                this.saveUserEvent(username, toCalendar, originalEvent, false);
            } else if (calType == 1) {
                this.saveEventToSharedCalendar(username, toCalendar, originalEvent, false);
            } else if (calType == 2) {
                this.savePublicEvent(toCalendar, originalEvent, false);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when update recurrence series", (Throwable)e);
        }
    }

    @Override
    public void confirmInvitation(String fromUserId, String toUserId, int calType, String calendarId, String eventId, int answer) {
        try {
            HashMap<String, String> pars = new HashMap<String, String>();
            CalendarEvent event = this.getInvitationEvent(calType, calendarId, eventId, fromUserId);
            if (event != null) {
                if (event.getParticipant() != null) {
                    for (String id : event.getParticipant()) {
                        pars.put(id, id);
                    }
                }
                for (String s : toUserId.split(",")) {
                    if (0 == answer) {
                        pars.remove(s);
                    }
                    if (1 != answer && 2 != answer) continue;
                    pars.put(s, s);
                }
                event.setParticipant(pars.values().toArray(new String[pars.values().size()]));
                if (0 == calType) {
                    this.saveUserEvent(fromUserId, calendarId, event, false);
                } else if (1 == calType) {
                    this.saveEventToSharedCalendar(fromUserId, calendarId, event, false);
                } else if (2 == calType) {
                    this.savePublicEvent(calendarId, event, false);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)String.format("Failed to confirm an invitation from user %s to user %s with event %s in calendar %s", fromUserId, toUserId, eventId, calendarId), (Throwable)e);
        }
    }

    private CalendarEvent getInvitationEvent(int calType, String calendarId, String eventId, String fromUserId) throws Exception {
        CalendarEvent event = null;
        if (0 == calType) {
            event = this.getUserEvent(fromUserId, calendarId, eventId);
        } else if (1 == calType) {
            ArrayList<String> calendarIds = new ArrayList<String>();
            calendarIds.add(calendarId);
            for (CalendarEvent calEvent : this.getSharedEventByCalendars(fromUserId, calendarIds)) {
                if (!calEvent.getId().equals(eventId)) continue;
                event = calEvent;
                break;
            }
        } else if (2 == calType) {
            event = this.getGroupEvent(calendarId, eventId);
        }
        return event;
    }

    @Override
    public void confirmInvitation(String fromUserId, String confirmingEmail, String confirmingUser, int calType, String calendarId, String eventId, int answer) throws Exception {
        try {
            HashMap<String, String> pars = new HashMap<String, String>();
            CalendarEvent event = this.getInvitationEvent(calType, calendarId, eventId, fromUserId);
            if (event != null) {
                if (event.getParticipantStatus() != null) {
                    for (String parStatus : event.getParticipantStatus()) {
                        String[] entry = parStatus.split(":");
                        if (entry.length > 1) {
                            pars.put(entry[0], entry[1]);
                            continue;
                        }
                        pars.put(entry[0], "");
                    }
                }
                String status = "";
                switch (answer) {
                    case 0: {
                        status = "no";
                        break;
                    }
                    case 1: {
                        status = "yes";
                        break;
                    }
                    case 2: {
                        status = "maybe";
                        break;
                    }
                }
                if (pars.containsKey(confirmingUser)) {
                    pars.remove(confirmingUser);
                    pars.put(confirmingUser, status);
                }
                if (pars.containsKey(confirmingEmail)) {
                    pars.remove(confirmingEmail);
                    pars.put(confirmingEmail, status);
                }
                HashMap<String, String> participant = new HashMap<String, String>();
                for (Map.Entry par : pars.entrySet()) {
                    participant.put((String)par.getKey() + ":" + (String)par.getValue(), "");
                }
                event.setParticipantStatus(participant.keySet().toArray(new String[participant.keySet().size()]));
                if (0 == calType) {
                    this.saveUserEvent(fromUserId, calendarId, event, false);
                } else if (1 == calType) {
                    this.saveEventToSharedCalendar(fromUserId, calendarId, event, false);
                } else if (2 == calType) {
                    this.savePublicEvent(calendarId, event, false);
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.getClass().toString(), e.fillInStackTrace());
        }
    }

    @Override
    public int getTypeOfCalendar(String userName, String calendarId) {
        Calendar cal = (Calendar)this.calendarCache.get((Object)this, (Object)new KeyValuePair(calendarId, userName));
        if (this.isNullCalendar(cal) && (cal = this.getCalendar(calendarId, null)) == null && (cal = this.getCalendar(calendarId, userName)) == null) {
            return -1;
        }
        if (!cal.isCalTypeChecked()) {
            int calType = this.getTypeOfCalendarFromStore(calendarId, userName);
            if (calType == -1) {
                return -1;
            }
            cal.setCalType(calType);
            cal.setCalTypeChecked(true);
        }
        return cal.getCalType();
    }

    private boolean isNullCalendar(Calendar cal) {
        return cal == null || cal == Calendar.NULL_OBJECT || cal.getId() == null;
    }

    public int getTypeOfCalendarFromStore(String calendarId, String userName) {
        int calType;
        block10: {
            block9: {
                block8: {
                    calType = -1;
                    try {
                        this.getUserCalendarHome(userName).getNode(calendarId);
                        calType = 0;
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block8;
                        log.debug((Object)String.format("Failed to find calendar %s from user node of user %s", calendarId, userName), (Throwable)e);
                    }
                }
                try {
                    this.getPublicCalendarHome().getNode(calendarId);
                    calType = 2;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)String.format("Failed to find calendar %s from public node of user %s", calendarId, userName), (Throwable)e);
                }
            }
            try {
                Node sharedCalendarHome = this.getSharedCalendarHome();
                if (sharedCalendarHome.hasNode(userName)) {
                    Node userNode = sharedCalendarHome.getNode(userName);
                    PropertyIterator iter = userNode.getReferences();
                    while (iter.hasNext() && calType == -1) {
                        Node calendar = iter.nextProperty().getParent();
                        if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                        calType = 1;
                    }
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)String.format("Failed to find calendar %s from shared node of user %s", calendarId, userName), (Throwable)e);
            }
        }
        return calType;
    }

    @Override
    public SessionProvider createSessionProvider() {
        SessionProvider provider = this.sessionProviderService_.getSessionProvider(null);
        if (provider == null) {
            log.info((Object)"No user session provider was available, trying to use a system session provider");
            provider = this.sessionProviderService_.getSystemSessionProvider(null);
        }
        return SessionProvider.createSystemProvider();
    }

    @Override
    public SessionProvider createUserProvider() {
        return this.sessionProviderService_.getSessionProvider(null);
    }

    @Override
    public SessionProvider createSystemProvider() {
        return this.sessionProviderService_.getSystemSessionProvider(null);
    }

    @Override
    public void closeSessionProvider(SessionProvider sessionProvider) {
        if (sessionProvider != null) {
            sessionProvider.close();
        }
    }

    @Override
    public Node getNodeByPath(String nodePath, SessionProvider sessionProvider) throws Exception {
        return (Node)this.getSession(sessionProvider).getItem(nodePath);
    }

    @Override
    public Session getSession(SessionProvider sprovider) throws Exception {
        ManageableRepository currentRepo = this.repoService_.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public Session getSystemSession() throws Exception {
        return this.getSession(this.createSystemProvider());
    }

    private String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    @Override
    public void autoShareCalendar(List<String> groupsOfUser, String receiver) throws Exception {
        Node sharedHome = this.getSharedCalendarHome();
        NodeIterator userNodes = sharedHome.getNodes();
        ArrayList<String> sharedCalendars = new ArrayList<String>();
        while (userNodes.hasNext()) {
            Node sharedNode = userNodes.nextNode();
            PropertyIterator iter = sharedNode.getReferences();
            while (iter.hasNext()) {
                try {
                    Value[] viewPers;
                    Node calendarNode = iter.nextProperty().getParent();
                    String calendarId = calendarNode.getProperty("exo:id").getString();
                    if (sharedCalendars.contains(calendarId)) continue;
                    sharedCalendars.add(calendarId);
                    for (Value viewPer : viewPers = calendarNode.getProperty("exo:viewPermissions").getValues()) {
                        for (String groupId : groupsOfUser) {
                            if (!viewPer.getString().equals(groupId)) continue;
                            Node sharedCalendarHome = this.getSharedCalendarHome();
                            Value[] values = new Value[]{};
                            if (calendarNode.isNodeType("exo:calendarShared")) {
                                values = calendarNode.getProperty("exo:sharedId").getValues();
                            } else {
                                calendarNode.addMixin("exo:calendarShared");
                            }
                            List<Value> valueList = new ArrayList<Value>();
                            for (int i = 0; i < values.length; ++i) {
                                Value value = values[i];
                                valueList.add(value);
                            }
                            if ((valueList = this.calculateSharedCalendar(receiver, calendarNode, values, valueList, sharedCalendarHome)).size() <= 0) continue;
                            calendarNode.setProperty("exo:sharedId", valueList.toArray(new Value[valueList.size()]));
                            calendarNode.save();
                            sharedCalendarHome.getSession().save();
                            calendarNode.getSession().save();
                            String username = null;
                            if (calendarNode.hasProperty("exo:calendarOwner")) {
                                username = calendarNode.getProperty("exo:calendarOwner").getString();
                            }
                            this.clearCalendarCache(calendarId, username);
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Exception in method autoShareCalendar", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void removeSharedCalendar(String username, String calendarId) throws Exception {
        block9: {
            Node sharedCalendarHome = this.getSharedCalendarHome();
            if (sharedCalendarHome.hasNode(username)) {
                Node userNode = sharedCalendarHome.getNode(username);
                String uuid = userNode.getProperty("jcr:uuid").getString();
                PropertyIterator iter = userNode.getReferences();
                CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
                HashMap<String, String> map = new HashMap<String, String>();
                for (String key : calSetting.getSharedCalendarsColors()) {
                    map.put(key.split(":")[0], key.split(":")[1]);
                }
                while (iter.hasNext()) {
                    Node calendar = iter.nextProperty().getParent();
                    if (!calendar.getProperty("exo:id").getString().equals(calendarId)) continue;
                    this.deleteSharedCalendar(username, uuid, calSetting, calendar, map);
                    ArrayList<String> viewPerms = new ArrayList<String>();
                    if (calendar.hasProperty("exo:viewPermissions")) {
                        Value[] viewValues;
                        for (Value v : viewValues = calendar.getProperty("exo:viewPermissions").getValues()) {
                            if (v.getString() == null || v.getString().equals(username)) continue;
                            viewPerms.add(v.getString());
                        }
                    }
                    ArrayList<String> editPerms = new ArrayList<String>();
                    if (calendar.hasProperty("exo:editPermissions")) {
                        Value[] editValues;
                        for (Value v : editValues = calendar.getProperty("exo:editPermissions").getValues()) {
                            if (v.getString() == null || v.getString().equals(username)) continue;
                            editPerms.add(v.getString());
                        }
                    }
                    calendar.setProperty("exo:viewPermissions", viewPerms.toArray(new String[viewPerms.size()]));
                    calendar.setProperty("exo:editPermissions", editPerms.toArray(new String[editPerms.size()]));
                    calendar.getSession().save();
                    calendar.refresh(true);
                    this.clearCalendarCache(calendarId, username);
                    break;
                }
                try {
                    this.removeFeed(username, calendarId);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block9;
                    log.debug((Object)"Fail to remove feed", (Throwable)e);
                }
            }
        }
    }

    public void removeSharedCalendarFolder(String username) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator propIter = userNode.getReferences();
            while (propIter.hasNext()) {
                Property prop = propIter.nextProperty();
                Node calendar = prop.getParent();
                Value[] sharedIds = prop.getValues();
                ArrayList<Value> newValues = new ArrayList<Value>();
                for (Value value : sharedIds) {
                    if (value.getString().equals(uuid)) continue;
                    newValues.add(value);
                }
                calendar.setProperty("exo:sharedId", newValues.toArray(new Value[newValues.size()]));
                newValues.clear();
                if (calendar.hasProperty("exo:viewPermissions")) {
                    Value[] viewPerms;
                    for (Value v : viewPerms = calendar.getProperty("exo:viewPermissions").getValues()) {
                        if (username.equals(v.getString())) continue;
                        newValues.add(v);
                    }
                    calendar.setProperty("exo:viewPermissions", newValues.toArray(new Value[newValues.size()]));
                    newValues.clear();
                }
                if (calendar.hasProperty("exo:editPermissions")) {
                    Value[] editPerms;
                    for (Value v : editPerms = calendar.getProperty("exo:editPermissions").getValues()) {
                        if (username.equals(v.getString())) continue;
                        newValues.add(v);
                    }
                    calendar.setProperty("exo:editPermissions", newValues.toArray(new Value[newValues.size()]));
                }
                calendar.save();
                this.clearCalendarCache(calendar.getProperty("exo:id").getString(), username);
            }
            userNode.remove();
            sharedCalendarHome.save();
        }
    }

    @Override
    public void autoRemoveShareCalendar(String groupId, String username) throws Exception {
        Node sharedCalendarHome = this.getSharedCalendarHome();
        if (sharedCalendarHome.hasNode(username)) {
            Node userNode = sharedCalendarHome.getNode(username);
            String uuid = userNode.getProperty("jcr:uuid").getString();
            PropertyIterator iter = userNode.getReferences();
            CalendarSetting calSetting = this.getCalendarSetting(this.getUserCalendarServiceHome(username));
            OrganizationService organizationService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            HashMap<String, String> map = new HashMap<String, String>();
            for (String key : calSetting.getSharedCalendarsColors()) {
                map.put(key.split(":")[0], key.split(":")[1]);
            }
            while (iter.hasNext()) {
                Node calendar = iter.nextProperty().getParent();
                ArrayList<String> viewPers = new ArrayList<String>();
                for (Value value : calendar.getProperty("exo:viewPermissions").getValues()) {
                    viewPers.add(value.getString());
                }
                viewPers.remove(groupId);
                boolean deleteShared = true;
                if (viewPers.contains(username)) {
                    deleteShared = false;
                } else {
                    Object[] groups;
                    for (Object object : groups = organizationService.getGroupHandler().findGroupsOfUser(username).toArray()) {
                        if (!viewPers.contains(((Group)object).getId())) continue;
                        deleteShared = false;
                        break;
                    }
                }
                if (!deleteShared) continue;
                for (Value viewPer : calendar.getProperty("exo:viewPermissions").getValues()) {
                    if (!viewPer.getString().equals(groupId)) continue;
                    this.deleteSharedCalendar(username, uuid, calSetting, calendar, map);
                    calendar.getSession().save();
                    this.clearCalendarCache(calendar.getProperty("exo:id").getString(), username);
                    calendar.refresh(true);
                    break;
                }
                try {
                    this.removeFeed(username, calendar.getProperty("exo:id").getString());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)"Fail to remove feed", (Throwable)e);
                }
            }
        }
    }

    private void deleteSharedCalendar(String username, String userNodeUuid, CalendarSetting calSetting, Node calendarNode, Map<String, String> colorMap) throws Exception {
        colorMap.remove(calendarNode.getProperty("exo:id").getString());
        Value[] values = calendarNode.getProperty("exo:sharedId").getValues();
        ArrayList<Value> newValues = new ArrayList<Value>();
        for (Value value : values) {
            if (value.getString().equals(userNodeUuid)) continue;
            newValues.add(value);
        }
        ArrayList<String> calColors = new ArrayList<String>();
        for (String key : colorMap.keySet()) {
            calColors.add(key + ":" + colorMap.get(key));
        }
        calSetting.setSharedCalendarsColors(calColors.toArray(new String[calColors.size()]));
        this.saveCalendarSetting(calSetting, username);
        calendarNode.setProperty("exo:sharedId", newValues.toArray(new Value[newValues.size()]));
        this.clearCalendarCache(calendarNode.getProperty("exo:id").getString(), username);
    }

    public void assignGroupTask(String taskId, String calendarId, String assignee) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        Node eventNode = calendarNode.getNode(taskId);
        StringBuilder taskDelegator = new StringBuilder();
        if (eventNode.hasProperty("exo:taskDelegator")) {
            taskDelegator.append(eventNode.getProperty("exo:taskDelegator").getString());
        }
        if (assignee != null && assignee.length() > 0) {
            if (taskDelegator.toString().trim().length() == 0) {
                taskDelegator = new StringBuilder(assignee);
            } else {
                taskDelegator.append(",").append(assignee);
            }
            eventNode.setProperty("exo:taskDelegator", taskDelegator.toString());
            eventNode.getSession().save();
        }
    }

    public void setGroupTaskStatus(String taskId, String calendarId, String status) throws Exception {
        Node calendarNode = this.getPublicCalendarHome().getNode(calendarId);
        Node eventNode = calendarNode.getNode(taskId);
        if (status != null && status.length() > 0) {
            eventNode.setProperty("exo:eventState", status);
            eventNode.getSession().save();
        }
    }

    @Override
    public boolean isRemoteCalendar(String username, String calendarId) throws Exception {
        try {
            Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
            return calendarNode.isNodeType("exo:remoteCalendar");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage());
            return false;
        }
    }

    @Override
    public Calendar updateRemoteCalendarInfo(RemoteCalendar remoteCalendar) throws Exception {
        Node calendarNode = this.getUserCalendarHome(remoteCalendar.getUsername()).getNode(remoteCalendar.getCalendarId());
        this.updateRemoteCalendarInfo(calendarNode, remoteCalendar);
        return this.getUserCalendar(remoteCalendar.getUsername(), remoteCalendar.getCalendarId());
    }

    private void updateRemoteCalendarInfo(Node calendarNode, RemoteCalendar remoteCalendar) throws Exception {
        calendarNode.setProperty("exo:remoteType", remoteCalendar.getType());
        calendarNode.setProperty("exo:description", remoteCalendar.getDescription());
        calendarNode.setProperty("exo:remoteUrl", remoteCalendar.getRemoteUrl());
        calendarNode.setProperty("exo:syncPeriod", remoteCalendar.getSyncPeriod());
        calendarNode.setProperty("exo:username", remoteCalendar.getRemoteUser());
        calendarNode.setProperty("exo:password", remoteCalendar.getRemotePassword());
        calendarNode.setProperty("exo:afterDate", remoteCalendar.getAfterDateSave());
        calendarNode.setProperty("exo:beforeDate", remoteCalendar.getBeforeDateSave());
        if (remoteCalendar.getLastUpdated() != null) {
            calendarNode.setProperty("exo:lastUpdated", remoteCalendar.getLastUpdated());
        } else if (!calendarNode.hasProperty("exo:lastUpdated")) {
            calendarNode.setProperty("exo:lastUpdated", (java.util.Calendar)Utils.getInstanceTempCalendar());
        }
        calendarNode.save();
    }

    public RemoteCalendar getRemoteCalendar(String username, String remoteCalendarId) throws Exception {
        RemoteCalendar remoteCalendar = new RemoteCalendar();
        try {
            Node calendarNode = this.getUserCalendarHome(username).getNode(remoteCalendarId);
            remoteCalendar.setUsername(username);
            remoteCalendar.setCalendarId(remoteCalendarId);
            StringBuilder namePattern = new StringBuilder(128);
            namePattern.append("exo:remoteType").append('|').append("exo:syncPeriod").append('|').append("exo:beforeDate").append('|').append("exo:afterDate").append('|').append("exo:remoteUrl").append('|').append("exo:username").append('|').append("exo:password").append('|').append("exo:lastUpdated");
            PropertyIterator it = calendarNode.getProperties(namePattern.toString());
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String name = p.getName();
                if (name.equals("exo:remoteType")) {
                    remoteCalendar.setType(p.getString());
                    continue;
                }
                if (name.equals("exo:syncPeriod")) {
                    remoteCalendar.setSyncPeriod(p.getString());
                    continue;
                }
                if (name.equals("exo:beforeDate")) {
                    remoteCalendar.setBeforeDateSave(p.getString());
                    continue;
                }
                if (name.equals("exo:afterDate")) {
                    remoteCalendar.setAfterDateSave(p.getString());
                    continue;
                }
                if (name.equals("exo:remoteUrl")) {
                    remoteCalendar.setRemoteUrl(p.getString());
                    continue;
                }
                if (name.equals("exo:username")) {
                    remoteCalendar.setRemoteUser(p.getString());
                    continue;
                }
                if (name.equals("exo:password")) {
                    remoteCalendar.setRemotePassword(p.getString());
                    continue;
                }
                if (!name.equals("exo:lastUpdated")) continue;
                remoteCalendar.setLastUpdated(p.getDate());
            }
        }
        catch (Exception e) {
            log.debug((Object)"Failed to get RemoteCalendar by user.", (Throwable)e);
        }
        return remoteCalendar;
    }

    @Override
    public Calendar createRemoteCalendar(RemoteCalendar remoteCalendar) throws Exception {
        Calendar eXoCalendar = new Calendar();
        eXoCalendar.setName(remoteCalendar.getCalendarName());
        eXoCalendar.setPublic(false);
        eXoCalendar.setCalendarOwner(remoteCalendar.getUsername());
        eXoCalendar.setDescription(remoteCalendar.getDescription());
        eXoCalendar.setCalendarColor(remoteCalendar.getCalendarColor());
        this.saveUserCalendar(remoteCalendar.getUsername(), eXoCalendar, true);
        Node calendarNode = this.getUserCalendarHome(remoteCalendar.getUsername()).getNode(eXoCalendar.getId());
        if (!calendarNode.isNodeType("exo:remoteCalendar")) {
            calendarNode.addMixin("exo:remoteCalendar");
        }
        this.updateRemoteCalendarInfo(calendarNode, remoteCalendar);
        return eXoCalendar;
    }

    @Override
    public void setRemoteEvent(String username, String calendarId, String eventId, String href, String etag) throws Exception {
        Node eventNode = this.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
        if (!eventNode.isNodeType("exo:caldavCalendarEvent")) {
            eventNode.addMixin("exo:caldavCalendarEvent");
        }
        if (href != null) {
            eventNode.setProperty("exo:caldavHref", href);
        }
        eventNode.setProperty("exo:caldavEtag", etag);
        eventNode.save();
    }

    @Override
    public void setRemoteCalendarLastUpdated(String username, String calendarId, java.util.Calendar timeGMT) throws Exception {
        Node calendarNode = this.getUserCalendarHome(username).getNode(calendarId);
        calendarNode.setProperty("exo:lastUpdated", timeGMT);
        calendarNode.save();
        this.clearCalendarCache(calendarNode.getProperty("exo:id").getString(), username);
    }

    @Override
    public Calendar getRemoteCalendar(String username, String remoteUrl, String remoteType) throws Exception {
        try {
            Node calendarHome = this.getUserCalendarHome(username);
            String queryString = "/jcr:root" + XPathUtils.escapeIllegalXPathName((String)calendarHome.getPath()) + "//element(*,exo:remoteCalendar)[@exo:remoteUrl='" + remoteUrl + "' and @exo:remoteType='" + remoteType + "']";
            QueryManager queryManager = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            if (iter.hasNext()) {
                Node calNode = iter.nextNode();
                Calendar calendar = this.getCalendar(null, username, calNode, true);
                return calendar;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int getRemoteCalendarCount(String username) throws Exception {
        try {
            Node calendarHome = this.getUserCalendarHome(username);
            String queryString = "/jcr:root" + XPathUtils.escapeIllegalXPathName((String)calendarHome.getPath()) + "//element(*,exo:remoteCalendar)";
            QueryManager queryManager = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString.toString(), "xpath");
            QueryResult results = query.execute();
            NodeIterator iter = results.getNodes();
            int count = 0;
            while (iter.hasNext()) {
                iter.nextNode();
                ++count;
            }
            return count;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e);
            }
            return 0;
        }
    }

    @Override
    public void setCalDavResourceHref(String username, String calendarId, String eventId, String href) throws Exception {
        Node eventNode = this.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
        eventNode.setProperty("exo:caldavHref", href);
    }

    @Override
    public void setCalDavResourceEtag(String username, String calendarId, String eventId, String etag) throws Exception {
        Node eventNode = this.getUserCalendarHome(username).getNode(calendarId).getNode(eventId);
        eventNode.setProperty("exo:caldavHref", etag);
    }

    public CalendarEvent getEventById(String eventId) throws Exception {
        CalendarEvent event = (CalendarEvent)this.eventCache.get((Object)this, (Object)eventId);
        return event.equals(CalendarEvent.NULL_OBJECT) || event.getCalendarId() == null ? null : event;
    }

    @Override
    public Calendar getCalendarById(String calId) throws Exception {
        return this.getCalendar(calId, null);
    }

    public NodeHierarchyCreator getNodeHierarchyCreator() {
        return this.nodeHierarchyCreator_;
    }

    @Override
    public Collection<CalendarEvent> getAllExcludedEvent(CalendarEvent originEvent, java.util.Calendar from, java.util.Calendar to, String userId) {
        ArrayList<CalendarEvent> coll;
        block8: {
            CalendarSetting st;
            block7: {
                coll = new ArrayList<CalendarEvent>();
                List<String> calendarIds = Arrays.asList(originEvent.getCalendarId());
                st = null;
                try {
                    st = this.getCalendarSetting(userId);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block7;
                    log.debug((Object)e);
                }
            }
            List<String> filterCalendarIds = Arrays.asList(st.getFilterPrivateCalendars());
            filterCalendarIds.addAll(Arrays.asList(st.getFilterPublicCalendars()));
            filterCalendarIds.addAll(Arrays.asList(st.getFilterSharedCalendars()));
            StringBuffer queryString = new StringBuffer("SELECT * FROM exo:calendarEvent WHERE ");
            queryString.append(" exo:originalReference ='").append(originEvent.getId()).append("'");
            try {
                QueryManager qm = this.getUserCalendarHome(userId).getSession().getWorkspace().getQueryManager();
                Query query = qm.createQuery(queryString.toString(), "sql");
                QueryResult result = query.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    Node eventNode = it.nextNode();
                    CalendarEvent event = this.getEvent(eventNode);
                    event.setCalType(originEvent.getCalType());
                    coll.add(event);
                }
            }
            catch (RepositoryException e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e);
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block8;
                log.debug((Object)e);
            }
        }
        return coll;
    }

    @Override
    public Collection<CalendarEvent> buildSeriesByTime(CalendarEvent recurEvent, java.util.Calendar from, java.util.Calendar to, String userId) {
        net.fortuna.ical4j.model.TimeZone tz;
        DateTime ical4jEventFrom;
        Recur recur;
        int diffMinutes;
        ArrayList<CalendarEvent> occurrences;
        SimpleDateFormat format;
        TimeZone userTimeZone;
        block14: {
            String timezone;
            block13: {
                block12: {
                    timezone = TimeZone.getDefault().getID();
                    try {
                        timezone = this.getCalendarSetting(userId).getTimeZone();
                    }
                    catch (Exception e) {
                        if (!log.isDebugEnabled()) break block12;
                        log.debug((Object)e);
                    }
                }
                if (Utils.isEmpty(recurEvent.getRepeatType())) {
                    return null;
                }
                if (from.after(to) || !recurEvent.getFromDateTime().before(to.getTime())) {
                    return null;
                }
                if (recurEvent.getRepeatUntilDate() != null && recurEvent.getRepeatUntilDate().before(from.getTime())) {
                    return null;
                }
                userTimeZone = DateUtils.getTimeZone((String)timezone);
                format = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
                format.setTimeZone(userTimeZone);
                occurrences = new ArrayList<CalendarEvent>();
                diffMinutes = (int)((recurEvent.getToDateTime().getTime() - recurEvent.getFromDateTime().getTime()) / 60000L);
                recur = null;
                try {
                    recur = Utils.getICalendarRecur(recurEvent);
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block13;
                    log.debug((Object)e);
                }
            }
            if (recur == null) {
                return null;
            }
            ical4jEventFrom = new DateTime(recurEvent.getFromDateTime());
            tz = null;
            try {
                tz = Utils.getICalTimeZone(DateUtils.getTimeZone((String)timezone));
            }
            catch (ParseException e) {
                if (!log.isDebugEnabled()) break block14;
                log.debug((Object)e);
            }
        }
        ical4jEventFrom.setTimeZone(tz);
        Utils.adaptRepeatRule(recur, recurEvent.getFromDateTime(), CalendarService.PERSISTED_TIMEZONE, userTimeZone);
        java.util.Calendar occurenceFrom = java.util.Calendar.getInstance();
        occurenceFrom.setTime(from.getTime());
        occurenceFrom.add(12, -(diffMinutes - 1));
        DateTime ical4jFrom = new DateTime(occurenceFrom.getTime());
        DateTime ical4jTo = new DateTime(to.getTime());
        Period period = new Period(ical4jFrom, ical4jTo);
        period.setTimeZone(tz);
        DateList list = recur.getDates((net.fortuna.ical4j.model.Date)ical4jEventFrom, period, net.fortuna.ical4j.model.parameter.Value.DATE_TIME);
        for (Object dt : list) {
            DateTime ical4jStart = (DateTime)dt;
            ical4jStart.setTimeZone(tz);
            CalendarEvent occurrence = new CalendarEvent(recurEvent);
            java.util.Calendar startTime = java.util.Calendar.getInstance(TimeZone.getDefault());
            java.util.Calendar endTime = java.util.Calendar.getInstance(TimeZone.getDefault());
            startTime.setTimeInMillis(ical4jStart.getTime());
            occurrence.setFromDateTime(startTime.getTime());
            endTime.setTime(startTime.getTime());
            endTime.add(12, diffMinutes);
            occurrence.setToDateTime(endTime.getTime());
            if (userTimeZone.useDaylightTime()) {
                this.adaptTimeToDST(occurrence, recurEvent, userTimeZone);
            }
            String recurId = format.format(occurrence.getFromDateTime());
            if (recurEvent.getExceptionIds() != null && recurEvent.getExceptionIds().contains(recurId)) continue;
            occurrence.setRecurrenceId(recurId);
            occurrences.add(occurrence);
        }
        return occurrences;
    }

    private class GroupCalendarEventSelector
    implements CachedObjectSelector<String, List<CalendarEvent>> {
        private String pattern;

        public GroupCalendarEventSelector(String calendarPath) {
            StringBuilder queryEventsStatementSQL = new StringBuilder(" SELECT * FROM ").append("exo:calendarEvent").append(" WHERE jcr:path LIKE '").append(calendarPath);
            this.pattern = queryEventsStatementSQL.toString();
        }

        public boolean select(String key, ObjectCacheInfo<? extends List<CalendarEvent>> ocinfo) {
            return key.startsWith(this.pattern);
        }

        public void onSelect(ExoCache<? extends String, ? extends List<CalendarEvent>> cache, String key, ObjectCacheInfo<? extends List<CalendarEvent>> ocinfo) throws Exception {
            cache.remove((Serializable)((Object)key));
        }
    }

    private class GroupCalendarSelector
    implements CachedObjectSelector<String, List<Calendar>> {
        private Set<String> groups;

        public GroupCalendarSelector(Set<String> groups) {
            this.groups = groups;
        }

        public boolean select(String key, ObjectCacheInfo<? extends List<Calendar>> ocinfo) {
            return !this.groups.isEmpty() && this.groups.contains(key);
        }

        public void onSelect(ExoCache<? extends String, ? extends List<Calendar>> cache, String key, ObjectCacheInfo<? extends List<Calendar>> ocinfo) throws Exception {
            cache.remove((Serializable)((Object)key));
        }
    }

    private class EventCategorySelector
    implements CachedObjectSelector<String, CalendarEvent> {
        private String idCategory;

        public EventCategorySelector(String idCategory) {
            this.idCategory = idCategory;
        }

        public boolean select(String key, ObjectCacheInfo<? extends CalendarEvent> ocinfo) {
            CalendarEvent event = (CalendarEvent)ocinfo.get();
            return event != null && event.getEventCategoryId().equals(this.idCategory);
        }

        public void onSelect(ExoCache<? extends String, ? extends CalendarEvent> cache, String key, ObjectCacheInfo<? extends CalendarEvent> ocinfo) throws Exception {
            cache.remove((Serializable)((Object)key));
        }
    }

    private class EventCalendarSelector
    implements CachedObjectSelector<String, CalendarEvent> {
        private String idCalendar;

        public EventCalendarSelector(String calId) {
            this.idCalendar = calId;
        }

        public boolean select(String key, ObjectCacheInfo<? extends CalendarEvent> ocinfo) {
            CalendarEvent event = (CalendarEvent)ocinfo.get();
            return !event.equals(CalendarEvent.NULL_OBJECT) && event.getCalendarId().equals(this.idCalendar);
        }

        public void onSelect(ExoCache<? extends String, ? extends CalendarEvent> cache, String key, ObjectCacheInfo<? extends CalendarEvent> ocinfo) throws Exception {
            cache.remove((Serializable)((Object)key));
        }
    }

    public static class KeyValuePair
    extends AbstractMap.SimpleEntry<String, String> {
        private static final long serialVersionUID = -2558703122631062086L;

        public KeyValuePair(String key, String value) {
            super(key, value);
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o instanceof KeyValuePair) {
                return this.hashCode() == o.hashCode();
            }
            return false;
        }

        @Override
        public int hashCode() {
            return (this.getKey() == null ? 0 : ((String)this.getKey()).hashCode()) ^ (this.getValue() == null ? 1 : ((String)this.getValue()).hashCode());
        }
    }

    private class InternalLock
    extends ReentrantLock {
        private static final long serialVersionUID = -3362387346368015145L;
        private final String fullId;

        public InternalLock(String fullId) {
            this.fullId = fullId;
        }

        @Override
        public void unlock() {
            if (!this.hasQueuedThreads()) {
                JCRDataStorage.this.locks.remove(this.fullId, this);
            }
            super.unlock();
        }
    }

    private static class CalendarEventLoader
    implements Loader<String, CalendarEvent, JCRDataStorage> {
        private CalendarEventLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CalendarEvent retrieve(JCRDataStorage context, String key) throws Exception {
            try (SessionProvider provider = null;){
                provider = context.createSessionProvider();
                QueryManager queryManager = context.getSession(provider).getWorkspace().getQueryManager();
                String sql = "select * from exo:calendarEvent where exo:id='" + key + "'";
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult result = query.execute();
                NodeIterator nodesIt = result.getNodes();
                if (nodesIt.hasNext()) {
                    CalendarEvent calendarEvent = context.getEvent(nodesIt.nextNode());
                    return calendarEvent;
                }
                CalendarEvent calendarEvent = CalendarEvent.NULL_OBJECT;
                return calendarEvent;
            }
        }
    }

    private static class GroupCalendarLoader
    implements Loader<String, List<Calendar>, JCRDataStorage> {
        private GroupCalendarLoader() {
        }

        public List<Calendar> retrieve(JCRDataStorage context, String key) throws Exception {
            LinkedList<Calendar> calendarList = new LinkedList<Calendar>();
            Node calendarHome = context.getPublicCalendarHome();
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            Query query = qm.createQuery(key, "sql");
            QueryResult result = query.execute();
            NodeIterator it = result.getNodes();
            while (it.hasNext()) {
                Node calNode = it.nextNode();
                Calendar cal = context.loadCalendar(calNode);
                calendarList.add(cal);
            }
            return calendarList;
        }
    }

    private static class CalendarLoader
    implements Loader<KeyValuePair, Calendar, JCRDataStorage> {
        private CalendarLoader() {
        }

        public Calendar retrieve(JCRDataStorage context, KeyValuePair calKey) throws Exception {
            String sql;
            String calendarId = (String)calKey.getKey();
            String username = (String)calKey.getValue();
            if (StringUtils.isNotBlank((String)username)) {
                if (context.getUserCalendarHome(username).hasNode(calendarId)) {
                    Node calendarNode = context.getUserCalendarHome(username).getNode(calendarId);
                    return context.getCalendar(new String[]{calendarId}, username, calendarNode, true);
                }
                return Calendar.NULL_OBJECT;
            }
            if (context.getPublicCalendarHome().hasNode(calendarId)) {
                Node calendarNode = context.getPublicCalendarHome().getNode(calendarId);
                Calendar loadedCalendar = context.getCalendar(new String[]{calendarId}, null, calendarNode, true);
                if (loadedCalendar != null) {
                    loadedCalendar.setCalType(2);
                    loadedCalendar.setCalTypeChecked(true);
                }
                return loadedCalendar;
            }
            Node calendarApp = context.getNodeHierarchyCreator().getPublicApplicationNode(Utils.createSystemProvider());
            QueryManager queryManager = calendarApp.getSession().getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sql = "select * from exo:calendar where exo:id='" + calendarId + "'", "sql");
            QueryResult result = query.execute();
            NodeIterator nodesIt = result.getNodes();
            if (nodesIt.hasNext()) {
                return context.loadCalendar(nodesIt.nextNode());
            }
            return Calendar.NULL_OBJECT;
        }
    }

    private static class UserCalendarLoader
    implements Loader<String, List<Calendar>, JCRDataStorage> {
        private UserCalendarLoader() {
        }

        public List<Calendar> retrieve(JCRDataStorage context, String key) throws Exception {
            LinkedList<Calendar> calList = new LinkedList<Calendar>();
            Node userCalendarHome = context.getUserCalendarHome(key);
            NodeIterator iter = userCalendarHome.getNodes();
            while (iter.hasNext()) {
                calList.add(context.loadCalendar(iter.nextNode()));
            }
            return calList;
        }
    }

    private static class CalendarSettingLoader
    implements Loader<String, CalendarSetting, JCRDataStorage> {
        private CalendarSettingLoader() {
        }

        public CalendarSetting retrieve(JCRDataStorage context, String key) throws Exception {
            Node calendarHome = context.getUserCalendarServiceHome(key);
            if (!calendarHome.hasNode(CALENDAR_SETTING)) {
                return null;
            }
            return context.getCalendarSetting(calendarHome);
        }
    }

    private class QueryRecurrentEventsTask
    implements Runnable {
        private CountDownLatch latch;
        private Node homeNode;
        private String calendarType;
        private java.util.Calendar fromDate;
        private java.util.Calendar toDate;
        private String[] filteredCalendars;
        private String[] calendarIds;
        public List<CalendarEvent> calendarEvents;

        public QueryRecurrentEventsTask(Node calendarHome, String type, java.util.Calendar from, java.util.Calendar to, String[] _calendarIds, String[] _filteredCalendars, CountDownLatch aLatch) {
            this.homeNode = calendarHome;
            this.calendarType = type;
            this.fromDate = from;
            this.toDate = to;
            this.latch = aLatch;
            this.filteredCalendars = _filteredCalendars;
            this.calendarIds = _calendarIds;
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.calendarEvents = JCRDataStorage.this.getOriginalRecurrenceEvents1(this.homeNode, this.calendarType, this.fromDate, this.toDate, this.calendarIds, this.filteredCalendars);
                    this.latch.countDown();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block2;
                    log.debug((Object)("Exception: " + e.getLocalizedMessage()));
                }
            }
        }
    }

    private class QueryEventsTask
    implements Runnable {
        private Query query;
        private CountDownLatch latch;
        private String calendarType;
        public List<CalendarEvent> events;

        public QueryEventsTask(Query aQuery, String type, CountDownLatch aLatch) {
            this.query = aQuery;
            this.latch = aLatch;
            this.calendarType = type;
            this.events = new ArrayList<CalendarEvent>();
        }

        @Override
        public void run() {
            try {
                NodeIterator iterator = this.query.execute().getNodes();
                while (iterator.hasNext()) {
                    CalendarEvent event = JCRDataStorage.this.getEvent(iterator.nextNode());
                    event.setCalType(String.valueOf(this.calendarType));
                    this.events.add(event);
                }
                this.latch.countDown();
            }
            catch (RepositoryException e) {
                log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
            }
            catch (Exception e) {
                log.debug((Object)("Exception: " + e.getLocalizedMessage()));
            }
        }
    }

    private class QueryHighLightEventsTask
    implements Runnable {
        private Query query;
        private CountDownLatch latch;
        public NodeIterator iterator;

        public QueryHighLightEventsTask(Query aQuery, CountDownLatch aLatch) {
            this.query = aQuery;
            this.latch = aLatch;
        }

        @Override
        public void run() {
            try {
                this.iterator = this.query.execute().getNodes();
                this.latch.countDown();
            }
            catch (RepositoryException e) {
                log.debug((Object)("RepositoryException: " + e.getLocalizedMessage()));
            }
        }
    }
}

