/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.DataStorage;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class SynchronizeRemoteCalendarJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(SynchronizeRemoteCalendarJob.class);
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_JOB = "SynchonizeRemoteCalendarJob";
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_GROUP = "SynchonizeRemoteCalendarGroup";
    public static final String CALENDARS = "calendars".intern();
    public static final String USERNAME_PARAMETER = "username";
    private DataStorage dataStorage;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        block41: {
            block39: {
                container = Utils.getPortalContainer(context);
                if (container == null) {
                    return;
                }
                oldContainer = ExoContainerContext.getCurrentContainer();
                ExoContainerContext.setCurrentContainer((ExoContainer)container);
                provider = SessionProvider.createSystemProvider();
                calService = (CalendarService)container.getComponentInstanceOfType(CalendarService.class);
                repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                currentRepo = null;
                try {
                    currentRepo = repositoryService.getCurrentRepository().getConfiguration().getName();
                }
                catch (RepositoryException e) {
                    SynchronizeRemoteCalendarJob.LOG.warn((Object)"Can't get current repository name", (Throwable)e);
                }
                total = 0;
                success = 0;
                failed = 0;
                start = System.currentTimeMillis();
                if (SynchronizeRemoteCalendarJob.LOG.isDebugEnabled()) {
                    SynchronizeRemoteCalendarJob.LOG.debug((Object)"Remote calendar synchronization service");
                }
                if ((username = (dataMap = (jobDetail = context.getJobDetail()).getJobDataMap()).getString("username")) != null) break block39;
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.LOG.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                }
                return;
            }
            try {
                userCalendarHome = this.getDataStorage().getUserCalendarHome(username);
                if (userCalendarHome == null) {
                    throw new IllegalStateException("Can't get user calendar home node");
                }
                path = new StringBuilder("/jcr:root");
                path.append(userCalendarHome.getPath());
                path.append("//element(*,exo:remoteCalendar)");
                queryManager = this.getSession(provider).getWorkspace().getQueryManager();
                query = queryManager.createQuery(path.toString(), "xpath");
                results = query.execute();
                iter = results.getNodes();
                while (iter.hasNext()) {
                    ++total;
                    remoteCalendar = iter.nextNode();
                    remoteCalendarId = remoteCalendar.getProperty("exo:id").getString();
                    syncPeriod = remoteCalendar.getProperty("exo:syncPeriod").getString();
                    try {
                        if (syncPeriod.equals("auto")) {
                            calService.refreshRemoteCalendar(username, remoteCalendarId);
                            ++success;
                            continue;
                        }
                        lastUpdate = remoteCalendar.getProperty("exo:lastUpdated").getDate().getTimeInMillis();
                        now = Utils.getGreenwichMeanTime().getTimeInMillis();
                        interval = 0L;
                        if ("5mins".equals(syncPeriod)) {
                            interval = 300000L;
                        }
                        if ("10mins".equals(syncPeriod)) {
                            interval = 600000L;
                        }
                        if ("15mins".equals(syncPeriod)) {
                            interval = 900000L;
                        }
                        if ("1hour".equals(syncPeriod)) {
                            interval = 3600000L;
                        }
                        if ("1day".equals(syncPeriod)) {
                            interval = 86400000L;
                        }
                        if ("1week".equals(syncPeriod)) {
                            interval = 604800000L;
                        }
                        if ("1year".equals(syncPeriod)) {
                            interval = 220752000000L;
                        }
                        if (lastUpdate + interval >= now) continue;
                        calService.refreshRemoteCalendar(username, remoteCalendarId);
                        ++success;
                    }
                    catch (Exception e) {
                        SynchronizeRemoteCalendarJob.LOG.debug((Object)("Skip this calendar, error when reload remote calendar " + remoteCalendarId + ". Error message: " + e.getMessage()));
                        ++failed;
                    }
                }
            }
            catch (RepositoryException e) {
                block40: {
                    if (!SynchronizeRemoteCalendarJob.LOG.isDebugEnabled()) break block40;
                    SynchronizeRemoteCalendarJob.LOG.debug((Object)"Data base not ready!");
                }
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.LOG.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                }
                break block41;
            }
            catch (Exception e) {
                block42: {
                    if (!SynchronizeRemoteCalendarJob.LOG.isDebugEnabled()) break block42;
                    SynchronizeRemoteCalendarJob.LOG.debug((Object)"Exception when synchronize remote calendar. ", (Throwable)e);
                    {
                        catch (Throwable var31_37) {
                            provider.close();
                            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                            if (currentRepo != null) {
                                try {
                                    repositoryService.setCurrentRepositoryName(currentRepo);
                                }
                                catch (RepositoryConfigurationException e) {
                                    SynchronizeRemoteCalendarJob.LOG.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                                }
                            }
                            throw var31_37;
                        }
                    }
                }
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.LOG.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                } else {
                    ** GOTO lbl130
                }
            }
            provider.close();
            ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
            if (currentRepo != null) {
                try {
                    repositoryService.setCurrentRepositoryName(currentRepo);
                }
                catch (RepositoryConfigurationException e) {
                    SynchronizeRemoteCalendarJob.LOG.error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                }
            }
        }
        finish = System.currentTimeMillis();
        spent = finish - start;
        if (total > 0) {
            SynchronizeRemoteCalendarJob.LOG.info((Object)("Reload remote calendar completed. Total: " + total + ", Success: " + success + ", Failed: " + failed + ", Skip: " + (total - success - failed) + ". Time spent: " + spent + " ms."));
        }
    }

    private Session getSession(SessionProvider sprovider) throws RepositoryException {
        ManageableRepository currentRepo = SessionProviderService.getRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static JobInfo getJobInfo(String username) {
        return new JobInfo(SynchronizeRemoteCalendarJob.getRemoteCalendarName(username), SYNCHRONIZE_REMOTE_CALENDAR_GROUP, SynchronizeRemoteCalendarJob.class);
    }

    public static String getRemoteCalendarName(String username) {
        String repoName = SessionProviderService.getRepository().getConfiguration().getName();
        StringBuilder jobNameBd = new StringBuilder().append(SYNCHRONIZE_REMOTE_CALENDAR_JOB).append("_").append(username).append("_").append(repoName);
        return jobNameBd.toString();
    }

    public DataStorage getDataStorage() {
        if (this.dataStorage == null) {
            this.dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        }
        return this.dataStorage;
    }
}

