/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.exoplatform.calendar.ws.common.RestSecurityService;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.portal.config.UserACL;

public class RestSecurityServiceImpl
implements RestSecurityService {
    private PermissionConfig config = new PermissionConfig();
    private UserACL userACL;
    public static String NOBODY = "NOBODY";

    public RestSecurityServiceImpl(UserACL userACL) {
        this.userACL = userACL;
    }

    @Override
    public boolean hasPermission(String requestPath) {
        if (requestPath != null) {
            for (Set<String> permissions : this.config.getPermission(requestPath)) {
                boolean hasPermission = false;
                for (String per : permissions) {
                    per = NOBODY.equalsIgnoreCase(per) ? null : per;
                    if (!this.userACL.hasPermission(per)) continue;
                    hasPermission = true;
                    break;
                }
                if (permissions.size() <= 0 || hasPermission) continue;
                return false;
            }
        }
        return true;
    }

    public void addPermission(PermissionPlugin config) {
        Map<String, String> perConfig = config.getConfig();
        for (Map.Entry<String, String> c : perConfig.entrySet()) {
            this.addPermission(c.getKey(), c.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPermission(String path, String permission) {
        PermissionConfig permissionConfig = this.config;
        synchronized (permissionConfig) {
            this.config.addConfig(path, permission);
        }
    }

    public static class PermissionPlugin
    extends BaseComponentPlugin {
        private Map<String, String> config = new HashMap<String, String>();

        public PermissionPlugin(InitParams params) {
            if (params != null) {
                Iterator iter = params.getPropertiesParamIterator();
                while (iter.hasNext()) {
                    PropertiesParam param = (PropertiesParam)iter.next();
                    Iterator props = param.getPropertyIterator();
                    while (props.hasNext()) {
                        Property permission = (Property)props.next();
                        this.config.put(permission.getName().trim(), permission.getValue().trim());
                    }
                }
            }
        }

        public Map<String, String> getConfig() {
            return this.config;
        }
    }

    public static class PermissionConfig {
        private Map<String, PermissionConfig> childs = new HashMap<String, PermissionConfig>();
        private Set<String> permission = new HashSet<String>();

        public List<Set<String>> getPermission(String path) {
            String fragment;
            List<String> fragments = this.getFragments(path);
            LinkedList<Set<String>> result = new LinkedList<Set<String>>();
            result.add(this.permission);
            PermissionConfig current = this;
            Iterator<String> iterator = fragments.iterator();
            while (iterator.hasNext() && (current = current.childs.get(fragment = iterator.next())) != null) {
                result.add(current.permission);
            }
            return result;
        }

        public void addConfig(String path, String permission) {
            List<String> fragments = this.getFragments(path);
            PermissionConfig current = this;
            for (String fragment : fragments) {
                PermissionConfig child = current.childs.get(fragment);
                if (child != null) {
                    current = child;
                    continue;
                }
                child = new PermissionConfig();
                current.childs.put(fragment, child);
                current = child;
            }
            for (String per : permission.split(",")) {
                if ((per = per.trim()).isEmpty()) continue;
                current.permission.add(per);
            }
        }

        private List<String> getFragments(String path) {
            LinkedList<String> fragments = new LinkedList<String>();
            if (path != null) {
                String[] tmp;
                for (String s : tmp = path.split("/")) {
                    if ((s = s.trim()).isEmpty()) continue;
                    fragments.add(s);
                }
            }
            return fragments;
        }
    }
}

