/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.InterruptableJob;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.UnableToInterruptJobException;

public class ShareCalendarJob
implements Job,
InterruptableJob {
    private static Log log = ExoLogger.getLogger(ShareCalendarJob.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        log.info((Object)"Starting sharing calendar for groups");
        OrganizationService oService = (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
        if (oService instanceof ComponentRequestLifecycle) {
            ((ComponentRequestLifecycle)oService).startRequest(ExoContainerContext.getCurrentContainer());
        }
        try {
            JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
            String user = jobDataMap.getString("userName");
            String calendarId = jobDataMap.getString("calendarId");
            List sharedGroups = (List)jobDataMap.get((Object)"sharedGroups");
            CalendarService calendarService = (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
            Calendar cal = calendarService.getUserCalendar(user, calendarId);
            String calendarName = cal.getName();
            String startMessage = Utils.buildMessageToSend("startShare", calendarName, sharedGroups, oService);
            String stopMessage = Utils.buildMessageToSend("finishShare", calendarName, sharedGroups, oService);
            ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
            continuation.sendMessage(user, "/eXo/Application/Calendar/notifyShareCalendar", (Object)startMessage);
            HashMap<Object, String> perms = new HashMap<Object, String>();
            HashMap<String, String> sharedUsers = new HashMap<String, String>();
            if (cal.getViewPermission() != null) {
                for (String v : cal.getViewPermission()) {
                    perms.put(v, String.valueOf(cal.getEditPermission() != null && Arrays.asList(cal.getEditPermission()).contains(v)));
                }
            }
            for (String name : sharedGroups) {
                for (User userTmp : oService.getUserHandler().findUsersByGroup(name.trim()).getAll()) {
                    String userId = userTmp.getUserName();
                    if (perms.get(userId) != null) continue;
                    sharedUsers.put(userId, userId);
                }
            }
            sharedUsers.remove(user);
            calendarService.shareCalendar(user, calendarId, Arrays.asList(sharedUsers.keySet().toArray(new String[sharedUsers.keySet().size()])));
            continuation.sendMessage(user, "/eXo/Application/Calendar/notifyShareCalendar", (Object)stopMessage);
            log.info((Object)"Finish sharing calendar for groups");
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Cant share calendar by job:" + e));
            }
        }
        finally {
            if (oService instanceof ComponentRequestLifecycle) {
                ((ComponentRequestLifecycle)oService).endRequest(ExoContainerContext.getCurrentContainer());
            }
        }
    }

    public void interrupt() throws UnableToInterruptJobException {
    }
}

