/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.io.InputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import javax.jcr.Node;
import javax.jcr.PropertyIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.ParameterList;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.Daylight;
import net.fortuna.ical4j.model.component.Standard;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.component.VTimeZone;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.TzId;
import net.fortuna.ical4j.model.property.TzName;
import net.fortuna.ical4j.model.property.TzOffsetFrom;
import net.fortuna.ical4j.model.property.TzOffsetTo;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.DataStorage;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.PermissionOwner;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.quartz.JobExecutionContext;
import org.quartz.impl.JobDetailImpl;

public class Utils {
    public static final String EXO_ID = "exo:id";
    public static final String EXO_LABEL = "exo:label";
    public static final String EXO_NAME = "exo:name";
    public static final String EXO_DESCRIPTION = "exo:description";
    public static final String EXO_EVENT_ID = "exo:eventId";
    public static final String EXO_EVENT_CATEGORYID = "exo:eventCategoryId";
    public static final String EXO_EVENT_CATEGORY_NAME = "exo:eventCategoryName";
    public static final String EXO_TASK_DELEGATOR = "exo:taskDelegator";
    public static final String EXO_REPEAT = "exo:repeat";
    public static final String EXO_EVENT_TYPE = "exo:eventType";
    public static final String EXO_PRIORITY = "exo:priority";
    public static final String EXO_IS_PRIVATE = "exo:isPrivate";
    public static final String EXO_EVENT_STATE = "exo:eventState";
    public static final String EXO_INVITATION = "exo:invitation";
    public static final String EXO_CALENDAR_EVENT = "exo:calendarEvent";
    public static final String EXO_REMINDER_TYPE = "exo:reminderType";
    public static final String EXO_ALARM_BEFORE = "exo:alarmBefore";
    public static final String EXO_EMAIL = "exo:email";
    public static final String EXO_OWNER = "exo:creator";
    public static final String EXO_REMINDER = "exo:reminder";
    public static final String EXO_FROM_DATE_TIME = "exo:fromDateTime";
    public static final String EXO_TO_DATE_TIME = "exo:toDateTime";
    public static final String EXO_SUMMARY = "exo:summary";
    public static final String EXO_IS_REPEAT = "exo:isRepeat";
    public static final String EXO_IS_OVER = "exo:isOver";
    public static final String EXO_CALENDAR_PUBLIC_EVENT = "exo:calendarPublicEvent";
    public static final String EXO_EVENT_CATEGORY = "exo:eventCategory";
    public static final String EXO_PUBLIC_URL = "exo:publicUrl";
    public static final String EXO_PRIVATE_URL = "exo:privateUrl";
    public static final String EXO_DATA = "exo:data";
    public static final String EXO_ICAL_DATA = "exo:iCalData";
    public static final String EXO_TITLE = "exo:title";
    public static final String EXO_CONTENT = "exo:content";
    public static final String EXO_CALENDAR_SETTING = "exo:calendarSetting";
    public static final String EXO_IS_SHOW_WORKING_TIME = "exo:showWorkingTime";
    public static final String EXO_WORKING_BEGIN = "exo:workingTimeBegin";
    public static final String EXO_WORKING_END = "exo:workingTimeEnd";
    public static final String EXO_PRIVATE_CALENDARS = "exo:defaultPrivateCalendars";
    public static final String EXO_PUBLIC_CALENDARS = "exo:defaultPublicCalendars";
    public static final String EXO_SHARED_CALENDARS = "exo:defaultSharedCalendars";
    public static final String EXO_SHARED_CALENDAR_COLORS = "exo:sharedCalendarsColors";
    public static final String EXO_EVEN_TATTACHMENT = "exo:eventAttachment";
    public static final String EXO_FILE_NAME = "exo:fileName";
    public static final String EXO_CATEGORY_ID = "exo:categoryId";
    public static final String EXO_VIEW_PERMISSIONS = "exo:viewPermissions";
    public static final String EXO_EDIT_PERMISSIONS = "exo:editPermissions";
    public static final String EXO_GROUPS = "exo:groups";
    public static final String EXO_LOCALE = "exo:locale";
    public static final String EXO_TIMEZONE = "exo:timeZone";
    public static final String EXO_CALENDAR_ID = "exo:calendarId";
    public static final String EXO_SHARED_MIXIN = "exo:calendarShared";
    public static final String EXO_SHARED_ID = "exo:sharedId";
    public static final String EXO_PARTICIPANT = "exo:participant";
    public static final String EXO_CALENDAR = "exo:calendar";
    public static final String EXO_CALENDAR_COLOR = "exo:calendarColor";
    public static final String EXO_CALENDAR_CATEGORY = "exo:calendarCategory";
    public static final String EXO_CALENDAR_OWNER = "exo:calendarOwner";
    public static final String EXO_SHARED_COLOR = "exo:sharedColor";
    public static final String EXO_VIEW_TYPE = "exo:viewType";
    public static final String EXO_TIME_INTERVAL = "exo:timeInterval";
    public static final String EXO_WEEK_START_ON = "exo:weekStartOn";
    public static final String EXO_DATE_FORMAT = "exo:dateFormat";
    public static final String EXO_TIME_FORMAT = "exo:timeFormat";
    public static final String EXO_LOCATION = "exo:location";
    public static final String EXO_REMINDER_DATE = "exo:remindDateTime";
    public static final String EXO_ROOT_EVENT_ID = "exo:rootEventId";
    public static final String EXO_RSS_DATA = "exo:rssData";
    public static final String EXO_BASE_URL = "exo:baseUrl";
    public static final String EXO_SEND_OPTION = "exo:sendOption";
    public static final String EXO_MESSAGE = "exo:message";
    public static final String EXO_PARTICIPANT_STATUS = "exo:participantStatus";
    public static final String EXO_DATE_MODIFIED = "exo:dateModified";
    public static final String EXO_REMOTE_MIXIN = "exo:remoteCalendar";
    public static final String EXO_REMOTE_URL = "exo:remoteUrl";
    public static final String EXO_REMOTE_TYPE = "exo:remoteType";
    public static final String EXO_REMOTE_USERNAME = "exo:username";
    public static final String EXO_REMOTE_PASSWORD = "exo:password";
    public static final String EXO_REMOTE_SYNC_PERIOD = "exo:syncPeriod";
    public static final String EXO_REMOTE_LAST_UPDATED = "exo:lastUpdated";
    public static final String EXO_REMOTE_BEFORE_DATE = "exo:beforeDate";
    public static final String EXO_REMOTE_AFTER_DATE = "exo:afterDate";
    public static final String EXO_REMOTE_EVENT_MIXIN = "exo:caldavCalendarEvent";
    public static final String EXO_CALDAV_HREF = "exo:caldavHref";
    public static final String EXO_CALDAV_ETAG = "exo:caldavEtag";
    public static final String EXO_REPEAT_CALENDAR_EVENT = "exo:repeatCalendarEvent";
    public static final String EXO_REPEAT_COUNT = "exo:repeatCount";
    public static final String EXO_REPEAT_UNTIL = "exo:repeatUntil";
    public static final String EXO_RECURRENCE_ID = "exo:recurrenceId";
    public static final String EXO_IS_EXCEPTION = "exo:isException";
    public static final String EXO_EXCLUDE_ID = "exo:excludeId";
    public static final String EXO_ORIGINAL_REFERENCE = "exo:originalReference";
    public static final String EXO_REPEAT_INTERVAL = "exo:repeatInterval";
    public static final String EXO_REPEAT_BYDAY = "exo:repeatByDay";
    public static final String EXO_REPEAT_BYMONTHDAY = "exo:repeatByMonthDay";
    public static final String EXO_REPEAT_FINISH_DATE = "exo:repeatFinishDate";
    public static final String EXO_DATE_CREATED = "exo:dateCreated";
    public static final String X_STATUS = "X-STATUS";
    public static final String ATTACHMENT_NODE = "attachment";
    public static final String REMINDERS_NODE = "reminders";
    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_SCORE = "jcr:score";
    public static final String MIMETYPE_TEXTPLAIN = "text/plain";
    public static final String MIMETYPE_ICALENDAR = "TEXT/CALENDAR";
    public static final String ATTACHMENT = "ATTACHMENT";
    public static final String INLINE = "INLINE";
    public static final String COMMA = ",";
    public static final String COLON = ":";
    public static final String SEMICOLON = ";";
    public static final String SLASH = "/";
    public static final String UNDERSCORE = "_";
    public static final String SLASH_COLON = "/:";
    public static final String COLON_SLASH = ":/";
    public static final String ANY = "*.*";
    public static final String ANY_OF = "*.";
    public static final String SLASH_AST = "/*";
    public static final String MINUS = "-";
    public static final String CALENDAR_REMINDER = "reminders";
    public static final String CALENDAR_APP = "CalendarApplication";
    public static final int DENY = 0;
    public static final int ACCEPT = 1;
    public static final int NOTSURE = 2;
    public static final int ACCEPT_IMPORT = 3;
    public static final int JUMP_TO_CALENDAR = 4;
    public static final String RSS_NODE = "iCalendars";
    public static final String CALDAV_NODE = "WebDavCalendars";
    public static final String ICS_EXT = ".ics";
    public static final String RSS_EXT = ".rss";
    public static final String EMPTY_STR = "";
    public static final String STATUS_MAYBE = "maybe";
    public static final String STATUS_YES = "yes";
    public static final String STATUS_NO = "no";
    public static final int INVALID_TYPE = -1;
    public static final int PRIVATE_TYPE = 0;
    public static final int SHARED_TYPE = 1;
    public static final int PUBLIC_TYPE = 2;
    public static final String SPLITTER = "splitter";
    public static final String ASCENDING = "ascending";
    public static final String DESCENDING = "descending";
    public static final String SPACE = " ";
    public static final String RESOURCEBUNDLE_NAME = "locale.portlet.calendar.CalendarPortlet";
    public static int EVENT_NUMBER = -1;
    public static final String LANGUAGE = "en";
    public static final String SYNC_AUTO = "auto";
    public static final String SYNC_5MINS = "5mins";
    public static final String SYNC_10MINS = "10mins";
    public static final String SYNC_15MINS = "15mins";
    public static final String SYNC_1HOUR = "1hour";
    public static final String SYNC_1DAY = "1day";
    public static final String SYNC_1WEEK = "1week";
    public static final String SYNC_1YEAR = "1year";
    public static final String MIMETYPE_TEXTHTML = "text/html";
    public static String[] SYNC_PERIOD = new String[]{"auto", "5mins", "10mins", "15mins", "1hour", "1day", "1week", "1year"};
    public static final String SHARE_CALENDAR_GROUP = "CS-ShareCalenar";
    public static final String DELETE_SHARED_GROUP = "CS-DeleteShare";
    public static final String SHARED_GROUPS = "sharedGroups";
    public static final String USER_NAME = "userName";
    public static final String CALENDAR_ID = "calendarId";
    public static final String JCR_DATA_STORAGE = "JCRDataStorage";
    public static final String SHARE_CAL_CHANEL = "/eXo/Application/Calendar/notifyShareCalendar";
    public static final String REMOVED_USERS = "removedUsers";
    public static final String START_SHARE = "startShare";
    public static final String FINISH_SHARE = "finishShare";
    public static final String START_UN_SHARE = "startUnShare";
    public static final String FINISH_UN_SHARE = "finishUnShare";
    public static final String ERROR_SHARE = "errorShare";
    public static final String ERROR_UN_SHARE = "errorUnShare";
    private static final String CALENDAR_DST_CACHE_REGION = "calendar.DaylightSavingTime";
    public static final String DETAIL_PATH = "details";
    public static final String DUE_FOR = "Due for: ";
    public static final String ORDER_TYPE_ASCENDING = "ASC";
    public static final String ORDER_TYPE_DESCENDING = "DESC";
    public static final String DOT = ".";
    public static String ORDERBY_RELEVANCY = "relevancy";
    public static String ORDERBY_DATE = "date";
    public static String ORDERBY_TITLE = "title";
    public static String DATE_TIME_FORMAT = "EEEEE, MMMMMMMM d, yyyy K:mm a";
    public static String JCR_EXCERPT = "excerpt(.)";
    public static String JCR_EXCERPT_ROW = "rep:excerpt(.)";
    public static String DATE_FORMAT_RECUR_ID = "yyyyMMdd'T'HHmmss'Z'";
    public static final Map<String, String> SORT_FIELD_MAP = new LinkedHashMap<String, String>(){
        {
            this.put(ORDERBY_RELEVANCY, Utils.JCR_SCORE);
            this.put(ORDERBY_DATE, Utils.EXO_DATE_CREATED);
            this.put(ORDERBY_TITLE, Utils.EXO_SUMMARY);
        }
    };
    public static final String[] SELECT_FIELDS = new String[]{JCR_EXCERPT, "exo:summary", "exo:description", "exo:location", "exo:fromDateTime", "exo:toDateTime", "exo:eventState", "exo:isPrivate", "exo:dateCreated", "jcr:score", "exo:id", "exo:calendarId", "exo:eventType"};
    public static String[] SEARCH_FIELDS = new String[]{"exo:summary", "exo:description", "exo:location"};
    public static String EVENT_ICON_URL = null;
    public static String TASK_ICON_URL = "/eXoSkin/skin/images/system/unified-search/status-task.png";
    public static final String DEFAULT_SITENAME = "intranet";
    public static final String PAGE_NAGVIGATION = "calendar";
    public static final String NONE_NAGVIGATION = "#";
    public static final String PORTLET_NAME = "CalendarPortlet";
    public static final String SPACES_GROUP = "spaces";
    public static final String SPACES_GROUP_ID_PREFIX = "/spaces/";
    public static final String SPACE_CALENDAR_ID_SUFFIX = "_space_calendar";
    private static final Log LOG = ExoLogger.getExoLogger(Utils.class);
    public static final Object JCR_PATH = "jcr:path";
    public static final int UNLIMITED = -1;
    private static Log log = ExoLogger.getLogger(Utils.class);

    public static OrganizationService getOrganizationService() {
        return (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstance(OrganizationService.class);
    }

    public static GregorianCalendar getInstanceTempCalendar() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeZone(DateUtils.getTimeZone((String)"GMT"));
        return calendar;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean hasPermission(String[] permissions, Identity user) throws Exception {
        if (permissions != null) {
            for (String savePer : permissions) {
                PermissionOwner permission = PermissionOwner.createPermissionOwnerFrom(savePer);
                if (permission.getOwnerType().equals("user")) {
                    if (!permission.getId().equals(user.getUserId())) continue;
                    return true;
                }
                String groupId = permission.getGroupId();
                String membershipType = permission.getMembership();
                MembershipEntry expected = new MembershipEntry(groupId, membershipType);
                for (MembershipEntry ms : user.getMemberships()) {
                    if (!ms.equals((Object)expected)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasPermission(OrganizationService oService, String[] savePerms, String username) {
        if (savePerms != null) {
            ConversationState conversationState = CommonsUtils.getConversationState((String)username);
            Identity identity = conversationState == null ? null : conversationState.getIdentity();
            for (String savePer : savePerms) {
                PermissionOwner permission = PermissionOwner.createPermissionOwnerFrom(savePer);
                if (permission.getOwnerType().equals("user")) {
                    if (!permission.getMeaningfulPermissionOwnerStatement().equals(username)) continue;
                    return true;
                }
                String groupId = permission.getGroupId();
                String membershipType = permission.getMembership();
                MembershipEntry expected = new MembershipEntry(groupId, membershipType);
                if (identity == null) {
                    try {
                        Collection memberships = oService.getMembershipHandler().findMembershipsByUserAndGroup(username, groupId);
                        for (Membership ms : memberships) {
                            MembershipEntry userMS = new MembershipEntry(groupId, ms.getMembershipType());
                            if (!userMS.equals((Object)expected)) continue;
                            return true;
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while testing on user permissions", (Throwable)e);
                    }
                    continue;
                }
                return identity.isMemberOf(expected);
            }
        }
        return false;
    }

    public static boolean hasPermission(String[] savePerms) {
        Identity identity = ConversationState.getCurrent().getIdentity();
        if (savePerms != null) {
            for (String savePer : savePerms) {
                String membershipType;
                String groupId;
                PermissionOwner permission = PermissionOwner.createPermissionOwnerFrom(savePer);
                if (!(permission.getOwnerType().equals("user") ? permission.getMeaningfulPermissionOwnerStatement().equals(identity.getUserId()) : identity.isMemberOf(groupId = permission.getGroupId(), membershipType = permission.getMembership()))) continue;
                return true;
            }
        }
        return false;
    }

    public static String getDefaultCalendarId(String username) {
        return username + MINUS + Utils.getCalendarService().getDefaultCalendarId();
    }

    public static PortalContainer getPortalContainer(JobExecutionContext context) {
        if (context == null) {
            return null;
        }
        String portalName = ((JobDetailImpl)context.getJobDetail()).getGroup();
        if (portalName == null) {
            return null;
        }
        if (portalName.indexOf(COLON) > 0) {
            portalName = portalName.substring(0, portalName.indexOf(COLON));
        }
        return RootContainer.getInstance().getPortalContainer(portalName);
    }

    public static String getDisplaySharedCalendar(String sharedUserId, String calName) {
        return sharedUserId + MINUS + SPACE + calName;
    }

    public static String getDisplayGroupCalendar(String groupId, String calName) {
        return groupId.substring(groupId.lastIndexOf(SLASH) + 1) + MINUS + calName;
    }

    public static String[] getEditPerUsers(Calendar calendar) throws Exception {
        ArrayList<String> sharedUsers = new ArrayList<String>();
        if (calendar.getEditPermission() != null) {
            for (String editPer : calendar.getEditPermission()) {
                if (editPer.contains(SLASH)) {
                    sharedUsers.addAll(Utils.getUsersCanEdit(editPer));
                    continue;
                }
                sharedUsers.add(editPer);
            }
        }
        return sharedUsers.toArray(new String[sharedUsers.size()]);
    }

    public static java.util.Calendar getGreenwichMeanTime() {
        java.util.Calendar calendar = GregorianCalendar.getInstance(DateUtils.getTimeZone((String)"GMT"));
        calendar.setLenient(false);
        int gmtoffset = calendar.get(16) + calendar.get(15);
        calendar.setTimeInMillis(System.currentTimeMillis() - (long)gmtoffset);
        return calendar;
    }

    public static boolean isSameDate(java.util.Date value1, java.util.Date value2) {
        GregorianCalendar date1 = Utils.getInstanceTempCalendar();
        date1.setTime(value1);
        GregorianCalendar date2 = Utils.getInstanceTempCalendar();
        date2.setTime(value2);
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    public static boolean isRepeatEvent(CalendarEvent event) throws Exception {
        return event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType());
    }

    public static boolean isExceptionOccurrence(CalendarEvent event) throws Exception {
        return event.getIsExceptionOccurrence() != null && event.getIsExceptionOccurrence() == true;
    }

    public static boolean isOccurrence(CalendarEvent event) {
        return event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && (event.getIsExceptionOccurrence() == null || event.getIsExceptionOccurrence() == false);
    }

    public static Node getPublicServiceHome() throws Exception {
        DataStorage dataStorage = (DataStorage)ExoContainerContext.getService(DataStorage.class);
        return dataStorage.getPublicCalendarServiceHome();
    }

    public static Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static SessionProvider createSystemProvider() {
        SessionProviderService sessionProviderService = (SessionProviderService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SessionProviderService.class);
        return sessionProviderService.getSystemSessionProvider(null);
    }

    public static String buildMessageToSend(String type, String calendarName, List<String> groups, OrganizationService oService) throws Exception {
        StringBuilder sb = new StringBuilder(EMPTY_STR);
        sb.append(type);
        sb.append(COMMA);
        sb.append(calendarName);
        Iterator<String> it = groups.iterator();
        while (it.hasNext()) {
            sb.append(COMMA);
            String groupId = it.next();
            Group group = oService.getGroupHandler().findGroupById(groupId);
            sb.append(group.getGroupName());
        }
        return sb.toString();
    }

    public static java.util.Calendar getBeginDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        return newCal;
    }

    public static java.util.Calendar getEndDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        newCal.add(11, 24);
        return newCal;
    }

    public static Set<String> getUserByMembershipId(String membershipId, String groupId) throws Exception {
        OrganizationService organizationService = (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
        List usersInGroup = organizationService.getUserHandler().findUsersByGroup(groupId).getAll();
        HashSet<String> userIds = new HashSet<String>();
        if (usersInGroup == null) {
            return userIds;
        }
        MembershipEntry expected = new MembershipEntry(groupId, membershipId);
        block0: for (User user : usersInGroup) {
            Collection membership = organizationService.getMembershipHandler().findMembershipsByUserAndGroup(user.getUserName(), groupId);
            for (Membership ms : membership) {
                MembershipEntry userMS = new MembershipEntry(groupId, ms.getMembershipType());
                if (!userMS.equals((Object)expected)) continue;
                userIds.add(user.getUserName());
                continue block0;
            }
        }
        return userIds;
    }

    public static List<String> getUsersCanEdit(String editPer) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        String[] perArr = editPer.split(COLON);
        String membershipId = perArr[1].substring(2);
        String groupId = perArr[0].substring(0, perArr[0].length() - 1);
        Set<String> usersCanEdit = Utils.getUserByMembershipId(membershipId, groupId);
        result.addAll(usersCanEdit);
        return result;
    }

    public static String getCalendarIdFromSpace(String spaceGroupId) {
        StringBuilder sb = new StringBuilder(spaceGroupId.substring(SPACES_GROUP_ID_PREFIX.length()));
        sb.append(SPACE_CALENDAR_ID_SUFFIX);
        return sb.toString();
    }

    public static String getSpaceGroupIdFromCalendarId(String calendarId) {
        StringBuilder sb = new StringBuilder(SPACES_GROUP_ID_PREFIX);
        sb.append(calendarId.split(SPACE_CALENDAR_ID_SUFFIX)[0]);
        return sb.toString();
    }

    public static net.fortuna.ical4j.model.TimeZone getICalTimeZone(TimeZone jTz) throws ParseException {
        String key;
        ExoCache<String, net.fortuna.ical4j.model.TimeZone> dstCache = Utils.getDaylightTimeCache();
        net.fortuna.ical4j.model.TimeZone tz = (net.fortuna.ical4j.model.TimeZone)dstCache.get((Serializable)((Object)(key = jTz.getID())));
        if (tz != null) {
            return tz;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss");
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        String dtStartValue = dateFormat.format(calendar.getTime());
        PropertyList standardTzProps = new PropertyList();
        TzName standardTzName = new TzName(new ParameterList(), jTz.getDisplayName(false, 0));
        DtStart standardTzStart = new DtStart();
        if (jTz.useDaylightTime()) {
            java.util.Date date = Utils.getDaylightEnd(jTz);
            standardTzStart.setValue(dateFormat.format(date));
        } else {
            standardTzStart.setValue(dtStartValue);
        }
        TzOffsetTo standardTzOffsetTo = new TzOffsetTo();
        standardTzOffsetTo.setOffset(ZoneOffset.of(jTz.getID()));
        TzOffsetFrom standardTzOffsetFrom = new TzOffsetFrom();
        standardTzOffsetFrom.setOffset(ZoneOffset.of(jTz.getID()));
        standardTzProps.add((Property)standardTzName);
        standardTzProps.add((Property)standardTzStart);
        standardTzProps.add((Property)standardTzOffsetTo);
        standardTzProps.add((Property)standardTzOffsetFrom);
        Standard standardTz = new Standard(standardTzProps);
        ComponentList tzComponents = new ComponentList();
        tzComponents.add((Object)standardTz);
        if (jTz.useDaylightTime()) {
            PropertyList daylightTzProps = new PropertyList();
            TzName daylightTzName = new TzName(jTz.getDisplayName(true, 0));
            java.util.Date start = Utils.getDaylightStart(jTz);
            DtStart daylightDtStart = new DtStart();
            daylightDtStart.setValue(dateFormat.format(start));
            TzOffsetTo daylightTzOffsetTo = new TzOffsetTo();
            daylightTzOffsetTo.setOffset(ZoneOffset.of(jTz.getID()));
            TzOffsetFrom daylightTzOffsetFrom = new TzOffsetFrom();
            daylightTzOffsetFrom.setOffset(ZoneOffset.of(jTz.getID()));
            daylightTzProps.add((Property)daylightTzOffsetFrom);
            daylightTzProps.add((Property)daylightTzOffsetTo);
            daylightTzProps.add((Property)daylightDtStart);
            daylightTzProps.add((Property)daylightTzName);
            Daylight daylightTz = new Daylight(daylightTzProps);
            tzComponents.add((Object)daylightTz);
        }
        PropertyList tzProps = new PropertyList();
        TzId tzId = new TzId(null, jTz.getID());
        tzProps.add((Property)tzId);
        VTimeZone vTz = new VTimeZone(tzProps, tzComponents);
        try {
            vTz.validate();
            tz = new net.fortuna.ical4j.model.TimeZone(vTz);
            dstCache.put((Serializable)((Object)key), (Object)tz);
            return tz;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static java.util.Date getDaylightStart(TimeZone timezone) {
        java.util.Calendar calendar = java.util.Calendar.getInstance(timezone);
        calendar.set(6, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        while (timezone.inDaylightTime(calendar.getTime())) {
            calendar.set(6, calendar.get(6) + 1);
        }
        while (!timezone.inDaylightTime(calendar.getTime())) {
            calendar.set(6, calendar.get(6) + 1);
        }
        while (timezone.inDaylightTime(calendar.getTime())) {
            calendar.add(11, -1);
        }
        calendar.add(11, 1);
        return calendar.getTime();
    }

    public static java.util.Date getDaylightEnd(TimeZone timezone) {
        java.util.Calendar calendar = java.util.Calendar.getInstance(timezone);
        calendar.set(6, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        while (!timezone.inDaylightTime(calendar.getTime())) {
            calendar.set(6, calendar.get(6) + 1);
        }
        while (timezone.inDaylightTime(calendar.getTime())) {
            calendar.set(6, calendar.get(6) + 1);
        }
        while (!timezone.inDaylightTime(calendar.getTime())) {
            calendar.add(11, -1);
        }
        calendar.add(11, 1);
        return calendar.getTime();
    }

    public static ExoCache<String, net.fortuna.ical4j.model.TimeZone> getDaylightTimeCache() {
        CacheService cacheService = (CacheService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CacheService.class);
        ExoCache dstCache = cacheService.getCacheInstance(CALENDAR_DST_CACHE_REGION);
        return dstCache;
    }

    public static CalendarEvent adaptRepeatRule(CalendarEvent event, TimeZone fromTimezone, TimeZone toTimeZone) {
        NumberList list;
        Recur recur;
        try {
            recur = Utils.getICalendarRecur(event);
        }
        catch (Exception ex) {
            return event;
        }
        if (recur == null) {
            return event;
        }
        Utils.adaptRepeatRule(recur, event.getFromDateTime(), fromTimezone, toTimeZone);
        WeekDayList dayList = recur.getDayList();
        if (dayList != null && dayList.size() > 0) {
            String[] days = new String[dayList.size()];
            for (int i = 0; i < dayList.size(); ++i) {
                days[i] = ((WeekDay)dayList.get(i)).toString();
            }
            event.setRepeatByDay(days);
        }
        if ((list = recur.getMonthDayList()) != null && list.size() > 0) {
            long[] array = new long[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Integer day = (Integer)list.get(i);
                array[i] = day.intValue();
            }
            event.setRepeatByMonthDay(array);
        }
        return event;
    }

    public static void adaptRepeatRule(Recur recur, java.util.Date firstOccurDate, TimeZone fromTimezone, TimeZone toTimezone) {
        WeekDay[] weekdays = new WeekDay[]{WeekDay.SU, WeekDay.MO, WeekDay.TU, WeekDay.WE, WeekDay.TH, WeekDay.FR, WeekDay.SA};
        WeekDayList weekdayList = recur.getDayList();
        NumberList numberList = recur.getMonthDayList();
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTime(firstOccurDate);
        calendar.setTimeZone(fromTimezone);
        int date = calendar.get(7);
        calendar.setTimeZone(toTimezone);
        int delta = calendar.get(7) - date;
        if (delta != 0) {
            if (weekdayList != null && weekdayList.size() > 0) {
                WeekDayList newWeekDayList = new WeekDayList();
                for (int i = 0; i < weekdayList.size(); ++i) {
                    WeekDay weekdayI = (WeekDay)weekdayList.get(i);
                    int index = (WeekDay.getCalendarDay((WeekDay)weekdayI) - 1 + delta) % 7;
                    if (index < 0) {
                        index += 7;
                    }
                    newWeekDayList.add((Object)new WeekDay(weekdays[index], weekdayI.getOffset()));
                }
                recur.getDayList().removeAll((Collection)weekdayList);
                recur.getDayList().addAll((Collection)newWeekDayList);
            }
            if (numberList != null && numberList.size() > 0) {
                NumberList newNumberList = new NumberList();
                for (int j = 0; j < numberList.size(); ++j) {
                    Integer numberI = (Integer)numberList.get(j);
                    newNumberList.add(new Integer(numberI + delta));
                }
                recur.getMonthDayList().removeAll((Collection)numberList);
                recur.getMonthDayList().addAll((Collection)newNumberList);
            }
        }
    }

    @Deprecated
    public static void adaptRepeatRule(Recur recur, DateTime firstOccurDate, TimeZone tz) {
        int delta;
        WeekDay[] weekdays = new WeekDay[]{WeekDay.SU, WeekDay.MO, WeekDay.TU, WeekDay.WE, WeekDay.TH, WeekDay.FR, WeekDay.SA};
        WeekDayList weekdayList = recur.getDayList();
        NumberList numberList = recur.getMonthDayList();
        java.util.Calendar calendar = java.util.Calendar.getInstance(tz);
        calendar.setTimeInMillis(firstOccurDate.getTime());
        if (weekdayList != null && weekdayList.size() > 0) {
            WeekDay expectedFirstWeekday = WeekDay.getWeekDay((java.util.Calendar)calendar);
            WeekDay firstWeekDayOfRule = (WeekDay)weekdayList.get(0);
            delta = WeekDay.getCalendarDay((WeekDay)expectedFirstWeekday) - WeekDay.getCalendarDay((WeekDay)firstWeekDayOfRule);
            if (delta != 0) {
                WeekDayList newWeekDayList = new WeekDayList();
                for (int i = 0; i < weekdayList.size(); ++i) {
                    WeekDay weekdayI = (WeekDay)weekdayList.get(i);
                    int index = (WeekDay.getCalendarDay((WeekDay)weekdayI) - 1 + delta) % 7;
                    newWeekDayList.add((Object)weekdays[index]);
                }
                recur.getDayList().removeAll((Collection)weekdayList);
                recur.getDayList().addAll((Collection)newWeekDayList);
            }
        }
        if (numberList != null && numberList.size() > 0) {
            Integer firstDayOfRule = (Integer)numberList.get(0);
            int expectedFirstDay = calendar.get(5);
            delta = expectedFirstDay - firstDayOfRule;
            if (delta != 0) {
                NumberList newNumberList = new NumberList();
                for (int j = 0; j < numberList.size(); ++j) {
                    Integer numberI = (Integer)numberList.get(j);
                    newNumberList.add(new Integer(numberI + delta));
                }
                recur.getMonthDayList().removeAll((Collection)numberList);
                recur.getMonthDayList().addAll((Collection)newNumberList);
            }
        }
    }

    public static java.util.Date getPreviousOccurrenceDate(CalendarEvent recurEvent, java.util.Date aDate, TimeZone tz) throws Exception {
        DateTime ical4jEventFrom = new DateTime(recurEvent.getFromDateTime());
        VEvent vevent = new VEvent((Date)ical4jEventFrom, EMPTY_STR);
        Recur recur = Utils.getICalendarRecur(recurEvent);
        vevent.getProperties().add((Property)new RRule(recur));
        GregorianCalendar calendar = new GregorianCalendar();
        ((java.util.Calendar)calendar).setTimeZone(tz);
        calendar.set(1, ((java.util.Calendar)calendar).getMinimum(1));
        DateTime ical4jFrom = new DateTime(calendar.getTime());
        calendar.setTime(aDate);
        int delta = aDate.getDate() - calendar.get(5);
        ((java.util.Calendar)calendar).add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        DateTime ical4jTo = new DateTime(calendar.getTime());
        Period period = new Period(ical4jFrom, ical4jTo);
        PeriodList list = vevent.calculateRecurrenceSet(period);
        if (list == null || list.size() == 0 || list.size() == 1) {
            return null;
        }
        Period last = list.isEmpty() ? null : (Period)list.stream().max((period1, period2) -> period1.getStart().compareTo((java.util.Date)period2.getStart())).orElse(null);
        list.remove(last);
        last = list.isEmpty() ? null : (Period)list.stream().max((period1, period2) -> period1.getStart().compareTo((java.util.Date)period2.getStart())).orElse(null);
        calendar.setTimeInMillis(last.getStart().getTime());
        ((java.util.Calendar)calendar).add(5, delta);
        return calendar.getTime();
    }

    public static Recur getICalendarRecur(CalendarEvent recurEvent) throws Exception {
        int interval;
        String repeatType = recurEvent.getRepeatType();
        int count = (int)recurEvent.getRepeatCount();
        GregorianCalendar until = null;
        if (recurEvent.getRepeatUntilDate() != null) {
            until = Utils.getInstanceTempCalendar();
            until.setTimeInMillis(recurEvent.getRepeatUntilDate().getTime() + 86400000L - 1L);
        }
        if ((interval = (int)recurEvent.getRepeatInterval()) <= 1) {
            interval = 1;
        }
        Recur recur = null;
        if (repeatType.equals(CalendarEvent.RP_DAILY)) {
            recur = until != null ? new Recur("DAILY", new Date(until.getTime())) : (count > 0 ? new Recur("DAILY", count) : new Recur("FREQ=DAILY"));
            recur.setInterval(interval);
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_WEEKLY)) {
            recur = until != null ? new Recur("WEEKLY", new Date(until.getTime())) : (count > 0 ? new Recur("WEEKLY", count) : new Recur("FREQ=WEEKLY"));
            recur.setInterval(interval);
            String[] repeatByDay = recurEvent.getRepeatByDay();
            if (repeatByDay == null || repeatByDay.length == 0) {
                return null;
            }
            WeekDayList weekDayList = new WeekDayList();
            for (String s : repeatByDay) {
                weekDayList.add((Object)new WeekDay(s));
            }
            recur.getDayList().addAll((Collection)weekDayList);
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_MONTHLY)) {
            recur = until != null ? new Recur("MONTHLY", new Date(until.getTime())) : (count > 0 ? new Recur("MONTHLY", count) : new Recur("FREQ=MONTHLY"));
            recur.setInterval(interval);
            long[] repeatByMonthDay = recurEvent.getRepeatByMonthDay();
            if (repeatByMonthDay != null && repeatByMonthDay.length > 0) {
                NumberList numberList = new NumberList();
                for (long monthDay : repeatByMonthDay) {
                    numberList.add(new Integer((int)monthDay));
                }
                recur.getMonthDayList().addAll((Collection)numberList);
            } else {
                String[] repeatByDay = recurEvent.getRepeatByDay();
                if (repeatByDay != null && repeatByDay.length > 0) {
                    WeekDayList weekDayList = new WeekDayList();
                    for (String s : repeatByDay) {
                        weekDayList.add((Object)new WeekDay(s));
                    }
                    recur.getDayList().addAll((Collection)weekDayList);
                }
            }
            return recur;
        }
        if (repeatType.equals(CalendarEvent.RP_YEARLY)) {
            recur = until != null ? new Recur("YEARLY", new Date(until.getTime())) : (count > 0 ? new Recur("YEARLY", count) : new Recur("FREQ=YEARLY"));
            recur.setInterval(interval);
            return recur;
        }
        return recur;
    }

    public static void updateOriginDate(CalendarEvent event, TimeZone tz) throws Exception {
        long diff = event.getToDateTime().getTime() - event.getFromDateTime().getTime();
        java.util.Calendar calendar = java.util.Calendar.getInstance(tz);
        calendar.setTime(event.getFromDateTime());
        Recur recur = Utils.getICalendarRecur(event);
        if (recur == null) {
            return;
        }
        WeekDayList weekDayList = recur.getDayList();
        if (weekDayList.size() == 0) {
            return;
        }
        HashSet<Integer> days = new HashSet<Integer>();
        for (int i = 0; i < weekDayList.size(); ++i) {
            WeekDay wd = (WeekDay)weekDayList.get(i);
            days.add(WeekDay.getCalendarDay((WeekDay)wd));
        }
        int dayOfWeek = calendar.get(7);
        while (!days.contains(dayOfWeek)) {
            calendar.add(5, 1);
            dayOfWeek = calendar.get(7);
        }
        event.setFromDateTime(calendar.getTime());
        calendar.setTimeInMillis(calendar.getTimeInMillis() + diff);
        event.setToDateTime(calendar.getTime());
    }

    public static Calendar loadCalendar(Node calNode) throws Exception {
        Calendar calendar = new Calendar();
        StringBuilder namePattern = new StringBuilder(256);
        namePattern.append(EXO_ID).append('|').append(EXO_NAME).append('|').append(EXO_DESCRIPTION).append('|').append(EXO_LOCALE).append('|').append(EXO_TIMEZONE).append('|').append(EXO_SHARED_COLOR).append('|').append(EXO_CALENDAR_COLOR).append('|').append(EXO_CALENDAR_OWNER).append('|').append(EXO_PUBLIC_URL).append('|').append(EXO_PRIVATE_URL).append('|').append(EXO_GROUPS).append('|').append(EXO_VIEW_PERMISSIONS).append('|').append(EXO_EDIT_PERMISSIONS).append("|").append(EXO_DATE_MODIFIED);
        PropertyIterator it = calNode.getProperties(namePattern.toString());
        ArrayList<String> groups = null;
        String[] viewPermission = null;
        String[] editPermission = null;
        while (it.hasNext()) {
            javax.jcr.Property p = it.nextProperty();
            String name = p.getName();
            if (name.equals(EXO_ID)) {
                calendar.setId(p.getString());
                continue;
            }
            if (name.equals(EXO_NAME)) {
                calendar.setName(p.getString());
                continue;
            }
            if (name.equals(EXO_DESCRIPTION)) {
                calendar.setDescription(p.getString());
                continue;
            }
            if (name.equals(EXO_LOCALE)) {
                calendar.setLocale(p.getString());
                continue;
            }
            if (name.equals(EXO_TIMEZONE)) {
                calendar.setTimeZone(p.getString());
                continue;
            }
            if (name.equals(EXO_SHARED_COLOR)) {
                calendar.setCalendarColor(p.getString());
                continue;
            }
            if (name.equals(EXO_CALENDAR_COLOR)) {
                calendar.setCalendarColor(p.getString());
                continue;
            }
            if (name.equals(EXO_CALENDAR_OWNER)) {
                calendar.setCalendarOwner(p.getString());
                continue;
            }
            if (name.equals(EXO_PUBLIC_URL)) {
                calendar.setPublicUrl(p.getString());
                continue;
            }
            if (name.equals(EXO_PRIVATE_URL)) {
                calendar.setPrivateUrl(p.getString());
                continue;
            }
            if (name.equals(EXO_DATE_MODIFIED)) {
                calendar.setLastModified(p.getDate().getTimeInMillis());
                continue;
            }
            if (name.equals(EXO_GROUPS)) {
                Value[] values = p.getValues();
                groups = new ArrayList<String>();
                for (Value v : values) {
                    groups.add(v.getString());
                }
                continue;
            }
            if (name.equals(EXO_VIEW_PERMISSIONS)) {
                viewPermission = Utils.ValuesToStrings(p.getValues());
                continue;
            }
            if (!name.equals(EXO_EDIT_PERMISSIONS)) continue;
            editPermission = Utils.ValuesToStrings(p.getValues());
        }
        calendar.setHasChildren(calNode.hasNodes());
        if (!calendar.isPublic()) {
            if (groups != null) {
                calendar.setGroups(groups.toArray(new String[groups.size()]));
            }
            if (viewPermission != null) {
                calendar.setViewPermission(viewPermission);
            }
            if (editPermission != null) {
                calendar.setEditPermission(editPermission);
            }
        }
        return calendar;
    }

    public static String[] ValuesToStrings(Value[] Val) throws Exception {
        if (Val.length == 1) {
            return new String[]{Val[0].getString()};
        }
        String[] Str = new String[Val.length];
        for (int i = 0; i < Val.length; ++i) {
            Str[i] = Val[i].getString();
        }
        return Str;
    }

    public static void skip(Iterator<?> it, long offset) {
        while (it.hasNext()) {
            if (offset == 0L) {
                return;
            }
            it.next();
            --offset;
        }
    }

    public static <T> List<T> subList(List<T> it, int offset, int limit) {
        if (it == null) {
            return it;
        }
        if (it.size() <= offset) {
            return Collections.emptyList();
        }
        if (limit < 0) {
            limit = it.size();
        }
        if (offset < 0) {
            offset = 0;
        }
        limit = offset + limit > it.size() ? it.size() - offset : limit;
        return limit == it.size() && offset == 0 ? it : it.subList(offset, offset + limit);
    }

    public static <T> T[] subArray(T[] t, int offset, int limit) {
        if (t == null) {
            return t;
        }
        if (limit < 0) {
            limit = t.length;
        }
        if (offset >= t.length) {
            offset = t.length;
        }
        if (offset < 0) {
            offset = 0;
        }
        limit = offset + limit > t.length ? t.length - offset : limit;
        return Arrays.copyOfRange(t, offset, offset + limit);
    }

    public static boolean isCalendarEditable(String username, Calendar cal) {
        return Utils.isCalendarEditable(username, cal, true);
    }

    public static boolean isCalendarEditable(String username, Calendar cal, boolean checkRemote) {
        if (cal == null || username == null) {
            throw new IllegalArgumentException("username and cal parameter must not be null");
        }
        CalendarService service = Utils.getCalendarService();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService oService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        try {
            Identity curr;
            if (service.getUserCalendar(username, cal.getId()) != null) {
                return !checkRemote || !cal.isRemote();
            }
            if (ConversationState.getCurrent() != null && (curr = ConversationState.getCurrent().getIdentity()) != null && curr.getUserId().equals(username)) {
                return Utils.hasPermission(cal.getEditPermission(), curr);
            }
            return Utils.hasPermission(oService, cal.getEditPermission(), username);
        }
        catch (Exception ex) {
            log.error((Object)"Exception raised during checking for calendar editable", (Throwable)ex);
            return false;
        }
    }

    private static CalendarService getCalendarService() {
        return (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
    }

    public static Attachment loadAttachment(Node attchmentNode) throws Exception {
        Attachment attachment = null;
        if (attchmentNode.isNodeType(EXO_EVEN_TATTACHMENT)) {
            Node contentNode;
            attachment = new Attachment();
            attachment.setId(attchmentNode.getPath());
            if (attchmentNode.hasProperty(EXO_FILE_NAME)) {
                attachment.setName(attchmentNode.getProperty(EXO_FILE_NAME).getString());
            }
            if ((contentNode = attchmentNode.getNode(JCR_CONTENT)) != null) {
                if (contentNode.hasProperty(JCR_LASTMODIFIED)) {
                    attachment.setLastModified(contentNode.getProperty(JCR_LASTMODIFIED).getDate().getTimeInMillis());
                }
                if (contentNode.hasProperty(JCR_MIMETYPE)) {
                    attachment.setMimeType(contentNode.getProperty(JCR_MIMETYPE).getString());
                }
                if (contentNode.hasProperty(JCR_DATA)) {
                    InputStream inputStream = contentNode.getProperty(JCR_DATA).getStream();
                    attachment.setSize(inputStream.available());
                    attachment.setInputStream(inputStream);
                }
            }
            attachment.setWorkspace(attchmentNode.getSession().getWorkspace().getName());
        }
        return attachment;
    }

    public static String getLocalizedName(EventCategory cat) {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        for (int i = 0; i < Utils.getCalendarService().getDefaultEventCategoryIds().length; ++i) {
            if (!cat.getId().equals(Utils.getCalendarService().getDefaultEventCategoryIds()[i]) || !cat.getName().equals(Utils.getCalendarService().getDefaultEventCategoryNames()[i])) continue;
            try {
                if (res == null) continue;
                return res.getString("UICalendarView.label." + cat.getId());
            }
            catch (MissingResourceException e) {
                log.debug((Object)("Can not find resource bundle for key: UICalendarView.label." + cat.getId()));
            }
        }
        return cat.getName();
    }
}

