/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchResult;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;

public class CalendarSearchServiceConnector
extends SearchServiceConnector {
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private CalendarService calendarService_;
    private OrganizationService organizationService_;
    private static final Log log = ExoLogger.getLogger((String)"cs.calendar.unified.search.service");
    private Map<String, String[]> calendarMap = new HashMap<String, String[]>();

    public CalendarSearchServiceConnector(InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator_ = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        this.calendarService_ = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarServiceImpl.class);
        this.organizationService_ = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.searchData(context, null, query, sites, offset, limit, sort, order);
    }

    protected Collection<SearchResult> searchData(SearchContext context, String dataType, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> events = new ArrayList<SearchResult>();
        try {
            Collection group;
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            Node calendarHome = this.nodeHierarchyCreator_.getUserApplicationNode(SessionProvider.createSystemProvider(), userId);
            List<Calendar> calendars = this.calendarService_.getUserCalendars(userId, true);
            GroupCalendarData sharedCalendar = this.calendarService_.getSharedCalendars(userId, true);
            if (sharedCalendar != null) {
                calendars.addAll(sharedCalendar.getCalendars());
            }
            if (!(group = this.organizationService_.getGroupHandler().findGroupsOfUser(userId)).isEmpty()) {
                String[] groupIds = new String[group.size()];
                int i = 0;
                for (Group g : group) {
                    groupIds[i] = g.getId();
                    ++i;
                }
                List<GroupCalendarData> groupCalendar = this.calendarService_.getGroupCalendars(groupIds, true, userId);
                if (groupCalendar != null) {
                    for (GroupCalendarData gCal : groupCalendar) {
                        if (gCal.getCalendars() == null) continue;
                        calendars.addAll(gCal.getCalendars());
                    }
                }
            }
            this.calendarMap.clear();
            for (Calendar cal : calendars) {
                this.calendarMap.put(cal.getId(), new String[]{cal.getName(), cal.getTimeZone()});
            }
            UnifiedQuery eventQuery = new UnifiedQuery();
            java.util.Calendar today = java.util.Calendar.getInstance();
            eventQuery.setFromDate(today);
            eventQuery.setQueryType("sql");
            eventQuery.setEventType(dataType);
            eventQuery.setText(query);
            String sortBy = Utils.SORT_FIELD_MAP.get(sort);
            if (Utils.ORDERBY_DATE.equals(sortBy)) {
                sortBy = CalendarEvent.TYPE_EVENT.equals(dataType) ? Utils.EXO_FROM_DATE_TIME : Utils.EXO_TO_DATE_TIME;
            }
            eventQuery.setOrderBy(new String[]{sortBy});
            eventQuery.setOrderType(order);
            if (CalendarEvent.TYPE_TASK.equals(dataType)) {
                eventQuery.setState(CalendarEvent.COMPLETED + Utils.COLON + CalendarEvent.CANCELLED);
            }
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            QueryImpl jcrquery = (QueryImpl)qm.createQuery(((EventQuery)eventQuery).getQueryStatement(), eventQuery.getQueryType());
            jcrquery.setOffset((long)offset);
            jcrquery.setLimit((long)limit);
            QueryResult result = jcrquery.execute();
            RowIterator rIt = result.getRows();
            while (rIt.hasNext()) {
                SearchResult rs = this.buildResult(context, dataType, rIt.nextRow());
                if (rs == null) continue;
                events.add(rs);
            }
        }
        catch (Exception e) {
            log.info((Object)("Could not execute unified seach " + dataType), (Throwable)e);
        }
        return events;
    }

    private SearchResult buildResult(SearchContext sc, String dataType, Object iter) {
        try {
            String calId = null;
            if (iter instanceof Row) {
                Row row = (Row)iter;
                calId = row.getValue(Utils.EXO_CALENDAR_ID).getString();
            } else {
                Node eventNode = (Node)iter;
                if (eventNode.hasProperty(Utils.EXO_CALENDAR_ID)) {
                    calId = eventNode.getProperty(Utils.EXO_CALENDAR_ID).getString();
                }
            }
            if (this.calendarMap.keySet().contains(calId)) {
                StringBuffer detail = new StringBuffer();
                String title = this.buildValue(Utils.EXO_SUMMARY, iter);
                detail.append(this.buildCalName(Utils.EXO_CALENDAR_ID, iter));
                String url = CalendarSearchResult.buildLink(sc, calId, this.buildValue(Utils.EXO_ID, iter));
                String excerpt = this.buildExcerpt(iter);
                String detailValue = Utils.EMPTY_STR;
                String imageUrl = this.buildImageUrl(iter);
                detail.append(this.buildDetail(iter));
                if (detail.length() > 0) {
                    detailValue = detail.toString();
                }
                long relevancy = this.buildScore(iter);
                long date = this.buildDate(iter);
                CalendarSearchResult result = new CalendarSearchResult(url, title, excerpt, detailValue, imageUrl, date, relevancy);
                result.setDataType(dataType);
                result.setTimeZoneName(this.calendarMap.get(calId)[1]);
                if (CalendarEvent.TYPE_EVENT.equals(dataType)) {
                    result.setFromDateTime(this.buildDate(iter, Utils.EXO_FROM_DATE_TIME).getTimeInMillis());
                }
                return result;
            }
        }
        catch (Exception e) {
            log.info((Object)("Error when building result object from result data " + e));
        }
        return null;
    }

    private String buildExcerpt(Object iter) throws RepositoryException {
        StringBuffer origin = new StringBuffer(Utils.EMPTY_STR);
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                int counter = 0;
                for (String field : Utils.SEARCH_FIELDS) {
                    if (row.getValue(field) == null) continue;
                    if (counter > 0) {
                        origin.append(" ");
                    }
                    origin.append(row.getValue(field).getString());
                    ++counter;
                }
            } else {
                Node eventNode = (Node)iter;
                int counter = 0;
                for (String field : Utils.SEARCH_FIELDS) {
                    if (!eventNode.hasProperty(field)) continue;
                    if (counter > 0) {
                        origin.append(" ");
                    }
                    origin.append(eventNode.getProperty(field).getString());
                    ++counter;
                }
            }
        }
        catch (Exception e) {
            log.info((Object)("Error when building customer exerpt property from data " + e));
        }
        return origin.toString();
    }

    private String buildImageUrl(Object iter) throws RepositoryException {
        String icon = null;
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(Utils.EXO_EVENT_TYPE) != null) {
                icon = CalendarEvent.TYPE_TASK.equals(row.getValue(Utils.EXO_EVENT_TYPE).getString()) ? row.getValue(Utils.EXO_EVENT_STATE).getString() : Utils.EVENT_ICON;
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(Utils.EXO_EVENT_TYPE)) {
                if (CalendarEvent.TYPE_TASK.equals(eventNode.getProperty(Utils.EXO_EVENT_TYPE).getString())) {
                    if (eventNode.hasProperty(Utils.EXO_EVENT_STATE)) {
                        icon = eventNode.getProperty(Utils.EXO_EVENT_STATE).getString();
                    }
                } else {
                    icon = Utils.EVENT_ICON;
                }
            }
        }
        return icon;
    }

    private long buildDate(Object iter) {
        try {
            return this.buildDate(iter, "exo:dateCreated").getTimeInMillis();
        }
        catch (Exception e) {
            log.info((Object)("Clould not build date value to long from data " + e));
            return 0L;
        }
    }

    private java.util.Calendar buildDate(Object iter, String readProperty) {
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                return row.getValue(readProperty).getDate();
            }
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(readProperty)) {
                return eventNode.getProperty(readProperty).getDate();
            }
            return null;
        }
        catch (Exception e) {
            log.info((Object)("Could not build date value from " + readProperty + " : " + e));
            return null;
        }
    }

    private String buildCalName(String property, Object iter) throws RepositoryException {
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(property) != null && this.calendarMap.get(row.getValue(property).getString()) != null) {
                return this.calendarMap.get(row.getValue(property).getString())[0];
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(property) && this.calendarMap.get(eventNode.getProperty(property).getString()) != null) {
                return this.calendarMap.get(eventNode.getProperty(property).getString())[0];
            }
        }
        return Utils.EMPTY_STR;
    }

    private long buildScore(Object iter) {
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                return row.getValue("jcr:score").getLong();
            }
        }
        catch (Exception e) {
            log.info((Object)("No score return by query " + e));
        }
        return 0L;
    }

    private String buildValue(String property, Object iter) throws RepositoryException {
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(property) != null) {
                return row.getValue(property).getString();
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(property)) {
                return eventNode.getProperty(property).getString();
            }
        }
        return Utils.EMPTY_STR;
    }

    private String buildDetail(Object iter) throws RepositoryException {
        SimpleDateFormat df = new SimpleDateFormat(Utils.DATE_TIME_FORMAT);
        StringBuffer detail = new StringBuffer();
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(Utils.EXO_EVENT_TYPE) != null) {
                if (CalendarEvent.TYPE_EVENT.equals(row.getValue(Utils.EXO_EVENT_TYPE).getString())) {
                    if (row.getValue(Utils.EXO_FROM_DATE_TIME) != null) {
                        detail.append(" ").append(Utils.MINUS).append(" ").append(df.format(row.getValue(Utils.EXO_FROM_DATE_TIME).getDate().getTime()));
                    }
                    if (row.getValue(Utils.EXO_LOCATION) != null) {
                        detail.append(" ").append(Utils.MINUS).append(" ").append(row.getValue(Utils.EXO_LOCATION).getString());
                    }
                } else if (row.getValue(Utils.EXO_TO_DATE_TIME) != null) {
                    detail.append(" ").append(Utils.MINUS).append(" ").append("Due for: ").append(df.format(row.getValue(Utils.EXO_TO_DATE_TIME).getDate().getTime()));
                }
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(Utils.EXO_EVENT_TYPE)) {
                if (CalendarEvent.TYPE_EVENT.equals(eventNode.getProperty(Utils.EXO_EVENT_TYPE).getString())) {
                    if (eventNode.hasProperty(Utils.EXO_FROM_DATE_TIME)) {
                        detail.append(" ").append(Utils.MINUS).append(" ").append(df.format(eventNode.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTime()));
                    }
                    if (eventNode.hasProperty(Utils.EXO_LOCATION)) {
                        detail.append(" ").append(Utils.MINUS).append(" ").append(eventNode.getProperty(Utils.EXO_LOCATION).getString());
                    }
                } else if (eventNode.hasProperty(Utils.EXO_TO_DATE_TIME)) {
                    detail.append(" ").append(Utils.MINUS).append(" ").append("Due for: ").append(df.format(eventNode.getProperty(Utils.EXO_TO_DATE_TIME).getDate().getTime()));
                }
            }
        }
        return detail.toString();
    }
}

