/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.quartz.JobExecutionContext;

public class PopupReminderJob
extends MultiTenancyJob {
    private static Log log_ = ExoLogger.getLogger((String)"cs.calendar.job.popup");

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return PopupReminderTask.class;
    }

    public static String getReminderPath(Calendar fromCalendar, SessionProvider provider) throws Exception {
        String year = "Y" + String.valueOf(fromCalendar.get(1));
        String month = "M" + String.valueOf(fromCalendar.get(2) + 1);
        String day = "D" + String.valueOf(fromCalendar.get(5));
        StringBuffer path = new StringBuffer("/jcr:root");
        path.append(Utils.getPublicServiceHome(provider).getPath());
        path.append(Utils.SLASH).append(year).append(Utils.SLASH).append(month).append(Utils.SLASH).append(day);
        path.append(Utils.SLASH).append(Utils.CALENDAR_REMINDER);
        return path.toString();
    }

    public class PopupReminderTask
    extends MultiTenancyJob.MultiTenancyTask {
        public PopupReminderTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)PopupReminderJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            super.run();
            SessionProvider provider = SessionProvider.createSystemProvider();
            try {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"Calendar popup reminder service");
                }
                GregorianCalendar fromCalendar = Utils.getInstanceTempCalendar();
                ContinuationService continuation = (ContinuationService)this.container.getComponentInstanceOfType(ContinuationService.class);
                Node calendarHome = Utils.getPublicServiceHome(provider);
                if (calendarHome == null) {
                    return;
                }
                StringBuffer path = new StringBuffer(PopupReminderJob.getReminderPath(fromCalendar, provider));
                path.append("//element(*,exo:reminder)");
                path.append("[@exo:remindDateTime <= xs:dateTime('" + ISO8601.format((Calendar)fromCalendar) + "') and @exo:isOver = 'false' and @exo:reminderType = 'popup' ]");
                QueryManager queryManager = Utils.getSession(provider).getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(path.toString(), "xpath");
                QueryResult results = query.execute();
                NodeIterator iter = results.getNodes();
                ArrayList<Reminder> popupReminders = new ArrayList<Reminder>();
                while (iter.hasNext()) {
                    Node reminder = iter.nextNode();
                    boolean isRepeat = reminder.getProperty(Utils.EXO_IS_REPEAT).getBoolean();
                    long fromTime = reminder.getProperty(Utils.EXO_FROM_DATE_TIME).getDate().getTimeInMillis();
                    long remindTime = reminder.getProperty(Utils.EXO_REMINDER_DATE).getDate().getTimeInMillis();
                    long interval = reminder.getProperty(Utils.EXO_TIME_INTERVAL).getLong() * 60L * 1000L;
                    Reminder rmdObj = new Reminder();
                    rmdObj.setRepeate(isRepeat);
                    if (reminder.hasProperty(Utils.EXO_OWNER)) {
                        rmdObj.setReminderOwner(reminder.getProperty(Utils.EXO_OWNER).getString());
                    }
                    if (reminder.hasProperty(Utils.EXO_EVENT_ID)) {
                        rmdObj.setId(reminder.getProperty(Utils.EXO_EVENT_ID).getString());
                    }
                    if (isRepeat) {
                        if (fromCalendar.getTimeInMillis() >= fromTime) {
                            reminder.setProperty(Utils.EXO_IS_OVER, true);
                        } else if (remindTime + interval > fromTime) {
                            reminder.setProperty(Utils.EXO_IS_OVER, true);
                        } else {
                            GregorianCalendar cal = new GregorianCalendar();
                            cal.setTimeInMillis(remindTime + interval);
                            reminder.setProperty(Utils.EXO_REMINDER_DATE, (Calendar)cal);
                            reminder.setProperty(Utils.EXO_IS_OVER, false);
                        }
                    } else {
                        reminder.setProperty(Utils.EXO_IS_OVER, true);
                    }
                    popupReminders.add(rmdObj);
                    reminder.save();
                }
                if (!popupReminders.isEmpty()) {
                    for (Reminder rmdObj : popupReminders) {
                        for (String user : rmdObj.getReminderOwner().split(Utils.COMMA)) {
                            continuation.sendMessage(user, "/eXo/Application/Calendar/messages", (Object)rmdObj.getId());
                        }
                    }
                }
            }
            catch (RepositoryException e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"Data base not ready!");
                }
            }
            catch (Exception e) {
                if (log_.isDebugEnabled()) {
                    log_.debug((Object)"Exception in method execute", (Throwable)e);
                }
            }
            finally {
                provider.close();
            }
            if (log_.isDebugEnabled()) {
                log_.debug((Object)"File plan job done");
            }
        }
    }
}

