/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchResult;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserPortalContext;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class CalendarSearchServiceConnector
extends SearchServiceConnector {
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private CalendarService calendarService_;
    private OrganizationService organizationService_;
    private SpaceService spaceService_;
    private static final Log log = ExoLogger.getLogger((String)"cs.calendar.unified.search.service");
    private Map<String, Calendar> calendarMap = new HashMap<String, Calendar>();

    public CalendarSearchServiceConnector(InitParams initParams) {
        super(initParams);
        this.nodeHierarchyCreator_ = (NodeHierarchyCreator)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(NodeHierarchyCreator.class);
        this.calendarService_ = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarServiceImpl.class);
        this.organizationService_ = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        this.spaceService_ = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.searchData(context, null, query, sites, offset, limit, sort, order);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<SearchResult> searchData(SearchContext context, String dataType, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        ArrayList<SearchResult> events = new ArrayList<SearchResult>();
        SessionProvider provider = SessionProvider.createSystemProvider();
        try {
            Collection group;
            this.calendarMap.clear();
            String userId = ConversationState.getCurrent().getIdentity().getUserId();
            Node calendarHome = this.nodeHierarchyCreator_.getUserApplicationNode(provider, userId);
            List<Calendar> privateCalendars = this.calendarService_.getUserCalendars(userId, true);
            for (Calendar cal : privateCalendars) {
                this.calendarMap.put(cal.getId(), cal);
            }
            GroupCalendarData sharedCalendar = this.calendarService_.getSharedCalendars(userId, true);
            if (sharedCalendar != null) {
                List<Calendar> shareCalendars = sharedCalendar.getCalendars();
                for (Calendar cal : shareCalendars) {
                    this.calendarMap.put(cal.getId(), cal);
                }
            }
            if (!(group = this.organizationService_.getGroupHandler().findGroupsOfUser(userId)).isEmpty()) {
                String[] groupIds = new String[group.size()];
                int i = 0;
                for (Group g : group) {
                    groupIds[i] = g.getId();
                    ++i;
                }
                List<GroupCalendarData> groupCalendar = this.calendarService_.getGroupCalendars(groupIds, true, userId);
                if (groupCalendar != null) {
                    ArrayList<Calendar> spaceCalendars = new ArrayList<Calendar>();
                    for (GroupCalendarData gCal : groupCalendar) {
                        if (gCal.getCalendars() == null) continue;
                        spaceCalendars.addAll(gCal.getCalendars());
                    }
                    for (Calendar cal : spaceCalendars) {
                        this.calendarMap.put(cal.getId(), cal);
                    }
                }
            }
            UnifiedQuery eventQuery = new UnifiedQuery();
            java.util.Calendar today = java.util.Calendar.getInstance();
            eventQuery.setFromDate(today);
            eventQuery.setQueryType("sql");
            eventQuery.setEventType(dataType);
            eventQuery.setText(query);
            String sortBy = Utils.SORT_FIELD_MAP.get(sort);
            if (Utils.ORDERBY_DATE.equals(sortBy)) {
                sortBy = CalendarEvent.TYPE_EVENT.equals(dataType) ? "exo:fromDateTime" : "exo:toDateTime";
            }
            eventQuery.setOrderBy(new String[]{sortBy});
            eventQuery.setOrderType(order);
            if (CalendarEvent.TYPE_TASK.equals(dataType)) {
                eventQuery.setState(CalendarEvent.COMPLETED + ":" + CalendarEvent.CANCELLED);
            }
            QueryManager qm = calendarHome.getSession().getWorkspace().getQueryManager();
            QueryImpl jcrquery = (QueryImpl)qm.createQuery(((EventQuery)eventQuery).getQueryStatement(), eventQuery.getQueryType());
            jcrquery.setOffset((long)offset);
            jcrquery.setLimit((long)limit);
            QueryResult result = jcrquery.execute();
            RowIterator rIt = result.getRows();
            while (rIt.hasNext()) {
                SearchResult rs = this.buildResult(context, sites, dataType, rIt.nextRow());
                if (rs == null) continue;
                events.add(rs);
            }
        }
        catch (Exception e) {
            log.info((Object)("Could not execute unified seach " + dataType), (Throwable)e);
        }
        finally {
            provider.close();
        }
        return events;
    }

    private SearchResult buildResult(SearchContext sc, Collection<String> siteKeys, String dataType, Object iter) {
        try {
            String calId = null;
            if (iter instanceof Row) {
                Row row = (Row)iter;
                calId = row.getValue("exo:calendarId").getString();
            } else {
                Node eventNode = (Node)iter;
                if (eventNode.hasProperty("exo:calendarId")) {
                    calId = eventNode.getProperty("exo:calendarId").getString();
                }
            }
            if (this.calendarMap.keySet().contains(calId)) {
                Calendar cal = this.calendarMap.get(calId);
                String currentUser = ConversationState.getCurrent().getIdentity().getUserId();
                int calType = this.calendarService_.getTypeOfCalendar(currentUser, calId);
                if (this.isSearchable(calType, cal, currentUser, iter)) {
                    StringBuffer detail = new StringBuffer();
                    String title = this.buildValue("exo:summary", iter);
                    detail.append(this.buildCalName("exo:calendarId", iter));
                    String url = this.buildLink(sc, siteKeys, calId, this.buildValue("exo:id", iter));
                    String excerpt = this.buildValue("exo:description", iter);
                    String detailValue = "";
                    String imageUrl = this.buildImageUrl(iter);
                    detail.append(this.buildDetail(iter));
                    if (detail.length() > 0) {
                        detailValue = detail.toString();
                    }
                    long relevancy = this.buildScore(iter);
                    long date = this.buildDate(iter);
                    CalendarSearchResult result = new CalendarSearchResult(url, title, excerpt, detailValue, imageUrl, date, relevancy);
                    result.setDataType(dataType);
                    result.setTimeZoneName(cal.getTimeZone());
                    if (CalendarEvent.TYPE_EVENT.equals(dataType)) {
                        result.setFromDateTime(this.buildDate(iter, "exo:fromDateTime").getTimeInMillis());
                    } else if (CalendarEvent.TYPE_TASK.equals(dataType)) {
                        result.setTaskStatus(this.buildValue("exo:eventState", iter));
                    }
                    return result;
                }
            }
        }
        catch (Exception e) {
            log.info((Object)("Error when building result object from result data " + e));
        }
        return null;
    }

    private String buildExcerpt(Object iter) throws RepositoryException {
        StringBuffer origin = new StringBuffer("");
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                int counter = 0;
                for (String field : Utils.SEARCH_FIELDS) {
                    if (row.getValue(field) == null) continue;
                    if (counter > 0) {
                        origin.append(" ");
                    }
                    origin.append(row.getValue(field).getString());
                    ++counter;
                }
            } else {
                Node eventNode = (Node)iter;
                int counter = 0;
                for (String field : Utils.SEARCH_FIELDS) {
                    if (!eventNode.hasProperty(field)) continue;
                    if (counter > 0) {
                        origin.append(" ");
                    }
                    origin.append(eventNode.getProperty(field).getString());
                    ++counter;
                }
            }
        }
        catch (Exception e) {
            log.info((Object)("Error when building customer exerpt property from data " + e));
        }
        return origin.toString();
    }

    private String buildImageUrl(Object iter) throws RepositoryException {
        String icon = null;
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue("exo:eventType") != null) {
                icon = CalendarEvent.TYPE_TASK.equals(row.getValue("exo:eventType").getString()) ? Utils.TASK_ICON_URL : Utils.EVENT_ICON_URL;
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty("exo:eventType")) {
                icon = CalendarEvent.TYPE_TASK.equals(eventNode.getProperty("exo:eventType").getString()) ? Utils.TASK_ICON_URL : Utils.EVENT_ICON_URL;
            }
        }
        return icon;
    }

    private long buildDate(Object iter) {
        try {
            return this.buildDate(iter, "exo:dateCreated").getTimeInMillis();
        }
        catch (Exception e) {
            log.info((Object)("Clould not build date value to long from data " + e));
            return 0L;
        }
    }

    private java.util.Calendar buildDate(Object iter, String readProperty) {
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                return row.getValue(readProperty).getDate();
            }
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(readProperty)) {
                return eventNode.getProperty(readProperty).getDate();
            }
            return null;
        }
        catch (Exception e) {
            log.info((Object)("Could not build date value from " + readProperty + " : " + e));
            return null;
        }
    }

    private String buildCalName(String property, Object iter) throws RepositoryException {
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(property) != null && this.calendarMap.get(row.getValue(property).getString()) != null) {
                return this.calendarMap.get(row.getValue(property).getString()).getName();
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(property) && this.calendarMap.get(eventNode.getProperty(property).getString()) != null) {
                return this.calendarMap.get(eventNode.getProperty(property).getString()).getName();
            }
        }
        return "";
    }

    private long buildScore(Object iter) {
        try {
            if (iter instanceof Row) {
                Row row = (Row)iter;
                return row.getValue("jcr:score").getLong();
            }
        }
        catch (Exception e) {
            log.info((Object)("No score return by query " + e));
        }
        return 0L;
    }

    private String buildValue(String property, Object iter) throws RepositoryException {
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue(property) != null) {
                return row.getValue(property).getString();
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty(property)) {
                return eventNode.getProperty(property).getString();
            }
        }
        return "";
    }

    private String buildDetail(Object iter) throws RepositoryException {
        SimpleDateFormat df = new SimpleDateFormat(Utils.DATE_TIME_FORMAT);
        StringBuffer detail = new StringBuffer();
        if (iter instanceof Row) {
            Row row = (Row)iter;
            if (row.getValue("exo:eventType") != null) {
                if (CalendarEvent.TYPE_EVENT.equals(row.getValue("exo:eventType").getString())) {
                    if (row.getValue("exo:fromDateTime") != null) {
                        detail.append(" ").append("-").append(" ").append(df.format(row.getValue("exo:fromDateTime").getDate().getTime()));
                    }
                    if (row.getValue("exo:location") != null) {
                        detail.append(" ").append("-").append(" ").append(row.getValue("exo:location").getString());
                    }
                } else if (row.getValue("exo:toDateTime") != null) {
                    detail.append(" ").append("-").append(" ").append("Due for: ").append(df.format(row.getValue("exo:toDateTime").getDate().getTime()));
                }
            }
        } else {
            Node eventNode = (Node)iter;
            if (eventNode.hasProperty("exo:eventType")) {
                if (CalendarEvent.TYPE_EVENT.equals(eventNode.getProperty("exo:eventType").getString())) {
                    if (eventNode.hasProperty("exo:fromDateTime")) {
                        detail.append(" ").append("-").append(" ").append(df.format(eventNode.getProperty("exo:fromDateTime").getDate().getTime()));
                    }
                    if (eventNode.hasProperty("exo:location")) {
                        detail.append(" ").append("-").append(" ").append(eventNode.getProperty("exo:location").getString());
                    }
                } else if (eventNode.hasProperty("exo:toDateTime")) {
                    detail.append(" ").append("-").append(" ").append("Due for: ").append(df.format(eventNode.getProperty("exo:toDateTime").getDate().getTime()));
                }
            }
        }
        return detail.toString();
    }

    private boolean isSearchable(int calType, Calendar cal, String uId, Object iter) throws Exception {
        Row row = (Row)iter;
        boolean isTask = CalendarEvent.TYPE_TASK.equals(row.getValue("exo:eventType").getString());
        boolean isPrivateCalendar = 0 == calType;
        boolean isPrivateEvent = row.getValue("exo:isPrivate").getBoolean();
        boolean isViewPublic = !isPrivateCalendar && !isPrivateEvent;
        boolean isEditable = !isTask && !isPrivateCalendar && isPrivateEvent && cal.getEditPermission() != null && Utils.canEdit(this.organizationService_, cal.getEditPermission(), uId);
        return isTask || isPrivateCalendar || isViewPublic || isEditable;
    }

    private String buildLink(SearchContext sc, Collection<String> siteKeys, String calendarId, String eventId) {
        String url = "#";
        if (sc != null) {
            try {
                Router router = sc.getRouter();
                ExoContainerContext context = (ExoContainerContext)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(ExoContainerContext.class);
                String handler = context.getPortalContainerName();
                SiteKey siteKey = null;
                String spaceGroupId = null;
                if (calendarId.indexOf("_space_calendar") > 0) {
                    spaceGroupId = this.calendarMap.get(calendarId).getCalendarOwner();
                    siteKey = SiteKey.group((String)spaceGroupId);
                } else {
                    UserPortalConfig prc = CalendarSearchServiceConnector.getUserPortalConfig();
                    siteKey = SiteKey.portal((String)prc.getPortalConfig().getName());
                }
                if (siteKey != null && !Utils.isEmpty(siteKey.getName())) {
                    String pageName = CalendarSearchServiceConnector.getSiteName(siteKey);
                    if (Utils.isEmpty(pageName)) {
                        siteKey = SiteKey.portal((String)(sc.getSiteName() != null ? sc.getSiteName() : "intranet"));
                        pageName = CalendarSearchServiceConnector.getSiteName(siteKey);
                    }
                    url = new StringBuffer(this.getUrl(router, handler, siteKey.getName(), spaceGroupId, pageName)).append("/").append("details").append("/").append(eventId).toString();
                }
            }
            catch (Exception e) {
                log.info((Object)"build link error !");
            }
        }
        return url;
    }

    private static String getSiteName(SiteKey siteKey) {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NavigationService navService = (NavigationService)container.getComponentInstance(NavigationService.class);
            NavigationContext nav = navService.loadNavigation(siteKey);
            NodeContext parentNodeCtx = navService.loadNode(NodeModel.SELF_MODEL, nav, Scope.ALL, null);
            if (parentNodeCtx.getSize() >= 1) {
                Collection children = parentNodeCtx.getNodes();
                if (siteKey.getType() == SiteType.GROUP) {
                    children = ((NodeContext)parentNodeCtx.get(0)).getNodes();
                }
                Iterator it = children.iterator();
                NodeContext child = null;
                while (it.hasNext()) {
                    child = (NodeContext)it.next();
                    if (!"calendar".equals(child.getName()) && child.getName().indexOf("CalendarPortlet") < 0) continue;
                    return child.getName();
                }
            }
        }
        catch (NullPointerException e) {
            return "";
        }
        return "";
    }

    private static UserPortalConfig getUserPortalConfig() throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserPortalConfigService userPortalConfigSer = (UserPortalConfigService)container.getComponentInstanceOfType(UserPortalConfigService.class);
        UserPortalContext NULL_CONTEXT = new UserPortalContext(){

            public ResourceBundle getBundle(UserNavigation navigation) {
                return null;
            }

            public Locale getUserLocale() {
                return Locale.ENGLISH;
            }
        };
        String remoteId = ConversationState.getCurrent().getIdentity().getUserId();
        UserPortalConfig userPortalCfg = userPortalConfigSer.getUserPortalConfig(userPortalConfigSer.getDefaultPortal(), remoteId, NULL_CONTEXT);
        return userPortalCfg;
    }

    public String getUrl(Router router, String handler, String siteName, String spaceGroupId, String pageName) {
        try {
            HashedMap qualifiedName = new HashedMap();
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"handler"), (Object)handler);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)pageName);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"lang"), (Object)"");
            if (Utils.isEmpty(spaceGroupId)) {
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)siteName);
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.PORTAL.getName());
            } else {
                Space sp;
                String groupId = spaceGroupId.split("/")[2];
                if (this.spaceService_ != null && (sp = this.spaceService_.getSpaceByGroupId(spaceGroupId)) != null) {
                    groupId = sp.getPrettyName();
                }
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)spaceGroupId.replaceAll("/", ":"));
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.GROUP.getName());
                qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)(groupId + "/" + pageName));
            }
            return "/" + handler + URLDecoder.decode(router.render((Map)qualifiedName), "UTF-8");
        }
        catch (Exception e) {
            return null;
        }
    }
}

