/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.job.MultiTenancyJob;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.scheduler.JobInfo;
import org.quartz.JobExecutionContext;

public class SynchronizeRemoteCalendarJob
extends MultiTenancyJob {
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_JOB = "SynchonizeRemoteCalendarJob";
    public static final String SYNCHRONIZE_REMOTE_CALENDAR_GROUP = "SynchonizeRemoteCalendarGroup";
    private static final String CALENDARS = "calendars".intern();
    public static Boolean isExecuting = false;
    private static Log log_ = ExoLogger.getLogger(SynchronizeRemoteCalendarJob.class);
    public static final String USERNAME = "username";
    private String username;

    public Class<? extends MultiTenancyJob.MultiTenancyTask> getTask() {
        return SynchronizeRemoteCalendarTask.class;
    }

    private Session getSession(SessionProvider sprovider) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        return sprovider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
    }

    public static JobInfo getJobInfo(String username) {
        JobInfo info = new JobInfo(SynchronizeRemoteCalendarJob.getRemoteCalendarName(username), SYNCHRONIZE_REMOTE_CALENDAR_GROUP, SynchronizeRemoteCalendarJob.class);
        return info;
    }

    public static String getRemoteCalendarName(String username) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        String repoName = null;
        try {
            repoName = repositoryService.getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            log_.error((Object)"Repository is error", (Throwable)e);
        }
        StringBuilder jobNameBd = new StringBuilder().append(SYNCHRONIZE_REMOTE_CALENDAR_JOB).append("_").append(username).append("_").append(repoName);
        return jobNameBd.toString();
    }

    private Node getUserCalendarHome(SessionProvider provider) throws Exception {
        try {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
            Node userApp = nodeHierarchyCreator.getUserApplicationNode(provider, this.username);
            Node userCalendarApp = userApp.getNode("CalendarApplication");
            return userCalendarApp.getNode(CALENDARS);
        }
        catch (Exception e) {
            return null;
        }
    }

    static /* synthetic */ Log access$000() {
        return log_;
    }

    static /* synthetic */ String access$102(SynchronizeRemoteCalendarJob x0, String x1) {
        x0.username = x1;
        return x0.username;
    }

    static /* synthetic */ String access$100(SynchronizeRemoteCalendarJob x0) {
        return x0.username;
    }

    static /* synthetic */ Node access$200(SynchronizeRemoteCalendarJob x0, SessionProvider x1) throws Exception {
        return x0.getUserCalendarHome(x1);
    }

    static /* synthetic */ Session access$300(SynchronizeRemoteCalendarJob x0, SessionProvider x1) throws Exception {
        return x0.getSession(x1);
    }

    public class SynchronizeRemoteCalendarTask
    extends MultiTenancyJob.MultiTenancyTask {
        public SynchronizeRemoteCalendarTask(JobExecutionContext context, String repoName) {
            super((MultiTenancyJob)SynchronizeRemoteCalendarJob.this, context, repoName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void run() {
            block40: {
                block38: {
                    super.run();
                    SynchronizeRemoteCalendarJob.isExecuting = true;
                    container = Utils.getPortalContainer(this.context);
                    if (container == null) {
                        return;
                    }
                    oldContainer = ExoContainerContext.getCurrentContainer();
                    ExoContainerContext.setCurrentContainer((ExoContainer)container);
                    provider = SessionProvider.createSystemProvider();
                    calService = (CalendarService)container.getComponentInstanceOfType(CalendarService.class);
                    repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
                    currentRepo = null;
                    try {
                        currentRepo = repositoryService.getCurrentRepository().getConfiguration().getName();
                    }
                    catch (RepositoryException e) {
                        SynchronizeRemoteCalendarJob.access$000().warn((Object)"Can't get current repository name", (Throwable)e);
                    }
                    total = 0;
                    success = 0;
                    failed = 0;
                    start = System.currentTimeMillis();
                    if (SynchronizeRemoteCalendarJob.access$000().isDebugEnabled()) {
                        SynchronizeRemoteCalendarJob.access$000().debug((Object)"Remote calendar synchronization service");
                    }
                    jobDetail = this.context.getJobDetail();
                    dataMap = jobDetail.getJobDataMap();
                    SynchronizeRemoteCalendarJob.access$102(SynchronizeRemoteCalendarJob.this, dataMap.getString("username"));
                    if (SynchronizeRemoteCalendarJob.access$100(SynchronizeRemoteCalendarJob.this) != null) break block38;
                    provider.close();
                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                    SynchronizeRemoteCalendarJob.isExecuting = false;
                    if (currentRepo != null) {
                        try {
                            repositoryService.setCurrentRepositoryName(currentRepo);
                        }
                        catch (RepositoryConfigurationException e) {
                            SynchronizeRemoteCalendarJob.access$000().error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                        }
                    }
                    return;
                }
                try {
                    userCalendarHome = SynchronizeRemoteCalendarJob.access$200(SynchronizeRemoteCalendarJob.this, provider);
                    path = new StringBuffer("/jcr:root");
                    path.append(userCalendarHome.getPath());
                    path.append("//element(*,exo:remoteCalendar)");
                    queryManager = SynchronizeRemoteCalendarJob.access$300(SynchronizeRemoteCalendarJob.this, provider).getWorkspace().getQueryManager();
                    query = queryManager.createQuery(path.toString(), "xpath");
                    results = query.execute();
                    iter = results.getNodes();
                    while (iter.hasNext()) {
                        ++total;
                        remoteCalendar = iter.nextNode();
                        remoteCalendarId = remoteCalendar.getProperty("exo:id").getString();
                        remoteType = remoteCalendar.getProperty("exo:remoteType").getString();
                        syncPeriod = remoteCalendar.getProperty("exo:syncPeriod").getString();
                        try {
                            if (syncPeriod.equals("auto")) {
                                calService.refreshRemoteCalendar(SynchronizeRemoteCalendarJob.access$100(SynchronizeRemoteCalendarJob.this), remoteCalendarId);
                                ++success;
                                continue;
                            }
                            lastUpdate = remoteCalendar.getProperty("exo:lastUpdated").getDate().getTimeInMillis();
                            now = Utils.getGreenwichMeanTime().getTimeInMillis();
                            interval = 0L;
                            if ("5mins".equals(syncPeriod)) {
                                interval = 300000L;
                            }
                            if ("10mins".equals(syncPeriod)) {
                                interval = 600000L;
                            }
                            if ("15mins".equals(syncPeriod)) {
                                interval = 900000L;
                            }
                            if ("1hour".equals(syncPeriod)) {
                                interval = 3600000L;
                            }
                            if ("1day".equals(syncPeriod)) {
                                interval = 86400000L;
                            }
                            if ("1week".equals(syncPeriod)) {
                                interval = 604800000L;
                            }
                            if ("1year".equals(syncPeriod)) {
                                interval = 1708667904L;
                            }
                            if (lastUpdate + interval >= now) continue;
                            calService.refreshRemoteCalendar(SynchronizeRemoteCalendarJob.access$100(SynchronizeRemoteCalendarJob.this), remoteCalendarId);
                            ++success;
                        }
                        catch (Exception e) {
                            SynchronizeRemoteCalendarJob.access$000().debug((Object)("Skip this calendar, error when reload remote calendar " + remoteCalendarId + ". Error message: " + e.getMessage()));
                            ++failed;
                        }
                    }
                }
                catch (RepositoryException e) {
                    block39: {
                        if (!SynchronizeRemoteCalendarJob.access$000().isDebugEnabled()) break block39;
                        SynchronizeRemoteCalendarJob.access$000().debug((Object)"Data base not ready!");
                    }
                    provider.close();
                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                    SynchronizeRemoteCalendarJob.isExecuting = false;
                    if (currentRepo != null) {
                        try {
                            repositoryService.setCurrentRepositoryName(currentRepo);
                        }
                        catch (RepositoryConfigurationException e) {
                            SynchronizeRemoteCalendarJob.access$000().error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                        }
                    }
                    break block40;
                }
                catch (Exception e) {
                    block41: {
                        if (!SynchronizeRemoteCalendarJob.access$000().isDebugEnabled()) break block41;
                        SynchronizeRemoteCalendarJob.access$000().debug((Object)"Exception when synchronize remote calendar. ", (Throwable)e);
                        {
                            catch (Throwable var30_36) {
                                provider.close();
                                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                                SynchronizeRemoteCalendarJob.isExecuting = false;
                                if (currentRepo != null) {
                                    try {
                                        repositoryService.setCurrentRepositoryName(currentRepo);
                                    }
                                    catch (RepositoryConfigurationException e) {
                                        SynchronizeRemoteCalendarJob.access$000().error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                                    }
                                }
                                throw var30_36;
                            }
                        }
                    }
                    provider.close();
                    ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                    SynchronizeRemoteCalendarJob.isExecuting = false;
                    if (currentRepo != null) {
                        try {
                            repositoryService.setCurrentRepositoryName(currentRepo);
                        }
                        catch (RepositoryConfigurationException e) {
                            SynchronizeRemoteCalendarJob.access$000().error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                        }
                    } else {
                        ** GOTO lbl140
                    }
                }
                provider.close();
                ExoContainerContext.setCurrentContainer((ExoContainer)oldContainer);
                SynchronizeRemoteCalendarJob.isExecuting = false;
                if (currentRepo != null) {
                    try {
                        repositoryService.setCurrentRepositoryName(currentRepo);
                    }
                    catch (RepositoryConfigurationException e) {
                        SynchronizeRemoteCalendarJob.access$000().error((Object)String.format("Can't set current repository name as %s", new Object[]{currentRepo}), (Throwable)e);
                    }
                }
            }
            finish = System.currentTimeMillis();
            spent = finish - start;
            if (total > 0) {
                SynchronizeRemoteCalendarJob.access$000().info((Object)("Reload remote calendar completed. Total: " + total + ", Success: " + success + ", Failed: " + failed + ", Skip: " + (total - success - failed) + ". Time spent: " + spent + " ms."));
            }
        }
    }
}

