/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.model.AbstractModel;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Invitation;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.services.jcr.util.IdGenerator;

public class Event
extends AbstractModel {
    private static final long serialVersionUID = 908458203599863175L;
    public static final String TYPE_EVENT = "Event".intern();
    public static final String TYPE_TASK = "Task".intern();
    public static final String TYPE_JOURNAL = "Journal".intern();
    public static final String TENTATIVE = "tentative".intern();
    public static final String CONFIRMED = "confirmed".intern();
    public static final String CANCELLED = "canceled".intern();
    public static final String NEEDS_ACTION = "needs-action".intern();
    public static final String COMPLETED = "completed".intern();
    public static final String IN_PROCESS = "in-process".intern();
    public static final String PRIORITY_NONE = "none".intern();
    public static final String PRIORITY_LOW = "low".intern();
    public static final String PRIORITY_NORMAL = "normal".intern();
    public static final String PRIORITY_HIGH = "high".intern();
    public static final int PRI_UNDEFINED = 0;
    public static final int PRI_HIGH = 1;
    public static final int PRI_MEDIUM = 2;
    public static final int PRI_LOW = 3;
    public static final String[] PRIORITY = new String[]{PRIORITY_NONE, PRIORITY_HIGH, PRIORITY_NORMAL, PRIORITY_LOW};
    public static final String DRAFT = "draft".intern();
    public static final String FINAL = "final".intern();
    public static final String[] EVENT_STATUS = new String[]{TENTATIVE, CONFIRMED, CANCELLED};
    public static final String[] TASK_STATUS = new String[]{NEEDS_ACTION, IN_PROCESS, COMPLETED, CANCELLED};
    public static final String[] JOURNAL_STATUS = new String[]{DRAFT, FINAL, CANCELLED};
    public static final String IS_PUBLIC = "public".intern();
    public static final String IS_PRIVATE = "private".intern();
    public static final String ST_AVAILABLE = "available".intern();
    public static final String ST_BUSY = "busy".intern();
    public static final String ST_OUTSIDE = "outside".intern();
    public static final String RP_NOREPEAT = "norepeat".intern();
    public static final String RP_DAILY = "daily".intern();
    public static final String RP_WEEKLY = "weekly".intern();
    public static final String RP_MONTHLY = "monthly".intern();
    public static final String RP_YEARLY = "yearly".intern();
    public static final String RP_WEEKEND = "weekend".intern();
    public static final String RP_WORKINGDAYS = "workingdays".intern();
    public static final String[] RP_WEEKLY_BYDAY = new String[]{"MO", "TU", "WE", "TH", "FR", "SA", "SU"};
    public static final String[] REPEATTYPES = new String[]{RP_NOREPEAT, RP_DAILY, RP_WEEKLY, RP_MONTHLY, RP_YEARLY};
    private String summary;
    private String location;
    private String description;
    private String eventCategoryId;
    private String eventCategoryName;
    private String calendarId;
    private String repeatType;
    private Date fromDateTime;
    private Date toDateTime;
    private Date completedDateTime;
    private String taskDelegator;
    private String sendOption = CalendarSetting.ACTION_BYSETTING;
    private String message;
    private String[] participantStatus;
    private String recurrenceId;
    private Boolean isExceptionOccurrence;
    private Collection<String> exclusions;
    private String originalReference;
    private Date repeatUntilDate;
    private long repeatCount;
    private long repeatInterval;
    private long[] repeatBySecond;
    private long[] repeatByMinute;
    private long[] repeatByHour;
    private String[] repeatByDay;
    private long[] repeatByMonthDay;
    private long[] repeatByYearDay;
    private long[] repeatByWeekNo;
    private long[] repeatByMonth;
    private long[] repeatBySetPos;
    private String repeatWkst;
    private String eventType = TYPE_EVENT;
    private String priority = PRIORITY_NONE;
    private boolean isPrivate = true;
    private String eventState = ST_BUSY;
    private String status = "";
    private String[] invitation = new String[0];
    private String[] participant = new String[0];
    private List<Reminder> reminders = Collections.emptyList();
    private List<Attachment> attachment = Collections.emptyList();
    private String activityId;

    public Event() {
        super("Event" + IdGenerator.generate());
    }

    public Event(Event event) {
        super(event.getId());
        this.summary = event.summary;
        this.description = event.description;
        this.fromDateTime = event.fromDateTime;
        this.toDateTime = event.toDateTime;
        this.eventCategoryId = event.eventCategoryId;
        this.eventCategoryName = event.eventCategoryName;
        this.message = event.message;
        this.location = event.location;
        this.repeatType = event.repeatType;
        this.calendarId = event.calendarId;
        this.sendOption = event.sendOption;
        this.status = event.status;
        List<Attachment> attachments = event.getAttachment();
        this.setAttachment(attachments);
        this.setInvitation(event.getInvitation());
        this.setParticipant(event.getParticipant());
        this.setParticipantStatus(event.getParticipantStatus());
        this.setReminders(event.getReminders());
        this.setPriority(event.getPriority());
        this.setRepeatUntilDate(event.getRepeatUntilDate());
        this.setRepeatCount(event.getRepeatCount());
        this.setRepeatInterval(event.getRepeatInterval());
        this.setRepeatByDay(event.getRepeatByDay());
        this.setRepeatByMonthDay(event.getRepeatByMonthDay());
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String sum) {
        this.summary = sum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public String getEventCategoryId() {
        return this.eventCategoryId;
    }

    public void setEventCategoryId(String eventCategoryId) {
        this.eventCategoryId = eventCategoryId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    public void setCalendarId(String calendarId) {
        this.calendarId = calendarId;
    }

    public Date getFromDateTime() {
        return this.fromDateTime;
    }

    public void setFromDateTime(Date fromDateTime) {
        this.fromDateTime = fromDateTime;
    }

    public Date getToDateTime() {
        return this.toDateTime;
    }

    public void setToDateTime(Date toDateTime) {
        this.toDateTime = toDateTime;
    }

    public Date getCompletedDateTime() {
        return this.completedDateTime;
    }

    public void setCompletedDateTime(Date completedDateTime) {
        this.completedDateTime = completedDateTime;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getEventState() {
        return this.eventState;
    }

    public void setEventState(String eventState) {
        this.eventState = eventState;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getEventType() {
        return this.eventType;
    }

    public void setEventType(String eventType) {
        this.eventType = eventType;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String[] getInvitation() {
        return this.invitation;
    }

    public void setInvitation(String[] invitation) {
        this.invitation = invitation;
    }

    public List<Reminder> getReminders() {
        return this.reminders;
    }

    public void setReminders(List<Reminder> rm) {
        this.reminders = rm;
    }

    public void setRepeatType(String repeatType) {
        this.repeatType = repeatType;
    }

    public String getRepeatType() {
        return this.repeatType;
    }

    public List<Attachment> getAttachment() {
        return this.attachment;
    }

    public void setAttachment(List<Attachment> list) {
        this.attachment = list;
    }

    public void setParticipant(String[] participant) {
        this.participant = participant;
    }

    public String[] getParticipant() {
        return this.participant;
    }

    public String[] getParticipantStatus() {
        return this.participantStatus;
    }

    public void setParticipantStatus(String[] participantStatus) {
        this.participantStatus = participantStatus;
    }

    public void setTaskDelegator(String taskDelegator) {
        this.taskDelegator = taskDelegator;
    }

    public String getTaskDelegator() {
        return this.taskDelegator;
    }

    public void setEventCategoryName(String eventCategoryName) {
        this.eventCategoryName = eventCategoryName;
    }

    public String getEventCategoryName() {
        return this.eventCategoryName;
    }

    public void setSendOption(String sendOption) {
        this.sendOption = sendOption;
    }

    public String getSendOption() {
        return this.sendOption;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message != null ? message : new String();
    }

    public void setRecurrenceId(String recurrenceId) {
        this.recurrenceId = recurrenceId;
    }

    public String getRecurrenceId() {
        return this.recurrenceId;
    }

    public void setIsExceptionOccurrence(Boolean isExceptionOccurrence) {
        this.isExceptionOccurrence = isExceptionOccurrence;
    }

    public Boolean getIsExceptionOccurrence() {
        return this.isExceptionOccurrence;
    }

    public void setExclusions(Collection<String> ids) {
        if (ids != null) {
            ids = new HashSet<String>(ids);
        }
        this.exclusions = ids;
    }

    public Collection<String> getExclusions() {
        return this.exclusions;
    }

    public void addExclusion(String id) {
        if (this.exclusions == null) {
            this.exclusions = new HashSet<String>();
        }
        this.exclusions.add(id);
    }

    public void removeExclusion(String id) {
        if (this.exclusions != null) {
            this.exclusions.remove(id);
        }
    }

    public void setRepeatUntilDate(Date repeatUntilDate) {
        this.repeatUntilDate = repeatUntilDate;
    }

    public Date getRepeatUntilDate() {
        return this.repeatUntilDate;
    }

    public void setOriginalReference(String originalReference) {
        this.originalReference = originalReference;
    }

    public String getOriginalReference() {
        return this.originalReference;
    }

    public void setRepeatCount(long repeatCount) {
        this.repeatCount = repeatCount;
    }

    public long getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatInterval(long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public long getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatBySecond(long[] repeatBySecond) {
        this.repeatBySecond = repeatBySecond;
    }

    public long[] getRepeatBySecond() {
        return this.repeatBySecond;
    }

    public long[] getRepeatByMinute() {
        return this.repeatByMinute;
    }

    public void setRepeatByMinute(long[] repeatByMinute) {
        this.repeatByMinute = repeatByMinute;
    }

    public long[] getRepeatByMonthDay() {
        return this.repeatByMonthDay;
    }

    public void setRepeatByMonthDay(long[] repeatByMonthDay) {
        this.repeatByMonthDay = repeatByMonthDay;
    }

    public long[] getRepeatByYearDay() {
        return this.repeatByYearDay;
    }

    public void setRepeatByYearDay(long[] repeatByYearDay) {
        this.repeatByYearDay = repeatByYearDay;
    }

    public long[] getRepeatByWeekNo() {
        return this.repeatByWeekNo;
    }

    public void setRepeatByWeekNo(long[] repeatByWeekNo) {
        this.repeatByWeekNo = repeatByWeekNo;
    }

    public long[] getRepeatByMonth() {
        return this.repeatByMonth;
    }

    public void setRepeatByMonth(long[] repeatByMonth) {
        this.repeatByMonth = repeatByMonth;
    }

    public long[] getRepeatBySetPos() {
        return this.repeatBySetPos;
    }

    public void setRepeatBySetPos(long[] repeatBySetPos) {
        this.repeatBySetPos = repeatBySetPos;
    }

    public String getRepeatWkst() {
        return this.repeatWkst;
    }

    public void setRepeatWkst(String repeatWkst) {
        this.repeatWkst = repeatWkst;
    }

    public void setRepeatByHour(long[] repeatByHour) {
        this.repeatByHour = repeatByHour;
    }

    public long[] getRepeatByHour() {
        return this.repeatByHour;
    }

    public void setRepeatByDay(String[] repeatByDay) {
        this.repeatByDay = repeatByDay;
    }

    public String[] getRepeatByDay() {
        return this.repeatByDay;
    }

    public boolean isEventDurationSmallerThanHalfHour() {
        long differenceInMin = (this.getToDateTime().getTime() - this.getFromDateTime().getTime()) / 60000L;
        return differenceInMin <= 30L;
    }

    public String getActivityId() {
        return this.activityId;
    }

    public void setActivityId(String activityId) {
        this.activityId = activityId;
    }

    public void addParticipant(String parName, String status) {
        LinkedList<String> pars = new LinkedList<String>();
        if (this.getParticipant() != null) {
            pars.addAll(Arrays.asList(this.getParticipant()));
        }
        if (!pars.contains(parName)) {
            pars.add(parName);
            this.setParticipant(pars.toArray(new String[pars.size()]));
            Map<String, String> statusMap = this.getStatusMap();
            if (statusMap.isEmpty()) {
                statusMap = new HashMap<String, String>();
            }
            statusMap.put(parName, status);
            this.setStatusMap(statusMap);
        }
    }

    public void removeParticipant(String parName) {
        if (this.getParticipant() == null) {
            return;
        }
        LinkedList<String> parList = new LinkedList<String>(Arrays.asList(this.getParticipant()));
        parList.remove(parName);
        this.setParticipant(parList.toArray(new String[parList.size()]));
        Map<String, String> statusMap = this.getStatusMap();
        statusMap.remove(parName);
        this.setStatusMap(statusMap);
    }

    public Invitation[] getInvitations() {
        if (this.getParticipant() == null) {
            return new Invitation[0];
        }
        Invitation[] invitations = new Invitation[this.getParticipant().length];
        int i = 0;
        Map<String, String> parStatus = this.getStatusMap();
        for (String par : this.getParticipant()) {
            invitations[i++] = new Invitation(this.getId(), par, parStatus.get(par));
        }
        return invitations;
    }

    public void setStatusMap(Map<String, String> statusMap) {
        String[] status = new String[statusMap.values().size()];
        int i = 0;
        for (String name : statusMap.keySet()) {
            status[i++] = String.format("%s:%s", name, statusMap.get(name));
        }
        this.setParticipantStatus(status);
    }

    public Map<String, String> getStatusMap() {
        if (this.getParticipantStatus() == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> status = new HashMap<String, String>();
        for (String s : this.getParticipantStatus()) {
            String[] tmp = s.split(":");
            if (tmp.length == 2) {
                status.put(tmp[0], tmp[1]);
                continue;
            }
            status.put(tmp[0], "");
        }
        return status;
    }
}

