/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.Arrays;
import java.util.LinkedList;
import org.exoplatform.calendar.model.CompositeID;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.CalendarException;
import org.exoplatform.calendar.service.EventHandler;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.ExtendedCalendarServiceImpl;
import org.exoplatform.calendar.storage.EventDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class EventHandlerImpl
implements EventHandler {
    private static Log log = ExoLogger.getLogger(EventHandlerImpl.class);
    protected ExtendedCalendarServiceImpl calService;

    public EventHandlerImpl(ExtendedCalendarServiceImpl service) {
        this.calService = service;
    }

    @Override
    public Event getEventById(String eventId) {
        CompositeID composID = CompositeID.parse(eventId);
        if (composID.getDS() != null) {
            EventDAO dao = this.getEventDAOImpl(composID.getDS());
            if (dao != null) {
                return (Event)dao.getById(composID.getId());
            }
        } else {
            for (Storage storage : this.calService.getAllStorage()) {
                Event evt;
                EventDAO dao = storage.getEventDAO();
                if (dao == null || (evt = (Event)dao.getById(composID.getId())) == null) continue;
                return evt;
            }
        }
        return null;
    }

    @Override
    public Event saveEvent(Event event) {
        EventDAO dao = this.getEventDAOImpl(event.getDS());
        if (dao != null) {
            return dao.save(event);
        }
        return null;
    }

    @Override
    public Event removeEvent(String eventId) {
        CompositeID composId = CompositeID.parse(eventId);
        EventDAO dao = this.getEventDAOImpl(composId.getDS());
        if (dao != null) {
            return (Event)dao.remove(composId.getId());
        }
        return null;
    }

    @Override
    public ListAccess<Event> findEventsByQuery(EventQuery eventQuery) {
        LinkedList<EventDAO> daos = new LinkedList<EventDAO>();
        if (eventQuery.getDS() == null) {
            for (Storage storage : this.calService.getAllStorage()) {
                daos.add(storage.getEventDAO());
            }
        } else {
            daos.add(this.getEventDAOImpl(eventQuery.getDS()));
        }
        LinkedList<ListAccess<Event>> result = new LinkedList<ListAccess<Event>>();
        for (EventDAO dao : daos) {
            ListAccess<Event> listAccess = dao.findEventsByQuery(eventQuery);
            if (listAccess == null) continue;
            result.add(listAccess);
        }
        if (result.size() == 0) {
            return null;
        }
        if (result.size() == 1) {
            return (ListAccess)result.get(0);
        }
        final LinkedList<Object> events = new LinkedList<Object>();
        for (ListAccess listAccess : result) {
            try {
                events.addAll(Arrays.asList(listAccess.load(0, -1)));
            }
            catch (Exception e) {
                throw new CalendarException(null, e.getMessage(), e);
            }
        }
        return new ListAccess<Event>(){

            public int getSize() throws Exception {
                return events.size();
            }

            public Event[] load(int offset, int limit) throws Exception, IllegalArgumentException {
                return Utils.subArray(events.toArray(new Event[this.getSize()]), offset, limit);
            }
        };
    }

    @Override
    public Event newEventInstance(String dsId) {
        EventDAO dao = this.getEventDAOImpl(dsId);
        if (dao != null) {
            return (Event)dao.newInstance();
        }
        return null;
    }

    private EventDAO getEventDAOImpl(String id) {
        return this.calService.lookForDS(id).getEventDAO();
    }
}

