/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import org.exoplatform.calendar.model.AbstractModel;
import org.exoplatform.services.jcr.util.IdGenerator;

public class Calendar
extends AbstractModel {
    private String name;
    private String calendarColor = "powder_blue";
    private String description;
    private String timeZone = TimeZone.getDefault().getID();
    private String locale = Locale.getDefault().getISO3Country();
    private String calendarOwner;
    private String[] viewPermission;
    private String[] editPermission;
    private String[] groups;
    private String publicUrl;
    private String privateUrl;
    private boolean _isPublic = false;
    private boolean remote = false;
    private boolean hasChildren = false;
    public static final String CAL_PREFIX = "calendar";

    public Calendar() {
        this(CAL_PREFIX + IdGenerator.generate());
    }

    public Calendar(String compositeId) {
        super(compositeId);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String[] editPermission) {
        this.editPermission = editPermission;
    }

    public String[] getViewPermission() {
        return this.viewPermission;
    }

    public void setViewPermission(String[] viewPermission) {
        this.viewPermission = viewPermission;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public boolean isPublic() {
        return this._isPublic;
    }

    public void setPublic(boolean isPublic) {
        this._isPublic = isPublic;
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = timeZone;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setCalendarColor(String calendarColor) {
        this.calendarColor = calendarColor;
    }

    public String getCalendarColor() {
        return this.calendarColor;
    }

    public void setCalendarOwner(String calendarOwner) {
        this.calendarOwner = calendarOwner;
    }

    public String getCalendarOwner() {
        return this.calendarOwner;
    }

    public void setPublicUrl(String publicUrl) {
        this.publicUrl = this.removeDomainName(publicUrl);
    }

    public String getPublicUrl() {
        return this.publicUrl;
    }

    public void setPrivateUrl(String privateUrl) {
        this.privateUrl = this.removeDomainName(privateUrl);
    }

    public String getPrivateUrl() {
        return this.privateUrl;
    }

    private String removeDomainName(String url) {
        if (url != null && url.indexOf("http") == 0) {
            url = url.substring(url.indexOf(":") + 3);
            url = url.substring(url.indexOf("/"));
        }
        return url;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean hasChildren() {
        return this.hasChildren;
    }

    public void setHasChildren(boolean children) {
        this.hasChildren = children;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Calendar calendar = (Calendar)o;
        return this._isPublic == calendar._isPublic && this.remote == calendar.remote && this.hasChildren == calendar.hasChildren && Objects.equals(this.name, calendar.name) && Objects.equals(this.calendarColor, calendar.calendarColor) && Objects.equals(this.description, calendar.description) && Objects.equals(this.timeZone, calendar.timeZone) && Objects.equals(this.locale, calendar.locale) && Objects.equals(this.calendarOwner, calendar.calendarOwner) && Arrays.equals(this.viewPermission, calendar.viewPermission) && Arrays.equals(this.editPermission, calendar.editPermission) && Arrays.equals(this.groups, calendar.groups) && Objects.equals(this.publicUrl, calendar.publicUrl) && Objects.equals(this.privateUrl, calendar.privateUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.calendarColor, this.description, this.timeZone, this.locale, this.calendarOwner, this.viewPermission, this.editPermission, this.groups, this.publicUrl, this.privateUrl, this._isPublic, this.remote, this.hasChildren);
    }
}

