/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.storage.jcr;

import java.util.LinkedList;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.model.query.EventQuery;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.storage.EventDAO;
import org.exoplatform.calendar.storage.Storage;
import org.exoplatform.calendar.storage.jcr.JCRCalendarDAOImpl;
import org.exoplatform.calendar.storage.jcr.JCREventQuery;
import org.exoplatform.calendar.storage.jcr.JCRStorage;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class JCREventDAOImpl
implements EventDAO {
    private final Storage context;
    private final JCRDataStorage dataStorage;
    private static final Log LOG = ExoLogger.getExoLogger(JCRCalendarDAOImpl.class);

    public JCREventDAOImpl(CalendarService calService, JCRStorage storage) {
        this.context = storage;
        this.dataStorage = ((CalendarServiceImpl)calService).getDataStorage();
    }

    @Override
    public Event getById(String id) {
        try {
            return this.dataStorage.getEventById(id);
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    @Override
    public Event save(Event event) {
        return this.persist(event, true);
    }

    @Override
    public Event update(Event event) {
        return this.persist(event, false);
    }

    private Event persist(Event event, boolean isNew) {
        try {
            String calendarId = event.getCalendarId();
            org.exoplatform.calendar.model.Calendar cal = (org.exoplatform.calendar.model.Calendar)this.context.getCalendarDAO().getById(calendarId);
            if (cal == null) {
                return null;
            }
            int calType = -1;
            if (cal instanceof Calendar) {
                calType = ((Calendar)cal).getCalType();
            }
            CalendarEvent calEvent = CalendarEvent.build(event);
            if (calType == Calendar.Type.PERSONAL.type()) {
                this.dataStorage.saveUserEvent(cal.getCalendarOwner(), cal.getId(), calEvent, isNew);
            } else if (calType == Calendar.Type.GROUP.type()) {
                this.dataStorage.savePublicEvent(cal.getId(), calEvent, isNew);
            } else {
                return null;
            }
            return event;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    @Override
    public Event remove(String id) {
        try {
            Event event = this.getById(id);
            if (event == null) {
                return null;
            }
            org.exoplatform.calendar.model.Calendar cal = (org.exoplatform.calendar.model.Calendar)this.context.getCalendarDAO().getById(event.getCalendarId());
            int type = -1;
            if (cal instanceof Calendar) {
                type = ((Calendar)cal).getCalType();
            }
            if (type == Calendar.Type.PERSONAL.type()) {
                this.dataStorage.removeUserEvent(cal.getCalendarOwner(), cal.getId(), id);
            } else if (type == Calendar.Type.GROUP.type()) {
                this.dataStorage.removePublicEvent(cal.getId(), id);
            } else {
                return null;
            }
            return event;
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            return null;
        }
    }

    @Override
    public Event newInstance() {
        Event event = new Event();
        return event;
    }

    @Override
    public ListAccess<Event> findEventsByQuery(EventQuery query) {
        final LinkedList<CalendarEvent> events = new LinkedList<CalendarEvent>();
        org.exoplatform.calendar.service.EventQuery eventQuery = this.buildEvenQuery(query);
        int type = Calendar.Type.UNDEFINED.type();
        if (query instanceof JCREventQuery) {
            type = ((JCREventQuery)query).getCalType();
        }
        try {
            if (Calendar.Type.PERSONAL.type() == type) {
                events.addAll(this.dataStorage.getUserEvents(query.getOwner(), eventQuery));
            } else if (Calendar.Type.GROUP.type() == type) {
                events.addAll(this.dataStorage.getPublicEvents(eventQuery));
            } else if (Calendar.Type.SHARED.type() == type) {
                events.addAll(this.dataStorage.getSharedEvents(query.getOwner(), eventQuery));
            } else {
                SessionProvider provider = this.dataStorage.createSystemProvider();
                Session session = this.dataStorage.getSession(provider);
                QueryManager qm = session.getWorkspace().getQueryManager();
                Query jcrQuery = qm.createQuery(eventQuery.getQueryStatement(), eventQuery.getQueryType());
                QueryResult result = jcrQuery.execute();
                NodeIterator it = result.getNodes();
                while (it.hasNext()) {
                    CalendarEvent evt = this.dataStorage.getEventById(it.nextNode().getProperty("exo:id").getString());
                    events.add(evt);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Can't query for event", (Throwable)ex);
        }
        return new ListAccess<Event>(){

            public int getSize() throws Exception {
                return events.size();
            }

            public Event[] load(int offset, int limit) throws Exception, IllegalArgumentException {
                return Utils.subArray(events.toArray(new Event[this.getSize()]), offset, limit);
            }
        };
    }

    private org.exoplatform.calendar.service.EventQuery buildEvenQuery(EventQuery query) {
        org.exoplatform.calendar.service.EventQuery eventQuery = new org.exoplatform.calendar.service.EventQuery();
        eventQuery.setCalendarId(query.getCalendarIds());
        eventQuery.setCategoryId(query.getCategoryIds());
        eventQuery.setEventType(query.getEventType());
        eventQuery.setExcludeRepeatEvent(query.getExcludeRepeatEvent());
        eventQuery.setFilterCalendarIds(query.getFilterCalendarIds());
        if (query.getFromDate() != null) {
            java.util.Calendar from = java.util.Calendar.getInstance();
            from.setTimeInMillis(query.getFromDate());
            eventQuery.setFromDate(from);
        }
        eventQuery.setOrderBy(query.getOrderBy());
        eventQuery.setOrderType(query.getOrderType());
        eventQuery.setParticipants(query.getParticipants());
        eventQuery.setPriority(query.getPriority());
        eventQuery.setQueryType("xpath");
        eventQuery.setState(query.getState());
        eventQuery.setText(query.getText());
        if (query.getToDate() != null) {
            java.util.Calendar to = java.util.Calendar.getInstance();
            to.setTimeInMillis(query.getToDate());
            eventQuery.setToDate(to);
        }
        return eventQuery;
    }
}

