/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service;

import java.util.Objects;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;

public class Calendar
extends org.exoplatform.calendar.model.Calendar {
    public static final Calendar NULL_OBJECT = new Calendar(null);
    private static final long serialVersionUID = 2638692203625602436L;
    private static final Log log = ExoLogger.getLogger(Calendar.class);
    public static final int TYPE_PRIVATE = 0;
    public static final int TYPE_SHARED = 1;
    public static final int TYPE_PUBLIC = 2;
    public static final int TYPE_ALL = -1;
    private String _calendarPath;
    private boolean _isDataInit = false;
    private int _calType;
    private boolean calTypeChecked = false;
    public static final String CALENDAR_PREF = "calendar";

    public Calendar() {
        this(CALENDAR_PREF + IdGenerator.generate());
    }

    public Calendar(String compositeId) {
        super(compositeId);
    }

    public String getCalendarPath() {
        return this._calendarPath;
    }

    public void setCalendarPath(String path) {
        this._calendarPath = path;
    }

    public void setDataInit(boolean isDataInit) {
        this._isDataInit = isDataInit;
    }

    public boolean isDataInit() {
        return this._isDataInit;
    }

    public int getCalType() {
        return this._calType;
    }

    public void setCalType(int calType) {
        this._calType = calType;
    }

    public boolean canEdit(String username) {
        return Utils.isCalendarEditable(username, this);
    }

    public boolean isShared(String username) {
        OrganizationService service = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
        return Type.PERSONAL.type() == this.getCalType() && username != null && !username.equals(this.getCalendarOwner()) && Utils.hasPermission(service, this.getViewPermission(), username);
    }

    public boolean isCalTypeChecked() {
        return this.calTypeChecked;
    }

    public void setCalTypeChecked(boolean calTypeChecked) {
        this.calTypeChecked = calTypeChecked;
    }

    public static Calendar build(org.exoplatform.calendar.model.Calendar newModel) {
        if (newModel == null) {
            return null;
        }
        Calendar cal = new Calendar();
        cal.setId(newModel.getId());
        cal.setName(newModel.getName());
        cal.setDescription(newModel.getDescription());
        cal.setLocale(newModel.getLocale());
        cal.setTimeZone(newModel.getTimeZone());
        cal.setCalendarColor(newModel.getCalendarColor());
        cal.setCalendarOwner(newModel.getCalendarOwner());
        cal.setPublicUrl(newModel.getPublicUrl());
        cal.setPrivateUrl(newModel.getPrivateUrl());
        cal.setLastModified(newModel.getLastModified());
        cal.setGroups(newModel.getGroups());
        cal.setViewPermission(newModel.getViewPermission());
        cal.setEditPermission(newModel.getEditPermission());
        cal.setRemote(newModel.isRemote());
        cal.setHasChildren(newModel.hasChildren());
        CalendarService service = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarService.class);
        try {
            cal.setCalType(service.getTypeOfCalendar(ConversationState.getCurrent().getIdentity().getUserId(), cal.getId()));
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        cal.setDS(newModel.getDS());
        return cal;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Calendar calendar = (Calendar)o;
        return this._isDataInit == calendar._isDataInit && this._calType == calendar._calType && this.calTypeChecked == calendar.calTypeChecked && Objects.equals(this._calendarPath, calendar._calendarPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._calendarPath, this._isDataInit, this._calType, this.calTypeChecked);
    }

    public static enum Type {
        PERSONAL(0),
        SHARED(1),
        GROUP(2),
        UNDEFINED(-1);

        private final int type;

        private Type(int type) {
            this.type = type;
        }

        public int type() {
            return this.type;
        }

        public static Type getType(int type) {
            for (Type t : Type.values()) {
                if (t.type() != type) continue;
                return t;
            }
            return UNDEFINED;
        }
    }
}

