/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.commons.utils.ISO8601;

public class UnifiedQuery
extends EventQuery {
    private Set<String> excludePrivateEventInCalendars = Collections.EMPTY_SET;

    public Set<String> getExcludePrivateEventInCalendars() {
        return Collections.unmodifiableSet(this.excludePrivateEventInCalendars);
    }

    public void setExcludePrivateEventInCalendars(Set<String> excludePrivateEventInCalendars) {
        this.excludePrivateEventInCalendars = excludePrivateEventInCalendars;
    }

    @Override
    public String getQueryStatement() throws Exception {
        String text;
        StringBuffer queryString = new StringBuffer("");
        if (this.getQueryType().equals("sql") && !Utils.isEmpty(text = this.getText())) {
            queryString = new StringBuffer("SELECT ");
            queryString.append(UnifiedQuery.repeat("%s", Arrays.asList(Utils.SELECT_FIELDS), ","));
            queryString.append(" FROM " + this.getNodeType() + " WHERE ");
            if (!Utils.isEmpty(this.getCalendarPath())) {
                queryString.append("jcr:path LIKE '").append(this.getCalendarPath()).append("/%/%' AND ");
            }
            if (this.getCalendarId() != null && this.getCalendarId().length > 0) {
                queryString.append("(");
                String[] calendarIds = this.getCalendarId();
                for (int i = 0; i < calendarIds.length; ++i) {
                    if (i != 0) {
                        queryString.append(" OR ");
                    }
                    String calendarId = calendarIds[i];
                    queryString.append("(").append("exo:calendarId").append(" = '").append(calendarId).append("'");
                    if (this.excludePrivateEventInCalendars != null && this.excludePrivateEventInCalendars.contains(calendarId)) {
                        queryString.append(" AND ").append("exo:isPrivate").append(" = 'false' ");
                    }
                    queryString.append(")");
                }
                queryString.append(") AND ");
            }
            if (!Utils.isEmpty(this.getEventType())) {
                queryString.append("exo:eventType").append(" = '").append(this.getEventType()).append("' AND (");
            }
            List<String> inputs = UnifiedQuery.parse(text);
            int inputCount = 0;
            for (String keyword : inputs) {
                if (inputCount > 0) {
                    queryString.append(" AND ");
                }
                queryString.append("CONTAINS(*,'").append(this.escapeContainsQuery(keyword)).append("')");
                ++inputCount;
            }
            if (!Utils.isEmpty(this.getEventType())) {
                queryString.append(") ");
            }
            if (this.getFromDate() != null && CalendarEvent.TYPE_EVENT.equals(this.getEventType())) {
                queryString.append(" AND ").append(this.queryStringForFromTime(this.getFromDate()));
            }
            if (!Utils.isEmpty(this.getState()) && this.getState().indexOf(":") > 0) {
                for (String state : this.getState().split(":")) {
                    queryString.append(" AND ").append("exo:eventState").append(" <> '").append(state).append("'");
                }
            }
            if (this.getOrderBy() != null && this.getOrderBy().length > 0) {
                queryString.append(" ORDER BY ").append(this.getOrderBy()[0]);
                if (!Utils.isEmpty(this.getOrderType())) {
                    queryString.append(" ").append(this.getOrderType().toUpperCase());
                }
            }
        }
        return queryString.toString();
    }

    public static List<String> parse(String input) {
        LinkedList<String> terms = new LinkedList<String>();
        Matcher matcher = Pattern.compile("\"([^\"]+)\"").matcher(input);
        while (matcher.find()) {
            String founds = matcher.group(1);
            terms.add(founds);
        }
        String remain = matcher.replaceAll("").replaceAll("\"\"", "").trim();
        if (!remain.isEmpty()) {
            terms.addAll(Arrays.asList(remain.split("\\s+")));
        }
        return terms;
    }

    private static String repeat(String format, Collection<String> strArr, String delimiter) {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String str : strArr) {
            sb.append(delim).append(String.format(format, str));
            delim = delimiter;
        }
        return sb.toString();
    }

    private String queryStringForFromTime(Calendar cal) {
        StringBuilder sb = new StringBuilder("(");
        sb.append("exo:toDateTime").append(" >= TIMESTAMP '").append(ISO8601.format((Calendar)cal)).append("'");
        sb.append(" OR ").append("(");
        sb.append("exo:repeat").append(" <> '").append(CalendarEvent.RP_NOREPEAT).append("'");
        sb.append(" AND ").append("(");
        sb.append("exo:repeatFinishDate").append(" >= TIMESTAMP '").append(ISO8601.format((Calendar)cal)).append("'");
        sb.append(" OR ");
        sb.append("exo:repeatFinishDate").append(" IS ").append("NULL");
        sb.append(")))");
        return sb.toString();
    }
}

