/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.util.Arrays;
import java.util.LinkedList;
import javax.jcr.NodeIterator;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.Invitation;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.jcr.impl.core.query.lucene.QueryResultImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class InvitationListAccess
implements ListAccess<Invitation> {
    private static Log log = ExoLogger.getLogger(InvitationListAccess.class);
    private EventDAOImpl evtDAO;
    private EventQuery query;
    private Integer size;

    public InvitationListAccess(EventDAOImpl evtDAO, EventQuery query) {
        this.evtDAO = evtDAO;
        this.query = query;
    }

    public int getSize() throws Exception {
        if (this.size == null) {
            log.debug((Object)"Querying to get Size");
            this.load(0, 0);
        }
        return this.size;
    }

    public Invitation[] load(int offset, int limit) throws Exception, IllegalArgumentException {
        try (SessionProvider provider = SessionProvider.createSystemProvider();){
            QueryImpl jcrQuery = this.evtDAO.createJCRQuery(provider, this.query.getQueryStatement(), this.query.getQueryType());
            if (limit > 0) {
                jcrQuery.setOffset((long)offset);
                jcrQuery.setLimit((long)limit);
            }
            QueryResultImpl queryResult = (QueryResultImpl)jcrQuery.execute();
            NodeIterator events = queryResult.getNodes();
            this.size = queryResult.getTotalSize();
            LinkedList<Invitation> invitations = new LinkedList<Invitation>();
            Object[] calIds = this.query.getCalendarId() == null ? new String[]{} : this.query.getCalendarId();
            Arrays.sort(calIds);
            Object[] pars = this.query.getParticipants() == null ? new String[]{} : this.query.getParticipants();
            Arrays.sort(pars);
            while (events.hasNext()) {
                CalendarEvent event = this.evtDAO.storage.getEventById(events.nextNode().getProperty("exo:id").getString());
                if (Arrays.binarySearch(calIds, event.getCalendarId()) >= 0) {
                    invitations.addAll(Arrays.asList(event.getInvitations()));
                    continue;
                }
                for (Invitation ivt : event.getInvitations()) {
                    if (Arrays.binarySearch(pars, ivt.getParticipant()) < 0) continue;
                    invitations.add(ivt);
                }
            }
            Invitation[] invitationArray = invitations.toArray(new Invitation[invitations.size()]);
            return invitationArray;
        }
    }
}

