/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.impl;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.HashedMap;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.EventDAOImpl;
import org.exoplatform.calendar.service.impl.EventSearchListAccess;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.commons.api.search.SearchServiceConnector;
import org.exoplatform.commons.api.search.data.SearchContext;
import org.exoplatform.commons.api.search.data.SearchResult;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.controller.QualifiedName;
import org.exoplatform.web.controller.router.Router;

public class CalendarSearchServiceConnector
extends SearchServiceConnector {
    private CalendarService calendarService_;
    private SpaceService spaceService_;
    private static final Log log = ExoLogger.getLogger(CalendarSearchServiceConnector.class);
    private ThreadLocal<Map<String, Calendar>> calendarMap = new ThreadLocal();

    public CalendarSearchServiceConnector(InitParams initParams) {
        super(initParams);
        this.calendarService_ = (CalendarService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(CalendarServiceImpl.class);
        this.spaceService_ = (SpaceService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(SpaceService.class);
    }

    public Collection<SearchResult> search(SearchContext context, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        return this.searchData(context, null, query, sites, offset, limit, sort, order);
    }

    protected Collection<SearchResult> searchData(SearchContext context, String dataType, String query, Collection<String> sites, int offset, int limit, String sort, String order) {
        List<SearchResult> events;
        block9: {
            events = new ArrayList<SearchResult>();
            if (Utils.isEmpty(query)) {
                return events;
            }
            OrganizationService orgService = (OrganizationService)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(OrganizationService.class);
            HashSet<String> readOnlyCalendars = new HashSet<String>();
            try {
                List<GroupCalendarData> groupCalendar;
                this.getCalendarMap().clear();
                Identity currentUser = ConversationState.getCurrent().getIdentity();
                String userId = currentUser.getUserId();
                LinkedList<String> uCals = new LinkedList<String>();
                List<Calendar> privateCalendars = this.calendarService_.getUserCalendars(userId, true);
                for (Calendar cal : privateCalendars) {
                    this.getCalendarMap().put(cal.getId(), cal);
                    uCals.add(cal.getId());
                }
                LinkedList<String> sCals = new LinkedList<String>();
                GroupCalendarData sharedCalendar = this.calendarService_.getSharedCalendars(userId, true);
                if (sharedCalendar != null) {
                    List<Calendar> shareCalendars = sharedCalendar.getCalendars();
                    for (Calendar cal : shareCalendars) {
                        this.getCalendarMap().put(cal.getId(), cal);
                        sCals.add(cal.getId());
                        if (Utils.hasPermission(orgService, cal.getEditPermission(), userId)) continue;
                        readOnlyCalendars.add(cal.getId());
                    }
                }
                LinkedList<String> gCals = new LinkedList<String>();
                Set groupIds = currentUser.getGroups();
                if (!groupIds.isEmpty() && (groupCalendar = this.calendarService_.getGroupCalendars(groupIds.toArray(new String[groupIds.size()]), true, userId)) != null) {
                    ArrayList<Calendar> spaceCalendars = new ArrayList<Calendar>();
                    for (GroupCalendarData gCal : groupCalendar) {
                        if (gCal.getCalendars() == null) continue;
                        spaceCalendars.addAll(gCal.getCalendars());
                    }
                    for (Calendar cal : spaceCalendars) {
                        this.getCalendarMap().put(cal.getId(), cal);
                        gCals.add(cal.getId());
                        if (Utils.hasPermission(orgService, cal.getEditPermission(), userId)) continue;
                        readOnlyCalendars.add(cal.getId());
                    }
                }
                LinkedList<String> calIds = new LinkedList<String>();
                calIds.addAll(uCals);
                calIds.addAll(gCals);
                calIds.addAll(sCals);
                EventQuery uEventQuery = this.createQuery(dataType, query, sort, order, calIds.toArray(new String[calIds.size()]), readOnlyCalendars);
                EventSearchListAccess listAccess = new EventSearchListAccess((EventDAOImpl)this.calendarService_.getEventDAO(), uEventQuery);
                events = listAccess.load(offset, limit, context, sites, dataType);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug((Object)("Could not execute unified seach " + dataType), (Throwable)e);
            }
        }
        return events;
    }

    private EventQuery createQuery(String dataType, String queryText, String sort, String order, String[] calendarIds, Set<String> excludePrivateEventInCalendars) throws Exception {
        UnifiedQuery eventQuery = new UnifiedQuery();
        eventQuery.setExcludePrivateEventInCalendars(excludePrivateEventInCalendars);
        java.util.Calendar today = java.util.Calendar.getInstance();
        eventQuery.setFromDate(today);
        eventQuery.setQueryType("sql");
        eventQuery.setEventType(dataType);
        eventQuery.setText(queryText);
        String sortBy = Utils.SORT_FIELD_MAP.get(sort);
        if (Utils.ORDERBY_DATE.equals(sortBy)) {
            sortBy = CalendarEvent.TYPE_EVENT.equals(dataType) ? "exo:fromDateTime" : "exo:toDateTime";
        }
        eventQuery.setOrderBy(new String[]{sortBy});
        eventQuery.setOrderType(order);
        if (CalendarEvent.TYPE_TASK.equals(dataType)) {
            eventQuery.setState(CalendarEvent.COMPLETED + ":" + CalendarEvent.CANCELLED);
        }
        eventQuery.setCalendarId(calendarIds);
        return eventQuery;
    }

    public String getUrl(Router router, String handler, String siteName, String spaceGroupId, String pageName) {
        HashedMap qualifiedName = new HashedMap();
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"handler"), (Object)handler);
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)pageName);
        qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"lang"), (Object)"");
        if (Utils.isEmpty(spaceGroupId)) {
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)siteName);
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.PORTAL.getName());
        } else {
            Space sp;
            String groupId = spaceGroupId.split("/")[2];
            if (this.spaceService_ != null && (sp = this.spaceService_.getSpaceByGroupId(spaceGroupId)) != null) {
                groupId = sp.getPrettyName();
            }
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitename"), (Object)spaceGroupId.replaceAll("/", ":"));
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"sitetype"), (Object)SiteType.GROUP.getName());
            qualifiedName.put((Object)QualifiedName.create((String)"gtn", (String)"path"), (Object)(groupId + "/" + pageName));
        }
        try {
            return "/" + handler + URLDecoder.decode(router.render((Map)qualifiedName), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private Map<String, Calendar> getCalendarMap() {
        Map<String, Calendar> map = this.calendarMap.get();
        if (map == null) {
            map = new HashMap<String, Calendar>();
            this.calendarMap.set(map);
        }
        return map;
    }
}

