/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarImportExport;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;

public class ImportExportTestCase
extends BaseCalendarServiceTestCase {
    public void testImportExportIcs() throws Exception {
        CalendarImportExport calIE = this.calendarService_.getCalendarImportExports("ICalendar(.ics)");
        String calendarId = this.createPrivateCalendar(this.username, "IcsCalendar", "abcd").getId();
        InputStream icalInputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ObmCalendar_isolated.ics");
        InputStream icalInputStream2 = Thread.currentThread().getContextClassLoader().getResourceAsStream("ObmCalendar_isolated_p2.ics");
        InputStream icalInputStream3 = Thread.currentThread().getContextClassLoader().getResourceAsStream("ObmCalendar_isolated_p3.ics");
        InputStream icalInputStream4 = Thread.currentThread().getContextClassLoader().getResourceAsStream("nonstandard.ics");
        InputStream icalInputStream5 = Thread.currentThread().getContextClassLoader().getResourceAsStream("png_attachment.ics");
        calIE.importCalendar(this.username, icalInputStream, calendarId, calendarId, null, null, false);
        calIE.importCalendar(this.username, icalInputStream2, calendarId, calendarId, null, null, false);
        calIE.importCalendar(this.username, icalInputStream3, calendarId, calendarId, null, null, false);
        calIE.importCalendar(this.username, icalInputStream4, calendarId, calendarId, null, null, false);
        calIE.importCalendar(this.username, icalInputStream5, calendarId, calendarId, null, null, false);
        ArrayList<String> calendarIds = new ArrayList<String>();
        calendarIds.add(calendarId);
        List events = this.calendarService_.getUserEventByCalendar(this.username, calendarIds);
        ImportExportTestCase.assertEquals((int)5, (int)events.size());
        CalendarEvent event = (CalendarEvent)events.get(0);
        ImportExportTestCase.assertEquals((String)CalendarEvent.PRIORITY[1], (String)event.getPriority());
        CalendarEvent event2 = (CalendarEvent)events.get(1);
        ImportExportTestCase.assertEquals((String)CalendarEvent.PRIORITY[2], (String)event2.getPriority());
        CalendarEvent event3 = (CalendarEvent)events.get(2);
        ImportExportTestCase.assertEquals((String)CalendarEvent.PRIORITY[3], (String)event3.getPriority());
        ImportExportTestCase.assertNotNull((Object)event.getFromDateTime());
        ImportExportTestCase.assertNotNull((Object)event.getToDateTime());
        ImportExportTestCase.assertNotNull((Object)event.getSummary());
        OutputStream icalOutputStream = calIE.exportEventCalendar(this.username, calendarId, CalendarImportExport.PRIVATE_TYPE, event.getId());
        ImportExportTestCase.assertNotNull((Object)icalOutputStream);
        icalOutputStream.close();
        icalOutputStream = calIE.exportCalendar(this.username, calendarIds, CalendarImportExport.PRIVATE_TYPE, 3);
        ImportExportTestCase.assertNotNull((Object)icalOutputStream);
        icalOutputStream.close();
        icalInputStream.close();
    }

    public void testImportCSVFile() throws Exception {
        CalendarImportExport calIE = this.calendarService_.getCalendarImportExports("ExportedCsv(.csv)");
        String calendarId = this.createPrivateCalendar(this.username, "CSVCalendar", "abcd").getId();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("sunbird_calendar.csv");
        calIE.importCalendar(this.username, in, calendarId, calendarId, null, null, false);
        ArrayList<String> calendarIds = new ArrayList<String>();
        calendarIds.add(calendarId);
        List events = this.calendarService_.getUserEventByCalendar(this.username, calendarIds);
        ImportExportTestCase.assertEquals((int)3, (int)events.size());
    }
}

