/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.GroupHandler;
import org.exoplatform.services.organization.OrganizationService;

public class TestNewGroupListener
extends BaseCalendarServiceTestCase {
    private CalendarService calendarService;
    private OrganizationService organizationService;
    private String username = "root";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.calendarService = this.getService(CalendarService.class);
        this.organizationService = this.getService(OrganizationService.class);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    public void testCreateNewGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupA");
        group.setLabel("label for group A");
        groupHandler.addChild(null, group, true);
        TestNewGroupListener.assertNotNull((Object)groupHandler.findGroupById("/groupA"));
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/groupA"}, true, this.username);
        TestNewGroupListener.assertEquals((int)1, (int)calendars.size());
        GroupCalendarData data = (GroupCalendarData)calendars.get(0);
        TestNewGroupListener.assertEquals((String)"/groupA", (String)data.getName());
        List cs = data.getCalendars();
        TestNewGroupListener.assertEquals((int)1, (int)cs.size());
        Calendar c = (Calendar)cs.get(0);
        TestNewGroupListener.assertEquals((String)"label for group A", (String)c.getName());
        TestNewGroupListener.assertEquals((String)"Europe/Brussels", (String)c.getTimeZone());
        TestNewGroupListener.assertEquals((String)"BEL", (String)c.getLocale());
        TestNewGroupListener.assertEquals((int)1, (int)c.getViewPermission().length);
        TestNewGroupListener.assertEquals((String)"*.*", (String)c.getViewPermission()[0]);
        TestNewGroupListener.assertEquals((int)1, (int)c.getEditPermission().length);
        TestNewGroupListener.assertEquals((String)"/groupA/:*.*", (String)c.getEditPermission()[0]);
        TestNewGroupListener.assertEquals((int)1, (int)c.getGroups().length);
        TestNewGroupListener.assertEquals((String)"/groupA", (String)c.getGroups()[0]);
    }

    public void testCreateNewChildGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group plf = groupHandler.findGroupById("/platform");
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupB");
        group.setLabel("label for groupB");
        groupHandler.addChild(plf, group, true);
        TestNewGroupListener.assertNotNull((Object)groupHandler.findGroupById("/groupB"));
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/platform/groupB"}, true, this.username);
        TestNewGroupListener.assertEquals((int)1, (int)calendars.size());
        GroupCalendarData data = (GroupCalendarData)calendars.get(0);
        TestNewGroupListener.assertEquals((String)"/platform/groupB", (String)data.getName());
        List cs = data.getCalendars();
        TestNewGroupListener.assertEquals((int)1, (int)cs.size());
        Calendar c = (Calendar)cs.get(0);
        TestNewGroupListener.assertEquals((String)"label for groupB", (String)c.getName());
        TestNewGroupListener.assertEquals((String)"Europe/Brussels", (String)c.getTimeZone());
        TestNewGroupListener.assertEquals((String)"BEL", (String)c.getLocale());
        TestNewGroupListener.assertEquals((int)1, (int)c.getViewPermission().length);
        TestNewGroupListener.assertEquals((String)"*.*", (String)c.getViewPermission()[0]);
        TestNewGroupListener.assertEquals((int)1, (int)c.getEditPermission().length);
        TestNewGroupListener.assertEquals((String)"/platform/groupB/:*.*", (String)c.getEditPermission()[0]);
        TestNewGroupListener.assertEquals((int)1, (int)c.getGroups().length);
        TestNewGroupListener.assertEquals((String)"/platform/groupB", (String)c.getGroups()[0]);
    }

    public void testSilentCreateNewGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupSilent");
        group.setLabel("label for group groupSilent");
        groupHandler.addChild(null, group, false);
        TestNewGroupListener.assertNotNull((Object)groupHandler.findGroupById("/groupSilent"));
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/groupSilent"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)calendars.size());
    }

    public void testIgnoredGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("ignoreGroup");
        group.setLabel("label for group ignoreGroup");
        groupHandler.addChild(null, group, true);
        TestNewGroupListener.assertNotNull((Object)groupHandler.findGroupById("/ignoreGroup"));
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/ignoreGroup"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)calendars.size());
        Group plf = groupHandler.findGroupById("/platform");
        group = groupHandler.createGroupInstance();
        group.setGroupName("ignoreGroupChild");
        group.setLabel("label for group ignoreGroupChild");
        groupHandler.addChild(plf, group, true);
        TestNewGroupListener.assertNotNull((Object)groupHandler.findGroupById("/ignoreGroupChild"));
        calendars = this.calendarService.getGroupCalendars(new String[]{"/platform/ignoreGroupChild"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)calendars.size());
    }

    public void testIgnoreAllDescendant() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("ignoreAllDescendant");
        group.setLabel("label for group ignoreAllDescendant");
        groupHandler.addChild(null, group, true);
        Group parent = groupHandler.findGroupById("/ignoreAllDescendant");
        TestNewGroupListener.assertNotNull((Object)parent);
        List calendars = this.calendarService.getGroupCalendars(new String[]{"/ignoreAllDescendant"}, true, this.username);
        TestNewGroupListener.assertEquals((int)1, (int)calendars.size());
        group = groupHandler.createGroupInstance();
        group.setGroupName("firstLevelChild");
        group.setLabel("label for group firstLevelChild");
        groupHandler.addChild(parent, group, true);
        Group firstLevelChild = groupHandler.findGroupById("/ignoreAllDescendant/firstLevelChild");
        TestNewGroupListener.assertNotNull((Object)firstLevelChild);
        calendars = this.calendarService.getGroupCalendars(new String[]{"/ignoreAllDescendant/firstLevelChild"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)calendars.size());
        group = groupHandler.createGroupInstance();
        group.setGroupName("secondLevelChild");
        group.setLabel("label for group secondLevelChild");
        groupHandler.addChild(firstLevelChild, group, true);
        Group secondLevelChild = groupHandler.findGroupById("/ignoreAllDescendant/firstLevelChild/secondLevelChild");
        TestNewGroupListener.assertNotNull((Object)secondLevelChild);
        calendars = this.calendarService.getGroupCalendars(new String[]{"/ignoreAllDescendant/firstLevelChild/secondLevelChild"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)calendars.size());
    }

    public void testDeleteGroup() throws Exception {
        GroupHandler groupHandler = this.organizationService.getGroupHandler();
        Group group = groupHandler.createGroupInstance();
        group.setGroupName("groupWillBeDeleted");
        group.setLabel("label for group groupWillBeDeleted");
        groupHandler.addChild(null, group, true);
        Group groupWillBeDeleted = groupHandler.findGroupById("/groupWillBeDeleted");
        TestNewGroupListener.assertNotNull((Object)groupWillBeDeleted);
        List data = this.calendarService.getGroupCalendars(new String[]{"/groupWillBeDeleted"}, true, this.username);
        TestNewGroupListener.assertEquals((int)1, (int)data.size());
        List calendars = ((GroupCalendarData)data.get(0)).getCalendars();
        TestNewGroupListener.assertEquals((int)1, (int)calendars.size());
        Calendar calendar = (Calendar)calendars.get(0);
        String calendarId = calendar.getId();
        TestNewGroupListener.assertNotNull((Object)this.calendarService.getCalendarById(calendarId));
        groupHandler.removeGroup(groupWillBeDeleted, true);
        TestNewGroupListener.assertNull((Object)groupHandler.findGroupById("/groupWillBeDeleted"));
        data = this.calendarService.getGroupCalendars(new String[]{"/groupWillBeDeleted"}, true, this.username);
        TestNewGroupListener.assertEquals((int)0, (int)data.size());
        TestNewGroupListener.assertNull((Object)this.calendarService.getCalendarById(calendarId));
    }
}

