/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchServiceConnector;
import org.exoplatform.calendar.service.impl.CalendarServiceImpl;
import org.exoplatform.calendar.service.impl.JCRDataStorage;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;
import org.exoplatform.commons.utils.DateUtils;

public class RecurringEventTestCase
extends BaseCalendarServiceTestCase {
    private JCRDataStorage storage_;
    private CalendarSearchServiceConnector unifiedSearchService_;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.unifiedSearchService_ = this.getService(CalendarSearchServiceConnector.class);
        this.storage_ = ((CalendarServiceImpl)this.calendarService_).getDataStorage();
    }

    public void testRemoveOccurrenceEvent() throws Exception {
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        List original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)5, (int)occMap.size());
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        fromCal.add(5, 1);
        String recurenceId1 = sf.format(fromCal.getTime());
        fromCal.add(5, 2);
        String recurrenceId2 = sf.format(fromCal.getTime());
        CalendarEvent occEvent1 = (CalendarEvent)occMap.get(recurenceId1);
        CalendarEvent occEvent2 = (CalendarEvent)occMap.get(recurrenceId2);
        occEvent2.setDescription("newException");
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occEvent2, this.username);
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occEvent2, this.username);
        List exceptionEvents = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)1, (int)exceptionEvents.size());
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        this.calendarService_.removeOneOccurrenceEvent(recurEvent, occEvent2, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        exceptionEvents = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        RecurringEventTestCase.assertEquals((int)0, (int)exceptionEvents.size());
        this.calendarService_.removeFollowingSeriesEvents(recurEvent, occEvent1, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        exceptionEvents = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)1, (int)occMap.size());
        RecurringEventTestCase.assertEquals((int)0, (int)exceptionEvents.size());
        this.calendarService_.removeAllSeriesEvents(recurEvent, this.username);
        RecurringEventTestCase.assertNull((Object)this.calendarService_.getEventById(recurEvent.getId()));
    }

    public void testSaveAllOccurrenceEvent() throws Exception {
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        List original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)5, (int)occMap.size());
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        fromCal.add(5, 2);
        String reocurenceId1 = sf.format(fromCal.getTime());
        CalendarEvent occEvent1 = (CalendarEvent)occMap.get(reocurenceId1);
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occEvent1, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        recurEvent.setSummary("change and update all");
        this.calendarService_.saveAllSeriesEvents(recurEvent, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
    }

    public void testSaveFollowingOccurrenceEvent() throws Exception {
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.setTime(recurEvent.getToDateTime());
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        List original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)5, (int)occMap.size());
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        fromCal.add(5, 1);
        String recurrenceId1 = sf.format(fromCal.getTime());
        fromCal.add(5, 2);
        String recurrenceId2 = sf.format(fromCal.getTime());
        CalendarEvent occEvent1 = (CalendarEvent)occMap.get(recurrenceId1);
        CalendarEvent occEvent2 = (CalendarEvent)occMap.get(recurrenceId2);
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occEvent2, this.username);
        List exceptions = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)1, (int)exceptions.size());
        this.calendarService_.saveFollowingSeriesEvents(recurEvent, occEvent1, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)1, (int)occMap.size());
        occMap = this.calendarService_.getOccurrenceEvents(occEvent1, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        exceptions = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)0, (int)exceptions.size());
    }

    public void testSaveFollowingOccurrenceEventWithChangeTime() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "testSaveFollowingOccurrenceEventWithChangeTime calendar", "description");
        String startTime = "05252015 10:00";
        String endTime = "05252015 11:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(end);
        to.add(5, 10);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("testSaveFollowingOccurrenceEventWithChangeTime event");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_DAILY);
        event.setRepeatInterval(1L);
        event.setRepeatCount(5L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        event = this.calendarService_.getEvent(this.username, event.getId());
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)5, (int)events.size());
        CalendarEvent occurence = (CalendarEvent)events.get("20150527T100000Z");
        RecurringEventTestCase.assertNotNull((Object)occurence);
        java.util.Calendar newFromCal = java.util.Calendar.getInstance(userTimezone);
        newFromCal.setTime(occurence.getFromDateTime());
        java.util.Calendar newToCal = java.util.Calendar.getInstance(userTimezone);
        newFromCal.setTime(occurence.getToDateTime());
        newFromCal.add(12, 30);
        newToCal.add(12, 30);
        occurence.setFromDateTime(newFromCal.getTime());
        occurence.setToDateTime(newToCal.getTime());
        this.calendarService_.saveFollowingSeriesEvents(event, occurence, this.username);
        event = this.calendarService_.getEvent(this.username, event.getId());
        occurence = this.calendarService_.getEvent(this.username, occurence.getId());
        events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)2, (int)events.size());
        events = this.calendarService_.getOccurrenceEvents(occurence, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)3, (int)events.size());
    }

    public void testSaveOneOccurrenceEvent() throws Exception {
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.setTime(recurEvent.getToDateTime());
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        List original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)5, (int)occMap.size());
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        String recurrenceId1 = sf.format(fromCal.getTime());
        CalendarEvent occEvent1 = (CalendarEvent)occMap.get(recurrenceId1);
        fromCal.add(5, 1);
        String recurrenceId2 = sf.format(fromCal.getTime());
        CalendarEvent occEvent2 = (CalendarEvent)occMap.get(recurrenceId2);
        List list = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)0, (int)list.size());
        occEvent1.setSummary("broken series event");
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occEvent1, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        list = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertNotNull((Object)list);
        RecurringEventTestCase.assertEquals((int)1, (int)list.size());
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        this.calendarService_.removeOneOccurrenceEvent(recurEvent, occEvent2, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)3, (int)occMap.size());
        this.calendarService_.removeOneOccurrenceEvent(recurEvent, occEvent1, this.username);
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        list = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)3, (int)occMap.size());
        RecurringEventTestCase.assertEquals((int)0, (int)list.size());
    }

    public void testGetRepetitiveEvent() throws Exception {
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.setTime(recurEvent.getToDateTime());
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        fromCal.add(5, 1);
        String recurrenceId = sf.format(fromCal.getTime());
        CalendarEvent occurrence = (CalendarEvent)occMap.get(recurrenceId);
        CalendarEvent expectedOrigin = this.calendarService_.getRepetitiveEvent(occurrence);
        RecurringEventTestCase.assertNotNull((Object)expectedOrigin);
        RecurringEventTestCase.assertEquals((String)recurEvent.getId(), (String)expectedOrigin.getId());
        occurrence.setSummary("I'm now an exception");
        this.calendarService_.saveOneOccurrenceEvent(recurEvent, occurrence, this.username);
        List exceptions = this.calendarService_.getExceptionEvents(this.username, recurEvent);
        RecurringEventTestCase.assertEquals((int)1, (int)exceptions.size());
        CalendarEvent exceptionEvent = (CalendarEvent)exceptions.iterator().next();
        RecurringEventTestCase.assertFalse((exceptionEvent.getId() == recurEvent.getId() ? 1 : 0) != 0);
        expectedOrigin = this.calendarService_.getRepetitiveEvent(exceptionEvent);
        RecurringEventTestCase.assertNotNull((Object)expectedOrigin);
        RecurringEventTestCase.assertEquals((String)recurEvent.getId(), (String)expectedOrigin.getId());
    }

    public void testGetOccurrenceEvents1() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.set(2013, 2, 7, 5, 30);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.set(2013, 2, 7, 6, 30);
        Calendar calendar = this.createPrivateCalendar(this.username, this.username, "unified search test");
        CalendarEvent recurEvent = new CalendarEvent();
        recurEvent.setSummary("repeated past");
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
        String[] days = new String[]{"TH"};
        recurEvent.setRepeatByDay(days);
        recurEvent.setRepeatUntilDate(null);
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        Utils.adaptRepeatRule((CalendarEvent)recurEvent, (TimeZone)this.tz, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), recurEvent, true);
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)1, (int)occMap.size());
        CalendarEvent occEvent = (CalendarEvent)occMap.get(occMap.keySet().iterator().next());
        java.util.Calendar occCal = java.util.Calendar.getInstance(this.tz);
        occCal.setTime(occEvent.getFromDateTime());
        RecurringEventTestCase.assertEquals((int)occCal.get(5), (int)7);
        RecurringEventTestCase.assertEquals((int)occCal.get(2), (int)2);
        RecurringEventTestCase.assertEquals((int)occCal.get(1), (int)2013);
        UnifiedQuery query = new UnifiedQuery();
        query.setQueryType("sql");
        query.setText("past");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection result = this.unifiedSearchService_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        RecurringEventTestCase.assertNotNull((Object)result);
        RecurringEventTestCase.assertEquals((int)1, (int)result.size());
    }

    public void testGetOccurrenceEvents2() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.set(2013, 2, 7, 22, 30);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.set(2013, 2, 7, 23, 30);
        CalendarEvent recurEvent = new CalendarEvent();
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
        String[] days = new String[]{"TH"};
        recurEvent.setRepeatByDay(days);
        recurEvent.setRepeatUntilDate(null);
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 24, 0, 0, 0);
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)3, (int)occMap.size());
        SimpleDateFormat format = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        format.setTimeZone(this.tz);
        RecurringEventTestCase.assertNotNull(occMap.get(format.format(fromCal.getTime())));
        fromCal.add(5, 7);
        RecurringEventTestCase.assertNotNull(occMap.get(format.format(fromCal.getTime())));
        fromCal.add(5, 7);
        RecurringEventTestCase.assertNotNull(occMap.get(format.format(fromCal.getTime())));
    }

    public void testGetOccurrenceEvents3() throws Exception {
        CalendarEvent recurEvent = this.createRepetitiveEventForTest();
        Calendar calendar = this.calendarService_.getCalendarById(recurEvent.getCalendarId());
        java.util.Calendar from = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar to = java.util.Calendar.getInstance(this.tz);
        from.set(2013, 2, 1, 0, 0, 0);
        to.set(2013, 2, 12, 0, 0, 0);
        List original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        Map occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)5, (int)occMap.size());
        SimpleDateFormat sf = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        sf.setTimeZone(this.tz);
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.setTime(recurEvent.getFromDateTime());
        String reocurenceId1 = sf.format(fromCal.getTime());
        CalendarEvent occEvent1 = (CalendarEvent)occMap.get(reocurenceId1);
        java.util.Calendar occCal = java.util.Calendar.getInstance(this.tz);
        occCal.setTime(occEvent1.getFromDateTime());
        RecurringEventTestCase.assertEquals((int)occCal.get(5), (int)7);
        RecurringEventTestCase.assertEquals((int)occCal.get(2), (int)2);
        RecurringEventTestCase.assertEquals((int)occCal.get(1), (int)2013);
        fromCal.add(5, 1);
        String reocurenceId2 = sf.format(fromCal.getTime());
        CalendarEvent occEvent2 = (CalendarEvent)occMap.get(reocurenceId2);
        occCal = java.util.Calendar.getInstance(this.tz);
        occCal.setTime(occEvent2.getFromDateTime());
        RecurringEventTestCase.assertEquals((int)occCal.get(5), (int)8);
        RecurringEventTestCase.assertEquals((int)occCal.get(2), (int)2);
        RecurringEventTestCase.assertEquals((int)occCal.get(1), (int)2013);
        ArrayList<CalendarEvent> listEvent = new ArrayList<CalendarEvent>();
        occEvent1.setIsExceptionOccurrence(Boolean.valueOf(true));
        occEvent1.setSummary("broken series event");
        occEvent1.setRecurrenceId(reocurenceId1);
        listEvent.add(occEvent1);
        calendar.setEditPermission(new String[]{"john", this.username});
        this.calendarService_.saveUserCalendar(this.username, calendar, false);
        this.calendarService_.shareCalendar(this.username, calendar.getId(), Arrays.asList("john"));
        this.login("john");
        this.calendarService_.updateOccurrenceEvent(calendar.getId(), calendar.getId(), String.valueOf(1), String.valueOf(1), listEvent, "john");
        recurEvent.setExcludeId(new String[]{reocurenceId1});
        this.calendarService_.saveEventToSharedCalendar("john", calendar.getId(), recurEvent, false);
        original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)4, (int)occMap.size());
        listEvent = new ArrayList();
        occEvent2.setSummary("broken series event 2");
        occEvent2.setIsExceptionOccurrence(Boolean.valueOf(true));
        occEvent2.setRecurrenceId(reocurenceId2);
        listEvent.add(occEvent2);
        this.calendarService_.updateOccurrenceEvent(calendar.getId(), calendar.getId(), String.valueOf(1), String.valueOf(1), listEvent, "john");
        recurEvent.setExcludeId(new String[]{reocurenceId1, reocurenceId2});
        this.calendarService_.saveEventToSharedCalendar("john", calendar.getId(), recurEvent, false);
        original = this.calendarService_.getOriginalRecurrenceEvents(this.username, from, to, null);
        RecurringEventTestCase.assertEquals((int)1, (int)original.size());
        occMap = this.calendarService_.getOccurrenceEvents(recurEvent, from, to, this.timeZone);
        RecurringEventTestCase.assertEquals((int)3, (int)occMap.size());
    }

    public void testUpdateRecurrenceSeries() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        Calendar publicCalendar = this.createGroupCalendar(this.userGroups, "publicCalendar", "publicDescription");
        EventCategory eventCategory = this.createUserEventCategory(this.username, "eventCategoryName0");
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.add(10, 1);
        java.util.Calendar repeatUntilDate = java.util.Calendar.getInstance(this.tz);
        repeatUntilDate.add(5, 5);
        CalendarEvent userEvent = new CalendarEvent();
        userEvent.setSummary("Have a meeting");
        userEvent.setFromDateTime(fromCal.getTime());
        userEvent.setToDateTime(toCal.getTime());
        userEvent.setCalendarId(calendar.getId());
        userEvent.setEventCategoryId(eventCategory.getId());
        userEvent.setRepeatType(CalendarEvent.RP_DAILY);
        userEvent.setRepeatInterval(2L);
        userEvent.setRepeatCount(3L);
        userEvent.setRepeatUntilDate(repeatUntilDate.getTime());
        userEvent.setRepeatByDay(null);
        userEvent.setRepeatByMonthDay(new long[]{2L, 3L, 4L, 5L, 7L});
        this.storage_.saveOccurrenceEvent(this.username, calendar.getId(), userEvent, true);
        this.storage_.getOccurrenceEvents(userEvent, fromCal, toCal, this.timeZone);
        ArrayList<CalendarEvent> listEvent = new ArrayList<CalendarEvent>();
        listEvent.add(userEvent);
        this.storage_.updateOccurrenceEvent(calendar.getId(), publicCalendar.getId(), String.valueOf(0), String.valueOf(2), listEvent, this.username);
    }

    public void testCalculateRecurrenceFinishDate() throws Exception {
        TimeZone timeZone = DateUtils.getTimeZone((String)"GMT");
        java.util.Calendar fromCal = java.util.Calendar.getInstance(timeZone);
        fromCal.set(2011, 6, 20, 5, 30);
        java.util.Calendar toCal = java.util.Calendar.getInstance(timeZone);
        toCal.set(2011, 6, 25, 5, 30);
        CalendarEvent userEvent = new CalendarEvent();
        userEvent.setFromDateTime(fromCal.getTime());
        userEvent.setToDateTime(toCal.getTime());
        userEvent.setRepeatType(CalendarEvent.RP_DAILY);
        userEvent.setRepeatInterval(2L);
        userEvent.setRepeatCount(3L);
        userEvent.setRepeatUntilDate(null);
        userEvent.setRepeatByDay(null);
        userEvent.setRepeatByMonthDay(new long[]{2L, 3L, 4L, 5L, 7L});
        Date date = this.storage_.calculateRecurrenceFinishDate(userEvent);
        java.util.Calendar calendar = java.util.Calendar.getInstance(timeZone);
        calendar.setTime(date);
        RecurringEventTestCase.assertEquals((int)2011, (int)calendar.get(1));
        RecurringEventTestCase.assertEquals((int)6, (int)calendar.get(2));
        RecurringEventTestCase.assertEquals((int)25, (int)calendar.get(5));
        RecurringEventTestCase.assertEquals((int)0, (int)calendar.get(10));
        RecurringEventTestCase.assertEquals((int)0, (int)calendar.get(12));
    }

    public void testGetPreviousOccurence() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.set(2013, 2, 7, 22, 30);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.set(2013, 2, 7, 23, 30);
        CalendarEvent recurEvent = new CalendarEvent();
        recurEvent.setSummary("test previous");
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatType(CalendarEvent.RP_DAILY);
        recurEvent.setRepeatInterval(1L);
        recurEvent.setRepeatCount(6L);
        recurEvent.setRepeatUntilDate(null);
        java.util.Calendar calendar = java.util.Calendar.getInstance(this.tz);
        calendar.set(2013, 2, 10, 22, 30);
        Date expectedDate = Utils.getPreviousOccurrenceDate((CalendarEvent)recurEvent, (Date)calendar.getTime(), (TimeZone)this.tz);
        calendar.setTime(expectedDate);
        RecurringEventTestCase.assertEquals((int)9, (int)calendar.get(5));
        fromCal.set(2013, 8, 10, 22, 30);
        toCal.set(2013, 8, 10, 23, 30);
        recurEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatCount(-1L);
        recurEvent.setRepeatInterval(1L);
        recurEvent.setRepeatByDay(new String[]{"TU"});
        calendar.set(2013, 8, 24, 22, 30);
        expectedDate = Utils.getPreviousOccurrenceDate((CalendarEvent)recurEvent, (Date)calendar.getTime(), (TimeZone)this.tz);
        calendar.setTime(expectedDate);
        RecurringEventTestCase.assertEquals((int)17, (int)calendar.get(5));
    }

    public void testGetPreviousOccurrence2() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.set(2013, 8, 11, 19, 0);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.set(2013, 8, 11, 22, 30);
        CalendarEvent recurEvent = new CalendarEvent();
        recurEvent.setSummary("test previous");
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatType(CalendarEvent.RP_WEEKLY);
        recurEvent.setRepeatInterval(1L);
        recurEvent.setRepeatCount(-1L);
        recurEvent.setRepeatByDay(new String[]{"WE"});
        recurEvent.setRepeatUntilDate(null);
        java.util.Calendar calendar = java.util.Calendar.getInstance(this.tz);
        calendar.set(2013, 8, 25, 19, 0);
        Date expectedDate = Utils.getPreviousOccurrenceDate((CalendarEvent)recurEvent, (Date)calendar.getTime(), (TimeZone)this.tz);
        calendar.setTime(expectedDate);
        RecurringEventTestCase.assertEquals((int)18, (int)calendar.get(5));
    }

    public void tes1tRecurringEventStartFromToday() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        String originUserTimezone = setting.getTimeZone();
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Europe/Brussels");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(11, 1);
        from.set(12, 0);
        from.set(13, 0);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(from.getTime());
        to.add(11, 1);
        String startTime = this.formatDate(setting, from.getTime());
        String endTime = this.formatDate(setting, to.getTime());
        Date fromDate = this.getDate(setting, startTime);
        Date toDate = this.getDate(setting, endTime);
        java.util.Calendar fromCalendar = java.util.Calendar.getInstance(userTimezone);
        fromCalendar.setTime(fromDate);
        Calendar cal = this.createPrivateCalendar(this.username, "testRecurringEventStartFromToday", "testRecurringEventStartFromToday");
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test previous");
        event.setFromDateTime(fromDate);
        event.setToDateTime(toDate);
        event.setRepeatType(CalendarEvent.RP_DAILY);
        event.setRepeatInterval(1L);
        event.setRepeatCount(10L);
        event.setRepeatByDay(null);
        event.setRepeatUntilDate(null);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), event, true);
        from.setTimeZone(userTimezone);
        from.add(5, -2);
        to.setTimeZone(userTimezone);
        to.add(5, 20);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        Set<String> keys = events.keySet();
        RecurringEventTestCase.assertEquals((int)10, (int)keys.size());
        SimpleDateFormat format = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        format.setCalendar(fromCalendar);
        from = (java.util.Calendar)fromCalendar.clone();
        for (int i = 0; i < 10; ++i) {
            this.assertContain(format.format(from.getTime()), keys);
            from.add(11, 1);
            this.assertNotContain(format.format(from.getTime()), keys);
            from.add(11, -2);
            this.assertNotContain(format.format(from.getTime()), keys);
            from.add(11, 1);
            from.add(6, 1);
        }
        this.calendarService_.removeAllSeriesEvents(event, this.username);
        setting.setTimeZone(originUserTimezone);
        this.calendarService_.saveCalendarSetting(this.username, setting);
    }

    public void tes1tRecurringEventStartFromYesterday() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        String originUserTimezone = setting.getTimeZone();
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Europe/Brussels");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.add(5, -1);
        from.add(11, 1);
        from.set(12, 0);
        from.set(13, 0);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(from.getTime());
        to.add(11, 1);
        String startTime = this.formatDate(setting, from.getTime());
        String endTime = this.formatDate(setting, to.getTime());
        Date fromDate = this.getDate(setting, startTime);
        Date toDate = this.getDate(setting, endTime);
        java.util.Calendar fromCalendar = java.util.Calendar.getInstance(userTimezone);
        fromCalendar.setTime(fromDate);
        Calendar cal = this.createPrivateCalendar(this.username, "testRecurringEventStartFromYesterday", "testRecurringEventStartFromYesterday");
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test previous");
        event.setFromDateTime(fromDate);
        event.setToDateTime(toDate);
        event.setRepeatType(CalendarEvent.RP_DAILY);
        event.setRepeatInterval(1L);
        event.setRepeatCount(10L);
        event.setRepeatByDay(null);
        event.setRepeatUntilDate(null);
        this.calendarService_.saveUserEvent(this.username, cal.getId(), event, true);
        from.setTimeZone(userTimezone);
        from.add(5, -2);
        to.setTimeZone(userTimezone);
        to.add(5, 20);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        Set<String> keys = events.keySet();
        RecurringEventTestCase.assertEquals((int)10, (int)keys.size());
        SimpleDateFormat format = new SimpleDateFormat(Utils.DATE_FORMAT_RECUR_ID);
        format.setCalendar(fromCalendar);
        from = (java.util.Calendar)fromCalendar.clone();
        for (int i = 0; i < 10; ++i) {
            this.assertContain(format.format(from.getTime()), keys);
            from.add(11, 1);
            this.assertNotContain(format.format(from.getTime()), keys);
            from.add(11, -2);
            this.assertNotContain(format.format(from.getTime()), keys);
            from.add(11, 1);
            from.add(6, 1);
        }
        this.calendarService_.removeAllSeriesEvents(event, this.username);
        setting.setTimeZone(originUserTimezone);
        this.calendarService_.saveCalendarSetting(this.username, setting);
    }

    public void testRecurringWithTimezoneChange() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "test recurring calendar", "description");
        String startTime = "10202014 10:00";
        String endTime = "10202014 11:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTimeZone(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(end);
        to.setTimeZone(userTimezone);
        to.add(2, 2);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test recurring");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_WEEKLY);
        event.setRepeatInterval(1L);
        event.setRepeatByDay(new String[]{"MO", "TU", "WE", "TH"});
        event.setRepeatCount(10L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)10, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertContain("20141020T100000Z", keys);
        this.assertContain("20141021T100000Z", keys);
        this.assertContain("20141022T100000Z", keys);
        this.assertContain("20141023T100000Z", keys);
        setting.setTimeZone("US/Mountain");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        userTimezone = TimeZone.getTimeZone(setting.getTimeZone());
        from = java.util.Calendar.getInstance();
        from.setTimeZone(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        to = java.util.Calendar.getInstance();
        to.setTimeZone(userTimezone);
        to.setTime(end);
        to.add(2, 2);
        events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)10, (int)events.size());
        keys = events.keySet();
        this.assertContain("20141019T210000Z", keys);
        this.assertContain("20141020T210000Z", keys);
        this.assertContain("20141021T210000Z", keys);
        this.assertContain("20141022T210000Z", keys);
    }

    public void testCreateRecurringEvent() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "test recurring calendar", "description");
        String startTime = "10222014 10:00";
        String endTime = "10222014 11:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTimeZone(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(end);
        to.setTimeZone(userTimezone);
        to.add(2, 2);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test recurring");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_WEEKLY);
        event.setRepeatInterval(1L);
        event.setRepeatByDay(new String[]{"MO", "TU", "WE", "TH", "FR"});
        event.setRepeatCount(10L);
        event.setRepeatUntilDate(null);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)10, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertNotContain("20141020T100000Z", keys);
        this.assertNotContain("20141021T100000Z", keys);
        this.assertContain("20141022T100000Z", keys);
        this.assertContain("20141023T100000Z", keys);
        this.assertContain("20141024T100000Z", keys);
        this.assertNotContain("20141025T100000Z", keys);
        this.assertNotContain("20141026T100000Z", keys);
    }

    public void testCreateEventAndRecurringFromNextDay() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "test recurring calendar", "description");
        String startTime = "10222014 10:00";
        String endTime = "10222014 11:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTimeZone(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(end);
        to.setTimeZone(userTimezone);
        to.add(2, 2);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test recurring");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_WEEKLY);
        event.setRepeatInterval(1L);
        event.setRepeatByDay(new String[]{"TH", "FR"});
        event.setRepeatCount(10L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)10, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertNotContain("20141020T100000Z", keys);
        this.assertNotContain("20141021T100000Z", keys);
        this.assertNotContain("20141022T100000Z", keys);
        this.assertContain("20141023T100000Z", keys);
        this.assertContain("20141024T100000Z", keys);
        this.assertNotContain("20141025T100000Z", keys);
        this.assertNotContain("20141026T100000Z", keys);
    }

    public void testCreateRecurringEventStartAtSunday() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "test recurring calendar", "description");
        String startTime = "10192014 10:00";
        String endTime = "10192014 11:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance();
        from.setTimeZone(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance();
        to.setTime(end);
        to.setTimeZone(userTimezone);
        to.add(2, 2);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test recurring");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_WEEKLY);
        event.setRepeatInterval(1L);
        event.setRepeatByDay(new String[]{"MO", "SU"});
        event.setRepeatCount(10L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        RecurringEventTestCase.assertEquals((int)10, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertNotContain("20141017T100000Z", keys);
        this.assertNotContain("20141018T100000Z", keys);
        this.assertContain("20141019T100000Z", keys);
        this.assertContain("20141020T100000Z", keys);
        this.assertNotContain("20141021T100000Z", keys);
        this.assertContain("20141026T100000Z", keys);
        this.assertContain("20141027T100000Z", keys);
    }

    public void testEventRecurringMonthlyByDayOfWeek() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        String oldTimeZone = setting.getTimeZone();
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "calendar for testing monthly recurring", "description");
        String startTime = "03092015 03:00";
        String endTime = "03092015 04:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance(userTimezone);
        to.setTime(end);
        to.add(2, 6);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test monthly recurring event");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_MONTHLY);
        event.setRepeatInterval(1L);
        event.setRepeatByDay(new String[]{"2MO"});
        event.setRepeatCount(5L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        setting.setTimeZone(oldTimeZone);
        this.calendarService_.saveCalendarSetting(this.username, setting);
        RecurringEventTestCase.assertEquals((int)5, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertContain("20150309T030000Z", keys);
        this.assertNotContain("20150316T030000Z", keys);
        this.assertContain("20150413T030000Z", keys);
        this.assertContain("20150511T030000Z", keys);
        this.assertContain("20150608T030000Z", keys);
        this.assertContain("20150713T030000Z", keys);
        this.assertNotContain("20150810T030000Z", keys);
    }

    public void testEventRecurringMonthlyByDayOfMonth() throws Exception {
        CalendarSetting setting = this.calendarService_.getCalendarSetting(this.username);
        setting.setDateFormat("MMddyyyy");
        setting.setTimeFormat("H:m");
        String oldTimeZone = setting.getTimeZone();
        setting.setTimeZone("Asia/Saigon");
        this.calendarService_.saveCalendarSetting(this.username, setting);
        setting = this.calendarService_.getCalendarSetting(this.username);
        TimeZone userTimezone = DateUtils.getTimeZone((String)setting.getTimeZone());
        Calendar calendar = this.createPrivateCalendar(this.username, "calendar for testing monthly recurring", "description");
        String startTime = "03092015 03:00";
        String endTime = "03092015 04:00";
        Date start = this.getDate(setting, startTime);
        Date end = this.getDate(setting, endTime);
        java.util.Calendar from = java.util.Calendar.getInstance(userTimezone);
        from.setTime(start);
        from.add(5, -2);
        java.util.Calendar to = java.util.Calendar.getInstance(userTimezone);
        to.setTime(end);
        to.add(2, 6);
        CalendarEvent event = new CalendarEvent();
        event.setSummary("test monthly recurring event");
        event.setFromDateTime(start);
        event.setToDateTime(end);
        event.setRepeatType(CalendarEvent.RP_MONTHLY);
        event.setRepeatInterval(1L);
        event.setRepeatByMonthDay(new long[]{9L});
        event.setRepeatCount(5L);
        event.setRepeatUntilDate(null);
        Utils.updateOriginDate((CalendarEvent)event, (TimeZone)userTimezone);
        Utils.adaptRepeatRule((CalendarEvent)event, (TimeZone)userTimezone, (TimeZone)CalendarService.PERSISTED_TIMEZONE);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), event, true);
        Map events = this.calendarService_.getOccurrenceEvents(event, from, to, setting.getTimeZone());
        setting.setTimeZone(oldTimeZone);
        this.calendarService_.saveCalendarSetting(this.username, setting);
        RecurringEventTestCase.assertEquals((int)5, (int)events.size());
        Set<String> keys = events.keySet();
        this.assertContain("20150309T030000Z", keys);
        this.assertNotContain("20150316T030000Z", keys);
        this.assertContain("20150409T030000Z", keys);
        this.assertContain("20150509T030000Z", keys);
        this.assertContain("20150609T030000Z", keys);
        this.assertContain("20150709T030000Z", keys);
        this.assertNotContain("20150809T030000Z", keys);
    }

    private Date getDate(CalendarSetting setting, String datetime) throws Exception {
        String format = setting.getDateFormat() + " " + setting.getTimeFormat();
        SimpleDateFormat df = new SimpleDateFormat(format);
        df.setCalendar(this.getCalendarInstanceBySetting(setting));
        return df.parse(datetime);
    }

    private String formatDate(CalendarSetting setting, Date date) {
        String format = setting.getDateFormat() + " " + setting.getTimeFormat();
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(date);
    }

    private java.util.Calendar getCalendarInstanceBySetting(CalendarSetting calendarSetting) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(DateUtils.getTimeZone((String)calendarSetting.getTimeZone()));
        calendar.setFirstDayOfWeek(Integer.parseInt(calendarSetting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    private void assertContain(String key, Set<String> keys) {
        for (String k : keys) {
            if (!k.equals(key)) continue;
            return;
        }
        RecurringEventTestCase.fail((String)("Event at " + key + " should be found"));
    }

    private void assertNotContain(String key, Set<String> keys) {
        for (String k : keys) {
            if (!k.equals(key)) continue;
            RecurringEventTestCase.fail((String)("Event at " + key + " should not be found"));
        }
    }

    private CalendarEvent createRepetitiveEventForTest() throws Exception {
        java.util.Calendar fromCal = java.util.Calendar.getInstance(this.tz);
        fromCal.set(2013, 2, 7, 5, 30);
        java.util.Calendar toCal = java.util.Calendar.getInstance(this.tz);
        toCal.set(2013, 2, 7, 6, 30);
        Calendar calendar = this.createPrivateCalendar(this.username, this.username, "TestSaveOneOccurrence");
        CalendarEvent recurEvent = new CalendarEvent();
        recurEvent.setSummary("repeated past");
        recurEvent.setFromDateTime(fromCal.getTime());
        recurEvent.setToDateTime(toCal.getTime());
        recurEvent.setRepeatType(CalendarEvent.RP_DAILY);
        recurEvent.setRepeatInterval(1L);
        recurEvent.setRepeatCount(6L);
        recurEvent.setRepeatUntilDate(null);
        recurEvent.setRepeatByDay(null);
        recurEvent.setCalendarId(calendar.getId());
        this.calendarService_.saveUserCalendar(this.username, calendar, true);
        this.calendarService_.saveUserEvent(this.username, calendar.getId(), recurEvent, true);
        return recurEvent;
    }
}

