/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.service.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.CalendarSearchServiceConnector;
import org.exoplatform.calendar.service.impl.EventSearchConnector;
import org.exoplatform.calendar.service.impl.UnifiedQuery;
import org.exoplatform.calendar.service.test.BaseCalendarServiceTestCase;

public class SharedCalendarTestCase
extends BaseCalendarServiceTestCase {
    private CalendarSearchServiceConnector eventSearchConnector_;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.eventSearchConnector_ = (CalendarSearchServiceConnector)this.getService(EventSearchConnector.class);
    }

    public void testGetTypeOfCalendar() throws Exception {
        Calendar calendar = this.createPrivateCalendar(this.username, "myCalendar", "Description");
        Calendar publicCalendar = this.createGroupCalendar(this.userGroups, "publicCalendar", "publicDescription");
        Calendar sharedCalendar = this.createSharedCalendar("sharedCalendar", "shareDescription");
        SharedCalendarTestCase.assertEquals((int)0, (int)this.calendarService_.getTypeOfCalendar(this.username, calendar.getId()));
        SharedCalendarTestCase.assertEquals((int)2, (int)this.calendarService_.getTypeOfCalendar(this.username, publicCalendar.getId()));
        SharedCalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getTypeOfCalendar("john", sharedCalendar.getId()));
        SharedCalendarTestCase.assertEquals((int)-1, (int)this.calendarService_.getTypeOfCalendar(this.username, "Not exist id"));
        SharedCalendarTestCase.assertEquals((String)sharedCalendar.getId(), (String)this.calendarService_.getCalendarById(sharedCalendar.getId()).getId());
    }

    public void testSharedCalendar() throws Exception {
        Calendar cal = new Calendar();
        cal.setName("myCalendar");
        cal.setPublic(true);
        cal.setViewPermission(new String[]{"*.*"});
        cal.setEditPermission(new String[]{"*.*", "john"});
        this.calendarService_.saveUserCalendar(this.username, cal, true);
        ArrayList<String> receiverUser = new ArrayList<String>();
        receiverUser.add("john");
        this.calendarService_.shareCalendar(this.username, cal.getId(), receiverUser);
        Calendar sharedCalendar = this.calendarService_.getSharedCalendars("john", true).getCalendarById(cal.getId());
        SharedCalendarTestCase.assertEquals((String)"myCalendar", (String)sharedCalendar.getName());
        sharedCalendar.setDescription("shared description");
        this.calendarService_.saveSharedCalendar("john", sharedCalendar);
        Calendar editedCalendar = this.calendarService_.getSharedCalendars("john", true).getCalendarById(cal.getId());
        SharedCalendarTestCase.assertEquals((String)"shared description", (String)editedCalendar.getDescription());
        CalendarEvent calendarEvent = new CalendarEvent();
        calendarEvent.setCalendarId(cal.getId());
        calendarEvent.setSummary("calendarEvent");
        calendarEvent.setEventType(CalendarEvent.TYPE_EVENT);
        java.util.Calendar current = java.util.Calendar.getInstance();
        current.add(12, 10);
        calendarEvent.setFromDateTime(current.getTime());
        current.add(12, 30);
        calendarEvent.setToDateTime(current.getTime());
        this.calendarService_.saveEventToSharedCalendar("john", cal.getId(), calendarEvent, true);
        ArrayList<String> calendarIds = new ArrayList<String>();
        calendarIds.add(cal.getId());
        SharedCalendarTestCase.assertEquals((int)1, (int)this.calendarService_.getSharedEventByCalendars("john", calendarIds).size());
        SharedCalendarTestCase.assertNotNull((Object)this.calendarService_.getSharedEvent("john", cal.getId(), calendarEvent.getId()));
        CalendarEvent event = (CalendarEvent)this.calendarService_.getUserEventByCalendar(this.username, calendarIds).get(0);
        SharedCalendarTestCase.assertEquals((String)"calendarEvent", (String)event.getSummary());
        this.login("john");
        UnifiedQuery query = new UnifiedQuery();
        query.setText("calendarEvent");
        query.setOrderType("ASC");
        query.setOrderBy(new String[]{Utils.ORDERBY_TITLE});
        ArrayList params = new ArrayList();
        Collection rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        SharedCalendarTestCase.assertEquals((int)1, (int)rs.size());
        this.login(this.username);
        rs = this.eventSearchConnector_.search(null, query.getText(), params, 0, 10, query.getOrderBy()[0], query.getOrderType());
        SharedCalendarTestCase.assertEquals((int)1, (int)rs.size());
        this.calendarService_.removeSharedEvent("john", cal.getId(), calendarEvent.getId());
        List events = this.calendarService_.getUserEventByCalendar(this.username, calendarIds);
        SharedCalendarTestCase.assertEquals((int)0, (int)events.size());
        this.calendarService_.removeSharedCalendar("john", cal.getId());
        SharedCalendarTestCase.assertNull((Object)this.calendarService_.getSharedCalendars("john", true));
    }

    public void testRemoveSharedCalendarFolder() throws Exception {
        this.createSharedCalendar("sharedCalendar", "shareDescription");
        this.calendarService_.removeSharedCalendarFolder("john");
        GroupCalendarData groupCalendarData = this.calendarService_.getSharedCalendars(this.username, true);
        SharedCalendarTestCase.assertNull((Object)groupCalendarData);
    }

    public void testShareCalendarWithEditPermission() throws Exception {
        Calendar cal = this.createPrivateCalendar(this.username, "test share", "test sharing with edit permission");
        ArrayList<String> sharedUsers = new ArrayList<String>();
        String sharedUser = "mary";
        String sharedGroup = "/platform/guests/:*.*";
        String sharedMemberShip = "/organization/management/executive-board/:*.manager";
        String[] sharedList = new String[]{sharedUser, sharedGroup, sharedMemberShip};
        cal.setViewPermission(sharedList);
        cal.setEditPermission(sharedList);
        sharedUsers.add(sharedUser);
        sharedUsers.addAll(Utils.getUsersCanEdit((String)sharedGroup));
        sharedUsers.addAll(Utils.getUsersCanEdit((String)sharedMemberShip));
        this.calendarService_.saveUserCalendar(this.username, cal, false);
        this.calendarService_.shareCalendar(this.username, cal.getId(), sharedUsers);
        CalendarEvent eventByMary = this.createCalendarEventInstance("mary");
        CalendarEvent eventByJohn = this.createCalendarEventInstance("john");
        CalendarEvent eventByDemo = this.createCalendarEventInstance("demo");
        this.calendarService_.saveEventToSharedCalendar("john", cal.getId(), eventByJohn, true);
        this.calendarService_.saveEventToSharedCalendar("mary", cal.getId(), eventByMary, true);
        this.calendarService_.saveEventToSharedCalendar("demo", cal.getId(), eventByDemo, true);
    }

    private Calendar createSharedCalendar(String name, String description) {
        try {
            Calendar sharedCalendar = new Calendar();
            sharedCalendar.setName(name);
            sharedCalendar.setDescription(description);
            sharedCalendar.setPublic(true);
            sharedCalendar.setViewPermission(new String[]{"*.*"});
            sharedCalendar.setEditPermission(new String[]{"*.*", "john"});
            this.calendarService_.saveUserCalendar(this.username, sharedCalendar, true);
            ArrayList<String> receiverUser = new ArrayList<String>();
            receiverUser.add("john");
            this.calendarService_.shareCalendar(this.username, sharedCalendar.getId(), receiverUser);
            return sharedCalendar;
        }
        catch (Exception e) {
            SharedCalendarTestCase.fail();
            return null;
        }
    }
}

