/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.util;

import java.util.Locale;
import junit.framework.TestCase;
import org.exoplatform.calendar.util.CalendarUtils;

public class TestCalendarUtils
extends TestCase {
    public void testGetLocationDisplayString() {
        TestCalendarUtils.assertEquals((String)"", (String)CalendarUtils.getLocationDisplayString((String)""));
        TestCalendarUtils.assertEquals((String)"Viet nam", (String)CalendarUtils.getLocationDisplayString((String)"Viet nam"));
        Locale locale = Locale.FRANCE;
        String vietnamLocation = locale.getDisplayCountry() + "(" + locale.getDisplayLanguage() + ")";
        String countryname = locale.getISO3Country();
        TestCalendarUtils.assertEquals((String)vietnamLocation, (String)CalendarUtils.getLocationDisplayString((String)countryname));
    }

    public void testGenerateTimeZoneLabel() {
        TestCalendarUtils.assertEquals((String)"", (String)CalendarUtils.generateTimeZoneLabel((String)""));
        TestCalendarUtils.assertEquals((String)"Viet nam", (String)CalendarUtils.generateTimeZoneLabel((String)"Viet nam"));
        String vietnamTimezone = "Asia/Ho_Chi_Minh";
        String display = "(GMT +07:00) Asia/Ho_Chi_Minh";
        TestCalendarUtils.assertEquals((String)display, (String)CalendarUtils.generateTimeZoneLabel((String)vietnamTimezone));
    }

    public void testCleanValue() throws Exception {
        String values = "";
        TestCalendarUtils.assertEquals((String)"", (String)CalendarUtils.cleanValue((String)values));
        values = "root,";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = "root, ";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = " root     ,root ";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = " root, root , root ";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = ",root,";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = " , root , ";
        TestCalendarUtils.assertEquals((String)"root", (String)CalendarUtils.cleanValue((String)values));
        values = " , root , root abc ";
        TestCalendarUtils.assertEquals((String)"root,root abc", (String)CalendarUtils.cleanValue((String)values));
        values = "demo, root, exo/test  ,   platform/user ";
        TestCalendarUtils.assertEquals((String)"demo,root,exo/test,platform/user", (String)CalendarUtils.cleanValue((String)values));
    }

    public void testConvertURLsAsLinks() {
        String text = "a\rb\nc  http://github.com/exodev\nawww.github.com/exodev\nhttps://github.com/exodev\n bbac";
        String result = "a\rb\nc  <a href=\"http://github.com/exodev\" target=\"_blank\">http://github.com/exodev</a>\na<a href=\"http://www.github.com/exodev\" target=\"_blank\">www.github.com/exodev</a>\n<a href=\"https://github.com/exodev\" target=\"_blank\">https://github.com/exodev</a>\n bbac";
        TestCalendarUtils.assertEquals((String)result, (String)CalendarUtils.convertURLsAsLinks((String)text));
    }
}

