/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormComboBox
extends UIFormInputBase<String> {
    protected int size_ = 1;
    private List<SelectItemOption<String>> options_;
    private String onchange_;
    public static final String ON_CHANGE = "onchange".intern();
    public static final String ON_BLUR = "onblur".intern();
    public static final String ON_FOCUS = "onfocus".intern();
    public static final String ON_KEYUP = "onkeyup".intern();
    public static final String ON_KEYDOWN = "onkeydown".intern();
    public static final String ON_CLICK = "onclick".intern();
    private Map<String, String> jsActions_ = new HashMap();

    public UIFormComboBox(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
    }

    public UIFormComboBox(String name, String bindingExpression, List<SelectItemOption<String>> options) {
        super(name, bindingExpression, null);
        this.setOptions(options);
    }

    public void setJsActions(Map<String, String> jsActions) {
        if (jsActions != null) {
            this.jsActions_ = jsActions;
        }
    }

    public Map<String, String> getJsActions() {
        return this.jsActions_;
    }

    public void addJsActions(String action, String javaScript) {
        this.jsActions_.put(action, javaScript);
    }

    public UIFormComboBox(String name, String bindingExpression, List<SelectItemOption<String>> options, Map<String, String> jsActions) {
        super(name, bindingExpression, null);
        this.setOptions(options);
        this.setJsActions(jsActions);
    }

    public UIFormComboBox(String name, String value) {
        this(name, null, value);
    }

    public final UIFormComboBox setOptions(List<SelectItemOption<String>> options) {
        this.options_ = options;
        if (this.options_ == null || this.options_.size() < 1) {
            return this;
        }
        this.value_ = ((SelectItemOption)this.options_.get(0)).getValue();
        return this;
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).length() == 0) {
            this.value_ = null;
        }
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    public UIForm getUIform() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    private String renderJsActions() {
        StringBuffer sb = new StringBuffer();
        for (String k : this.jsActions_.keySet()) {
            if (sb != null && sb.length() > 0) {
                sb.append(" ");
            }
            if (this.jsActions_.get(k) == null) continue;
            sb.append(k).append("=\"").append((String)this.jsActions_.get(k)).append("\"");
        }
        return sb.toString();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        String parentId = this.getParent().getId();
        RequireJS requirejs = context.getJavascriptManager().getRequireJS();
        requirejs.require("SHARED/webui-ext", "wx");
        requirejs.addScripts("wx.UICombobox.init('" + parentId + "','" + this.getId() + "');");
        Writer w = context.getWriter();
        String options = "[";
        StringBuffer text = new StringBuffer("<div class='UIComboboxComponent'><div class='UIComboboxList'><div class='UIComboboxContainer'><div class='UIComboboxItemContainer'>");
        for (SelectItemOption item : this.options_) {
            options = options + "'" + item.getValue() + "',";
            text.append("<div value='").append(item.getValue()).append("' class='UIComboboxItem'>");
            text.append("<div class='UIComboboxIcon'>");
            text.append("<div class='UIComboboxLabel'>").append(item.getLabel()).append("</div>");
            text.append("</div>");
            text.append("</div>");
        }
        text.append("</div></div></div>");
        options = options.substring(0, options.length() - 1) + "]";
        text.append("<input class='UIComboboxInput' options=\"").append(options).append("\" name='").append(this.getName()).append("' type='text'").append(" id='").append(this.getId()).append("' ").append(this.renderJsActions());
        if (this.value_ != null && ((String)this.value_).trim().length() > 0) {
            text.append(" value='").append(this.encodeValue((String)this.value_).toString()).append("'");
        }
        text.append(" /></div>");
        requirejs.require("SHARED/jquery", "gj");
        requirejs.addScripts("gj('div.UIComboboxItem').click(function(){wx.UICombobox.getValue(this);});");
        requirejs.addScripts("gj('input#" + this.getId() + "').keyup(function(){wx.UICombobox.complete(this,event);});");
        w.write(text.toString());
    }

    private StringBuilder encodeValue(String value) {
        char[] chars = new char[]{'\'', '\"'};
        String[] refs = new String[]{"&#39;", "&#34;"};
        StringBuilder builder = new StringBuilder(value);
        for (int i = 0; i < chars.length; ++i) {
            int idx = this.indexOf(builder, chars[i], 0);
            while (idx > -1) {
                builder = builder.replace(idx, idx + 1, refs[i]);
                idx = this.indexOf(builder, chars[i], idx);
            }
        }
        return builder;
    }

    private int indexOf(StringBuilder builder, char c, int from) {
        for (int i = from; i < builder.length(); ++i) {
            if (builder.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }
}

