/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UITaskForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UITaskDetailTab.gtmpl")
public class UITaskDetailTab
extends UIFormInputWithActions {
    public static final String FIELD_EVENT = "eventName".intern();
    public static final String FIELD_CALENDAR = "calendar".intern();
    public static final String FIELD_CATEGORY = "category".intern();
    public static final String FIELD_FROM = "from".intern();
    public static final String FIELD_TO = "to".intern();
    public static final String FIELD_FROM_TIME = "fromTime".intern();
    public static final String FIELD_TO_TIME = "toTime".intern();
    public static final String FIELD_CHECKALL = "allDay".intern();
    public static final String FIELD_DELEGATION = "delegation".intern();
    public static final String FIELD_PRIORITY = "priority".intern();
    public static final String FIELD_DESCRIPTION = "description".intern();
    public static final String FIELD_STATUS = "status".intern();
    public static final String FIELD_ATTACHMENTS = "attachments".intern();
    protected List<Attachment> attachments_ = new ArrayList();
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_;

    public UITaskDetailTab(String arg0) throws Exception {
        super(arg0);
        this.setComponentConfig(this.getClass(), null);
        this.actionField_ = new HashMap();
        ArrayList options = new ArrayList();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EVENT, FIELD_EVENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION, FIELD_DESCRIPTION, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(FIELD_CALENDAR, FIELD_CALENDAR, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_CATEGORY, FIELD_CATEGORY, CalendarUtils.getCategory()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_STATUS, FIELD_STATUS, this.getStatus()));
        UIFormInputWithActions.ActionData addCategoryAction = new UIFormInputWithActions.ActionData();
        addCategoryAction.setActionType(0);
        addCategoryAction.setActionName(UIEventForm.ACT_ADDCATEGORY);
        addCategoryAction.setActionListener(UIEventForm.ACT_ADDCATEGORY);
        ArrayList<UIFormInputWithActions.ActionData> addCategoryActions = new ArrayList<UIFormInputWithActions.ActionData>();
        addCategoryActions.add(addCategoryAction);
        this.setActionField(FIELD_CATEGORY, addCategoryActions);
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        this.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_FROM, FIELD_FROM, new Date(), false));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_FROM_TIME, FIELD_FROM_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_TO_TIME, FIELD_TO_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_TO, FIELD_TO, new Date(), false));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_CHECKALL, FIELD_CHECKALL, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_DELEGATION, FIELD_DELEGATION, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_PRIORITY, FIELD_PRIORITY, this.getPriority()));
        UIFormInputWithActions.ActionData addEmailAddress = new UIFormInputWithActions.ActionData();
        addEmailAddress.setActionType(0);
        addEmailAddress.setActionName(UITaskForm.ACT_ADDEMAIL);
        addEmailAddress.setActionListener(UITaskForm.ACT_ADDEMAIL);
        ArrayList<UIFormInputWithActions.ActionData> addMailActions = new ArrayList<UIFormInputWithActions.ActionData>();
        addMailActions.add(addEmailAddress);
        UIFormInputWithActions.ActionData selectUser = new UIFormInputWithActions.ActionData();
        selectUser.setActionType(0);
        selectUser.setActionName(UITaskForm.ACT_SELECTUSER);
        selectUser.setActionListener(UITaskForm.ACT_SELECTUSER);
        ArrayList<UIFormInputWithActions.ActionData> selectUsers = new ArrayList<UIFormInputWithActions.ActionData>();
        selectUsers.add(selectUser);
        this.setActionField(FIELD_DELEGATION, selectUsers);
    }

    private List<SelectItemOption<String>> getStatus() {
        ArrayList<SelectItemOption<String>> status = new ArrayList<SelectItemOption<String>>();
        for (String taskStatus : CalendarEvent.TASK_STATUS) {
            status.add((SelectItemOption<String>)new SelectItemOption(taskStatus, (Object)taskStatus));
        }
        return status;
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public List<UIFormInputWithActions.ActionData> getUploadFileList() throws Exception {
        ArrayList<UIFormInputWithActions.ActionData> uploadedFiles = new ArrayList<UIFormInputWithActions.ActionData>();
        for (Attachment attachdata : this.attachments_) {
            UIFormInputWithActions.ActionData fileUpload = new UIFormInputWithActions.ActionData();
            fileUpload.setActionListener(UIEventForm.ACT_DOWNLOAD);
            fileUpload.setActionParameter(attachdata.getId());
            fileUpload.setActionType(1);
            fileUpload.setCssIconClass("AttachmentIcon ZipFileIcon");
            fileUpload.setActionName(attachdata.getName() + "-(" + CalendarUtils.convertSize((long)attachdata.getSize()) + ")");
            fileUpload.setShowLabel(true);
            uploadedFiles.add(fileUpload);
            UIFormInputWithActions.ActionData removeAction = new UIFormInputWithActions.ActionData();
            removeAction.setActionListener(UIEventForm.ACT_REMOVE);
            removeAction.setActionName(UIEventForm.ACT_REMOVE);
            removeAction.setActionParameter(attachdata.getId());
            removeAction.setActionType(1);
            removeAction.setBreakLine(true);
            uploadedFiles.add(removeAction);
        }
        return uploadedFiles;
    }

    public void addToUploadFileList(Attachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(Attachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void refreshUploadFileList() throws Exception {
        this.setActionField(FIELD_ATTACHMENTS, this.getUploadFileList());
    }

    protected List<Attachment> getAttachments() {
        return this.attachments_;
    }

    protected void setAttachments(List<Attachment> attachment) {
        this.attachments_ = attachment;
    }

    protected List<SelectItemOption<String>> getCalendar() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List calendars = calendarService.getUserCalendars(username, true);
        for (Calendar c : calendars) {
            if (c.getId().equals(Utils.getDefaultCalendarId((String)username)) && c.getName().equals(NewUserListener.defaultCalendarName)) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendars.label." + NewUserListener.defaultCalendarId), (String)NewUserListener.defaultCalendarId);
                c.setName(newName);
            }
            options.add((SelectItemOption<String>)new SelectItemOption(c.getName(), (Object)c.getId()));
        }
        return options;
    }

    private List<SelectItemOption<String>> getPriority() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("none", (Object)"none"));
        options.add(new SelectItemOption("normal", (Object)"normal"));
        options.add(new SelectItemOption("high", (Object)"high"));
        options.add(new SelectItemOption("low", (Object)"low"));
        return options;
    }

    protected List<SelectItemOption<String>> getRepeater() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (String s : CalendarEvent.REPEATTYPES) {
            options.add((SelectItemOption<String>)new SelectItemOption(s, (Object)s));
        }
        return options;
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public UIFormComboBox getUIFormComboBox(String id) {
        return (UIFormComboBox)this.findComponentById(id);
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }
}

