/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.TimeZone;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.UIActionBar;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIPopupAction;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.mortbay.cometd.AbstractBayeux;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="app:/templates/calendar/webui/UICalendarPortlet.gtmpl")
public class UICalendarPortlet
extends UIPortletApplication {
    private static Log log = ExoLogger.getLogger((String)"org.exoplatform.calendar.webui.UICalendarPortlet");
    private static String SPACE_ID_KEY = "UICalendarPortlet_Space_Id";

    public UICalendarPortlet() throws Exception {
        UIActionBar uiActionBar = (UIActionBar)this.addChild(UIActionBar.class, null, null);
        uiActionBar.setCurrentView(UICalendarViewContainer.TYPES[Integer.parseInt(this.getCalendarSetting().getViewType())]);
        this.addChild(UICalendarWorkingContainer.class, null, null);
        UIPopupAction uiPopup = (UIPopupAction)this.addChild(UIPopupAction.class, null, null);
        uiPopup.setId("UICalendarPopupAction");
        ((UIPopupWindow)uiPopup.getChild(UIPopupWindow.class)).setId("UICalendarPopupWindow");
    }

    public CalendarSetting getCalendarSetting() throws Exception {
        return CalendarUtils.getCurrentUserCalendarSetting();
    }

    public void setCalendarSetting(CalendarSetting setting) throws Exception {
        CalendarUtils.setCurrentCalendarSetting((CalendarSetting)setting);
    }

    public java.util.Calendar getUserCalendar() {
        return CalendarUtils.getInstanceOfCurrentCalendar();
    }

    public String getSettingTimeZone() throws Exception {
        return String.valueOf(TimeZone.getTimeZone(this.getCalendarSetting().getTimeZone()).getRawOffset() / 1000 / 60);
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupAction popupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public String getRemoteUser() throws Exception {
        return CalendarUtils.getCurrentUser();
    }

    public String getUserToken() throws Exception {
        ContinuationService continuation = CalendarUtils.getContinuationService();
        try {
            return continuation.getUserToken(this.getRemoteUser());
        }
        catch (Exception e) {
            log.debug((Object)"\n\n can not get UserToken", (Throwable)e);
            return "";
        }
    }

    protected String getCometdContextName() {
        EXoContinuationBayeux bayeux = (EXoContinuationBayeux)PortalContainer.getInstance().getComponentInstanceOfType(AbstractBayeux.class);
        return bayeux == null ? "cometd" : bayeux.getCometdContextName();
    }

    public String getRestContextName() {
        return PortalContainer.getInstance().getRestContextName();
    }

    public static String getSpaceId() {
        String spaceIdStr;
        block4: {
            PortletRequestContext pContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            spaceIdStr = (String)pContext.getAttribute(SPACE_ID_KEY);
            if (spaceIdStr == null) {
                try {
                    PortletRequest portletRequest = pContext.getRequest();
                    PortletPreferences pref = portletRequest.getPreferences();
                    if (pref.getValue("SPACE_URL", null) != null) {
                        String url = pref.getValue("SPACE_URL", null);
                        SpaceService sService = (SpaceService)PortalContainer.getInstance().getComponentInstanceOfType(SpaceService.class);
                        Space space = sService.getSpaceByUrl(url);
                        spaceIdStr = space.getPrettyName();
                        pContext.setAttribute(SPACE_ID_KEY, (Object)spaceIdStr);
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Getting space id in the UICalendar portlet failed.", (Throwable)e);
                }
            }
        }
        return spaceIdStr;
    }

    public static boolean isInSpace() {
        return UICalendarPortlet.getSpaceId() != null;
    }

    public void processInvitationURL(WebuiRequestContext context, PortalRequestContext pContext, String url) throws Exception {
        String isAjax = pContext.getRequestParameter("ajaxRequest");
        if (isAjax != null && Boolean.parseBoolean(isAjax)) {
            return;
        }
        String username = CalendarUtils.getCurrentUser();
        User user = CalendarUtils.getOrganizationService().getUserHandler().findUserByName(username);
        String formTime = CalendarUtils.getCurrentTime((UIComponent)this);
        CalendarService calService = CalendarUtils.getCalendarService();
        if (url.contains(CalendarUtils.INVITATION_IMPORT_URL)) {
            url = url.substring(url.indexOf(CalendarUtils.INVITATION_IMPORT_URL) + CalendarUtils.INVITATION_IMPORT_URL.length());
            String[] params = url.split("/");
            String inviter = params[0];
            String eventId = params[1];
            int calType = Integer.parseInt(params[2]);
            CalendarEvent event = null;
            event = calType == 2 ? calService.getGroupEvent(eventId) : calService.getEvent(inviter, eventId);
            if (event != null) {
                calService.confirmInvitation(inviter, user.getEmail(), username, calType, event.getCalendarId(), eventId, 1);
                UIPopupAction uiParentPopup = (UIPopupAction)this.getChild(UIPopupAction.class);
                UIPopupContainer uiPopupContainer = (UIPopupContainer)uiParentPopup.activate(UIPopupContainer.class, 800);
                uiPopupContainer.setId(UIPopupContainer.UIEVENTPOPUP);
                UIEventForm uiEventForm = (UIEventForm)uiPopupContainer.addChild(UIEventForm.class, null, null);
                uiEventForm.initForm(this.getCalendarSetting(), null, formTime);
                uiEventForm.update(CalendarUtils.PRIVATE_TYPE, CalendarUtils.getCalendarOption());
                uiEventForm.importInvitationEvent(this.getCalendarSetting(), event, Utils.getDefaultCalendarId((String)username), formTime);
                uiEventForm.setSelectedEventState(UIEventForm.ITEM_BUSY);
                uiEventForm.setEmailRemindBefore(String.valueOf(5));
                uiEventForm.setEmailReminder(false);
                uiEventForm.setEmailRepeat(Boolean.valueOf(false));
                context.addUIComponentToUpdateByAjax((UIComponent)uiParentPopup);
            } else {
                context.getUIApplication().addMessage(new ApplicationMessage("UICalendarPortlet.msg.event-was-not-found", null, 0));
            }
            return;
        }
        if (url.contains(CalendarUtils.INVITATION_DETAIL_URL)) {
            url = url.substring(url.indexOf(CalendarUtils.INVITATION_DETAIL_URL) + CalendarUtils.INVITATION_DETAIL_URL.length());
            String[] params = url.split("/");
            String inviter = params[0];
            String eventId = params[1];
            int calType = Integer.parseInt(params[2]);
            Calendar calendar = null;
            CalendarEvent event = null;
            if (calType == 0 || calType == 1) {
                event = calService.getEvent(inviter, eventId);
                String calendarId = event.getCalendarId();
                calendar = calService.getUserCalendar(inviter, calendarId);
            } else if (calType == 2) {
                event = calService.getGroupEvent(eventId);
                String calendarId = event.getCalendarId();
                calendar = calService.getGroupCalendar(calendarId);
            }
            if (calendar == null) {
                context.getUIApplication().addMessage(new ApplicationMessage("UICalendarPortlet.msg.have-no-permission-to-view-event", null, 1));
                return;
            }
            this.openEventPreviewPopup(event, context);
        }
    }

    private void processEventDetailsURL(WebuiRequestContext webuiRequestContext, String eventId) throws Exception {
        if (UIPreview.isClosed) {
            UIPreview.isClosed = false;
            return;
        }
        String username = CalendarUtils.getCurrentUser();
        CalendarService calService = CalendarUtils.getCalendarService();
        CalendarEvent event = calService.getEvent(username, eventId);
        if (event == null) {
            event = calService.getGroupEvent(eventId);
            if (event != null) {
                event.setCalType(String.valueOf(2));
            } else {
                webuiRequestContext.getUIApplication().addMessage(new ApplicationMessage("UICalendarPortlet.msg.have-no-permission-to-view-event", null, 1));
                return;
            }
        }
        this.openEventPreviewPopup(event, webuiRequestContext);
    }

    private void openEventPreviewPopup(CalendarEvent event, WebuiRequestContext webuiRequestContext) throws Exception {
        UIPopupAction uiPopupAction = (UIPopupAction)this.getChild(UIPopupAction.class);
        ((UIPopupWindow)uiPopupAction.getChild(UIPopupWindow.class)).setShowCloseButton(false);
        UIPreview uiPreview = (UIPreview)uiPopupAction.activate(UIPreview.class, 700);
        uiPreview.setEvent(event);
        uiPreview.setId("UIPreviewPopup");
        uiPreview.setShowPopup(true);
        webuiRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiPopupAction);
    }

    private void processExternalUrl(WebuiRequestContext webuiRequestContext) throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String requestedURL = pContext.getRequest().getRequestURL().toString();
        if (requestedURL.contains(CalendarUtils.INVITATION_URL)) {
            try {
                this.processInvitationURL(webuiRequestContext, pContext, requestedURL);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Invitation url is not valid", (Throwable)e);
                }
            }
        } else if (requestedURL.contains("/details/")) {
            String eventId = requestedURL.substring(requestedURL.indexOf("/details/") + "/details/".length());
            if (!eventId.startsWith("Event")) {
                return;
            }
            this.processEventDetailsURL(webuiRequestContext, eventId);
        }
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        this.processExternalUrl(context);
        super.processRender(app, context);
    }
}

