/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.webui.UIActionBar;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.calendar.webui.UISearchForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UICalendars.gtmpl", events={@EventConfig(listeners={AddCalendarActionListener.class}), @EventConfig(listeners={AddEventCategoryActionListener.class}), @EventConfig(listeners={ExportCalendarActionListener.class}), @EventConfig(listeners={ExportCalendarsActionListener.class}), @EventConfig(listeners={ImportCalendarActionListener.class}), @EventConfig(listeners={AddEventActionListener.class}), @EventConfig(listeners={AddTaskActionListener.class}), @EventConfig(listeners={EditCalendarActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveCalendarActionListener.class}, confirm="UICalendars.msg.confirm-delete-calendar"), @EventConfig(phase=Event.Phase.DECODE, listeners={RemoveSharedCalendarActionListener.class}, confirm="UICalendars.msg.confirm-delete-sharedCalendar"), @EventConfig(listeners={ChangeColorActionListener.class}), @EventConfig(listeners={TickActionListener.class}), @EventConfig(listeners={CalendarSettingActionListener.class}), @EventConfig(listeners={RemoteCalendarActionListener.class}), @EventConfig(listeners={RefreshRemoteCalendarActionListener.class}), @EventConfig(listeners={ShareCalendarActionListener.class})})
public class UICalendars
extends UIForm {
    private static final Log LOG = ExoLogger.getLogger(UICalendars.class);
    public static String CALENDARID = "calendarid".intern();
    public static String CALTYPE = "calType".intern();
    public static String CALNAME = "calName".intern();
    public static String CALCOLOR = "calColor".intern();
    private boolean isShowTaskList_ = false;
    private LinkedHashMap<String, String> colorMap_ = new LinkedHashMap();

    public String getLabel(String key) {
        try {
            return super.getLabel(key);
        }
        catch (Exception e) {
            return key;
        }
    }

    public void setShowTaskList(boolean isShowTaskList) {
        this.isShowTaskList_ = isShowTaskList;
    }

    public boolean isShowTaskList() {
        return this.isShowTaskList_;
    }

    public java.util.Calendar getCurrentMiniBeginDate() {
        UIMiniCalendar miniCal = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
        java.util.Calendar temCal = miniCal.getInstanceTempCalendar();
        temCal.setTime(miniCal.getCurrentDate());
        return miniCal.getBeginDay(temCal);
    }

    public java.util.Calendar getCurrentMiniEndDate() {
        UIMiniCalendar miniCal = (UIMiniCalendar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UIMiniCalendar.class);
        java.util.Calendar temCal = miniCal.getInstanceTempCalendar();
        temCal.setTime(miniCal.getCurrentDate());
        return miniCal.getEndDay(temCal);
    }

    public String[] getTaskStatus() {
        return CalendarEvent.TASK_STATUS;
    }

    public List<CalendarEvent> getAllTask(java.util.Calendar formDate, java.util.Calendar toDate, String taskStatus) throws Exception {
        ArrayList<CalendarEvent> list = new ArrayList();
        EventQuery eq = new EventQuery();
        if (!CalendarUtils.isEmpty((String)taskStatus)) {
            eq.setState(taskStatus);
        }
        eq.setEventType(CalendarEvent.TYPE_TASK);
        eq.setFromDate(formDate);
        eq.setToDate(toDate);
        list = CalendarUtils.getCalendarService().getEvents(CalendarUtils.getCurrentUser(), eq, null);
        return list;
    }

    public void checkAll() {
        if (UICalendarPortlet.getSpaceId() != null) {
            CalendarService calendarService;
            block10: {
                calendarService = null;
                try {
                    calendarService = CalendarUtils.getCalendarService();
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Object)"Can not get calendar service", (Throwable)e);
                }
            }
            String calendarId = null;
            for (UIComponent component : this.getChildren()) {
                block11: {
                    if (calendarService != null) {
                        try {
                            calendarId = calendarService.getGroupCalendar(component.getId()).getId();
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block11;
                            LOG.debug((Object)"Can not get group calendar id", (Throwable)e);
                        }
                    }
                }
                if (calendarId == null && this.getUICheckBoxInput(component.getId()) != null) {
                    this.getUICheckBoxInput(component.getId()).setChecked(false);
                    continue;
                }
                if (this.getUICheckBoxInput(component.getId()) == null) continue;
                if (this.isCalendarOfSpace(calendarId)) {
                    this.getUICheckBoxInput(component.getId()).setChecked(true);
                    continue;
                }
                this.getUICheckBoxInput(component.getId()).setChecked(false);
            }
            return;
        }
        for (UIComponent cpm : this.getChildren()) {
            this.getUICheckBoxInput(cpm.getId()).setChecked(true);
        }
    }

    public List<String> getCheckedCalendars() {
        ArrayList<String> list = new ArrayList<String>();
        for (UIComponent cpm : this.getChildren()) {
            UICheckBoxInput checkbox;
            if (!(cpm instanceof UICheckBoxInput) || !(checkbox = (UICheckBoxInput)cpm).isChecked()) continue;
            list.add(cpm.getId());
        }
        return list;
    }

    public String[] getCheckedPublicCalendars() {
        List lstCheck = this.getCheckedCalendars();
        ArrayList<String> lstReturn = new ArrayList<String>();
        String[] publicCal = this.getPublicCalendarIds();
        if (publicCal != null && publicCal.length > 0) {
            for (String calId : publicCal) {
                if (!lstCheck.contains(calId)) continue;
                lstReturn.add(calId);
            }
        }
        return lstReturn.toArray(new String[lstReturn.size()]);
    }

    public EventQuery getEventQuery(EventQuery eventQuery) throws Exception {
        List checkedCals = this.getCheckedCalendars();
        ArrayList<String> calendarIds = new ArrayList<String>();
        for (Calendar cal : this.getAllPrivateCalendars()) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        for (GroupCalendarData calendarData : this.getPublicCalendars()) {
            for (Calendar calendar : calendarData.getCalendars()) {
                if (!checkedCals.contains(calendar.getId())) continue;
                calendarIds.add(calendar.getId());
            }
        }
        GroupCalendarData sharedCalendars = this.getSharedCalendars();
        if (sharedCalendars != null) {
            for (Calendar cal : sharedCalendars.getCalendars()) {
                if (!checkedCals.contains(cal.getId())) continue;
                calendarIds.add(cal.getId());
            }
        }
        if (calendarIds.size() > 0) {
            eventQuery.setCalendarId(calendarIds.toArray(new String[0]));
        } else {
            eventQuery.setCalendarId(new String[]{"null"});
        }
        eventQuery.setOrderBy(new String[]{Utils.EXO_SUMMARY});
        return eventQuery;
    }

    public List<Calendar> getAllPrivateCalendars() throws Exception {
        boolean filterFromSetting;
        String username;
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List calendars = calendarService.getUserCalendars(username = CalendarUtils.getCurrentUser(), filterFromSetting = false);
        if (calendars.size() == 0) {
            return new ArrayList<Calendar>(0);
        }
        if (calendars != null) {
            for (Calendar calendar : calendars) {
                this.colorMap_.put(UICalendars.buildId((int)0, (String)calendar.getId()), calendar.getCalendarColor());
                UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
                if (checkbox == null) {
                    checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                    checkbox.setChecked(this.isCalendarOfSpace(calendar.getId()));
                    this.addUIFormInput((UIFormInput)checkbox);
                    continue;
                }
                this.setCheckedCheckbox(checkbox, calendar);
            }
        }
        return calendars;
    }

    private void setCheckedCheckbox(UICheckBoxInput checkbox, Calendar calendar) {
        UICalendarPortlet calendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)calendarPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
        boolean isListView = false;
        if (UICalendarViewContainer.LIST_VIEW.equals(uiViewContainer.getCurrentViewType())) {
            isListView = true;
        }
        if (isListView) {
            checkbox.setChecked(checkbox.isChecked());
        } else {
            checkbox.setChecked(this.isCalendarOfSpace(calendar.getId()));
        }
    }

    protected boolean isCalendarOfSpace(String calendarId) {
        String spaceId = UICalendarPortlet.getSpaceId();
        if (spaceId == null) {
            return true;
        }
        return calendarId.contains(spaceId);
    }

    @Deprecated
    public List<GroupCalendarData> getPublicCalendars() throws Exception {
        String username = CalendarUtils.getCurrentUser();
        String[] groups = CalendarUtils.getUserGroups((String)username);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List groupCalendars = calendarService.getGroupCalendars(groups, false, username);
        HashMap<String, String> map = new HashMap<String, String>();
        for (GroupCalendarData group : groupCalendars) {
            List calendars = group.getCalendars();
            for (Calendar calendar : calendars) {
                map.put(calendar.getId(), calendar.getId());
                this.colorMap_.put(UICalendars.buildId((int)2, (String)calendar.getId()), calendar.getCalendarColor());
                UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
                if (checkbox == null) {
                    checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                    checkbox.setChecked(this.isCalendarOfSpace(calendar.getId()));
                    this.addUIFormInput((UIFormInput)checkbox);
                    continue;
                }
                this.setCheckedCheckbox(checkbox, calendar);
            }
        }
        return groupCalendars;
    }

    private UIActionBar getUIActionBar() {
        return (UIActionBar)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getChild(UIActionBar.class);
    }

    private boolean hasFilteredCalendar() throws Exception {
        UICalendarPortlet portlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        CalendarSetting calendarSetting = portlet.getCalendarSetting();
        return calendarSetting.getFilterPrivateCalendars().length != 0 || calendarSetting.getFilterSharedCalendars().length != 0 || calendarSetting.getFilterPublicCalendars().length != 0;
    }

    public List<Calendar> getAllPublicCalendars() throws Exception {
        boolean filterFromSetting;
        String username = CalendarUtils.getCurrentUser();
        String[] groups = CalendarUtils.getUserGroups((String)username);
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List groupCalendars = calendarService.getGroupCalendars(groups, filterFromSetting = false, username);
        if (groupCalendars.size() == 0) {
            return new ArrayList<Calendar>(0);
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ArrayList calendars = new ArrayList();
        for (GroupCalendarData group : groupCalendars) {
            calendars.addAll(group.getCalendars());
            for (Calendar calendar : calendars) {
                map.put(calendar.getId(), calendar.getId());
                this.colorMap_.put(UICalendars.buildId((int)2, (String)calendar.getId()), calendar.getCalendarColor());
                UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
                if (checkbox == null) {
                    checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                    checkbox.setChecked(this.isCalendarOfSpace(calendar.getId()));
                    this.addUIFormInput((UIFormInput)checkbox);
                    continue;
                }
                this.setCheckedCheckbox(checkbox, calendar);
            }
        }
        return new ArrayList<Calendar>(new HashSet(calendars));
    }

    public String[] getPublicCalendarIds() {
        try {
            String userId = CalendarUtils.getCurrentUser();
            String[] groups = CalendarUtils.getUserGroups((String)userId);
            if (UICalendarPortlet.isInSpace()) {
                groups = new String[]{UICalendarPortlet.getGroupIdOfSpace()};
            }
            CalendarService calendarService = CalendarUtils.getCalendarService();
            HashSet<String> set = new HashSet<String>();
            for (GroupCalendarData group : calendarService.getGroupCalendars(groups, false, userId)) {
                for (Calendar calendar : group.getCalendars()) {
                    set.add(calendar.getId());
                    this.colorMap_.put(UICalendars.buildId((int)2, (String)calendar.getId()), calendar.getCalendarColor());
                }
            }
            return set.toArray(new String[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    public GroupCalendarData getSharedCalendars() throws Exception {
        CalendarService calendarService = CalendarUtils.getCalendarService();
        boolean filterFromSetting = false;
        GroupCalendarData groupCalendars = calendarService.getSharedCalendars(CalendarUtils.getCurrentUser(), filterFromSetting);
        if (groupCalendars == null) {
            return new GroupCalendarData("", "", new ArrayList(0));
        }
        CalendarSetting setting = calendarService.getCalendarSetting(CalendarUtils.getCurrentUser());
        HashMap<String, String> map = new HashMap<String, String>();
        for (String key : setting.getSharedCalendarsColors()) {
            map.put(key.split(CalendarUtils.COLON)[0], key.split(CalendarUtils.COLON)[1]);
        }
        List calendars = groupCalendars.getCalendars();
        for (Calendar calendar : calendars) {
            String color = (String)map.get(calendar.getId());
            if (color == null) {
                color = calendar.getCalendarColor();
            }
            this.colorMap_.put(UICalendars.buildId((int)1, (String)calendar.getId()), color);
            UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
            if (checkbox == null) {
                checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
                checkbox.setChecked(this.isCalendarOfSpace(calendar.getId()));
                this.addUIFormInput((UIFormInput)checkbox);
                continue;
            }
            this.setCheckedCheckbox(checkbox, calendar);
        }
        return groupCalendars;
    }

    public static String buildId(int calTye, String calId) {
        return new StringBuffer(String.valueOf(calTye)).append(CalendarUtils.COLON).append(calId).toString();
    }

    private String truncateLongName(String longName) {
        if (longName.length() < 17) {
            return longName;
        }
        int secondWhiteSpacePos = this.getPositionOfSecondWhiteSpaceFrom(longName);
        if (-1 < secondWhiteSpacePos && secondWhiteSpacePos < 20) {
            return longName.substring(0, secondWhiteSpacePos);
        }
        if (longName.length() > 20) {
            return longName.substring(0, 17) + "...";
        }
        return longName;
    }

    private int getPositionOfSecondWhiteSpaceFrom(String name) {
        int firstWhiteSpacePos = name.indexOf(" ");
        if (firstWhiteSpacePos == -1) {
            return -1;
        }
        int secondWhiteSpacePos = name.indexOf(" ", firstWhiteSpacePos + 1);
        if (secondWhiteSpacePos == -1) {
            return -1;
        }
        return secondWhiteSpacePos;
    }

    public LinkedHashMap<String, String> getColorMap() {
        return this.colorMap_;
    }

    public String[] getColors() {
        return UIFormColorPicker.Colors.COLORNAMES;
    }

    private boolean canAddTaskAndEvent(UICalendars uiComponent, String calendarId, String calType) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        Calendar calendar = null;
        String currentUser = CalendarUtils.getCurrentUser();
        if (calType.equals(CalendarUtils.SHARED_TYPE)) {
            calendar = calService.getSharedCalendars(currentUser, true).getCalendarById(calendarId);
            return CalendarUtils.canEdit(null, (String[])Utils.getEditPerUsers((Calendar)calendar), (String)currentUser);
        }
        if (calType.equals(CalendarUtils.PUBLIC_TYPE)) {
            calendar = calService.getGroupCalendar(calendarId);
            return CalendarUtils.canEdit((OrganizationService)((OrganizationService)uiComponent.getApplicationComponent(OrganizationService.class)), (String[])calendar.getEditPermission(), (String)currentUser);
        }
        return false;
    }

    public boolean canEdit(String[] savePerms, String[] checkPerms) throws Exception {
        return CalendarUtils.hasEditPermission((String[])savePerms, (String[])checkPerms);
    }

    public String getCheckPermissionString() throws Exception {
        return CalendarUtils.getCheckPermissionString();
    }

    public boolean isRemoteCalendar(String calendarId) throws Exception {
        String username = CalendarUtils.getCurrentUser();
        CalendarService calService = CalendarUtils.getCalendarService();
        return calService.isRemoteCalendar(username, calendarId);
    }

    private void updateView(UICalendars uiComponent, Event<UICalendars> event) throws Exception {
        UIListContainer list;
        UIListView uiListView;
        UICalendarPortlet uiPortlet = (UICalendarPortlet)uiComponent.getAncestorOfType(UICalendarPortlet.class);
        UICalendarViewContainer uiViewContainer = (UICalendarViewContainer)uiPortlet.findFirstComponentOfType(UICalendarViewContainer.class);
        if (uiViewContainer.getRenderedChild() instanceof UIListContainer && (uiListView = (UIListView)(list = (UIListContainer)uiViewContainer.getRenderedChild()).getChild(UIListView.class)).isDisplaySearchResult()) {
            uiListView.setDisplaySearchResult(false);
            uiListView.setCategoryId(null);
            uiListView.refresh();
            uiListView.setLastViewId(null);
            UISearchForm uiSearchForm = (UISearchForm)uiPortlet.findFirstComponentOfType(UISearchForm.class);
            uiSearchForm.reset();
            UIActionBar uiActionBar = (UIActionBar)uiPortlet.findFirstComponentOfType(UIActionBar.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchForm);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionBar);
        }
    }

    static /* synthetic */ boolean access$000(UICalendars x0, UICalendars x1, String x2, String x3) throws Exception {
        return x0.canAddTaskAndEvent(x1, x2, x3);
    }

    static /* synthetic */ void access$100(UICalendars x0, UICalendars x1, Event x2) throws Exception {
        x0.updateView(x1, x2);
    }

    static /* synthetic */ Log access$200() {
        return LOG;
    }
}

