/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UIPopupContainer;
import org.exoplatform.calendar.webui.popup.UIRepeatEventForm;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormHiddenInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

/*
 * Exception performing whole class analysis ignored.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIRepeatEventForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UIRepeatEventForm
extends UIForm
implements UIPopupComponent {
    private static final Log log = ExoLogger.getExoLogger(UIRepeatEventForm.class);
    public static final String FIELD_REPEAT_TYPE = "repeatType";
    public static final String FIELD_INTERVAL = "interval";
    public static final String FIELD_WEEKLY_BYDAY = "weeklyByDay";
    public static final String FIELD_MONTHLY_TYPE = "monthlyType";
    public static final String FIELD_END_REPEAT = "endRepeat";
    public static final String FIELD_END_BYDATE = "endDate";
    public static final String FIELD_END_AFTER = "endAfterNumber";
    public static final String OCCURRENCES = "occurrences";
    public static final String RP_END_BYDATE = "endByDate";
    public static final String RP_END_AFTER = "endAfter";
    public static final String RP_END_NEVER = "neverEnd";
    public static final String RP_MONTHLY_BYDAY = "monthlyByDay";
    public static final String RP_MONTHLY_BYMONTHDAY = "monthlyByMonthDay";
    private Date startDate;

    public UIRepeatEventForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("repeatType", "repeatType", this.getRepeatTypeOptions()));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox("interval", "interval", this.getIntervalOptions()));
        ArrayList<SelectItemOption> monthlyTypes = new ArrayList<SelectItemOption>();
        monthlyTypes.add(new SelectItemOption("monthlyByMonthDay", (Object)"monthlyByMonthDay"));
        monthlyTypes.add(new SelectItemOption("monthlyByDay", (Object)"monthlyByDay"));
        UIFormRadioBoxInput monthlyType = new UIFormRadioBoxInput("monthlyType", "monthlyType", monthlyTypes);
        this.addUIFormInput((UIFormInput)monthlyType);
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        DateFormatSymbols symbols = new DateFormatSymbols(locale);
        String[] dayNames = symbols.getWeekdays();
        for (int i = 0; i < 7; ++i) {
            UICheckBoxInput checkbox = new UICheckBoxInput(CalendarEvent.RP_WEEKLY_BYDAY[i], CalendarEvent.RP_WEEKLY_BYDAY[i], Boolean.valueOf(false));
            int dayOfWeek = UIRepeatEventForm.convertToDayOfWeek((String)CalendarEvent.RP_WEEKLY_BYDAY[i]);
            checkbox.setLabel(dayNames[dayOfWeek].substring(0, 2).toUpperCase());
            this.addUIFormInput((UIFormInput)checkbox);
        }
        this.addUIFormInput((UIFormInput)new UIFormStringInput("endAfterNumber", "endAfterNumber", null));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker("endDate", "endDate", new Date(), false));
        this.addUIFormInput((UIFormInput)new UIFormHiddenInput("endRepeat", "endRepeat"));
    }

    public void init(CalendarEvent event) throws Exception {
        block23: {
            try {
                String repeatType;
                if (event == null) {
                    this.setRepeatType(CalendarEvent.RP_DAILY);
                    this.setInterval("1");
                    this.setEndType("neverEnd");
                    UIPopupContainer uiContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
                    UIEventForm uiEventForm = (UIEventForm)uiContainer.getChild(UIEventForm.class);
                    CalendarSetting calSetting = CalendarUtils.getCurrentUserCalendarSetting();
                    this.startDate = uiEventForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
                    if (this.startDate == null) {
                        this.startDate = CalendarUtils.getInstanceOfCurrentCalendar().getTime();
                    }
                    Calendar start = CalendarUtils.getInstanceOfCurrentCalendar();
                    start.setTime(this.startDate);
                    int dayOfWeek = start.get(7);
                    this.setWeeklyByDay(UIRepeatEventForm.convertToDayOfWeek((int)dayOfWeek));
                    this.setMonthlyType("monthlyByMonthDay");
                    this.setEndAfter("5");
                    Calendar until = (Calendar)start.clone();
                    until.add(5, 5);
                    this.setEndDate(until.getTime(), calSetting.getDateFormat());
                    return;
                }
                UIPopupContainer uiContainer = (UIPopupContainer)this.getAncestorOfType(UIPopupContainer.class);
                UIEventForm uiEventForm = (UIEventForm)uiContainer.getChild(UIEventForm.class);
                CalendarSetting calSetting = CalendarUtils.getCurrentUserCalendarSetting();
                this.startDate = uiEventForm.getEventFromDate(calSetting.getDateFormat(), calSetting.getTimeFormat());
                if (this.startDate == null) {
                    this.startDate = event.getFromDateTime();
                }
                if ((repeatType = event.getRepeatType()) != null && !repeatType.equals(CalendarEvent.RP_NOREPEAT)) {
                    this.setRepeatType(repeatType);
                } else {
                    this.setRepeatType(CalendarEvent.RP_DAILY);
                }
                long interval = event.getRepeatInterval();
                if (interval > 0L) {
                    this.setInterval(String.valueOf(interval));
                } else {
                    this.setInterval("1");
                }
                if (CalendarEvent.RP_WEEKLY.equals(repeatType)) {
                    String[] weeklyByDay = event.getRepeatByDay();
                    if (weeklyByDay != null && weeklyByDay.length > 0) {
                        for (String s : weeklyByDay) {
                            this.setWeeklyByDay(s);
                        }
                    } else {
                        Calendar start = CalendarUtils.getInstanceOfCurrentCalendar();
                        start.setTime(this.startDate);
                        int dayOfWeek = start.get(7);
                        this.setWeeklyByDay(UIRepeatEventForm.convertToDayOfWeek((int)dayOfWeek));
                    }
                } else {
                    Calendar start = CalendarUtils.getInstanceOfCurrentCalendar();
                    start.setTime(this.startDate);
                    int dayOfWeek = start.get(7);
                    this.setWeeklyByDay(UIRepeatEventForm.convertToDayOfWeek((int)dayOfWeek));
                }
                if (CalendarEvent.RP_MONTHLY.equals(repeatType)) {
                    String[] monthlyByDay = event.getRepeatByDay();
                    if (monthlyByDay != null && monthlyByDay.length > 0) {
                        this.setMonthlyType("monthlyByDay");
                    } else {
                        this.setMonthlyType("monthlyByMonthDay");
                    }
                } else {
                    this.setMonthlyType("monthlyByMonthDay");
                }
                String endType = "neverEnd";
                if (event.getRepeatCount() > 0L) {
                    endType = "endAfter";
                } else if (event.getRepeatUntilDate() != null) {
                    endType = "endByDate";
                }
                this.setEndType(endType);
                if (endType.equals("endAfter")) {
                    int count = (int)event.getRepeatCount();
                    this.setEndAfter(String.valueOf(count));
                }
                if (endType.equals("endByDate")) {
                    Date endDate = event.getRepeatUntilDate();
                    this.setEndDate(endDate, calSetting.getDateFormat());
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block23;
                log.debug((Object)"Exception occur when init the UIRepeatEventForm", (Throwable)e);
            }
        }
    }

    public List<SelectItemOption<String>> getRepeatTypeOptions() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (int i = 1; i < CalendarEvent.REPEATTYPES.length; ++i) {
            options.add((SelectItemOption<String>)new SelectItemOption(CalendarEvent.REPEATTYPES[i], (Object)CalendarEvent.REPEATTYPES[i]));
        }
        return options;
    }

    public List<SelectItemOption<String>> getIntervalOptions() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (int i = 1; i <= 30; ++i) {
            options.add((SelectItemOption<String>)new SelectItemOption(String.valueOf(i), (Object)String.valueOf(i)));
        }
        return options;
    }

    protected void setRepeatType(String value) {
        this.getUIFormSelectBox("repeatType").setValue(value);
    }

    protected String getRepeatType() {
        return (String)this.getUIFormSelectBox("repeatType").getValue();
    }

    protected void setInterval(String value) {
        this.getUIFormSelectBox("interval").setValue(value);
    }

    protected String getInterval() {
        return (String)this.getUIFormSelectBox("interval").getValue();
    }

    protected void setWeeklyByDay(String value) {
        UICheckBoxInput checkbox = this.getUICheckBoxInput(value);
        checkbox.setChecked(true);
    }

    protected List<String> getWeeklyByDay() {
        ArrayList<String> byDays = new ArrayList<String>();
        for (int i = 0; i < 7; ++i) {
            UICheckBoxInput checkbox = this.getUICheckBoxInput(CalendarEvent.RP_WEEKLY_BYDAY[i]);
            if (!checkbox.isChecked()) continue;
            byDays.add(CalendarEvent.RP_WEEKLY_BYDAY[i]);
        }
        return byDays;
    }

    protected void setMonthlyType(String value) {
        UIFormRadioBoxInput monthlyType = (UIFormRadioBoxInput)this.findComponentById("monthlyType");
        monthlyType.setValue((Object)value);
    }

    protected String getMonthlyType() {
        UIFormRadioBoxInput monthlyType = (UIFormRadioBoxInput)this.findComponentById("monthlyType");
        return (String)monthlyType.getValue();
    }

    protected String getEndType() {
        return (String)((UIFormHiddenInput)this.getChild(UIFormHiddenInput.class)).getValue();
    }

    protected void setEndType(String value) {
        ((UIFormHiddenInput)this.getChild(UIFormHiddenInput.class)).setValue((Object)value);
    }

    protected void setEndAfter(String value) {
        this.getUIStringInput("endAfterNumber").setValue((Object)value);
    }

    protected String getEndAfter() {
        return (String)this.getUIStringInput("endAfterNumber").getValue();
    }

    protected String getEndDate() {
        UIFormDateTimePicker endDate = (UIFormDateTimePicker)this.getChildById("endDate");
        return (String)endDate.getValue();
    }

    protected Date getEndDate(String dateFormat) throws Exception {
        UIFormDateTimePicker endDate = (UIFormDateTimePicker)this.getChildById("endDate");
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        return df.parse((String)endDate.getValue());
    }

    protected void setEndDate(Date date, String dateFormat) {
        UIFormDateTimePicker endDate = (UIFormDateTimePicker)this.getChildById("endDate");
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        SimpleDateFormat df = new SimpleDateFormat(dateFormat, locale);
        df.setCalendar(CalendarUtils.getInstanceOfCurrentCalendar());
        endDate.setValue((Object)df.format(date));
    }

    public static int convertToDayOfWeek(String day) {
        int dayOfWeek = day.equals("MO") ? 2 : (day.equals("TU") ? 3 : (day.equals("WE") ? 4 : (day.equals("TH") ? 5 : (day.equals("FR") ? 6 : (day.equals("SA") ? 7 : (day.equals("SU") ? 1 : 0))))));
        return dayOfWeek;
    }

    public static String convertToDayOfWeek(int day) {
        String dayOfWeek = day == 1 ? "SU" : (day == 2 ? "MO" : (day == 3 ? "TU" : (day == 4 ? "WE" : (day == 5 ? "TH" : (day == 6 ? "FR" : (day == 7 ? "SA" : null))))));
        return dayOfWeek;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    static /* synthetic */ Date access$000(UIRepeatEventForm x0) {
        return x0.startDate;
    }
}

