/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.calendar.webui.UIFormColorPicker;
import org.exoplatform.commons.utils.HTMLEntityEncoder;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputBase;

public class UIFormColorPicker
extends UIFormInputBase<String> {
    private int items_ = 10;
    private String onchange_;
    public static final String ON_CHANGE = "onchange".intern();
    public static final String ON_BLUR = "onblur".intern();
    public static final String ON_FOCUS = "onfocus".intern();
    public static final String ON_KEYUP = "onkeyup".intern();
    public static final String ON_KEYDOWN = "onkeydown".intern();
    public static final String ON_CLICK = "onclick".intern();
    private Map<String, String> jsActions_ = new HashMap();
    private Colors.Color[] colors_ = null;

    public UIFormColorPicker(String name, String bindingExpression, String value) {
        super(name, bindingExpression, String.class);
        this.value_ = value;
        this.setColors(Colors.COLORS);
    }

    public UIFormColorPicker(String name, String bindingExpression, Colors.Color[] colors) {
        super(name, bindingExpression, null);
        this.setColors(colors);
    }

    public void setJsActions(Map<String, String> jsActions) {
        if (jsActions != null) {
            this.jsActions_ = jsActions;
        }
    }

    public Map<String, String> getJsActions() {
        return this.jsActions_;
    }

    public void addJsActions(String action, String javaScript) {
        this.jsActions_.put(action, javaScript);
    }

    public UIFormColorPicker(String name, String bindingExpression, Colors.Color[] colors, Map<String, String> jsActions) {
        super(name, bindingExpression, null);
        this.setColors(colors);
        this.setJsActions(jsActions);
    }

    public UIFormColorPicker(String name, String value) {
        this(name, null, value);
    }

    public void decode(Object input, WebuiRequestContext context) {
        this.value_ = (String)input;
        if (this.value_ != null && ((String)this.value_).trim().length() == 0) {
            this.value_ = null;
        }
    }

    public void setOnChange(String onchange) {
        this.onchange_ = onchange;
    }

    protected String renderOnChangeEvent(UIForm uiForm) throws Exception {
        return uiForm.event(this.onchange_, (String)null);
    }

    protected UIForm getUIform() {
        return (UIForm)this.getAncestorOfType(UIForm.class);
    }

    private String renderJsActions() {
        StringBuffer sb = new StringBuffer("");
        for (String k : this.jsActions_.keySet()) {
            if (sb != null && sb.length() > 0) {
                sb.append(" ");
            }
            if (this.jsActions_.get(k) == null) continue;
            sb.append(k).append("=\"").append((String)this.jsActions_.get(k)).append("\"");
        }
        return sb.toString();
    }

    private Colors.Color[] getColors() {
        return this.colors_;
    }

    private void setColors(Colors.Color[] colors) {
        this.colors_ = colors;
        this.value_ = this.colors_[0].getName();
    }

    private int items() {
        return this.items_;
    }

    private int size() {
        return this.colors_.length;
    }

    public void setNumberItemsPerLine(int numberItems) {
        this.items_ = numberItems;
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        JavascriptManager jsManager = context.getJavascriptManager();
        RequireJS requireJS = jsManager.getRequireJS();
        requireJS.require("SHARED/jquery", "gj");
        requireJS.require("SHARED/bts_dropdown", "btsdropdown");
        requireJS.require("PORTLET/calendar/CalendarPortlet", "cal");
        requireJS.addScripts("gj(document).ready(function() { gj('div.uiColorPickerInput').click(function(){ cal.UIColorPicker.adaptPopup(this); }); });");
        requireJS.addScripts("gj('a.colorCell').click(function(){ cal.UIColorPicker.setColor(this); });");
        String value = (String)this.getValue();
        if (value != null) {
            value = HTMLEntityEncoder.getInstance().encode(value);
        }
        Writer w = context.getWriter();
        w.write("<div class='uiFormColorPicker dropdown'>");
        w.write("<div class=\"uiColorPickerInput dropdown-toggle\" data-toggle=\"dropdown\">");
        w.write("<span class=\" displayValue " + value + "\"><span><b class=\"caret\"></b></span></span>");
        w.write("</div>");
        w.write("<ul class='calendarTableColor dropdown-menu' role=\"menu\" selectedColor=\"" + value + " \">");
        int items = 6;
        int size = this.getColors().length;
        int rows = size / items;
        int count = 0;
        for (int i = 0; i < rows; ++i) {
            w.write("<li class=\"clearfix\">");
            for (int j = 0; j < items && count < size; ++count, ++j) {
                Colors.Color color = this.getColors()[count];
                w.write("<a href=\"javascript:void(0);");
                w.write("\" class=\"");
                w.write(color.getName());
                w.write(" colorCell \" onmousedown=\"event.cancelBubble=true\"><i class=\"");
                if (color.getName().equals(value)) {
                    w.write("iconCheckBox");
                }
                w.write("\"></i></a>");
            }
            w.write("</li>");
        }
        w.write("</ul>");
        w.write("<input class='uiColorPickerValue' name='" + this.getId() + "' type='hidden'" + " id='" + this.getId() + "' " + this.renderJsActions());
        if (value != null && value.trim().length() > 0) {
            w.write(" value='" + value + "'");
        }
        w.write(" />");
        w.write("</div>");
    }

    public UIFormInput setValue(String arg0) {
        if (arg0 == null) {
            arg0 = this.colors_[0].getName();
        }
        return super.setValue((Object)arg0);
    }
}

