/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.webui.popup.UIAddressForm;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIPopup/UIAddressForm.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={ReplaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ShowPageActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeGroupActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UIAddressForm
extends UIForm
implements UIPopupComponent {
    public static final String FIELD_KEYWORD = "keyWord".intern();
    public static final String FIELD_GROUP = "group".intern();
    private String recipientsType = "";
    protected String selectedAddressId_ = "";
    private UIPageIterator uiPageIterator_;
    protected String[] actions_ = new String[]{"Add", "Replace", "Cancel"};
    public List<String> checkedList_ = new ArrayList();

    public void setRecipientsType(String type) {
        this.recipientsType = type;
    }

    public String getRecipientType() {
        return this.recipientsType;
    }

    public UIAddressForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_KEYWORD, FIELD_KEYWORD, null));
        UIFormSelectBox fieldGroup = new UIFormSelectBox(FIELD_GROUP, FIELD_GROUP, this.getGroups());
        fieldGroup.setOnChange("ChangeGroup");
        this.addUIFormInput((UIFormInput)fieldGroup);
        this.uiPageIterator_ = new UIPageIterator();
        this.uiPageIterator_.setId("UICalendarAddressPage");
    }

    private List<SelectItemOption<String>> getGroups() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        OrganizationService oService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        options.add(new SelectItemOption("all", (Object)""));
        Collection groups = oService.getGroupHandler().findGroupsOfUser(CalendarUtils.getCurrentUser());
        for (Group g : groups) {
            ListAccess users = oService.getUserHandler().findUsersByGroupId(g.getId());
            for (User u : (User[])users.load(0, users.getSize())) {
                options.add((SelectItemOption<String>)new SelectItemOption(u.getUserName(), (Object)u.getUserName()));
            }
        }
        return options;
    }

    public String[] getActions() {
        return this.actions_;
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
        this.actions_ = new String[]{"Add", "Replace", "Cancel"};
    }

    public List<ContactData> getContacts() throws Exception {
        for (String id : this.checkedList_) {
            UICheckBoxInput uiInput = this.getUICheckBoxInput(id);
            if (uiInput == null) continue;
            uiInput.setChecked(true);
        }
        return new ArrayList<ContactData>(this.uiPageIterator_.getCurrentPageData());
    }

    public List<ContactData> getContactList() {
        try {
            return this.uiPageIterator_.getPageList().getAll();
        }
        catch (Exception e) {
            return new ArrayList<ContactData>();
        }
    }

    public void setContactList(List<ContactData> contactList) throws Exception {
        this.getUIFormSelectBox(FIELD_GROUP).setOptions(this.getGroups());
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(ContactData.class, contactList), 10);
        this.uiPageIterator_.setPageList((PageList)pageList);
        for (ContactData contact : contactList) {
            UICheckBoxInput uiCheckbox = this.getUICheckBoxInput(contact.getId());
            if (uiCheckbox != null) continue;
            uiCheckbox = new UICheckBoxInput(contact.getId(), contact.getId(), Boolean.valueOf(false));
            this.addUIFormInput((UIFormInput)uiCheckbox);
        }
    }

    public List<ContactData> getCheckedContact() throws Exception {
        ArrayList<ContactData> contactList = new ArrayList<ContactData>();
        for (ContactData contact : new ArrayList(this.uiPageIterator_.getCurrentPageData())) {
            UICheckBoxInput uiCheckbox = (UICheckBoxInput)this.getChildById(contact.getId());
            if (uiCheckbox == null || !uiCheckbox.isChecked()) continue;
            contactList.add(contact);
        }
        return contactList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public long getAvailablePage() {
        return this.uiPageIterator_.getAvailablePage();
    }

    public long getCurrentPage() {
        return this.uiPageIterator_.getCurrentPage();
    }

    protected void updateCurrentPage(int page) throws Exception {
        this.uiPageIterator_.setCurrentPage(page);
    }
}

