/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.webui.UIFormDateTimePicker;
import org.exoplatform.calendar.webui.popup.UIEventDetailTab;
import org.exoplatform.calendar.webui.popup.UIEventForm;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.cssfile.CssClassUtils;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormSelectBoxWithGroups;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.ext.UIFormComboBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UIEventDetailTab.gtmpl")
public class UIEventDetailTab
extends UIFormInputWithActions {
    public static final String FIELD_MESSAGE = "messageName".intern();
    public static final String FIELD_EVENT = "eventName".intern();
    public static final String FIELD_CALENDAR = "calendar".intern();
    public static final String FIELD_CATEGORY = "category".intern();
    public static final String FIELD_FROM = "from".intern();
    public static final String FIELD_TO = "to".intern();
    public static final String FIELD_FROM_TIME = "fromTime".intern();
    public static final String FIELD_TO_TIME = "toTime".intern();
    public static final String FIELD_CHECKALL = "allDay".intern();
    public static final String FIELD_REPEAT = "repeat".intern();
    public static final String FIELD_ISREPEAT = "isRepeat".intern();
    public static final String FIELD_REPEAT_UNTIL = "repeatUntil".intern();
    public static final String FIELD_PLACE = "place".intern();
    public static final String FIELD_PRIORITY = "priority".intern();
    public static final String FIELD_DESCRIPTION = "description".intern();
    public static final String FIELD_ATTACHMENTS = "attachments".intern();
    public static final String LABEL_ADD_ATTACHMENTS = "addfiles";
    protected List<Attachment> attachments_ = new ArrayList();
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_;

    public UIEventDetailTab(String id) throws Exception {
        super(id);
        this.setComponentConfig(this.getClass(), null);
        ArrayList options = new ArrayList();
        this.actionField_ = new HashMap();
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_EVENT, FIELD_EVENT, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(FIELD_DESCRIPTION, FIELD_DESCRIPTION, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBoxWithGroups(FIELD_CALENDAR, FIELD_CALENDAR, null));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_CATEGORY, FIELD_CATEGORY, CalendarUtils.getCategory()));
        UIFormInputWithActions.ActionData addCategoryAction = new UIFormInputWithActions.ActionData();
        addCategoryAction.setActionType(0);
        addCategoryAction.setCssIconClass("uiIconPlus uiIconLightGray");
        addCategoryAction.setActionName(UIEventForm.ACT_ADDCATEGORY);
        addCategoryAction.setActionListener(UIEventForm.ACT_ADDCATEGORY);
        ArrayList<UIFormInputWithActions.ActionData> addCategoryActions = new ArrayList<UIFormInputWithActions.ActionData>();
        addCategoryActions.add(addCategoryAction);
        this.setActionField(FIELD_CATEGORY, addCategoryActions);
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(FIELD_ATTACHMENTS, FIELD_ATTACHMENTS, null));
        this.setActionField(FIELD_ATTACHMENTS, this.getAttachmentData());
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_FROM_TIME, FIELD_FROM_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormComboBox(FIELD_TO_TIME, FIELD_TO_TIME, options));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_FROM, FIELD_FROM, new Date(), false));
        this.addUIFormInput((UIFormInput)new UIFormDateTimePicker(FIELD_TO, FIELD_TO, new Date(), false));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_CHECKALL, FIELD_CHECKALL, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_PLACE, FIELD_PLACE, null));
        this.addUIFormInput((UIFormInput)new UICheckBoxInput(FIELD_ISREPEAT, FIELD_ISREPEAT, Boolean.valueOf(false)));
        UIFormInputWithActions.ActionData editRepeatAction = new UIFormInputWithActions.ActionData();
        editRepeatAction.setActionType(0);
        editRepeatAction.setCssIconClass("uiIconEdit uiIconLightGray");
        editRepeatAction.setActionName(UIEventForm.ACT_EDITREPEAT);
        editRepeatAction.setActionListener(UIEventForm.ACT_EDITREPEAT);
        ArrayList<UIFormInputWithActions.ActionData> editRepeatActions = new ArrayList<UIFormInputWithActions.ActionData>();
        editRepeatActions.add(editRepeatAction);
        this.setActionField(FIELD_ISREPEAT, editRepeatActions);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_PRIORITY, FIELD_PRIORITY, this.getPriority()));
        UIFormInputWithActions.ActionData addEmailAddress = new UIFormInputWithActions.ActionData();
        addEmailAddress.setActionType(0);
        addEmailAddress.setActionName(UIEventForm.ACT_ADDEMAIL);
        addEmailAddress.setActionListener(UIEventForm.ACT_ADDEMAIL);
        ArrayList<UIFormInputWithActions.ActionData> addMailActions = new ArrayList<UIFormInputWithActions.ActionData>();
        addMailActions.add(addEmailAddress);
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public List<UIFormInputWithActions.ActionData> getAttachmentData() throws Exception {
        ArrayList<UIFormInputWithActions.ActionData> attachmentData = new ArrayList<UIFormInputWithActions.ActionData>();
        for (Attachment attachment : this.attachments_) {
            FileActionData fileUpload = new FileActionData();
            fileUpload.setActionListener(UIEventForm.ACT_DOWNLOAD);
            fileUpload.setActionParameter(attachment.getId());
            fileUpload.setActionType(1);
            fileUpload.setCssIconClass(CssClassUtils.getCSSClassByFileNameAndFileType((String)attachment.getName(), (String)attachment.getMimeType(), null));
            fileUpload.setActionName(attachment.getName());
            fileUpload.setFileSize(CalendarUtils.convertSize((long)attachment.getSize()));
            fileUpload.setShowLabel(true);
            attachmentData.add((UIFormInputWithActions.ActionData)fileUpload);
            FileActionData removeAction = new FileActionData();
            removeAction.setActionListener(UIEventForm.ACT_REMOVE);
            removeAction.setActionName(UIEventForm.ACT_REMOVE);
            removeAction.setActionParameter(attachment.getId());
            removeAction.setActionType(0);
            removeAction.setCssIconClass("uiIconDelete uiIconLightGray");
            removeAction.setBreakLine(true);
            attachmentData.add((UIFormInputWithActions.ActionData)removeAction);
        }
        return attachmentData;
    }

    public void addToUploadFileList(Attachment attachfile) {
        this.attachments_.add(attachfile);
    }

    public void removeFromUploadFileList(Attachment attachfile) {
        this.attachments_.remove(attachfile);
    }

    public void refreshUploadFileList() throws Exception {
        this.setActionField(FIELD_ATTACHMENTS, this.getAttachmentData());
    }

    protected List<Attachment> getAttachments() {
        return this.attachments_;
    }

    protected void setAttachments(List<Attachment> attachment) {
        this.attachments_ = attachment;
    }

    private List<SelectItemOption<String>> getPriority() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption("none", (Object)"none"));
        options.add(new SelectItemOption("normal", (Object)"normal"));
        options.add(new SelectItemOption("high", (Object)"high"));
        options.add(new SelectItemOption("low", (Object)"low"));
        return options;
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    public void processRender(WebuiRequestContext arg0) throws Exception {
        super.processRender(arg0);
    }

    public UIFormComboBox getUIFormComboBox(String id) {
        return (UIFormComboBox)this.findComponentById(id);
    }

    public UIFormDateTimePicker getUIFormDateTimePicker(String id) {
        return (UIFormDateTimePicker)this.findComponentById(id);
    }

    public UIFormSelectBoxWithGroups getUIFormSelectBoxGroup(String id) {
        return (UIFormSelectBoxWithGroups)this.findComponentById(id);
    }

    protected int getTimeShift() {
        try {
            return Integer.parseInt(PropertyManager.getProperty((String)"exo.calendar.default.event.suggest"));
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }
}

