/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.calendar.webui.popup.UISubscribeForm;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.web.application.RequireJS;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.URLValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={NextActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UISubscribeForm
extends UIForm
implements UIPopupComponent {
    private static final String URL = "url".intern();
    private static final String TYPE = "type".intern();

    public UISubscribeForm() throws Exception {
        ArrayList<SelectItemOption> types = new ArrayList<SelectItemOption>();
        types.add(new SelectItemOption("ICalendar(.ics)", (Object)"ICalendar(.ics)"));
        types.add(new SelectItemOption("CalDAV", (Object)"CalDAV"));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(TYPE, TYPE, types));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(URL, URL, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(URLValidator.class, new Object[0]));
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void init(String type, String remoteUrl) {
        this.setType(type);
        this.setUrl(remoteUrl);
    }

    protected void setType(String type) {
        ((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).setValue((Object)type);
    }

    protected String getType() {
        return (String)((UIFormRadioBoxInput)this.getChild(UIFormRadioBoxInput.class)).getValue();
    }

    protected void setUrl(String url) {
        this.getUIStringInput(URL).setValue((Object)url);
    }

    protected String getUrl() {
        return (String)this.getUIStringInput(URL).getValue();
    }

    public String getLabel(String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String label = this.getId() + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            return id;
        }
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        super.processRender(context);
        RequireJS requireJS = context.getJavascriptManager().getRequireJS();
        requireJS.require("PORTLET/calendar/CalendarPortlet", "cal");
        requireJS.addScripts("cal.UICalendarPortlet.autoFocusFirstInput('" + this.getId() + "');");
        requireJS.addScripts("cal.UICalendarPortlet.resizeSubscribeForm('" + this.getId() + "');");
    }

    static /* synthetic */ String access$000() {
        return URL;
    }
}

