/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventPageList;
import org.exoplatform.calendar.service.EventQuery;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.calendar.webui.UIListContainer;
import org.exoplatform.calendar.webui.UIListView;
import org.exoplatform.calendar.webui.UIPreview;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, events={@EventConfig(listeners={UICalendarView.AddEventActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmCloseActionListener.class}), @EventConfig(listeners={UICalendarView.AbortCloseActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteEvent.class}), @EventConfig(listeners={UICalendarView.CancelDeleteEvent.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.EditActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}), @EventConfig(listeners={CloseSearchActionListener.class}), @EventConfig(listeners={ViewDetailActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={ShowPageActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={OnchangeActionListener.class}), @EventConfig(listeners={SortActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteFollowingSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateCancel.class}), @EventConfig(listeners={AdvancedSearchActionListener.class})})
public class UIListView
extends UICalendarView {
    private static final Log log = ExoLogger.getLogger(UIListView.class);
    private LinkedHashMap<String, Event> eventMap_ = new LinkedHashMap();
    private EventPageList pageList_ = null;
    private String selectedEvent_ = null;
    private boolean isShowEventAndTask = true;
    private boolean isSearchResult = false;
    private String lastViewId_ = null;
    private String categoryId_ = null;
    private String keyWords_ = null;
    private int currentPage_ = 0;
    private org.exoplatform.calendar.model.query.EventQuery query = null;
    public static final String EVENT_SUMMARY = "exo:summary";
    public static final String EVENT_PRIORITY = "exo:priority";
    public static final String EVENT_DESCRIPTION = "exo:description";
    public static final String EVENT_START = "exo:fromDateTime";
    public static final String EVENT_END = "exo:toDateTime";
    private String sortedField_ = "exo:summary";
    private boolean isAscending_ = true;
    private boolean calClicked = true;

    public UIListView() throws Exception {
        if (this.getEvents().length > 0) {
            this.selectedEvent_ = this.getEvents()[0].getId();
        }
    }

    public String getTemplate() {
        if (this.getViewType().equals(TYPE_TASK)) {
            return "app:/templates/calendar/webui/UIListTask.gtmpl";
        }
        if (this.getViewType().equals(TYPE_EVENT)) {
            return "app:/templates/calendar/webui/UIListEvent.gtmpl";
        }
        return "app:/templates/calendar/webui/UIListView.gtmpl";
    }

    public void setSortedField(String field) {
        this.sortedField_ = field;
    }

    public String getSortedField() {
        return this.sortedField_;
    }

    public void setIsAscending(boolean b) {
        this.isAscending_ = b;
    }

    public boolean isAscending() {
        return this.isAscending_;
    }

    public void setEventQuery(org.exoplatform.calendar.model.query.EventQuery eventQuery) {
        this.query = eventQuery;
    }

    public org.exoplatform.calendar.model.query.EventQuery getEventQuery() {
        return this.query;
    }

    public void refresh() throws Exception {
        List calendarIds;
        UIListContainer uiListContainer = (UIListContainer)this.getParent();
        this.setCalClicked(true);
        if (uiListContainer.isDisplaySearchResult()) {
            return;
        }
        this.query = new org.exoplatform.calendar.model.query.EventQuery();
        this.query.setOwner(CalendarUtils.getCurrentUser());
        if (!(CalendarUtils.isEmpty((String)this.categoryId_) || this.categoryId_.toLowerCase().equals("null") || this.categoryId_.equals("calId") || this.categoryId_.equals("defaultEventCategoryIdAll"))) {
            this.query.setCategoryIds(new String[]{this.categoryId_});
        }
        java.util.Calendar fromcalendar = this.getBeginDay(this.getCurrentCalendar());
        this.query.setFromDate(Long.valueOf(fromcalendar.getTimeInMillis()));
        java.util.Calendar tocalendar = this.getEndDay(this.getCurrentCalendar());
        if (tocalendar.get(14) == 0) {
            tocalendar.add(14, -1);
        }
        this.query.setToDate(Long.valueOf(tocalendar.getTimeInMillis()));
        if (!this.getViewType().equals(TYPE_BOTH)) {
            this.query.setEventType(this.getViewType());
        }
        if ((calendarIds = this.findCalendarIds()).size() > 0) {
            this.query.setCalendarIds(calendarIds.toArray(new String[0]));
        } else {
            this.query.setCalendarIds(null);
        }
        this.query.setOrderBy(new String[]{EVENT_SUMMARY});
        List allEvents = this.getAllEvents(this.query);
        if (uiListContainer.isDisplaySearchResult()) {
            this.update(this.pageList_);
        } else {
            this.update(new EventPageList(allEvents, 10L));
        }
        if (this.currentPage_ > 0 && (long)this.currentPage_ <= this.pageList_.getAvailablePage()) {
            this.updateCurrentPage((long)this.currentPage_);
        }
        UIListContainer uiContainer = (UIListContainer)this.getParent();
        UIPreview view = (UIPreview)uiContainer.getChild(UIPreview.class);
        Event[] events = this.getEvents();
        String selectedEvent = this.getSelectedEvent();
        if (events.length == 0) {
            this.setSelectedEvent(null);
            view.setEvent(null);
            this.setLastUpdatedEventId(null);
        } else if (CalendarUtils.isEmpty((String)selectedEvent) || !this.eventMap_.containsKey(selectedEvent)) {
            String eventId = events[0].getId();
            this.setSelectedEvent(eventId);
            this.setLastUpdatedEventId(eventId);
            view.setEvent(events[0]);
        } else {
            view.setEvent((Event)this.eventMap_.get(selectedEvent));
            this.setLastUpdatedEventId(selectedEvent);
        }
    }

    public void refreshSearch() throws Exception {
        this.setDisplaySearchResult(true);
        List allEvents = this.getAllEvents(this.getEventQuery());
        this.update(new EventPageList(allEvents, 10L));
        this.setSelectedEvent(null);
        this.setLastUpdatedEventId(null);
        ((UIPreview)this.getParent().findFirstComponentOfType(UIPreview.class)).setEvent(null);
    }

    private List<String> findCalendarIds() throws Exception {
        ArrayList<String> calendarIds = new ArrayList<String>();
        UICalendars uiCalendars = (UICalendars)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).findFirstComponentOfType(UICalendars.class);
        if (this.isInSpace()) {
            LinkedList<String> spaceCals = new LinkedList<String>(Arrays.asList(this.getPublicCalendars()));
            spaceCals.addAll(this.getOtherSpaceCalendar());
            return spaceCals;
        }
        List checkedCals = uiCalendars.getCheckedCalendars();
        List privateCalendar = uiCalendars.getAllPrivateCalendars();
        List publicCalendar = uiCalendars.getAllPublicCalendars();
        List shareClas = uiCalendars.getAllSharedCalendars();
        List otherClas = uiCalendars.getAllOtherCalendars();
        for (Calendar cal : privateCalendar) {
            if (!checkedCals.contains(cal.getId())) continue;
            calendarIds.add(cal.getId());
        }
        for (Calendar calendar : publicCalendar) {
            if (!checkedCals.contains(calendar.getId())) continue;
            calendarIds.add(calendar.getId());
        }
        if (shareClas != null) {
            for (Calendar cal : shareClas) {
                if (!checkedCals.contains(cal.getId())) continue;
                calendarIds.add(cal.getId());
            }
        }
        if (otherClas != null) {
            for (Calendar cal : otherClas) {
                if (!checkedCals.contains(cal.getId())) continue;
                calendarIds.add(cal.getId());
            }
        }
        return calendarIds;
    }

    public List<Event> getAllEvents(org.exoplatform.calendar.model.query.EventQuery eventQuery) throws Exception {
        String username = CalendarUtils.getCurrentUser();
        eventQuery.setOwner(username);
        LinkedList<Event> allEvents = new LinkedList<Event>();
        LinkedList<Object> tmp = new LinkedList<Object>();
        if (this.isDisplaySearchResult()) {
            List<String> publicCalendars = null;
            if (eventQuery.getCalendarIds() != null && eventQuery.getCalendarIds().length > 0) {
                publicCalendars = new LinkedList<String>();
                List<String> calendarIds = Arrays.asList(eventQuery.getCalendarIds());
                for (String cal : this.getPublicCalendars()) {
                    if (!calendarIds.contains(cal)) continue;
                    publicCalendars.add(cal);
                }
            } else {
                publicCalendars = Arrays.asList(this.getPublicCalendars());
            }
            eventQuery.setExcludeRepeatEvent(Boolean.valueOf(false));
            tmp.addAll(CalendarUtils.getCalendarService().getEvents(username, this.convertQuery(eventQuery), publicCalendars.toArray(new String[publicCalendars.size()])));
        } else {
            ListAccess list = this.xCalService.getEventHandler().findEventsByQuery(eventQuery);
            tmp.addAll(Arrays.asList(list.load(0, -1)));
        }
        CalendarService calendarService = CalendarUtils.getCalendarService();
        CalendarSetting setting = this.getCalendarSetting();
        this.recurrenceEventsMap.clear();
        for (Event event : tmp) {
            if (event.getRepeatType() != null && !event.getRepeatType().equals(Event.RP_NOREPEAT)) {
                Map tempMap;
                CalendarEvent depEvt = CalendarEvent.build((Event)event);
                java.util.Calendar fromDate = CalendarUtils.getCalendarInstanceBySetting((CalendarSetting)setting);
                if (eventQuery.getFromDate() != null) {
                    fromDate.setTimeInMillis(eventQuery.getFromDate());
                } else {
                    fromDate.setTime(event.getFromDateTime());
                }
                java.util.Calendar toDate = (java.util.Calendar)fromDate.clone();
                if (eventQuery.getToDate() != null) {
                    toDate.setTimeInMillis(eventQuery.getToDate());
                } else {
                    toDate.add(1, 2);
                }
                if ((tempMap = calendarService.getOccurrenceEvents(depEvt, fromDate, toDate, setting.getTimeZone())) == null) continue;
                this.recurrenceEventsMap.put(depEvt.getId(), tempMap);
                continue;
            }
            allEvents.add(event);
        }
        for (Map map : this.recurrenceEventsMap.values()) {
            allEvents.addAll(map.values());
        }
        String orderType = eventQuery.getOrderType();
        String[] stringArray = eventQuery.getOrderBy();
        if (stringArray != null && stringArray.length > 0) {
            String orderBy = stringArray[0];
            Collections.sort(allEvents, new /* Unavailable Anonymous Inner Class!! */);
        }
        return allEvents;
    }

    private EventQuery convertQuery(org.exoplatform.calendar.model.query.EventQuery eventQuery) {
        EventQuery query = new EventQuery();
        query.setCalendarId(eventQuery.getCalendarIds());
        query.setCategoryId(eventQuery.getCategoryIds());
        query.setEventType(eventQuery.getEventType());
        query.setExcludeRepeatEvent(eventQuery.getExcludeRepeatEvent());
        query.setFilterCalendarIds(eventQuery.getFilterCalendarIds());
        if (eventQuery.getFromDate() != null) {
            java.util.Calendar fromDate = java.util.Calendar.getInstance();
            fromDate.setTimeInMillis(eventQuery.getFromDate());
            query.setFromDate(fromDate);
        }
        query.setOrderBy(eventQuery.getOrderBy());
        query.setOrderType(eventQuery.getOrderType());
        query.setParticipants(eventQuery.getParticipants());
        query.setPriority(eventQuery.getPriority());
        query.setState(eventQuery.getState());
        query.setText(eventQuery.getText());
        if (eventQuery.getToDate() != null) {
            java.util.Calendar toDate = java.util.Calendar.getInstance();
            toDate.setTimeInMillis(eventQuery.getToDate());
            query.setToDate(toDate);
        }
        return query;
    }

    public void update(EventPageList pageList) throws Exception {
        this.pageList_ = pageList;
        this.updateCurrentPage(this.pageList_.getCurrentPage());
    }

    public EventPageList getPageList() {
        return this.pageList_;
    }

    public void setPageList(EventPageList pageList) {
        this.pageList_ = pageList;
    }

    protected void updateCurrentPage(long page) throws Exception {
        this.getChildren().clear();
        this.update();
        UIFormSelectBox uiCategory = this.getUIFormSelectBox(EVENT_CATEGORIES);
        uiCategory.setValue(this.categoryId_);
        uiCategory.setOnChange("Onchange");
        this.eventMap_.clear();
        if (this.pageList_ != null) {
            for (Object evt : this.pageList_.getPage(page, CalendarUtils.getCurrentUser())) {
                Event calendarEvent = (Event)evt;
                String id = calendarEvent.getId();
                if (calendarEvent.getRecurrenceId() != null && (calendarEvent.getIsExceptionOccurrence() == null || !calendarEvent.getIsExceptionOccurrence().booleanValue()) && this.isDisplaySearchResult()) {
                    id = id + "-" + calendarEvent.getRecurrenceId();
                }
                UICheckBoxInput checkbox = new UICheckBoxInput(id, id, Boolean.valueOf(false));
                this.addUIFormInput((UIFormInput)checkbox);
                if (this.getViewType().equals(TYPE_BOTH)) {
                    this.eventMap_.put(id, calendarEvent);
                    continue;
                }
                if (!this.getViewType().equals(calendarEvent.getEventType())) continue;
                this.eventMap_.put(id, calendarEvent);
            }
        }
    }

    public Event[] getEvents() throws Exception {
        if (this.eventMap_.size() == 0) {
            return new Event[0];
        }
        return this.eventMap_.values().toArray(new Event[0]);
    }

    protected void refreshBrowser() {
        block4: {
            UIListContainer uiListContainer = (UIListContainer)this.getParent();
            if (uiListContainer.isDisplaySearchResult()) {
                return;
            }
            if (!this.isCalClicked()) {
                try {
                    UICalendarPortlet uiPortlet = (UICalendarPortlet)uiListContainer.getAncestorOfType(UICalendarPortlet.class);
                    UICalendars uiCalendars = (UICalendars)uiPortlet.findFirstComponentOfType(UICalendars.class);
                    uiCalendars.checkAll();
                    this.refresh();
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Exception occurs in freshBrowserListMethod", (Throwable)e);
                }
            }
        }
    }

    public long getAvailablePage() {
        return this.pageList_.getAvailablePage();
    }

    public void setCurrentPage(int page) {
        this.currentPage_ = page;
    }

    public long getCurrentPage() {
        return this.pageList_.getCurrentPage();
    }

    protected boolean isShowEvent() {
        return this.isShowEvent_;
    }

    protected boolean isShowEventAndTask() {
        return this.isShowEventAndTask;
    }

    public void setShowEventAndTask(boolean show) {
        this.isShowEventAndTask = show;
    }

    public boolean isDisplaySearchResult() {
        return this.isSearchResult;
    }

    public void setDisplaySearchResult(boolean show) {
        this.isSearchResult = show;
    }

    public void setSelectedEvent(String selectedEvent) {
        this.selectedEvent_ = selectedEvent;
    }

    public String getSelectedEvent() {
        return this.selectedEvent_;
    }

    public boolean isCalClicked() {
        return this.calClicked;
    }

    public void setCalClicked(boolean clickChkCalendar) {
        this.calClicked = clickChkCalendar;
    }

    public LinkedHashMap<String, Event> getDataMap() {
        return this.eventMap_;
    }

    public List<CalendarEvent> getSelectedEvents() {
        ArrayList<CalendarEvent> events = new ArrayList<CalendarEvent>();
        for (Event ce : this.eventMap_.values()) {
            UICheckBoxInput checkbox = (UICheckBoxInput)this.getChildById(ce.getId());
            if (checkbox == null || !checkbox.isChecked()) continue;
            events.add(CalendarEvent.build((Event)ce));
        }
        return events;
    }

    public void setLastViewId(String lastViewId_) {
        this.lastViewId_ = lastViewId_;
    }

    public String getLastViewId() {
        return this.lastViewId_;
    }

    public void setCategoryId(String catetoryId) {
        this.categoryId_ = catetoryId;
        this.setSelectedCategory(catetoryId);
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public Event getSelectedEventObj() {
        return (Event)this.eventMap_.get(this.selectedEvent_);
    }

    public void setKeyWords(String keyWords) {
        this.keyWords_ = keyWords;
    }

    public String getKeyWords() {
        return this.keyWords_;
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        this.setCalClicked(true);
        super.processAction(context);
    }

    static /* synthetic */ int access$002(UIListView x0, int x1) {
        x0.currentPage_ = x1;
        return x0.currentPage_;
    }

    static /* synthetic */ List access$100(UIListView x0) throws Exception {
        return x0.findCalendarIds();
    }
}

