/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.ExtendedCalendarService;
import org.exoplatform.calendar.webui.UICalendarContainer;
import org.exoplatform.calendar.webui.UICalendarPortlet;
import org.exoplatform.calendar.webui.UICalendarWorkingContainer;
import org.exoplatform.calendar.webui.UICalendars;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputWithActions;
import org.exoplatform.webui.form.input.UICheckBoxInput;

@ComponentConfig(template="app:/templates/calendar/webui/UIPopup/UICalendarSettingDisplayTab.gtmpl")
public class UICalendarSettingDisplayTab
extends UIFormInputWithActions {
    private Map<String, List<UIFormInputWithActions.ActionData>> actionField_ = new HashMap();
    private ExtendedCalendarService xCalService = (ExtendedCalendarService)this.getApplicationComponent(ExtendedCalendarService.class);

    public UICalendarSettingDisplayTab(String compId) throws Exception {
        super(compId);
        this.setComponentConfig(this.getClass(), null);
    }

    protected UIForm getParentFrom() {
        return (UIForm)this.getParent();
    }

    public Map<String, List<Calendar>> getCalendars() {
        return this.getWorkingContainer().getCalendarMap();
    }

    public Map<String, String> getColorMap() {
        return this.getWorkingContainer().getColorMap();
    }

    private UICalendarWorkingContainer getWorkingContainer() {
        UICalendarPortlet portlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        return (UICalendarWorkingContainer)portlet.findFirstComponentOfType(UICalendarWorkingContainer.class);
    }

    public List<Calendar> getAllPrivateCalendars() throws Exception {
        List<Calendar> cals = (List<Calendar>)this.getCalendars().get(Calendar.Type.PERSONAL.name());
        cals = cals != null ? cals : Collections.emptyList();
        this.initCheckbox(cals);
        return cals;
    }

    private UICalendars getUICalendars() {
        return (UICalendars)((UICalendarContainer)((UICalendarWorkingContainer)((UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class)).getChild(UICalendarWorkingContainer.class)).getChild(UICalendarContainer.class)).getChild(UICalendars.class);
    }

    public List<Calendar> getAllPublicCalendars() throws Exception {
        List<Calendar> groupCalendars = (List<Calendar>)this.getCalendars().get(Calendar.Type.GROUP.name());
        groupCalendars = groupCalendars != null ? groupCalendars : Collections.emptyList();
        this.initCheckbox(groupCalendars);
        return groupCalendars;
    }

    public List<Calendar> getSharedCalendars() throws Exception {
        List<Calendar> calendars = (List<Calendar>)this.getCalendars().get(Calendar.Type.SHARED.name());
        calendars = calendars != null ? calendars : Collections.emptyList();
        this.initCheckbox(calendars);
        return calendars;
    }

    public List<Calendar> getAllOtherCalendars() {
        LinkedList cals = new LinkedList();
        HashSet<String> typeNames = new HashSet<String>();
        for (Calendar.Type t : Calendar.Type.values()) {
            if (Calendar.Type.UNDEFINED.equals((Object)t)) continue;
            typeNames.add(t.name());
        }
        for (String type : this.getCalendars().keySet()) {
            if (typeNames.contains(type)) continue;
            cals.addAll((Collection)this.getCalendars().get(type));
        }
        this.initCheckbox(cals);
        return cals != null ? cals : Collections.emptyList();
    }

    private String truncateLongName(String longName) {
        if (longName.length() > 35) {
            return longName.substring(0, 30) + "..";
        }
        return longName;
    }

    protected boolean isCalendarOfSpace(String[] groupIds) {
        UICalendarPortlet uiCalendarPortlet = (UICalendarPortlet)this.getAncestorOfType(UICalendarPortlet.class);
        String spaceGroupId = uiCalendarPortlet.getSpaceGroupId();
        if (spaceGroupId.equals("")) {
            return true;
        }
        if (groupIds != null && groupIds.length > 0) {
            for (String groupId : groupIds) {
                if (!groupId.equals(spaceGroupId)) continue;
                return true;
            }
        }
        return false;
    }

    public void setActionField(String fieldName, List<UIFormInputWithActions.ActionData> actions) {
        this.actionField_.put(fieldName, actions);
    }

    public List<UIFormInputWithActions.ActionData> getActionField(String fieldName) {
        return (List)this.actionField_.get(fieldName);
    }

    private void initCheckbox(List<Calendar> calendars) {
        for (Calendar calendar : calendars) {
            UICheckBoxInput checkbox = this.getUICheckBoxInput(calendar.getId());
            if (checkbox != null) continue;
            checkbox = new UICheckBoxInput(calendar.getId(), calendar.getId(), Boolean.valueOf(false));
            checkbox.setChecked(this.isCalendarOfSpace(calendar.getGroups()));
            this.addUIFormInput((UIFormInput)checkbox);
        }
    }
}

