/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIMiniCalendar;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIMiniCalendar.gtmpl", events={@EventConfig(listeners={MoveNextActionListener.class}), @EventConfig(listeners={MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class})})
public class UIMiniCalendar
extends UICalendarView {
    private String categoryId_ = null;
    private static final Log LOG = ExoLogger.getExoLogger(UIMiniCalendar.class);

    protected int getWeeksOfTheMonth(int year, int month, int day) {
        Calendar cal = this.getInstanceTempCalendar();
        cal.set(1, year);
        cal.set(2, month);
        cal.set(5, day);
        return cal.getActualMaximum(4);
    }

    protected Map<Integer, String> getData() throws Exception {
        HashMap<Integer, String> busyDay = new HashMap<Integer, String>();
        List events = this.getEventInMonth();
        Calendar first = this.getBeginDateOfMonth();
        while (first.compareTo(this.getEndDateOfMonth()) < 0) {
            for (Event evt : events) {
                if (first.compareTo(CalendarUtils.getBeginDay((Date)evt.getFromDateTime())) < 0 || first.compareTo(CalendarUtils.getEndDay((Date)evt.getToDateTime())) >= 0) continue;
                busyDay.put(first.get(6), "value");
            }
            first.add(5, 1);
        }
        return busyDay;
    }

    public LinkedHashMap<String, Event> getDataMap() {
        return null;
    }

    public Calendar getBeginDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonth();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        int amount = temCal.getFirstDayOfWeek() - temCal.get(7);
        temCal.add(5, amount);
        while (temCal.get(5) < 20 && temCal.get(5) != 1) {
            temCal.add(5, -7);
        }
        return CalendarUtils.getBeginDay((Calendar)temCal);
    }

    public Calendar getEndDateOfMonthView() throws Exception {
        Calendar temCal = this.getBeginDateOfMonthView();
        temCal.setFirstDayOfWeek(Integer.parseInt(this.calendarSetting_.getWeekStartOn()));
        temCal.add(5, this.getWeeksOfTheMonth(this.getCurrentYear(), this.getCurrentMonth(), 1) * 7);
        return this.getBeginDay(temCal);
    }

    public void setCategoryId(String categoryId) {
        this.categoryId_ = categoryId;
    }

    public String getSelectedCategory() {
        return this.categoryId_;
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }
}

