/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui.popup;

import java.io.Writer;
import java.util.List;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.webui.popup.UIEventCategoryForm;
import org.exoplatform.calendar.webui.popup.UIEventCategoryManager;
import org.exoplatform.calendar.webui.popup.UIPopupComponent;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;

@ComponentConfig(lifecycle=UIContainerLifecycle.class, events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}), @EventConfig(listeners={ConfirmCloseActionListener.class}), @EventConfig(listeners={AbortCloseActionListener.class})})
public class UIEventCategoryManager
extends UIContainer
implements UIPopupComponent {
    public static String[] BEAN_FIELD = new String[]{"localizedName"};
    private static String[] ACTION = new String[]{"Edit", "Delete"};
    public String categoryId_;
    private String confirmedCategoryId_;

    public UIEventCategoryManager() throws Exception {
        this.setName("UIEventCategoryManager");
        UIGrid categoryList = (UIGrid)this.addChild(UIGrid.class, null, "UIEventCategoryList");
        categoryList.configure("id", BEAN_FIELD, ACTION);
        categoryList.getUIPageIterator().setId("EventCategoryIterator");
        this.addChild(UIEventCategoryForm.class, null, null);
        this.updateGrid();
    }

    public long getCurrentPage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getCurrentPage();
    }

    public long getAvailablePage() {
        return ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().getAvailablePage();
    }

    public void setCurrentPage(int page) throws Exception {
        ((UIGrid)this.getChild(UIGrid.class)).getUIPageIterator().setCurrentPage(page);
    }

    public void activate() throws Exception {
    }

    public void deActivate() throws Exception {
    }

    public void resetForm() {
        ((UIEventCategoryForm)this.getChild(UIEventCategoryForm.class)).reset();
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        Writer w = context.getWriter();
        w.write("<div id=\"UIEventCategoryManager\" class=\"uiEventCategoryManager\">");
        this.renderChildren();
        w.write("</div>");
    }

    public void updateGrid() throws Exception {
        CalendarService calService = (CalendarService)this.getApplicationComponent(CalendarService.class);
        String username = CalendarUtils.getCurrentUser();
        List categories = calService.getEventCategories(username);
        UIGrid uiGrid = (UIGrid)this.getChild(UIGrid.class);
        LazyPageList pageList = new LazyPageList((ListAccess)new ListAccessImpl(EventCategory.class, categories), 10);
        uiGrid.getUIPageIterator().setPageList((PageList)pageList);
    }

    static /* synthetic */ String access$002(UIEventCategoryManager x0, String x1) {
        x0.confirmedCategoryId_ = x1;
        return x0.confirmedCategoryId_;
    }

    static /* synthetic */ String access$000(UIEventCategoryManager x0) {
        return x0.confirmedCategoryId_;
    }
}

