/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.PathNotFoundException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.portlet.PortletPreferences;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.calendar.CalendarUtils;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.Calendar;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.service.CalendarSetting;
import org.exoplatform.calendar.service.EventCategory;
import org.exoplatform.calendar.service.GroupCalendarData;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.service.impl.NewUserListener;
import org.exoplatform.calendar.webui.UICalendarViewContainer;
import org.exoplatform.commons.utils.DateUtils;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webservice.cs.calendar.CalendarWebservice;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItem;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.core.model.SelectOption;
import org.exoplatform.webui.core.model.SelectOptionGroup;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;

/*
 * Exception performing whole class analysis ignored.
 */
public class CalendarUtils {
    public static final String PRIVATE_CALENDARS = "privateCalendar".intern();
    public static final String SHARED_CALENDARS = "sharedCalendar".intern();
    public static final String PUBLIC_CALENDARS = "publicCalendar".intern();
    public static final String PRIVATE_TYPE = "0".intern();
    public static final String SHARED_TYPE = "1".intern();
    public static final String PUBLIC_TYPE = "2".intern();
    public static final String SEMICOLON = ";".intern();
    public static final String COLON = ":".intern();
    public static final String COMMA = ",".intern();
    public static final String STAR = "*".intern();
    public static final String PLUS = "+".intern();
    public static final String AND = "&".intern();
    public static final String OR = "|".intern();
    public static final String PERCENT = "%".intern();
    public static final String QUESTION_MARK = "?".intern();
    public static final String SINGLE_QUOTE = "'".intern();
    public static final String QUOTE = "\"".intern();
    public static final String AT = "@".intern();
    public static final String EXCLAMATION = "!".intern();
    public static final String SHARP = "#".intern();
    public static final String OPEN_PARENTHESIS = "(".intern();
    public static final String CLOSE_PARENTHESIS = ")".intern();
    public static final String OPEN_SQUARE_BRACKET = "[".intern();
    public static final String CLOSE_SQUARE_BRACKET = "]".intern();
    public static final String OPEN_SHARP_BRACKET = "{".intern();
    public static final String CLOSE_SHARP_BRACKET = "}".intern();
    public static final String MONEY_MARK = "$".intern();
    public static final String EXPONENT = "^".intern();
    public static final String MINUS = "-".intern();
    public static final String SLASH = "/".intern();
    public static final String BACKSLASH = "\\".intern();
    public static final String DOUBLESCORE = "--".intern();
    public static final String UNDERSCORE = "_".intern();
    public static final String SLASH_COLON = "/:".intern();
    public static final String COLON_SLASH = ":/".intern();
    public static final String GREATER_THAN = ">".intern();
    public static final String SMALLER_THAN = "<".intern();
    public static final String ANY = "*.*".intern();
    public static final String ANY_OF = "*.".intern();
    public static final String DOT = ".".intern();
    public static final String TIMEFORMAT = "HH:mm".intern();
    public static final String DATEFORMAT = "MM/dd/yyyy".intern();
    public static final String[] TIMEFORMATPATTERNS = new String[]{"hh:mm a", "HH:mm"};
    public static final String DATEFORMAT1 = "dfm0".intern();
    public static final String DATEFORMAT2 = "dfm1".intern();
    public static final String DATEFORMAT3 = "dfm2".intern();
    public static final String DATEFORMAT4 = "dfm3".intern();
    public static final String[] DATEFORMATS = new String[]{DATEFORMAT1, DATEFORMAT2, DATEFORMAT3, DATEFORMAT4};
    public static final String FORMATPATTERN1 = "dd/MM/yyyy".intern();
    public static final String FORMATPATTERN2 = "dd-MM-yyyy".intern();
    public static final String FORMATPATTERN3 = "MM/dd/yyyy".intern();
    public static final String FORMATPATTERN4 = "MM-dd-yyyy".intern();
    public static final String[] FORMATPATTERNS = new String[]{FORMATPATTERN1, FORMATPATTERN2, FORMATPATTERN3, FORMATPATTERN4};
    public static final String TWELVE_HOURS = "12-Hours".intern();
    public static final String TWENTY_FOUR_HOURS = "24-Hours".intern();
    public static final int DEFAULT_VALUE_UPLOAD_PORTAL = -1;
    public static final String UPLOAD_LIMIT = "uploadFileSizeLimitMB";
    public static final String BREAK_LINE = "\n".intern();
    public static final String DATETIMEFORMAT = DATEFORMAT + " " + TIMEFORMAT;
    public static final int DEFAULT_TIMEITERVAL = 15;
    public static final long MILISECONS_OF_DAY = 84960000L;
    public static final String EXO_INVITATION = "X-Exo-Invitation".intern();
    public static final String[] SPECIALCHARACTER = new String[]{SEMICOLON, COMMA, SLASH, BACKSLASH, SINGLE_QUOTE, OR, GREATER_THAN, SMALLER_THAN, QUOTE, QUESTION_MARK, EXCLAMATION, AT, SHARP, MONEY_MARK, PERCENT, EXPONENT, AND, STAR};
    public static final String[] EXTENDEDCHARACTER = new String[]{SEMICOLON, COMMA, COLON, SLASH, BACKSLASH, SINGLE_QUOTE, OR, GREATER_THAN, SMALLER_THAN, QUOTE, QUESTION_MARK, EXCLAMATION, AT, SHARP, MONEY_MARK, PERCENT, EXPONENT, AND, STAR, PLUS, OPEN_SQUARE_BRACKET, CLOSE_SQUARE_BRACKET};
    public static final String[] EXTENDEDKEYWORD = new String[]{SEMICOLON, COMMA, COLON, SLASH, BACKSLASH, SINGLE_QUOTE, OR, GREATER_THAN, SMALLER_THAN, QUOTE, QUESTION_MARK, EXCLAMATION, AT, SHARP, MONEY_MARK, PERCENT, EXPONENT, AND, STAR, PLUS, OPEN_SQUARE_BRACKET, CLOSE_SQUARE_BRACKET, OPEN_SHARP_BRACKET, CLOSE_SHARP_BRACKET, OPEN_PARENTHESIS, CLOSE_PARENTHESIS};
    public static final String[] SIMPLECHARACTER = new String[]{GREATER_THAN, SMALLER_THAN};
    public static final String FIELD_SEND = "send".intern();
    public static final String ITEM_ALWAYS = "always".intern();
    public static final String ITEM_NERVER = "never".intern();
    public static final String ITEM_ASK = "ask".intern();
    public static final String emailRegex = "[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+";
    public static final String contactRegex = ".\\([_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+\\)";
    public static final String URL_REGEX = "(((https?|ftp|file):\\/\\/)|www\\.)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
    public static final Pattern PATTERN = Pattern.compile("(((https?|ftp|file):\\/\\/)|www\\.)[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]", 2);
    public static final String INVITATION_URL = "/invitation/".intern();
    public static final String INVITATION_IMPORT_URL = "/invitation/import/".intern();
    public static final String INVITATION_DETAIL_URL = "/invitation/detail/".intern();
    public static final String DETAILS_URL = "/details/";
    public static final String DETAIL_URL = "/detail/";
    public static final String IS_CLOSING = "closingPopup";
    private static Log log = ExoLogger.getLogger(CalendarUtils.class);
    private static ConcurrentHashMap<String, CalendarSetting> calendarSettingsByUserName = new ConcurrentHashMap();

    public static final String[] getUserGroups(String username) throws Exception {
        ConversationState conversationState = ConversationState.getCurrent();
        Identity identity = conversationState.getIdentity();
        Set objs = identity.getGroups();
        String[] groups = new String[objs.size()];
        int i = 0;
        for (String obj : objs) {
            groups[i++] = obj;
        }
        return groups;
    }

    public static String[] getAllGroups() throws Exception {
        Object[] objs = CalendarUtils.getOrganizationService().getGroupHandler().getAllGroups().toArray();
        String[] groups = new String[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            groups[i] = ((Group)objs[i]).getId();
        }
        return groups;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static CalendarService getCalendarService() throws Exception {
        return (CalendarService)PortalContainer.getInstance().getComponentInstance(CalendarService.class);
    }

    public static OrganizationService getOrganizationService() throws Exception {
        return (OrganizationService)PortalContainer.getInstance().getComponentInstance(OrganizationService.class);
    }

    public static CalendarSetting removeCurrentCalendarSetting() {
        try {
            return (CalendarSetting)calendarSettingsByUserName.remove(CalendarUtils.getCurrentUser());
        }
        catch (Exception e) {
            log.warn((Object)"could not remove calendar setting of the user.", (Throwable)e);
            return null;
        }
    }

    public static void setCurrentCalendarSetting(CalendarSetting setting) {
        try {
            if (setting == null) {
                calendarSettingsByUserName.remove(CalendarUtils.getCurrentUser());
            } else {
                calendarSettingsByUserName.put(CalendarUtils.getCurrentUser(), setting);
            }
        }
        catch (Exception e) {
            log.warn((Object)"could not set calendar setting for current user", (Throwable)e);
        }
    }

    public static CalendarSetting getCurrentUserCalendarSetting() {
        try {
            String user = CalendarUtils.getCurrentUser();
            CalendarSetting setting = (CalendarSetting)calendarSettingsByUserName.get(user);
            if (setting == null) {
                setting = CalendarUtils.getCalendarService().getCalendarSetting(user);
                calendarSettingsByUserName.put(user, setting);
            }
            return setting;
        }
        catch (Exception e) {
            log.warn((Object)"could not get calendar setting of user", (Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static java.util.Calendar getInstanceTempCalendar() {
        return CalendarUtils.getInstanceOfCurrentCalendar();
    }

    public static java.util.Calendar getCalendarInstanceBySetting(CalendarSetting calendarSetting) {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setLenient(false);
        calendar.setTimeZone(DateUtils.getTimeZone((String)calendarSetting.getTimeZone()));
        calendar.setFirstDayOfWeek(Integer.parseInt(calendarSetting.getWeekStartOn()));
        calendar.setMinimalDaysInFirstWeek(4);
        return calendar;
    }

    public static java.util.Calendar getInstanceOfCurrentCalendar() {
        try {
            CalendarSetting setting = CalendarUtils.getCurrentUserCalendarSetting();
            return CalendarUtils.getCalendarInstanceBySetting((CalendarSetting)setting);
        }
        catch (Exception e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Could not get calendar setting!", (Throwable)e);
            }
            java.util.Calendar calendar = java.util.Calendar.getInstance();
            calendar.setLenient(false);
            return calendar;
        }
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String timeFormat) {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return CalendarUtils.getTimesSelectBoxOptions((String)timeFormat, (String)TIMEFORMAT, (long)30L, (Locale)locale);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String labelFormat, String valueFormat) {
        return CalendarUtils.getTimesSelectBoxOptions((String)labelFormat, (String)valueFormat, (long)30L);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String labelFormat, String valueFormat, long timeInteval) {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return CalendarUtils.getTimesSelectBoxOptions((String)labelFormat, (String)valueFormat, (long)timeInteval, (Locale)locale);
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String labelFormat, String valueFormat, long timeInteval, Locale locale) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        java.util.Calendar cal = java.util.Calendar.getInstance(DateUtils.getTimeZone((String)""));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(14, 0);
        SimpleDateFormat dfLabel = new SimpleDateFormat(labelFormat, locale);
        dfLabel.setCalendar(cal);
        SimpleDateFormat dfValue = new SimpleDateFormat(valueFormat, locale);
        dfValue.setCalendar(cal);
        int day = cal.get(5);
        while (day == cal.get(5)) {
            options.add(new SelectItemOption(dfLabel.format(cal.getTime()), (Object)dfValue.format(cal.getTime())));
            cal.add(12, (int)timeInteval);
        }
        cal.set(5, day);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(14, 59);
        options.add(new SelectItemOption(dfLabel.format(cal.getTime()), (Object)dfValue.format(cal.getTime())));
        return options;
    }

    public static List<SelectItemOption<String>> getTimesSelectBoxOptions(String timeFormat, int timeInteval) {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        Locale locale = context.getParentAppRequestContext().getLocale();
        return CalendarUtils.getTimesSelectBoxOptions((String)timeFormat, (String)TIMEFORMAT, (long)timeInteval, (Locale)locale);
    }

    public static String generateTimeZoneLabel(String timeZoneID) {
        String label = timeZoneID;
        if (label.lastIndexOf("/") > 0 && label.toLowerCase().lastIndexOf("etc".toLowerCase()) < 0 && label.toLowerCase().lastIndexOf("system") < 0) {
            TimeZone timeZone = DateUtils.getTimeZone((String)label);
            int rawOffset = timeZone.getRawOffset() / 60000;
            int hours = rawOffset / 60;
            int minutes = Math.abs(rawOffset) % 60;
            String hrStr = "";
            hrStr = Math.abs(hours) < 10 ? (hours < 0 ? "-0" + Math.abs(hours) : "0" + Math.abs(hours)) : Integer.toString(hours);
            String minStr = minutes < 10 ? "0" + Integer.toString(minutes) : Integer.toString(minutes);
            label = "(GMT " + (timeZone.getRawOffset() >= 0 ? "+" : "") + hrStr + ":" + minStr + ") " + timeZoneID;
        }
        return label;
    }

    public static List<SelectItemOption<String>> getTimeZoneSelectBoxOptions(String[] timeZoneIds) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (String tz : timeZoneIds) {
            if (tz.lastIndexOf("/") <= 0 || tz.toLowerCase().lastIndexOf("etc".toLowerCase()) >= 0 || tz.toLowerCase().lastIndexOf("system") >= 0) continue;
            String str = CalendarUtils.generateTimeZoneLabel((String)tz);
            options.add((SelectItemOption<String>)new SelectItemOption(str, (Object)tz));
        }
        return options;
    }

    public static String getLocationDisplayString(String locationName) {
        String country;
        Locale[] avai = Locale.getAvailableLocales();
        Locale locale = null;
        for (Locale l : avai) {
            try {
                if (!l.getISO3Country().equalsIgnoreCase(locationName)) continue;
                locale = l;
                break;
            }
            catch (MissingResourceException ex) {
                log.debug((Object)("Three-letter country abbreviation is not available for locale: " + l.getDisplayName()), (Throwable)ex);
            }
        }
        if (locale != null && (country = locale.getISO3Country()) != null && country.trim().length() > 0) {
            return locale.getDisplayCountry() + "(" + locale.getDisplayLanguage() + ")";
        }
        return locationName;
    }

    public static List<SelectItemOption<String>> getLocaleSelectBoxOptions(Locale[] locale) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        for (Locale local : locale) {
            String country = local.getISO3Country();
            if (country == null || country.trim().length() <= 0) continue;
            options.add((SelectItemOption<String>)new SelectItemOption(local.getDisplayCountry() + "(" + local.getDisplayLanguage() + ")", (Object)country));
        }
        Collections.sort(options, new SelectComparator());
        return options;
    }

    public static String parse(Date date, String timeFormat) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(timeFormat);
        return df.format(date);
    }

    public static String parse(Date date, String timeFormat, Locale locale) throws Exception {
        SimpleDateFormat df = new SimpleDateFormat(timeFormat, locale);
        return df.format(date);
    }

    public static String getCurrentUser() {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    public static Identity getCurrentIdentity() throws Exception {
        return ConversationState.getCurrent().getIdentity();
    }

    public static boolean isAllDayEvent(CalendarEvent eventCalendar) {
        java.util.Calendar cal1 = CalendarUtils.getInstanceOfCurrentCalendar();
        java.util.Calendar cal2 = CalendarUtils.getInstanceOfCurrentCalendar();
        cal1.setTime(eventCalendar.getFromDateTime());
        cal2.setTime(eventCalendar.getToDateTime());
        return cal1.get(11) == 0 && cal1.get(12) == 0 && cal2.get(11) == cal2.getActualMaximum(11) && cal2.get(12) == cal2.getActualMaximum(12);
    }

    public static boolean isSameDate(java.util.Calendar date1, java.util.Calendar date2) {
        return date1.get(5) == date2.get(5) && date1.get(2) == date2.get(2) && date1.get(1) == date2.get(1);
    }

    public static boolean isSameDate(Date value1, Date value2) {
        java.util.Calendar date1 = CalendarUtils.getInstanceOfCurrentCalendar();
        date1.setTime(value1);
        java.util.Calendar date2 = CalendarUtils.getInstanceOfCurrentCalendar();
        date2.setTime(value2);
        return CalendarUtils.isSameDate((java.util.Calendar)date1, (java.util.Calendar)date2);
    }

    public static java.util.Calendar getBeginDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        return newCal;
    }

    public static java.util.Calendar getEndDay(java.util.Calendar cal) {
        java.util.Calendar newCal = (java.util.Calendar)cal.clone();
        newCal.set(11, 0);
        newCal.set(12, 0);
        newCal.set(13, 0);
        newCal.set(14, 0);
        newCal.add(11, 24);
        return newCal;
    }

    public static java.util.Calendar getBeginDay(Date date) {
        java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
        cal.setTime(date);
        return CalendarUtils.getBeginDay((java.util.Calendar)cal);
    }

    public static java.util.Calendar getEndDay(Date date) {
        java.util.Calendar cal = CalendarUtils.getInstanceOfCurrentCalendar();
        cal.setTime(date);
        return CalendarUtils.getEndDay((java.util.Calendar)cal);
    }

    public static String getDataSource(Attachment attach, DownloadService dservice) throws Exception {
        if (attach != null) {
            try {
                InputStream input = attach.getInputStream();
                byte[] imageBytes = null;
                if (input != null) {
                    imageBytes = new byte[input.available()];
                    input.read(imageBytes);
                    ByteArrayInputStream byteImage = new ByteArrayInputStream(imageBytes);
                    InputStreamDownloadResource dresource = new InputStreamDownloadResource((InputStream)byteImage, attach.getMimeType());
                    dresource.setDownloadName(attach.getName());
                    return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
                }
            }
            catch (PathNotFoundException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The attachment has no data source", (Throwable)ex);
                }
                return null;
            }
        }
        return null;
    }

    public static boolean isNameEmpty(String name) {
        return name == null || name.trim().length() == 0;
    }

    public static String getServerBaseUrl() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)RequestContext.getCurrentInstance();
        String url = portletRequestContext.getRequest().getScheme() + "://" + portletRequestContext.getRequest().getServerName() + ":" + String.format("%s", portletRequestContext.getRequest().getServerPort()) + "/";
        return url;
    }

    public static String getTimeZone(String timezone) {
        TimeZone timeZone = DateUtils.getTimeZone((String)timezone);
        int rawOffset = timeZone.getRawOffset();
        return String.valueOf(0 - (rawOffset / 60000 + timeZone.getDSTSavings() / 60000));
    }

    public static String getCalendarURL() throws Exception {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String url = pContext.getRequest().getRequestURL().toString();
        String selectedNode = Util.getUIPortal().getSelectedUserNode().getURI();
        String portalName = pContext.getPortalOwner();
        if (url.indexOf(portalName) > 0) {
            String s = portalName + "/" + selectedNode;
            if (url.indexOf(s) < 0) {
                url = url.replaceFirst(portalName, s);
            }
            selectedNode = s;
            url = url.substring(0, url.lastIndexOf(selectedNode) + selectedNode.length());
        }
        return url;
    }

    public static List<SelectItem> getCalendarOption() throws Exception {
        List lgcd;
        GroupCalendarData gcd;
        ArrayList<SelectItem> options = new ArrayList<SelectItem>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        HashMap<String, String> hash = new HashMap<String, String>();
        SelectOptionGroup privGrp = new SelectOptionGroup(PRIVATE_CALENDARS);
        List calendars = calendarService.getUserCalendars(username, true);
        for (Calendar c : calendars) {
            if (hash.containsKey(c.getId())) continue;
            hash.put(c.getId(), "");
            privGrp.addOption(new SelectOption(c.getName(), PRIVATE_TYPE + COLON + c.getId()));
        }
        if (privGrp.getOptions().size() > 0) {
            options.add((SelectItem)privGrp);
        }
        if ((gcd = calendarService.getSharedCalendars(username, true)) != null) {
            SelectOptionGroup sharedGrp = new SelectOptionGroup(SHARED_CALENDARS);
            for (Calendar c : gcd.getCalendars()) {
                if (!Utils.hasPermission((String[])Utils.getEditPerUsers((Calendar)c)) || hash.containsKey(c.getId())) continue;
                hash.put(c.getId(), "");
                sharedGrp.addOption(new SelectOption(c.getName(), SHARED_TYPE + COLON + c.getId()));
            }
            if (sharedGrp.getOptions().size() > 0) {
                options.add((SelectItem)sharedGrp);
            }
        }
        if ((lgcd = calendarService.getGroupCalendars(CalendarUtils.getUserGroups((String)username), true, username)) != null) {
            SelectOptionGroup pubGrp = new SelectOptionGroup(PUBLIC_CALENDARS);
            for (GroupCalendarData g : lgcd) {
                for (Calendar c : g.getCalendars()) {
                    if (!Utils.hasPermission((String[])c.getEditPermission()) || hash.containsKey(c.getId())) continue;
                    hash.put(c.getId(), "");
                    pubGrp.addOption(new SelectOption(c.getName(), PUBLIC_TYPE + COLON + c.getId()));
                }
            }
            if (pubGrp.getOptions().size() > 0) {
                options.add((SelectItem)pubGrp);
            }
        }
        return options;
    }

    public static String getGroupCalendarName(String groupName, String calendarName) {
        return calendarName + " " + OPEN_PARENTHESIS + groupName + CLOSE_PARENTHESIS;
    }

    public static List<Calendar> getAllOfCurrentUserCalendars() throws Exception {
        List lgcd;
        ArrayList<Calendar> list = new ArrayList<Calendar>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        String username = CalendarUtils.getCurrentUser();
        List calendars = calendarService.getUserCalendars(username, true);
        for (Object c : calendars) {
            list.add((Calendar)c);
        }
        GroupCalendarData gcd = calendarService.getSharedCalendars(username, true);
        if (gcd != null) {
            for (Calendar c : gcd.getCalendars()) {
                if (!Utils.hasPermission((String[])Utils.getEditPerUsers((Calendar)c))) continue;
                list.add(c);
            }
        }
        if ((lgcd = calendarService.getGroupCalendars(CalendarUtils.getUserGroups((String)username), true, username)) != null) {
            for (GroupCalendarData g : lgcd) {
                for (Calendar c : g.getCalendars()) {
                    if (!Utils.hasPermission((String[])c.getEditPermission())) continue;
                    list.add(c);
                }
            }
        }
        return list;
    }

    public static String encodeJCRText(String str) {
        return str.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("'", "&apos;").replaceAll("\"", "&quot;");
    }

    public static String encodeHTML(String htmlContent) throws Exception {
        return htmlContent.replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static MailService getMailService() throws Exception {
        return (MailService)PortalContainer.getInstance().getComponentInstance(MailService.class);
    }

    public static String convertSize(long size) throws Exception {
        StringBuilder str = new StringBuilder();
        DecimalFormat df = new DecimalFormat("0.00");
        if (size > 0x100000L) {
            str.append(df.format((double)size / 1048576.0)).append(" MB");
        } else if (size > 1024L) {
            str.append(df.format((double)size / 1024.0)).append(" KB");
        } else {
            str.append(size).append(" B");
        }
        return str.toString();
    }

    public static boolean isAValidEmailAddress(String email) {
        return email.matches("[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+");
    }

    public static boolean isValidEmailAddresses(String addressList) {
        if (CalendarUtils.isEmpty((String)addressList)) {
            return true;
        }
        addressList = addressList.replaceAll(SEMICOLON, COMMA);
        ArrayList<String> emails = new ArrayList<String>();
        emails.addAll(Arrays.asList(addressList.split(COMMA)));
        for (String email : emails) {
            if ((email = email.trim()).matches("[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+")) continue;
            return false;
        }
        return true;
    }

    public static String invalidEmailAddresses(String addressList) {
        StringBuilder invalidEmails = new StringBuilder("");
        addressList = addressList.replaceAll(SEMICOLON, COMMA);
        ArrayList<String> emails = new ArrayList<String>();
        emails.addAll(Arrays.asList(addressList.split(COMMA)));
        for (String email : emails) {
            if ((email = email.trim()).matches("[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+")) continue;
            if (invalidEmails.length() > 0) {
                invalidEmails.append(", ");
            }
            invalidEmails.append(email);
        }
        if (invalidEmails.length() == 0) {
            return addressList;
        }
        return invalidEmails.toString();
    }

    public static String invalidUsers(String userList) throws Exception {
        StringBuilder invalidNames = new StringBuilder("");
        userList = userList.replaceAll(SEMICOLON, COMMA);
        ArrayList<String> users = new ArrayList<String>();
        users.addAll(Arrays.asList(userList.split(COMMA)));
        for (String user : users) {
            user = user.trim();
            if (CalendarUtils.isUserExisted((OrganizationService)CalendarUtils.getOrganizationService(), (String)user)) continue;
            if (invalidNames.length() > 0) {
                invalidNames.append(", ");
            }
            invalidNames.append(user);
        }
        return invalidNames.toString();
    }

    public static String parseEmailAddress(String address) {
        try {
            InternetAddress[] iAdds = InternetAddress.parse((String)address, (boolean)true);
            return iAdds[0].getAddress();
        }
        catch (AddressException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The mail address is not valid", (Throwable)e);
            }
            return null;
        }
    }

    public static boolean isEmailValid(String value) {
        return value != null && value.trim().length() > 0 && value.trim().matches("[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[_A-Za-z0-9-.]+");
    }

    public static boolean isAllEmailValid(String addressList) {
        boolean isValid;
        block2: {
            isValid = true;
            if (CalendarUtils.isEmpty((String)addressList)) {
                return false;
            }
            addressList.replaceAll(SEMICOLON, COMMA);
            String[] stringArray = addressList.split(COMMA);
            int n = stringArray.length;
            int n2 = 0;
            if (n2 >= n) break block2;
            String s = stringArray[n2];
            if (!CalendarUtils.isEmailValid((String)(s = s.trim()))) {
                isValid = false;
            }
        }
        return isValid;
    }

    public static boolean isUserExisted(OrganizationService orgSevice, String value) {
        try {
            return !CalendarUtils.isEmpty((String)value) && orgSevice.getUserHandler().findUserByName(value) != null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Fail to check if user exist", (Throwable)e);
            }
            return false;
        }
    }

    public static String getCurrentTime(UIComponent uiCompo) throws Exception {
        return String.valueOf(System.currentTimeMillis());
    }

    public static List<SelectItemOption<String>> getSendValue(String more) {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        if (more != null) {
            options.add(new SelectItemOption(CalendarSetting.ACTION_BYSETTING, (Object)CalendarSetting.ACTION_BYSETTING));
        }
        options.add(new SelectItemOption(CalendarSetting.ACTION_NEVER, (Object)CalendarSetting.ACTION_NEVER));
        options.add(new SelectItemOption(CalendarSetting.ACTION_ALWAYS, (Object)CalendarSetting.ACTION_ALWAYS));
        options.add(new SelectItemOption(CalendarSetting.ACTION_ASK, (Object)CalendarSetting.ACTION_ASK));
        return options;
    }

    public static String reduceSpace(String s) {
        if (CalendarUtils.isEmpty((String)s)) {
            return "";
        }
        String[] words = s.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String word : words) {
            if (builder.length() > 0 && word.trim().length() > 0) {
                builder.append(" ");
            }
            builder.append(word.trim());
        }
        return builder.toString();
    }

    public static String cleanValue(String values) throws Exception {
        if (CalendarUtils.isEmpty((String)values)) {
            return "";
        }
        values = values.trim().replaceAll("(,\\s*)", COMMA).replaceAll("(\\s*,)", COMMA);
        String[] tmpArr = values.split(COMMA);
        LinkedHashSet<String> set = new LinkedHashSet<String>(Arrays.asList(tmpArr));
        StringBuilder data = new StringBuilder();
        for (String s : set) {
            if (s.trim().length() <= 0) continue;
            if (data.length() > 0) {
                data.append(COMMA);
            }
            data.append(s.trim());
        }
        return data.toString();
    }

    public static String getResourceBundle(String key, String defaultValue) {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString(key);
        }
        catch (MissingResourceException e) {
            log.warn((Object)("Can not find the resource for key: " + key));
            return defaultValue;
        }
    }

    public static ContinuationService getContinuationService() {
        ContinuationService continuation = (ContinuationService)PortalContainer.getInstance().getComponentInstanceOfType(ContinuationService.class);
        return continuation;
    }

    public static List<Calendar> getAllOfCalendars(String username) throws Exception {
        ArrayList<Calendar> calendars = new ArrayList<Calendar>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        for (Calendar calendar : calendarService.getUserCalendars(username, true)) {
            calendars.add(calendar);
        }
        String[] groups = CalendarUtils.getUserGroups((String)username);
        List groupCalendars = calendarService.getGroupCalendars(groups, true, CalendarUtils.getCurrentUser());
        HashMap<String, Calendar> mapCal = new HashMap<String, Calendar>();
        for (GroupCalendarData group : groupCalendars) {
            for (Calendar cal : group.getCalendars()) {
                mapCal.put(cal.getId(), cal);
            }
        }
        calendars.addAll(mapCal.values());
        GroupCalendarData groupCalendar = calendarService.getSharedCalendars(username, true);
        if (groupCalendar != null) {
            for (Calendar calendar : groupCalendar.getCalendars()) {
                calendars.add(calendar);
            }
        }
        return calendars;
    }

    public static String getLabel(String componentid, String id) throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        String label = componentid + ".label." + id;
        try {
            return res.getString(label);
        }
        catch (MissingResourceException e) {
            return id;
        }
    }

    public static Calendar getCalendar(String calType, String calendarId) throws Exception {
        CalendarService calService = CalendarUtils.getCalendarService();
        String currentUser = CalendarUtils.getCurrentUser();
        Calendar calendar = null;
        if (PRIVATE_TYPE.equals(calType)) {
            calendar = calService.getUserCalendar(currentUser, calendarId);
        } else if (SHARED_TYPE.equals(calType)) {
            GroupCalendarData gCalendarData = calService.getSharedCalendars(currentUser, true);
            if (gCalendarData != null) {
                calendar = gCalendarData.getCalendarById(calendarId);
            }
        } else if (PUBLIC_TYPE.equals(calType)) {
            calendar = calService.getGroupCalendar(calendarId);
        }
        return calendar;
    }

    public static List<SelectItemOption<String>> getCategory() throws Exception {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        CalendarService calendarService = CalendarUtils.getCalendarService();
        List eventCategories = calendarService.getEventCategories(CalendarUtils.getCurrentUser());
        for (EventCategory category : eventCategories) {
            boolean isDefaultEventCategory = false;
            for (int i = 0; i < NewUserListener.defaultEventCategoryIds.length; ++i) {
                if (!category.getId().equals(NewUserListener.defaultEventCategoryIds[i]) || !category.getName().equals(NewUserListener.defaultEventCategoryNames[i])) continue;
                isDefaultEventCategory = true;
                break;
            }
            if (isDefaultEventCategory) {
                String newName = CalendarUtils.getResourceBundle((String)("UICalendarView.label." + category.getId()), (String)category.getId());
                options.add((SelectItemOption<String>)new SelectItemOption(newName, (Object)category.getId()));
                continue;
            }
            options.add((SelectItemOption<String>)new SelectItemOption(category.getName(), (Object)category.getId()));
        }
        return options;
    }

    public static int getLimitUploadSize() {
        int limitMB;
        PortletRequestContext pcontext = (PortletRequestContext)RequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        try {
            limitMB = Integer.parseInt(portletPref.getValue("uploadFileSizeLimitMB", "").trim());
        }
        catch (NumberFormatException e) {
            limitMB = -1;
        }
        return limitMB;
    }

    public static String buildSubscribeUrl(String calId, String calType, boolean isPrivate) {
        try {
            String baseUrl = isPrivate ? CalendarWebservice.BASE_URL_PRIVATE : CalendarWebservice.BASE_URL_PUBLIC;
            return new StringBuffer(SLASH).append(PortalContainer.getCurrentRestContextName()).append(baseUrl).append(CalendarUtils.getCurrentUser()).append(SLASH).append(calId).append(SLASH).append(calType).toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getViewInSetting() {
        CalendarSetting calendarSetting = CalendarUtils.getCurrentUserCalendarSetting();
        try {
            return UICalendarViewContainer.TYPES[Integer.parseInt(calendarSetting.getViewType())];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CalendarUtils.resetViewInSetting((CalendarSetting)calendarSetting);
            return UICalendarViewContainer.TYPES[0];
        }
        catch (NumberFormatException nfe) {
            CalendarUtils.resetViewInSetting((CalendarSetting)calendarSetting);
            return UICalendarViewContainer.TYPES[0];
        }
    }

    public static String convertURLsAsLinks(String text) {
        if (StringUtils.isNotBlank((String)text)) {
            int tempIndex = 0;
            String urlifiedText = "";
            Matcher urlMatcher = PATTERN.matcher(text);
            while (urlMatcher.find()) {
                String chunk;
                int startIndex = urlMatcher.start(0);
                int endIndex = urlMatcher.end(0);
                if (StringUtils.isBlank((String)urlifiedText)) {
                    if (startIndex > 0) {
                        urlifiedText = urlifiedText + text.substring(0, startIndex);
                    }
                } else if (startIndex - tempIndex > 0) {
                    urlifiedText = urlifiedText + text.substring(tempIndex, startIndex);
                }
                String url = chunk = text.substring(startIndex, endIndex);
                if (chunk.indexOf("www.") == 0) {
                    url = "http://" + url;
                }
                urlifiedText = urlifiedText + "<a href=\"" + url + "\" target=\"_blank\">" + chunk + "</a>";
                tempIndex = endIndex;
            }
            if (text.length() > tempIndex) {
                urlifiedText = urlifiedText + text.substring(tempIndex, text.length());
            }
            return urlifiedText;
        }
        return text;
    }

    private static void resetViewInSetting(CalendarSetting calendarSetting) {
        block2: {
            try {
                calendarSetting.setViewType(CalendarSetting.DAY_VIEW);
                CalendarUtils.getCalendarService().saveCalendarSetting(CalendarUtils.getCurrentUser(), calendarSetting);
                CalendarUtils.setCurrentCalendarSetting((CalendarSetting)calendarSetting);
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Cant save Calendar Setting", (Throwable)e);
            }
        }
    }
}

