/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.CalendarService;
import org.exoplatform.calendar.util.CalendarUtils;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIWeekView;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIWeekView.gtmpl", events={@EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmCloseActionListener.class}), @EventConfig(listeners={UICalendarView.AbortCloseActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={UpdateAllDayEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteFollowingSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateFollowSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateCancel.class})})
public class UIWeekView
extends UICalendarView {
    private static final Log log = ExoLogger.getExoLogger(UIWeekView.class);
    public static final String CURRENT_DATE = "currentDate";
    protected Map<String, List<Event>> eventData_ = new HashMap();
    protected List<Event> allDayEvent = new ArrayList();
    protected LinkedHashMap<String, Event> dataMap_ = new LinkedHashMap();
    protected List<Event> daysData_ = new ArrayList();
    protected boolean isShowCustomView_ = false;
    protected Date beginDate_;
    protected Date endDate_;
    private DateFormat tf;
    private DateFormat dtf;
    private DateFormat wf;
    private DateFormat tempFormat;
    private DateFormat dayFormat;
    private DateFormat fullDateFormat;
    private List<String> eventList;
    private static final Log LOG = ExoLogger.getExoLogger(UIWeekView.class);

    private void init() throws Exception {
        String dateFormat = this.getDateFormat();
        Locale locale = WebuiRequestContext.getCurrentInstance().getParentAppRequestContext().getLocale();
        Calendar beginDate = this.getBeginDateOfWeek();
        this.dtf = new SimpleDateFormat(dateFormat + " " + CalendarUtils.TIMEFORMAT, locale);
        this.tf = new SimpleDateFormat(this.getTimeFormat(), locale);
        this.tf.setCalendar(CalendarUtils.getInstanceTempCalendar());
        this.wf = new SimpleDateFormat("EEE, dd MMM", locale);
        this.tempFormat = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss", Locale.ENGLISH);
        this.tempFormat.setCalendar(CalendarUtils.getInstanceTempCalendar());
        this.dayFormat = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        this.dayFormat.setCalendar(beginDate);
        this.fullDateFormat = new SimpleDateFormat(dateFormat + " " + CalendarUtils.TIMEFORMAT, Locale.ENGLISH);
        this.fullDateFormat.setCalendar(beginDate);
        this.eventList = new ArrayList();
    }

    public void refresh() throws Exception {
        super.refresh();
        this.init();
        this.eventData_.clear();
        this.allDayEvent.clear();
        this.recurrenceEventsMap.clear();
        int i = 0;
        Calendar c = this.getBeginDateOfWeek();
        int maxDay = 7;
        if (this.isShowCustomView_) {
            maxDay = 5;
        }
        while (i++ < maxDay) {
            LinkedList list = new LinkedList();
            String key = this.keyGen(c.get(5), c.get(2), c.get(1));
            this.eventData_.put(key, list);
            c.add(5, 1);
        }
        Calendar endDateOfWeek = this.getEndDateOfWeek();
        Date toDate = endDateOfWeek.getTime();
        toDate.setTime(toDate.getTime() - 1L);
        endDateOfWeek.setTime(toDate);
        List allEvents = this.getEventInMonth(this.getBeginDateOfWeek().getTimeInMillis(), endDateOfWeek.getTimeInMillis());
        if (this.isInSpace()) {
            this.filterNonSpaceEvent(allEvents);
        }
        for (Event evt : allEvents) {
            if (evt.getRepeatType() == null || evt.getRecurrenceId() == null || evt.getRepeatType().equals(Event.RP_NOREPEAT)) continue;
            HashMap<String, CalendarEvent> recurrMap = (HashMap<String, CalendarEvent>)this.recurrenceEventsMap.get(evt.getId());
            if (recurrMap == null) {
                recurrMap = new HashMap<String, CalendarEvent>();
                this.recurrenceEventsMap.put(evt.getId(), recurrMap);
            }
            recurrMap.put(evt.getRecurrenceId(), (CalendarEvent)evt);
        }
        Iterator iter = allEvents.iterator();
        while (iter.hasNext()) {
            Event event = (Event)iter.next();
            Date beginEvent = event.getFromDateTime();
            Date endEvent = event.getToDateTime();
            long eventAmount = endEvent.getTime() - beginEvent.getTime();
            i = 0;
            c = this.getBeginDateOfWeek();
            while (i++ < maxDay) {
                String key = this.keyGen(c.get(5), c.get(2), c.get(1));
                if (this.isSameDate(c.getTime(), beginEvent) && this.isSameDate(c.getTime(), endEvent) && eventAmount < 84960000L) {
                    ((List)this.eventData_.get(key)).add(event);
                    iter.remove();
                }
                c.add(5, 1);
            }
        }
        for (Event ce : allEvents) {
            this.allDayEvent.add(ce);
        }
    }

    private String renderDayHeader() throws Exception {
        String styleWidth;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n<table style=\"table-layout:fixed;\" class=\"uiGrid table\"  cellspacing=\"0\"").append(" cellpadding=\"0\" exocallback=\"eXo.calendar.UIWeekView.callbackSelectionX();\">").append("\n<tr>").append("\n<td style=\"width: 55px;\" class=\"UIEmtyBlock\"></td>");
        String cssClass = "day";
        String styleCss = "";
        Calendar cl = this.getBeginDateOfWeek();
        int t = 0;
        int numberOfDays = this.isShowCustomView_ ? 5 : 7;
        String string = styleWidth = this.isShowCustomView_ ? "width:19.8%;*width:20%;" : "width:13.8%;*width:14%;";
        while (t++ < numberOfDays) {
            if (this.isCurrentDay(cl.get(5), cl.get(2), cl.get(1))) {
                cssClass = "today";
            }
            String dayActionLink = "0&currentTime=" + cl.getTimeInMillis();
            String actionLink = this.event("GotoDate", dayActionLink);
            if (cl.get(7) == 1) {
                styleCss = "";
            }
            this.wf.setCalendar(cl);
            stringBuilder.append("\n<td class=\"" + cssClass + " uiCellBlock center\" style=\"" + styleWidth + "\" startTime=\"" + cl.getTimeInMillis() + "\" startTimeFull=\"" + this.tempFormat.format(cl.getTime()) + "\">").append("\n<a href=\"" + actionLink + "\" style=\"" + styleCss + "\">" + this.wf.format(cl.getTime()) + "</a>").append("</td>");
            cl.add(5, 1);
        }
        stringBuilder.append("\n</tr>").append("\n</table>");
        return stringBuilder.toString();
    }

    private String renderAllDayGrid() throws Exception {
        int numberOfDays = this.isShowCustomView_ ? 5 : 7;
        String styleWidth = this.isShowCustomView_ ? "width:19.8%;*width:20%;" : "width:13.8%;*width:14%;";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n<div id=\"UIWeekViewGridAllDay\" class=\"eventAllDay\" numberOfDays=\"" + numberOfDays + "\">").append("\n<div class=\"eventAlldayBoard\" style=\"position:relative\">").append("\n<table style=\"table-layout:fixed;\" class=\"uiGrid table allDayTable \" cellspacing=\"0\" cellpadding=\"0\">").append("\n<tr>").append("\n<td style=\"width: 55px;\"></td>");
        Calendar cl = this.getBeginDateOfWeek();
        int t = 0;
        while (t++ < numberOfDays) {
            stringBuilder.append("\n<td class=\"whiteTd\" style=\"" + styleWidth + "\" startTimeFull=\"" + this.tempFormat.format(cl.getTime()) + "\"></td>");
            cl.add(5, 1);
        }
        stringBuilder.append("\n</tr>").append("\n</table>");
        for (Event event : this.allDayEvent) {
            long begindate = event.getFromDateTime().getTime();
            long enddate = event.getToDateTime().getTime();
            String eventId = event.getId();
            String username = CalendarUtils.getCurrentUser();
            CalendarService service = CalendarUtils.getCalendarService();
            String calType = String.valueOf(service.getTypeOfCalendar(username, event.getCalendarId()));
            String calendarId = event.getCalendarId();
            String color = (String)this.getColors().get(calendarId);
            String actionLink = this.event("UpdateAllDayEvent", eventId);
            boolean isOccur = event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && (event.getIsExceptionOccurrence() == null || event.getIsExceptionOccurrence() == false);
            String recurId = event.getRecurrenceId();
            boolean isEditable = !calType.equals(CalendarUtils.PRIVATE_TYPE) ? this.isEventEditable(event) : true;
            stringBuilder.append("\n<div class=\"eventContainer eventAlldayContainer weekViewEventBoxes clearfix\" eventcat=\"" + event.getEventCategoryId() + "\" style=\"position:absolute;display:none;\"").append("\n caltype=\"" + calType + "\" eventid=\"" + eventId + "\" isOccur=\"" + isOccur + "\" recurId=\"" + recurId + "\"").append("\n calid=\"" + calendarId + "\" startTime=\"" + begindate + "\" endTime=\"" + enddate + "\"").append("\n startTimeFull=\"" + this.tempFormat.format(event.getFromDateTime()) + "\" endTimeFull=\"" + this.tempFormat.format(event.getToDateTime()) + "\"").append("\n actionlink=\"" + actionLink + "\" isEditable=\"" + isEditable + "\">");
            if (!this.eventList.contains(eventId)) {
                this.eventList.add(eventId);
                stringBuilder.append("\n<input type=\"hidden\" name=\"" + eventId + "calType\" value=\"" + calType + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "calendarId\" value=\"" + calendarId + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "startTime\" value=\"\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "finishTime\" value=\"\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "isOccur\" value=\"" + isOccur + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "recurId\" value=\"" + recurId + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "currentDate\" value=\"\" />");
            }
            if (event.getFromDateTime().before(this.getBeginDateOfWeek().getTime())) {
                stringBuilder.append("\n<div class=\"leftContinueEvent  pull-left " + color + "\">").append("\n<i class=\"uiIconMiniArrowLeft uiIconWhite\"></i>").append("\n</div>");
            } else {
                stringBuilder.append("\n<div class=\"leftResizeEvent LeftResizeEvent resizeEventContainer pull-left " + color + "\">").append("\n<span></span>\n</div>");
            }
            if (event.getToDateTime().after(this.getEndDateOfWeek().getTime())) {
                stringBuilder.append("\n<div class=\"rightContinueEvent pull-right " + color + "\">").append("\n<i class=\"uiIconMiniArrowRight uiIconWhite\"></i>\n</div>");
            } else {
                stringBuilder.append("\n<div class=\"rightResizeEvent RightResizeEvent resizeEventContainer pull-right " + color + "\">").append("\n<span></span>\n</div>");
            }
            stringBuilder.append("\n<div class=\"eventAlldayContent " + color + "\">" + StringEscapeUtils.escapeHtml((String)event.getSummary()) + "</div>").append("\n</div>");
        }
        stringBuilder.append("\n</div>\n</div>");
        return stringBuilder.toString();
    }

    private String renderEventBoard() throws Exception {
        String styleWidth;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\n<div class=\"eventBoard\">");
        Calendar cl = this.getBeginDateOfWeek();
        int t = 0;
        int numberOfDays = this.isShowCustomView_ ? 5 : 7;
        String string = styleWidth = this.isShowCustomView_ ? "width:19.8%;*width:20%;" : "width:13.8%;*width:14%;";
        while (t++ < numberOfDays) {
            int day = cl.get(5);
            int month = cl.get(2);
            int year = cl.get(1);
            String key = this.keyGen(day, month, year);
            int dayOfWeek = cl.get(7);
            List events = (List)this.getEventData().get(key);
            if (events != null) {
                for (Event event : events) {
                    String username = CalendarUtils.getCurrentUser();
                    String calType = String.valueOf(CalendarUtils.getCalendarService().getTypeOfCalendar(username, event.getCalendarId()));
                    String eventId = event.getId();
                    String begin = this.tf.format(event.getFromDateTime());
                    String begindate = this.dtf.format(event.getFromDateTime());
                    String end = this.tf.format(event.getToDateTime());
                    Calendar cal = CalendarUtils.getInstanceTempCalendar();
                    cal.setTime(event.getFromDateTime());
                    int beginTime = cal.get(11) * 60 + cal.get(12);
                    cal.setTime(event.getToDateTime());
                    int endTime = cal.get(11) * 60 + cal.get(12);
                    String color = (String)this.getColors().get(event.getCalendarId());
                    String actionLink = this.event("UpdateEvent", eventId);
                    boolean isOccur = event.getRepeatType() != null && !CalendarEvent.RP_NOREPEAT.equals(event.getRepeatType()) && (event.getIsExceptionOccurrence() == null || event.getIsExceptionOccurrence() == false);
                    String recurId = event.getRecurrenceId();
                    boolean isEditable = this.isEventEditable(event);
                    stringBuilder.append("\n<div class=\"eventContainerBorder weekViewEventBoxes " + color + "\" eventindex=\"" + dayOfWeek + "\"").append(" style=\"position: absolute;display:none\" eventcat=\"" + event.getEventCategoryId() + "\" caltype=\"" + calType + "\"").append(" eventid=\"" + eventId + "\" calid=\"" + event.getCalendarId() + "\" actionlink=\"" + actionLink + "\" unselectable=\"on\"").append(" starttimefull=\"" + event.getFromDateTime().getTime() + "\" endtimefull=\"" + event.getToDateTime().getTime() + "\"").append(" startTime=\"" + beginTime + "\" endTime=\"" + endTime + "\" isOccur=\"" + isOccur + "\" recurId=\"" + recurId + "\" isEditable=\"" + isEditable + "\">");
                    if (!this.eventList.contains(eventId)) {
                        this.eventList.add(eventId);
                        stringBuilder.append("\n<input type=\"hidden\" name=\"" + eventId + "calType\" value=\"" + calType + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "calendarId\" value=\"" + event.getCalendarId() + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "startTime\" value=\"\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "finishTime\" value=\"\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "isOccur\" value=\"" + isOccur + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "recurId\" value=\"" + recurId + "\" />").append("\n<input type=\"hidden\" name=\"" + eventId + "currentDate\" value=\"\" />");
                    }
                    if (event.isEventDurationSmallerThanHalfHour()) {
                        stringBuilder.append("\n<div class=\"clearfix\">").append("\n<div unselectable=\"on\" class=\"eventContainerBar eventTitle pull-left\" style=\" display: inline-block; \">");
                        if (CalendarEvent.TYPE_TASK.equals(event.getEventType())) {
                            stringBuilder.append("\n<i class=\"uiIconCalTaskMini\"></i>");
                        } else {
                            stringBuilder.append("\n<i class=\"uiIconCalClockMini\"></i>");
                            if (isOccur) {
                                stringBuilder.append("<i class=\"uiIconCalRecurring\"></i>");
                            } else if (!isOccur && Boolean.TRUE.equals(event.getIsExceptionOccurrence())) {
                                stringBuilder.append("<i class=\"uiIconCalEditRecurring\"></i>");
                            }
                        }
                        stringBuilder.append("\n<i class=\"uiIconCal" + event.getPriority() + "Priority\"></i>" + begin + "</div>");
                        if (event.getEventType().equals(CalendarEvent.TYPE_TASK) && event.getEventState().equals(CalendarEvent.COMPLETED)) {
                            stringBuilder.append("\n<div unselectable=\"on\" class=\"eventContainer\" style=\"text-decoration:line-through; \">" + event.getSummary() + "</div>");
                        } else {
                            stringBuilder.append("\n<div class=\"eventContainer \" >" + StringEscapeUtils.escapeHtml((String)event.getSummary()) + "</div>");
                        }
                        stringBuilder.append("</div>");
                    } else {
                        stringBuilder.append("\n<div unselectable=\"on\" class=\"eventContainerBar eventTitle\">");
                        if (CalendarEvent.TYPE_TASK.equals(event.getEventType())) {
                            stringBuilder.append("\n<i class=\"uiIconCalTaskMini\"></i>");
                        } else {
                            stringBuilder.append("\n<i class=\"uiIconCalClockMini\"></i>");
                            if (isOccur) {
                                stringBuilder.append("<i class=\"uiIconCalRecurring\"></i>");
                            } else if (!isOccur && Boolean.TRUE.equals(event.getIsExceptionOccurrence())) {
                                stringBuilder.append("<i class=\"uiIconCalEditRecurring\"></i>");
                            }
                        }
                        stringBuilder.append("\n<i class=\"uiIconCal" + event.getPriority() + "Priority\"></i>").append(begin + " - " + end + "</div>");
                        if (event.getEventType().equals(CalendarEvent.TYPE_TASK) && event.getEventState().equals(CalendarEvent.COMPLETED)) {
                            stringBuilder.append("\n<div unselectable=\"on\" class=\"eventContainer\" style=\" text-decoration:line-through; \">").append(event.getSummary() + "</div>");
                        } else {
                            stringBuilder.append("\n<div class=\"eventContainer\">" + StringEscapeUtils.escapeHtml((String)event.getSummary()) + "</div>");
                        }
                    }
                    stringBuilder.append("\n<div class=\"resizeEventContainer\" unselectable=\"on\">").append("\n<span></span>\n</div>\n</div>");
                }
            }
            cl.add(5, 1);
        }
        stringBuilder.append("\n</div>").append("\n<table style=\"table-layout:fixed;\" class=\"uiGrid table \" id=\"UIWeekViewGrid\" lastupdatedid=\"" + this.getLastUpdatedEventId() + "\"").append(" cellspacing=\"0\" cellpadding=\"0\">").append("\n<tbody>");
        boolean flag = false;
        String style = this.isShowWorkingTime() ? "WorkOffTime" : "none";
        String tempTimeFormat = CalendarUtils.TIMEFORMATPATTERNS[0];
        if (this.getTimeFormat().startsWith("HH")) {
            tempTimeFormat = CalendarUtils.TIMEFORMATPATTERNS[1];
        }
        int counter = 0;
        String timeName = "Gray";
        for (String full : this.getDisplayTimes(tempTimeFormat, this.getTimeInterval(), Locale.ENGLISH)) {
            if (counter % 4 == 0 || counter % 4 == 1) {
                timeName = "OddRow";
            } else if (counter % 4 == 2 || counter % 4 == 3) {
                timeName = "EvenRow";
            }
            String time = full.substring(0, full.lastIndexOf("_"));
            String display = full.substring(full.lastIndexOf("_") + 1);
            if (this.isShowWorkingTime()) {
                if (time.equals(this.getStartTime())) {
                    style = "";
                }
                if (time.equals(this.getEndTime())) {
                    style = "WorkOffTime";
                }
            }
            String styleClass = flag ? "tdDotLine" : "tdLine";
            stringBuilder.append("\n<tr class=\"" + style + " " + timeName + "\">");
            if (!flag) {
                stringBuilder.append("\n<td class=\"tdTime center\" style=\"width: 55px;\">");
            } else {
                stringBuilder.append("\n<td style=\"width: 55px;\">");
            }
            stringBuilder.append("\n<div>");
            if (!flag) {
                stringBuilder.append(display);
            } else {
                stringBuilder.append("&nbsp;");
            }
            stringBuilder.append("\n</div>\n</td>");
            cl = this.getBeginDateOfWeek();
            SimpleDateFormat dayFormat = new SimpleDateFormat(this.getDateFormat(), Locale.ENGLISH);
            SimpleDateFormat fullDateFormat = new SimpleDateFormat(this.getDateFormat() + " " + CalendarUtils.TIMEFORMAT, Locale.ENGLISH);
            dayFormat.setCalendar(cl);
            fullDateFormat.setCalendar(cl);
            t = 0;
            while (t++ < numberOfDays) {
                String startTime = dayFormat.format(cl.getTime()) + " " + time;
                fullDateFormat.setLenient(false);
                try {
                    cl.setTime(fullDateFormat.parse(startTime));
                }
                catch (ParseException e) {
                    fullDateFormat.setLenient(true);
                    cl.setTime(fullDateFormat.parse(startTime));
                }
                int dayOfWeek = cl.get(7);
                String cssClass = this.isCurrentDay(cl.get(5), cl.get(2), cl.get(1)) ? "today" : (dayOfWeek == 1 || dayOfWeek == 7 ? "Weekend" : "Weekday");
                stringBuilder.append("\n<td startFull=\"" + this.tempFormat.format(cl.getTime()) + "\" startTime=\"" + cl.getTimeInMillis() + "\"").append(" eventindex=\"" + dayOfWeek + "\" class=\"" + styleClass + " " + cssClass + " " + style + "\" style=\"" + styleWidth + "\">").append("\n<span></span>\n</td>");
                cl.add(5, 1);
            }
            flag = !flag;
            stringBuilder.append("</tr>");
            ++counter;
        }
        stringBuilder.append("\n</tbody>\n</table>");
        return stringBuilder.toString();
    }

    public Calendar getBeginDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        temCal.setTime(this.calendar_.getTime());
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        }
        if (temCal.getFirstDayOfWeek() > temCal.get(7)) {
            temCal.add(3, -1);
        }
        int amout = temCal.getFirstDayOfWeek() - temCal.get(7);
        if (this.isShowCustomView_) {
            ++amout;
        }
        temCal.add(5, amout);
        return this.getBeginDay(temCal);
    }

    public Calendar getEndDateOfWeek() throws Exception {
        Calendar temCal = this.getInstanceTempCalendar();
        if (this.isShowCustomView_) {
            temCal.setFirstDayOfWeek(1);
        }
        temCal.setTime(this.getBeginDateOfWeek().getTime());
        int amout = 6;
        if (this.isShowCustomView_) {
            amout -= 2;
        }
        temCal.add(5, amout);
        return this.getEndDay(temCal);
    }

    protected Map<String, List<Event>> getEventData() {
        return this.eventData_;
    }

    public LinkedHashMap<String, Event> getDataMap() {
        LinkedHashMap<String, Event> dataMap = new LinkedHashMap<String, Event>();
        for (Event ce : this.allDayEvent) {
            dataMap.put(ce.getId(), ce);
        }
        for (String key : this.eventData_.keySet()) {
            for (Event ce : (List)this.eventData_.get(key)) {
                dataMap.put(ce.getId(), ce);
            }
        }
        return dataMap;
    }

    public boolean isShowCustomView() {
        return this.isShowCustomView_;
    }

    public String getDefaultStartTimeOfEvent() {
        if (this.isCurrentWeek(this.calendar_.get(3), this.calendar_.get(2), this.calendar_.get(1))) {
            return String.valueOf(System.currentTimeMillis());
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.calendar_.getTime());
        int firstDayOfWeek = this.calendar_.getFirstDayOfWeek();
        c.setFirstDayOfWeek(firstDayOfWeek);
        do {
            c.add(5, 1);
        } while (c.get(7) != firstDayOfWeek);
        c.add(5, -1);
        return String.valueOf(c.getTimeInMillis());
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

