/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.webui;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.exoplatform.calendar.model.Event;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.webui.UICalendarView;
import org.exoplatform.calendar.webui.UIDayView;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/templates/calendar/webui/UIDayView.gtmpl", events={@EventConfig(listeners={UICalendarView.DeleteEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmCloseActionListener.class}), @EventConfig(listeners={UICalendarView.AbortCloseActionListener.class}), @EventConfig(listeners={UICalendarView.ViewActionListener.class}), @EventConfig(listeners={UICalendarView.DeleteActionListener.class}), @EventConfig(listeners={UICalendarView.GotoDateActionListener.class}), @EventConfig(listeners={UICalendarView.SwitchViewActionListener.class}), @EventConfig(listeners={UICalendarView.MoveNextActionListener.class}), @EventConfig(listeners={UICalendarView.MovePreviousActionListener.class}), @EventConfig(listeners={UICalendarView.ExportEventActionListener.class}), @EventConfig(listeners={UpdateEventActionListener.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteFollowingSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmDeleteCancel.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateOnlyInstance.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateFollowSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateAllSeries.class}), @EventConfig(listeners={UICalendarView.ConfirmUpdateCancel.class})})
public class UIDayView
extends UICalendarView {
    private static final Log log = ExoLogger.getExoLogger(UIDayView.class);
    private List<Event> eventData_ = new ArrayList();
    private List<Event> allDayEvent_ = new ArrayList();

    public void refresh() throws Exception {
        super.refresh();
        this.eventData_.clear();
        this.allDayEvent_.clear();
        this.recurrenceEventsMap.clear();
        PortletRequestContext.getCurrentInstance().setAttribute("", null);
        Calendar begin = this.getBeginDay(this.getCurrentCalendar());
        Calendar end = this.getEndDay(this.getCurrentCalendar());
        end.add(14, -1);
        List allEvents = this.getEventInMonth(begin.getTimeInMillis(), end.getTimeInMillis());
        if (this.isInSpace()) {
            this.filterNonSpaceEvent(allEvents);
        }
        for (Event evt : allEvents) {
            if (evt.getRepeatType() == null || evt.getRecurrenceId() == null || evt.getRepeatType().equals(Event.RP_NOREPEAT)) continue;
            HashMap<String, CalendarEvent> recurrMap = (HashMap<String, CalendarEvent>)this.recurrenceEventsMap.get(evt.getId());
            if (recurrMap == null) {
                recurrMap = new HashMap<String, CalendarEvent>();
                this.recurrenceEventsMap.put(evt.getId(), recurrMap);
            }
            recurrMap.put(evt.getRecurrenceId(), (CalendarEvent)evt);
        }
        Iterator iter = allEvents.iterator();
        while (iter.hasNext()) {
            Event ce = (Event)iter.next();
            long eventAmount = ce.getToDateTime().getTime() - ce.getFromDateTime().getTime();
            if (!this.isSameDate(ce.getFromDateTime(), this.getCurrentDate()) || !this.isSameDate(ce.getToDateTime(), this.getCurrentDate()) || eventAmount >= 84960000L) continue;
            this.eventData_.add(ce);
            iter.remove();
        }
        for (Event ce : allEvents) {
            this.allDayEvent_.add(ce);
        }
    }

    protected List<Event> getEventData() {
        return this.eventData_;
    }

    protected List<Event> getAllDayEvents() {
        return this.allDayEvent_;
    }

    public LinkedHashMap<String, Event> getDataMap() {
        LinkedHashMap<String, Event> dataMap = new LinkedHashMap<String, Event>();
        for (Event ce : this.eventData_) {
            dataMap.put(ce.getId(), ce);
        }
        for (Event ce : this.allDayEvent_) {
            dataMap.put(ce.getId(), ce);
        }
        return dataMap;
    }

    public String getDefaultStartTimeOfEvent() {
        return String.valueOf(this.calendar_.getTimeInMillis());
    }

    static /* synthetic */ Log access$000() {
        return log;
    }
}

