/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.calendar.ws.bean;

import java.io.Serializable;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import org.exoplatform.calendar.service.Attachment;
import org.exoplatform.calendar.service.CalendarEvent;
import org.exoplatform.calendar.service.Reminder;
import org.exoplatform.calendar.service.Utils;
import org.exoplatform.calendar.ws.bean.AttachmentResource;
import org.exoplatform.calendar.ws.common.Resource;
import org.exoplatform.commons.utils.ISO8601;

public class TaskResource
extends Resource {
    private static final long serialVersionUID = -5290204215375549320L;
    private String name;
    private String note;
    private String from;
    private String to;
    private Serializable calendar;
    private Serializable[] categories;
    private String[] delegation;
    private String priority;
    private Reminder[] reminder;
    private Serializable[] attachments;
    private String status;
    private String categoryId;

    public TaskResource() {
        super(null);
    }

    public TaskResource(CalendarEvent data, String basePath) throws Exception {
        super(data.getId());
        this.setHref(basePath + "/tasks/" + data.getId());
        this.name = data.getSummary();
        this.note = data.getDescription();
        GregorianCalendar fromCal = Utils.getInstanceTempCalendar();
        fromCal.setTime(data.getFromDateTime());
        this.from = ISO8601.format((Calendar)fromCal);
        GregorianCalendar toCal = Utils.getInstanceTempCalendar();
        toCal.setTime(data.getToDateTime());
        this.to = ISO8601.format((Calendar)toCal);
        this.calendar = basePath + "/calendars/" + data.getCalendarId();
        if (data.getEventCategoryId() != null) {
            this.categories = new String[]{basePath + "/categories/" + data.getEventCategoryId()};
            this.categoryId = data.getEventCategoryId();
        }
        if (data.getTaskDelegator() != null) {
            this.delegation = data.getTaskDelegator().split(":");
        }
        this.priority = data.getPriority();
        if (data.getReminders() != null) {
            this.reminder = data.getReminders().toArray(new Reminder[0]);
        }
        if (data.getAttachment() != null) {
            LinkedList<String> atts = new LinkedList<String>();
            for (Attachment att : data.getAttachment()) {
                AttachmentResource attRs = new AttachmentResource(att, basePath);
                atts.add(attRs.getHref());
            }
            this.attachments = (Serializable[])atts.toArray(new String[atts.size()]);
        }
        this.status = data.getEventState();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public Serializable getCalendar() {
        return this.calendar;
    }

    public TaskResource setCal(Serializable calendar) {
        this.calendar = calendar;
        return this;
    }

    public Serializable[] getCategories() {
        return this.categories;
    }

    public void setCats(Serializable[] categories) {
        this.categories = categories;
    }

    public String[] getDelegation() {
        return this.delegation;
    }

    public void setDelegation(String[] delegation) {
        this.delegation = delegation;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public Reminder[] getReminder() {
        return this.reminder;
    }

    public void setReminder(Reminder[] reminder) {
        this.reminder = reminder;
    }

    public Serializable[] getAttachments() {
        return this.attachments;
    }

    public void setAtts(Serializable[] attachments) {
        this.attachments = attachments;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }
}

