/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.command;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.apache.commons.chain.Catalog;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.chain.impl.CatalogFactoryBase;
import org.apache.commons.chain.impl.ContextBase;
import org.exoplatform.container.StandaloneContainer;
import org.exoplatform.services.command.impl.CommandService;

public class CommandServiceTest
extends TestCase {
    private static final String IS = "<catalog><command name='StrCommand' className='org.exoplatform.services.command.TestCommand1'/></catalog>";
    private StandaloneContainer container;

    public void setUp() throws Exception {
        StandaloneContainer.setConfigurationPath((String)"src/test/resources/conf/standalone/test-configuration.xml");
        this.container = StandaloneContainer.getInstance();
    }

    public void testPluginConf() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        CommandServiceTest.assertNotNull((Object)cservice);
        CommandServiceTest.assertTrue((boolean)cservice.getCatalog().getNames().hasNext());
        CommandServiceTest.assertNotNull(cservice.getCatalog().getNames().next());
    }

    public void testStringConf() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        Catalog c = cservice.getCatalog();
        CommandServiceTest.assertNull((Object)c.getCommand("StrCommand"));
        cservice.putCatalog((InputStream)new ByteArrayInputStream(IS.getBytes()));
        Catalog c1 = cservice.getCatalog();
        CommandServiceTest.assertNotNull((Object)c1.getCommand("StrCommand"));
    }

    public void testInitWithFile() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        cservice.putCatalog(((Object)((Object)this)).getClass().getResourceAsStream("/conf/test-commands3.xml"));
        CommandServiceTest.assertTrue((boolean)cservice.getCatalogNames().hasNext());
        Catalog c1 = cservice.getCatalog("catalog1");
        CommandServiceTest.assertNotNull((Object)c1.getCommand("Command2"));
    }

    public void testExcecute() throws Exception {
        CommandService cservice = (CommandService)this.container.getComponentInstanceOfType(CommandService.class);
        Command c1 = cservice.getCatalog().getCommand("Execute2");
        Command c2 = cservice.getCatalog().getCommand("Command1");
        Catalog c = cservice.getCatalog();
        ContextBase ctx = new ContextBase();
        ctx.put((Object)"test", (Object)0);
        c1.execute((Context)ctx);
        c2.execute((Context)ctx);
        CommandServiceTest.assertEquals((int)3, (int)((Integer)ctx.get((Object)"test")));
    }

    public void tearDown() {
        CatalogFactoryBase.clear();
        this.container.stop();
    }
}

