/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.persistence;

import java.io.IOException;
import java.io.Writer;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.exoplatform.commons.api.persistence.ExoEntity;

@SupportedAnnotationTypes(value={"org.exoplatform.commons.api.persistence.ExoEntity"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ExoEntityProcessor
extends AbstractProcessor {
    public static final String ENTITIES_IDX_PATH = "exo-jpa-entities/entities.idx";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Writer writer = null;
        if (roundEnv != null && roundEnv.getElementsAnnotatedWith(ExoEntity.class) != null && roundEnv.getElementsAnnotatedWith(ExoEntity.class).size() > 0) {
            try {
                FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", ENTITIES_IDX_PATH, new Element[0]);
                writer = file.openWriter();
                for (Element element : roundEnv.getElementsAnnotatedWith(ExoEntity.class)) {
                    writer.append(element.asType().toString() + "\n");
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Exo JPA entity detected: " + element.asType());
                }
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while processing @ExoEntity: " + e.getMessage());
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e) {
                        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while processing @ExoEntity: " + e.getMessage());
                    }
                }
            }
        }
        return true;
    }
}

