/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class UserSetting {
    public static String EMAIL_CHANNEL = "MAIL_CHANNEL";
    private List<String> channelActives = new ArrayList<String>();
    private Calendar lastUpdateTime;
    private String userId;
    private Map<String, List<String>> channelPlugins = new HashMap<String, List<String>>();
    private List<String> dailyPlugins = new ArrayList<String>();
    private List<String> weeklyPlugins = new ArrayList<String>();
    private long lastReadDate = 0L;
    private boolean isEnabled = true;

    public UserSetting() {
        this.lastUpdateTime = Calendar.getInstance();
    }

    public static UserSetting getInstance() {
        return new UserSetting();
    }

    public long getLastReadDate() {
        return this.lastReadDate;
    }

    public void setLastReadDate(long lastReadDate) {
        this.lastReadDate = lastReadDate;
    }

    public List<String> getChannelActives() {
        return this.channelActives == null ? (this.channelActives = new ArrayList<String>()) : this.channelActives;
    }

    public boolean isChannelActive(String channelId) {
        return this.channelActives != null && this.channelActives.contains(channelId);
    }

    public void setChannelActive(String channelId) {
        if (!this.isChannelActive(channelId)) {
            if (this.channelActives == null) {
                this.channelActives = new ArrayList<String>();
                this.channelActives.add(channelId);
            } else if (!this.channelActives.contains(channelId)) {
                this.channelActives.add(channelId);
            }
        }
    }

    public void removeChannelActive(String channelId) {
        if (this.isChannelActive(channelId)) {
            this.channelActives.remove(channelId);
        }
    }

    public void setChannelActives(List<String> channelActives) {
        this.channelActives = channelActives;
    }

    public String getUserId() {
        return this.userId;
    }

    public UserSetting setUserId(String userId) {
        this.userId = userId;
        return this;
    }

    public Calendar getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public UserSetting setLastUpdateTime(Calendar lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
        return this;
    }

    public void setAllChannelPlugins(Map<String, List<String>> channelPlugins) {
        this.channelPlugins = channelPlugins;
    }

    public Map<String, List<String>> getAllChannelPlugins() {
        return this.channelPlugins;
    }

    public List<String> getPlugins(String channelId) {
        List<String> channelPlugins = this.channelPlugins.get(channelId);
        if (channelPlugins == null) {
            channelPlugins = new ArrayList<String>();
            this.channelPlugins.put(channelId, channelPlugins);
        }
        return channelPlugins;
    }

    public void setChannelPlugins(String channelId, List<String> pluginIds) {
        this.channelPlugins.put(channelId, pluginIds);
    }

    public void addChannelPlugin(String channelId, String pluginId) {
        List<String> plugins = this.getPlugins(channelId);
        if (!plugins.contains(pluginId)) {
            plugins.add(pluginId);
        }
    }

    public void removeChannelPlugin(String channelId, String pluginId) {
        List<String> plugins = this.getPlugins(channelId);
        if (plugins.contains(pluginId)) {
            plugins.remove(pluginId);
        }
    }

    public List<String> getDailyPlugins() {
        return this.dailyPlugins;
    }

    public void setDailyPlugins(List<String> dailyPlugins) {
        this.dailyPlugins = dailyPlugins;
    }

    public List<String> getWeeklyPlugins() {
        return this.weeklyPlugins;
    }

    public void setWeeklyPlugins(List<String> weeklyPlugins) {
        this.weeklyPlugins = weeklyPlugins;
    }

    public void addPlugin(String pluginId, FREQUENCY frequencyType) {
        if (frequencyType.equals((Object)FREQUENCY.DAILY)) {
            this.addProperty(this.dailyPlugins, pluginId);
            this.weeklyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.WEEKLY)) {
            this.addProperty(this.weeklyPlugins, pluginId);
            this.dailyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.INSTANTLY)) {
            this.addChannelPlugin(EMAIL_CHANNEL, pluginId);
        }
    }

    public void removePlugin(String pluginId, FREQUENCY frequencyType) {
        if (frequencyType.equals((Object)FREQUENCY.DAILY)) {
            this.weeklyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.WEEKLY)) {
            this.dailyPlugins.remove(pluginId);
        } else if (frequencyType.equals((Object)FREQUENCY.INSTANTLY)) {
            this.removeChannelPlugin(EMAIL_CHANNEL, pluginId);
        }
    }

    public boolean isActive(String channelId, String pluginId) {
        return this.getPlugins(channelId).contains(pluginId);
    }

    public boolean isInDaily(String pluginId) {
        return this.dailyPlugins.contains(pluginId);
    }

    public boolean isInWeekly(String pluginId) {
        return this.weeklyPlugins.contains(pluginId);
    }

    private void addProperty(List<String> providers, String pluginId) {
        if (!providers.contains(pluginId)) {
            providers.add(pluginId);
        }
    }

    public UserSetting clone() {
        UserSetting setting = UserSetting.getInstance();
        setting.setChannelActives(new ArrayList<String>(this.channelActives));
        setting.setDailyPlugins(new ArrayList<String>(this.dailyPlugins));
        setting.setWeeklyPlugins(new ArrayList<String>(this.weeklyPlugins));
        for (Map.Entry<String, List<String>> entry : this.channelPlugins.entrySet()) {
            setting.getPlugins(entry.getKey()).addAll((Collection<String>)entry.getValue());
        }
        setting.setUserId(this.userId);
        return setting;
    }

    public String toString() {
        return "UserSetting : {userId : " + this.userId + "}";
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserSetting that = (UserSetting)o;
        return this.lastReadDate == that.lastReadDate && this.isEnabled == that.isEnabled && Objects.equals(this.channelActives, that.channelActives) && Objects.equals(this.lastUpdateTime, that.lastUpdateTime) && Objects.equals(this.userId, that.userId) && Objects.equals(this.channelPlugins, that.channelPlugins) && Objects.equals(this.dailyPlugins, that.dailyPlugins) && Objects.equals(this.weeklyPlugins, that.weeklyPlugins);
    }

    public int hashCode() {
        return Objects.hash(this.channelActives, this.lastUpdateTime, this.userId, this.channelPlugins, this.dailyPlugins, this.weeklyPlugins, this.lastReadDate, this.isEnabled);
    }

    public static enum FREQUENCY {
        INSTANTLY,
        DAILY,
        WEEKLY;


        public static FREQUENCY getFrequecy(String name) {
            for (int i = 0; i < FREQUENCY.values().length; ++i) {
                if (!FREQUENCY.values()[i].name().equalsIgnoreCase(name)) continue;
                return FREQUENCY.values()[i];
            }
            return null;
        }
    }
}

