/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.lifecycle;

import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.lifecycle.AbstractNotificationLifecycle;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.plugin.config.PluginConfig;
import org.exoplatform.commons.api.notification.service.setting.PluginSettingService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.container.ExoContainerContext;

public final class DefaultLifecycle
extends AbstractNotificationLifecycle {
    @Override
    public void process(NotificationContext ctx, String userId) {
        this.getChannel().dispatch(ctx, userId);
    }

    @Override
    public void process(NotificationContext ctx, String ... userIds) {
        NotificationInfo notification = ctx.getNotificationInfo();
        String channelId = this.getChannel().getId();
        String pluginId = notification.getKey().getId();
        UserSettingService userService = (UserSettingService)ExoContainerContext.getService(UserSettingService.class);
        PluginSettingService pluginSettingService = (PluginSettingService)ExoContainerContext.getService(PluginSettingService.class);
        PluginConfig pluginConfig = pluginSettingService.getPluginConfig(pluginId);
        for (String userId : userIds) {
            UserSetting userSetting = userService.get(userId);
            if (!userSetting.isEnabled() || !userSetting.isChannelGloballyActive(channelId) || !userSetting.isActive(channelId, pluginId) || userSetting.isSpaceMuted(notification.getSpaceId()) && pluginConfig.isMutable()) continue;
            this.process(ctx.setNotificationInfo(notification.clone(true).setTo(userId)), userId);
        }
    }

    @Override
    public void send(NotificationContext ctx) {
    }
}

