/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.service.template;

import java.util.HashMap;
import java.util.Locale;
import org.exoplatform.commons.api.notification.model.ChannelKey;

public class TemplateContext
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private String pluginId;
    private ChannelKey channelKey;
    private String language;
    private int digestSize = 0;
    private Throwable error = null;

    public TemplateContext() {
    }

    public TemplateContext(String pluginId, String language) {
        this.channelKey = ChannelKey.key("MAIL_CHANNEL");
        this.pluginId = pluginId;
        this.language = language;
    }

    public static TemplateContext newChannelInstance(ChannelKey channelKey, String pluginId, String language) {
        TemplateContext context = new TemplateContext(pluginId, language);
        context.channelKey = channelKey;
        return context;
    }

    public void setException(Throwable exception) {
        this.error = exception;
    }

    public Throwable getException() {
        return this.error;
    }

    public TemplateContext digestType(int digestSize) {
        this.digestSize = digestSize;
        return this;
    }

    public TemplateContext channelKey(ChannelKey channelKey) {
        this.channelKey = channelKey;
        return this;
    }

    public TemplateContext pluginId(String pluginId) {
        this.pluginId = pluginId;
        return this;
    }

    public TemplateContext language(String language) {
        this.language = language;
        return this;
    }

    public TemplateContext end() {
        return this;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public ChannelKey getChannelKey() {
        return this.channelKey;
    }

    public String getLanguage() {
        if (this.language == null) {
            return Locale.ENGLISH.getLanguage();
        }
        return this.language;
    }

    public int getDigestSize() {
        return this.digestSize;
    }
}

