/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.api.notification.plugin;

import org.exoplatform.commons.api.notification.plugin.NotificationPluginUtils;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.branding.BrandingService;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.UserProfile;
import org.exoplatform.services.organization.UserProfileHandler;
import org.exoplatform.services.organization.impl.UserProfileImpl;

@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml")})
public class NotificationPluginUtilsTest
extends AbstractKernelTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetLanguage() throws Exception {
        OrganizationService organizationService = (OrganizationService)this.getContainer().getComponentInstanceOfType(OrganizationService.class);
        String userName = "john";
        String langFR = "fr";
        String langFR_FR = "fr_FR";
        UserProfileHandler profileHandler = organizationService.getUserProfileHandler();
        UserProfileImpl profile = new UserProfileImpl(userName);
        profile.setAttribute("user.language", langFR);
        this.begin();
        try {
            profileHandler.saveUserProfile((UserProfile)profile, true);
        }
        finally {
            this.end();
        }
        String language = NotificationPluginUtils.getLanguage((String)userName);
        NotificationPluginUtilsTest.assertEquals((String)langFR, (String)language);
        profile.setAttribute("user.language", langFR_FR);
        this.begin();
        try {
            profileHandler.saveUserProfile((UserProfile)profile, true);
        }
        finally {
            this.end();
        }
        language = NotificationPluginUtils.getLanguage((String)userName);
        NotificationPluginUtilsTest.assertEquals((String)langFR, (String)language);
    }

    public void testGetBrandingPortalName() throws Exception {
        NotificationPluginUtilsTest.assertEquals((String)((BrandingService)ExoContainerContext.getService(BrandingService.class)).getCompanyName(), (String)NotificationPluginUtils.getBrandingPortalName());
    }
}

