/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.cometd.continuation;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.AsyncContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.oort.Oort;
import org.cometd.oort.OortConfigServlet;
import org.cometd.oort.OortMulticastConfigServlet;
import org.cometd.oort.OortStaticConfigServlet;
import org.cometd.oort.Seti;
import org.cometd.oort.SetiServlet;
import org.cometd.server.CometDServlet;
import org.cometd.websocket.client.WebSocketTransport;
import org.eclipse.jetty.client.HttpClient;
import org.exoplatform.commons.utils.PrivilegedSystemHelper;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.ServletContextWrapper;
import org.mortbay.cometd.continuation.EXoContinuationBayeux;

public class EXoContinuationCometdServlet
extends CometDServlet {
    private static final long serialVersionUID = 9204910608302112814L;
    private static final Log LOG = ExoLogger.getLogger(CometDServlet.class);
    private OortConfigServlet oConfig;
    private SetiServlet setiConfig;
    private ExoContainer container;
    private boolean initialized;
    private boolean clusterEnabled = false;
    private static EXoContinuationCometdServlet instance;
    private ServletConfig originConfig;
    public static final String PREFIX = "exo.cometd.";
    protected static final String CLOUD_ID_SEPARATOR = "exo.cometd.cloudIDSeparator";
    public static String OORT_CONFIG_TYPE;
    public static String OORT_MULTICAST;
    public static String OORT_STATIC;
    public static final Pattern URL_REGEX;

    public void init(ServletConfig config) throws ServletException {
        this.originConfig = config;
        RootContainer.PortalContainerPostInitTask task = new RootContainer.PortalContainerPostInitTask(){

            public void execute(ServletContext context, PortalContainer portalContainer) {
                EXoContinuationCometdServlet.this.setContainer((ExoContainer)portalContainer);
                EXoContinuationCometdServlet.this.init();
                EXoContinuationCometdServlet.this.initialized = true;
            }
        };
        PortalContainer.addInitTask((ServletContext)config.getServletContext(), (RootContainer.PortalContainerInitTask)task);
        instance = this;
    }

    public void reInit() {
        if (this.initialized) {
            this.init();
        }
    }

    public void init() {
        ServletConfig servletConfig = this.getServletConfig();
        try {
            String configType;
            super.init();
            String profiles = PropertyManager.getProperty((String)"exo.profiles");
            if (profiles != null) {
                this.clusterEnabled = profiles.contains("cluster");
                if (this.clusterEnabled) {
                    this.warnInvalidUrl(this.getInitParameter("oort.url"));
                }
            }
            this.oConfig = OORT_STATIC.equals(configType = this.getInitParameter(OORT_CONFIG_TYPE)) ? new OortStaticConfig() : new OortMulticastConfig();
            this.oConfig.init(servletConfig);
            this.setiConfig = new SetiServlet();
            this.setiConfig.init(servletConfig);
            ServletContext cometdContext = servletConfig.getServletContext();
            Seti seti = (Seti)cometdContext.getAttribute(Seti.SETI_ATTRIBUTE);
            Oort oort = (Oort)cometdContext.getAttribute(Oort.OORT_ATTRIBUTE);
            EXoContinuationBayeux bayeux = this.getBayeux();
            bayeux.setSeti(seti);
            bayeux.setOort(oort);
            String separator = this.getInitParameter(CLOUD_ID_SEPARATOR);
            if (separator != null) {
                bayeux.setCloudIDSeparator(separator);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot initialize Bayeux", (Throwable)e);
        }
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getContainer() == null || this.getBayeux() == null) {
            final AsyncContext ac = request.startAsync((ServletRequest)request, (ServletResponse)response);
            ac.start(new Runnable(){

                @Override
                public void run() {
                    while (EXoContinuationCometdServlet.this.getContainer() == null || EXoContinuationCometdServlet.this.getBayeux() == null) {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException e) {
                            LOG.error((Object)e);
                        }
                    }
                    try {
                        EXoContinuationCometdServlet.this.service(ac.getRequest(), ac.getResponse());
                    }
                    catch (Exception e) {
                        LOG.error((Object)e);
                    }
                }
            });
        } else {
            super.service(request, response);
        }
    }

    public ServletConfig getServletConfig() {
        EXoContinuationBayeux bayeux = this.getBayeux();
        ServletConfig config = bayeux.getServletConfig();
        if (config == null) {
            config = new ServletConfigWrapper(this.originConfig);
            bayeux.setServletConfig(config);
        }
        return config;
    }

    public void setContainer(ExoContainer container) {
        this.container = container;
    }

    private ExoContainer getContainer() {
        return this.container;
    }

    protected EXoContinuationBayeux newBayeuxServer() {
        return this.getBayeux();
    }

    public EXoContinuationBayeux getBayeux() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EXoContinuationCometdServlet - Current Container-ExoContainer: " + this.getContainer()));
            }
            EXoContinuationBayeux bayeux = (EXoContinuationBayeux)((Object)this.getContainer().getComponentInstanceOfType(BayeuxServer.class));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("EXoContinuationCometdServlet - -->AbstractBayeux=" + (Object)((Object)bayeux)));
            }
            return bayeux;
        }
        catch (Exception e) {
            LOG.error((Object)"Error new Bayeux creation ", (Throwable)e);
            return null;
        }
    }

    public static EXoContinuationCometdServlet getInstance() {
        return instance;
    }

    public void destroy() {
    }

    private Oort configTransports(Oort oort) {
        ServletConfig config = this.getServletConfig();
        String transport = config.getInitParameter("transports");
        if (transport == null || !transport.contains(WebSocketTransport.class.getName())) {
            oort.getClientTransportFactories().add(new LongPollingTransport.Factory(new HttpClient()));
        }
        return oort;
    }

    private void warnInvalidUrl(String url) {
        if (url == null || url.isEmpty()) {
            LOG.warn((Object)"You didn\u2019t set exo.cometd.oort.url, cometd cannot work in cluster mode without this property, please set it.");
        } else if (!URL_REGEX.matcher(url).matches()) {
            LOG.warn("exo.cometd.oort.url is invalid {}, cometd cannot work in cluster mode without this property, please set it.", new Object[]{url});
        }
    }

    static {
        OORT_CONFIG_TYPE = "exo.cometd.oort.configType";
        OORT_MULTICAST = "multicast";
        OORT_STATIC = "static";
        String ip_regex = "(((((25[0-5])|(2[0-4][0-9])|([01]?[0-9]?[0-9]))\\.){3}((25[0-4])|(2[0-4][0-9])|((1?[1-9]?[1-9])|([1-9]0))))|(0\\.){3}0)";
        URL_REGEX = Pattern.compile("^((ht|f)tp(s?)://)(\\w+(:\\w+)?@)?(" + ip_regex + "|([0-9a-z_!~*'()-]+\\.)*([0-9a-z][0-9a-z-]{0,61})?[0-9a-z]\\.[a-z]{2,6}|([a-zA-Z][-a-zA-Z0-9]+))(:[0-9]{1,5})?((/?)|(/[0-9a-zA-Z_!~*'().;?:@&=+$,%#-]+)+/?)$");
    }

    private class ServletConfigWrapper
    implements ServletConfig {
        private ServletConfig delegate;
        private ServletContext contextWrapper;
        private String[] configs;

        public ServletConfigWrapper(ServletConfig config) {
            this.delegate = config;
            this.contextWrapper = new ServletContextWrapper(this.delegate.getServletContext());
        }

        public String getInitParameter(String name) {
            String value = PropertyManager.getProperty((String)(EXoContinuationCometdServlet.PREFIX + name));
            if (value == null) {
                value = this.delegate.getInitParameter(name);
            }
            return value;
        }

        public Enumeration<String> getInitParameterNames() {
            if (this.configs == null) {
                LinkedList<String> keys = new LinkedList<String>();
                Properties props = PrivilegedSystemHelper.getProperties();
                int len = EXoContinuationCometdServlet.PREFIX.length();
                for (Object key : props.keySet()) {
                    String k = key.toString().trim();
                    if (!k.startsWith(EXoContinuationCometdServlet.PREFIX) || k.length() <= len) continue;
                    keys.add(k.substring(len));
                }
                this.configs = keys.toArray(new String[keys.size()]);
            }
            HashSet<Object> names = new HashSet<Object>();
            names.addAll(Collections.list(this.delegate.getInitParameterNames()));
            names.addAll(Arrays.asList(this.configs));
            return Collections.enumeration(names);
        }

        public ServletContext getServletContext() {
            return this.contextWrapper;
        }

        public String getServletName() {
            return this.delegate.getServletName();
        }
    }

    public class OortMulticastConfig
    extends OortMulticastConfigServlet {
        private static final long serialVersionUID = 6836833932474627776L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (EXoContinuationCometdServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return EXoContinuationCometdServlet.this.configTransports(oort);
        }
    }

    public class OortStaticConfig
    extends OortStaticConfigServlet {
        private static final long serialVersionUID = 1054209695244836363L;

        protected void configureCloud(ServletConfig config, Oort oort) throws Exception {
            if (EXoContinuationCometdServlet.this.clusterEnabled) {
                super.configureCloud(config, oort);
            }
        }

        protected Oort newOort(BayeuxServer bayeux, String url) {
            Oort oort = super.newOort(bayeux, url);
            return EXoContinuationCometdServlet.this.configTransports(oort);
        }
    }
}

