/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ws.frameworks.cometd;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import org.exoplatform.common.http.client.HTTPConnection;
import org.exoplatform.common.http.client.HTTPResponse;
import org.exoplatform.common.http.client.NVPair;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.cometd.CMessage;
import org.exoplatform.ws.frameworks.cometd.CMessages;
import org.exoplatform.ws.frameworks.cometd.transport.DelegateMessage;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;

public class TestTools {
    private static final Log LOG = ExoLogger.getLogger(TestTools.class);

    public static String getBaseURLCometdServer(String u) {
        try {
            URL url = new URL(u);
            HTTPConnection connection = new HTTPConnection(url);
            HTTPResponse response = connection.Get(url.getFile());
            if (response.getStatusCode() == 200) {
                String baseCometdURL = new String(response.getData());
                return baseCometdURL;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return null;
    }

    public static String getUserToken(String u) {
        try {
            LOG.info((Object)("TestTools.getUserToken()" + u));
            URL url = new URL(u);
            HTTPConnection connection = new HTTPConnection(url);
            HTTPResponse response = connection.Get(url.getFile());
            String token = new String(response.getData());
            return token;
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static void sendMessage(String exoid, String channel, String message, String msgId, String baseURI) {
        try {
            DelegateMessage data = new DelegateMessage(channel, exoid, message, msgId);
            URL url = new URL(baseURI);
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            JsonValue json = generatorImpl.createJsonObject((Object)data);
            HTTPConnection connection = new HTTPConnection(url);
            NVPair[] pairs = new NVPair[]{new NVPair("Content-Type", "application/json")};
            connection.Post(url.getFile(), json.toString().getBytes(), pairs);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static void sendBroadcastMessage(String channel, String message, String msgId, String baseURI) {
        try {
            DelegateMessage data = new DelegateMessage(channel, message, msgId);
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            JsonValue json = generatorImpl.createJsonObject((Object)data);
            URL url = new URL(baseURI);
            NVPair[] pairs = new NVPair[]{new NVPair("Content-Type", "application/json")};
            HTTPConnection connection = new HTTPConnection(url);
            connection.Post(url.getFile(), json.toString().getBytes(), pairs);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public static CMessage stringToCMessage(String incomString) {
        try {
            String tmpJ = incomString.trim();
            String jsonString = tmpJ.substring(1, tmpJ.length() - 1);
            JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
            JsonParserImpl jsonParser = new JsonParserImpl();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes());
            jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
            JsonValue jsonValue = jsonHandler.getJsonObject();
            return (CMessage)new BeanBuilder().createObject(CMessage.class, jsonValue);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static CMessages stringToCMessages(String incomString) {
        try {
            String tmpJ = incomString.trim();
            String jsonString = "{\"cometdMessages\":" + tmpJ + "}";
            JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
            JsonParserImpl jsonParser = new JsonParserImpl();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonString.getBytes());
            jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
            JsonValue jsonValue = jsonHandler.getJsonObject();
            return (CMessages)new BeanBuilder().createObject(CMessages.class, jsonValue);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return null;
        }
    }

    public static Boolean release(String u) {
        try {
            URL url = new URL(u);
            HTTPConnection connection = new HTTPConnection(url);
            HTTPResponse response = connection.Get(url.getFile());
            if (response.getStatusCode() == 200) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return false;
    }
}

