/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.exoplatform.commons.utils.HTMLEntityEncoder;

public class StringCommonUtils {
    private static final Pattern SCRIPT_TAG_PATTERN = Pattern.compile("(<(/|)?[ ]*(script|iframe|object|embed)>|<(iframe|object|embed)|((background|expression|style)=)|javascript:\\w+|(on\\w+=))", 2);
    private static List<String> MATCHED_WORDS = new ArrayList<String>(){
        {
            this.add("on");
            this.add("javascript");
            this.add("background");
            this.add("src");
            this.add("style");
        }
    };

    public static String encodeScriptMarkup(String input) {
        if (input != null) {
            String decodeInput = StringEscapeUtils.unescapeHtml((String)input);
            Matcher matcher = SCRIPT_TAG_PATTERN.matcher(decodeInput);
            StringBuffer str = new StringBuffer(decodeInput.length());
            while (matcher.find()) {
                if (StringCommonUtils.matchedWord(matcher.group())) {
                    matcher.appendReplacement(str, "");
                    continue;
                }
                matcher.appendReplacement(str, HTMLEntityEncoder.getInstance().encodeHTMLAttribute(matcher.group()));
            }
            matcher.appendTail(str);
            input = str.toString();
        }
        return input;
    }

    private static boolean matchedWord(String input) {
        if (input == null || input.length() == 0) {
            return true;
        }
        String lowerStr = input.toLowerCase();
        for (String word : MATCHED_WORDS) {
            if (!lowerStr.contains(word)) continue;
            return true;
        }
        return false;
    }
}

